/*
 * Decompiled with CFR 0.152.
 */
package pekko.contrib.persistence.mongodb;

import java.io.Serializable;
import org.apache.pekko.actor.DynamicAccess;
import org.apache.pekko.persistence.PersistentRepr;
import org.apache.pekko.persistence.journal.Tagged;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.Serialization$;
import pekko.contrib.persistence.mongodb.Bin;
import pekko.contrib.persistence.mongodb.BooleanPayload;
import pekko.contrib.persistence.mongodb.Bson;
import pekko.contrib.persistence.mongodb.DocumentType;
import pekko.contrib.persistence.mongodb.FixedPointPayload;
import pekko.contrib.persistence.mongodb.FloatingPointPayload;
import pekko.contrib.persistence.mongodb.Legacy;
import pekko.contrib.persistence.mongodb.Legacy$;
import pekko.contrib.persistence.mongodb.Payload;
import pekko.contrib.persistence.mongodb.Serialized;
import pekko.contrib.persistence.mongodb.Serialized$;
import pekko.contrib.persistence.mongodb.StringPayload;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.reflect.Manifest;
import scala.runtime.BoxesRunTime;

public final class Payload$ {
    public static final Payload$ MODULE$ = new Payload$();

    public <D> Bson<D> bson2payload(D document, DocumentType<D> dt) {
        return new Bson<D>(document, (Set<String>)Predef$.MODULE$.Set().empty(), dt);
    }

    public StringPayload str2payload(String string) {
        return new StringPayload(string, (Set<String>)Predef$.MODULE$.Set().empty());
    }

    public FloatingPointPayload fpnum2payload(double d) {
        return new FloatingPointPayload(d, (Set<String>)Predef$.MODULE$.Set().empty());
    }

    public FixedPointPayload fxnum2payload(long l) {
        return new FixedPointPayload(l, (Set<String>)Predef$.MODULE$.Set().empty());
    }

    public BooleanPayload bln2payload(boolean bool) {
        return new BooleanPayload(bool, (Set<String>)Predef$.MODULE$.Set().empty());
    }

    public Bin bytes2payload(byte[] buf) {
        return new Bin(buf, (Set<String>)Predef$.MODULE$.Set().empty());
    }

    public <D> Payload apply(Object payload, Set<String> tags, Serialization ser, Manifest<D> ev, DocumentType<D> dt, DynamicAccess loadClass) {
        return (Payload)Serialization$.MODULE$.withTransportInformation(ser.system(), (Function0 & Serializable)() -> {
            Option option;
            Object object = payload;
            if (object instanceof Tagged) {
                Tagged tagged = (Tagged)object;
                return MODULE$.apply(tagged.payload(), (Set<String>)tagged.tags(), ser, ev, dt, loadClass);
            }
            if (object instanceof PersistentRepr) {
                PersistentRepr persistentRepr = (PersistentRepr)object;
                return Legacy$.MODULE$.apply(persistentRepr, tags, ser);
            }
            if (object != null && !(option = ev.unapply(object)).isEmpty() && option.get() instanceof Object) {
                return new Bson<Object>(object, tags, dt);
            }
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                return new Bin(byArray, tags);
            }
            if (object instanceof String) {
                String string = (String)object;
                return new StringPayload(string, tags);
            }
            if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                return new FloatingPointPayload(d, tags);
            }
            if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                return new FixedPointPayload(l, tags);
            }
            if (object instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                return new BooleanPayload(bl, tags);
            }
            if (object instanceof Object) {
                Object object2 = object;
                return Serialized$.MODULE$.apply(object2, tags, ser, loadClass);
            }
            throw new IllegalArgumentException(new StringBuilder(38).append("Type for ").append(object).append(" of ").append(object.getClass()).append(" is currently unsupported").toString());
        });
    }

    public <D> Payload apply(String hint, Object any, Set<String> tags, Option<String> clazzName, Option<Object> serId, Option<String> serManifest, Serialization evs, Manifest<D> ev, DocumentType<D> dt, DynamicAccess loadClass) {
        Tuple2 tuple2 = new Tuple2((Object)hint, any);
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            Object repr = tuple2._2();
            if ("repr".equals(string) && repr instanceof byte[]) {
                byte[] byArray = (byte[])repr;
                return new Legacy(byArray, tags, evs);
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            Object ser = tuple2._2();
            if ("ser".equals(string) && ser instanceof byte[]) {
                byte[] byArray = (byte[])ser;
                return new Serialized(byArray, (String)clazzName.getOrElse((Function0 & Serializable)() -> Object.class.getName()), tags, serId, serManifest, evs, loadClass);
            }
        }
        if (tuple2 != null) {
            Option option;
            String string = (String)tuple2._1();
            Object d = tuple2._2();
            if ("bson".equals(string) && d != null && !(option = ev.unapply(d)).isEmpty() && option.get() instanceof Object) {
                return new Bson<Object>(d, tags, dt);
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            Object b = tuple2._2();
            if ("bin".equals(string) && b instanceof byte[]) {
                byte[] byArray = (byte[])b;
                return new Bin(byArray, tags);
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            Object s = tuple2._2();
            if ("s".equals(string) && s instanceof String) {
                String string2 = (String)s;
                return new StringPayload(string2, tags);
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            Object d = tuple2._2();
            if ("d".equals(string) && d instanceof Double) {
                double d2 = BoxesRunTime.unboxToDouble((Object)d);
                return new FloatingPointPayload(d2, tags);
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            Object l = tuple2._2();
            if ("l".equals(string) && l instanceof Long) {
                long l2 = BoxesRunTime.unboxToLong((Object)l);
                return new FixedPointPayload(l2, tags);
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            Object b = tuple2._2();
            if ("b".equals(string) && b instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)b);
                return new BooleanPayload(bl, tags);
            }
        }
        if (tuple2 != null) {
            String x = (String)tuple2._1();
            Object y = tuple2._2();
            throw new IllegalArgumentException(new StringBuilder(42).append("Unknown hint ").append(x).append(" or type for payload content ").append(y).toString());
        }
        throw new MatchError((Object)tuple2);
    }

    public <D> Set<String> apply$default$2() {
        return Predef$.MODULE$.Set().empty();
    }

    private Payload$() {
    }
}

