/*
 * Decompiled with CFR 0.152.
 */
package pekko.contrib.persistence.mongodb.driver;

import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.result.UpdateResult;
import java.io.Serializable;
import org.apache.pekko.persistence.SelectedSnapshot;
import org.apache.pekko.serialization.Serialization;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.mongodb.scala.MongoCollection;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Indexes$;
import org.mongodb.scala.package$;
import pekko.contrib.persistence.mongodb.MongoPersistenceSnapshottingApi;
import pekko.contrib.persistence.mongodb.SnapshottingFieldNames$V1$;
import pekko.contrib.persistence.mongodb.SnapshottingFieldNames$V2$;
import pekko.contrib.persistence.mongodb.driver.ScalaDriverPersistenceSnapshotter$;
import pekko.contrib.persistence.mongodb.driver.ScalaMongoDriver;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001ds!B\u0007\u000f\u0011\u0003Ib!B\u000e\u000f\u0011\u0003a\u0002\"B\u0014\u0002\t\u0003A\u0003\"B\u0015\u0002\t\u0003Q\u0003\"B+\u0002\t\u00031\u0006\"B.\u0002\t\u0003af\u0001B\u000e\u000f\u0001)D\u0001b\u0004\u0004\u0003\u0002\u0003\u0006IA\u001c\u0005\u0006O\u0019!\t!\u001d\u0005\u0006i\u001a!\t%\u001e\u0005\b\u0003C1A\u0011IA\u0012\u0011\u001d\tyC\u0002C!\u0003cAq!!\u0010\u0007\t\u0003\ny$A\u0011TG\u0006d\u0017\r\u0012:jm\u0016\u0014\b+\u001a:tSN$XM\\2f':\f\u0007o\u001d5piR,'O\u0003\u0002\u0010!\u00051AM]5wKJT!!\u0005\n\u0002\u000f5|gnZ8eE*\u00111\u0003F\u0001\fa\u0016\u00148/[:uK:\u001cWM\u0003\u0002\u0016-\u000591m\u001c8ue&\u0014'\"A\f\u0002\u000bA,7n[8\u0004\u0001A\u0011!$A\u0007\u0002\u001d\t\t3kY1mC\u0012\u0013\u0018N^3s!\u0016\u00148/[:uK:\u001cWm\u00158baNDw\u000e\u001e;feN\u0019\u0011!H\u0012\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\r\u0005s\u0017PU3g!\t!S%D\u0001\u0011\u0013\t1\u0003C\u0001\fT]\u0006\u00048\u000f[8ui&twMR5fY\u0012t\u0015-\\3t\u0003\u0019a\u0014N\\5u}Q\t\u0011$A\ttKJL\u0017\r\\5{KNs\u0017\r]:i_R$\"a\u000b(\u0015\u00051\"\u0005CA\u0017B\u001d\tqcH\u0004\u00020w9\u0011\u0001'\u000f\b\u0003c]r!AM\u001b\u000e\u0003MR!\u0001\u000e\r\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0014aA8sO&\u0011\u0011\u0003\u000f\u0006\u0002m%\u0011\u0001E\u000f\u0006\u0003#aJ!\u0001P\u001f\u0002\t\t\u001cxN\u001c\u0006\u0003AiJ!a\u0010!\u0002\u000fA\f7m[1hK*\u0011A(P\u0005\u0003\u0005\u000e\u0013ABQ:p]\u0012{7-^7f]RT!a\u0010!\t\u000b\u0015\u001b\u00019\u0001$\u0002\u001bM,'/[1mSj\fG/[8o!\t9E*D\u0001I\u0015\t)\u0015J\u0003\u0002\u0018\u0015*\u00111\nO\u0001\u0007CB\f7\r[3\n\u00055C%!D*fe&\fG.\u001b>bi&|g\u000eC\u0003P\u0007\u0001\u0007\u0001+\u0001\u0005t]\u0006\u00048\u000f[8u!\t\t6+D\u0001S\u0015\t\u0019\u0012*\u0003\u0002U%\n\u00012+\u001a7fGR,Gm\u00158baNDw\u000e^\u0001\u0014I\u0016\u001cXM]5bY&TXm\u00158baNDw\u000e\u001e\u000b\u0003/f#\"\u0001\u0015-\t\u000b\u0015#\u00019\u0001$\t\u000bi#\u0001\u0019\u0001\u0017\u0002\u0011\u0011|7-^7f]R\fq\u0003\\3hC\u000eL8+\u001a:jC2L'0Z*oCB\u001c\bn\u001c;\u0015\u0005u{FC\u0001\u0017_\u0011\u0015)U\u0001q\u0001G\u0011\u0015yU\u00011\u0001QQ\u0019)\u0011\rZ3hQB\u0011aDY\u0005\u0003G~\u0011!\u0002Z3qe\u0016\u001c\u0017\r^3e\u0003\u001diWm]:bO\u0016\f\u0013AZ\u0001\u0015+N,\u0007E\u001e\u001a!oJLG/\u001a\u0011j]N$X-\u00193\u0002\u000bMLgnY3\"\u0003%\fQ\u0001\r\u00184]A\u001a2AB\u000fl!\t!C.\u0003\u0002n!\tyRj\u001c8h_B+'o]5ti\u0016t7-Z*oCB\u001c\bn\u001c;uS:<\u0017\t]5\u0011\u0005iy\u0017B\u00019\u000f\u0005A\u00196-\u00197b\u001b>twm\u001c#sSZ,'\u000f\u0006\u0002sgB\u0011!D\u0002\u0005\u0006\u001f!\u0001\rA\\\u0001\"M&tG-W8v]\u001e,7\u000f^*oCB\u001c\bn\u001c;Cs6\u000b\u0007pU3rk\u0016t7-\u001a\u000b\u0007m~\f\u0019\"!\b\u0011\u0007]TH0D\u0001y\u0015\tIx$\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u001f=\u0003\r\u0019+H/\u001e:f!\rqR\u0010U\u0005\u0003}~\u0011aa\u00149uS>t\u0007bBA\u0001\u0013\u0001\u0007\u00111A\u0001\u0004a&$\u0007\u0003BA\u0003\u0003\u001bqA!a\u0002\u0002\nA\u0011!gH\u0005\u0004\u0003\u0017y\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0010\u0005E!AB*ue&twMC\u0002\u0002\f}Aq!!\u0006\n\u0001\u0004\t9\"\u0001\u0004nCb\u001cV-\u001d\t\u0004=\u0005e\u0011bAA\u000e?\t!Aj\u001c8h\u0011\u001d\ty\"\u0003a\u0001\u0003/\tQ!\\1y)N\fAb]1wKNs\u0017\r]:i_R$B!!\n\u0002.A!qO_A\u0014!\rq\u0012\u0011F\u0005\u0004\u0003Wy\"\u0001B+oSRDQa\u0014\u0006A\u0002A\u000ba\u0002Z3mKR,7K\\1qg\"|G\u000f\u0006\u0005\u0002&\u0005M\u0012QGA\u001d\u0011\u001d\t\ta\u0003a\u0001\u0003\u0007Aq!a\u000e\f\u0001\u0004\t9\"A\u0002tKFDq!a\u000f\f\u0001\u0004\t9\"\u0001\u0002ug\u00069B-\u001a7fi\u0016l\u0015\r^2iS:<7K\\1qg\"|Go\u001d\u000b\t\u0003K\t\t%a\u0011\u0002F!9\u0011\u0011\u0001\u0007A\u0002\u0005\r\u0001bBA\u000b\u0019\u0001\u0007\u0011q\u0003\u0005\b\u0003?a\u0001\u0019AA\f\u0001")
public class ScalaDriverPersistenceSnapshotter
implements MongoPersistenceSnapshottingApi {
    private final ScalaMongoDriver driver;

    public static BsonDocument legacySerializeSnapshot(SelectedSnapshot snapshot, Serialization serialization) {
        return ScalaDriverPersistenceSnapshotter$.MODULE$.legacySerializeSnapshot(snapshot, serialization);
    }

    public static SelectedSnapshot deserializeSnapshot(BsonDocument document, Serialization serialization) {
        return ScalaDriverPersistenceSnapshotter$.MODULE$.deserializeSnapshot(document, serialization);
    }

    public static BsonDocument serializeSnapshot(SelectedSnapshot snapshot, Serialization serialization) {
        return ScalaDriverPersistenceSnapshotter$.MODULE$.serializeSnapshot(snapshot, serialization);
    }

    public static SnapshottingFieldNames$V2$ V2() {
        return ScalaDriverPersistenceSnapshotter$.MODULE$.V2();
    }

    public static SnapshottingFieldNames$V1$ V1() {
        return ScalaDriverPersistenceSnapshotter$.MODULE$.V1();
    }

    public static String TIMESTAMP() {
        return ScalaDriverPersistenceSnapshotter$.MODULE$.TIMESTAMP();
    }

    public static String SEQUENCE_NUMBER() {
        return ScalaDriverPersistenceSnapshotter$.MODULE$.SEQUENCE_NUMBER();
    }

    public static String PROCESSOR_ID() {
        return ScalaDriverPersistenceSnapshotter$.MODULE$.PROCESSOR_ID();
    }

    @Override
    public Future<Option<SelectedSnapshot>> findYoungestSnapshotByMaxSequence(String pid, long maxSeq, long maxTs) {
        Future<Object> snaps = this.driver.getSnaps(pid);
        return snaps.flatMap((Function1 & Serializable)x$7 -> package$.MODULE$.SingleObservableFuture((Function0 & Serializable)() -> x$7.find(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.equal("pid", (Object)pid), Filters$.MODULE$.lte("sn", (Object)BoxesRunTime.boxToLong((long)maxSeq)), Filters$.MODULE$.lte("ts", (Object)BoxesRunTime.boxToLong((long)maxTs))})), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonDocument.class)).sort(Indexes$.MODULE$.descending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sn", "ts"}))).first()).toFutureOption().map((Function1 & Serializable)x$8 -> x$8.map((Function1 & Serializable)x$9 -> x$9.asDocument()).map((Function1 & Serializable)document -> ScalaDriverPersistenceSnapshotter$.MODULE$.deserializeSnapshot((BsonDocument)document, $this.driver.ScalaSerializers().serialization())), $this.driver.pluginDispatcher()).recoverWith((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    A12.printStackTrace();
                    return (B1)Future$.MODULE$.failed(A12);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable != null;
            }
        }, $this.driver.pluginDispatcher()), this.driver.pluginDispatcher());
    }

    @Override
    public Future<BoxedUnit> saveSnapshot(SelectedSnapshot snapshot) {
        Future<Object> snaps = this.driver.snaps(snapshot.metadata().persistenceId());
        Bson query = Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.equal("pid", (Object)snapshot.metadata().persistenceId()), Filters$.MODULE$.equal("sn", (Object)BoxesRunTime.boxToLong((long)snapshot.metadata().sequenceNr())), Filters$.MODULE$.equal("ts", (Object)BoxesRunTime.boxToLong((long)snapshot.metadata().timestamp()))}));
        return snaps.map((Function1 & Serializable)x$10 -> x$10.withWriteConcern($this.driver.snapsWriteConcern()), this.driver.pluginDispatcher()).flatMap((Function1 & Serializable)x$11 -> package$.MODULE$.SingleObservableFuture((Function0 & Serializable)() -> x$11.replaceOne(query, (Object)ScalaDriverPersistenceSnapshotter$.MODULE$.serializeSnapshot(snapshot, $this.driver.ScalaSerializers().serialization()), new ReplaceOptions().upsert(true))).toFuture(), this.driver.pluginDispatcher()).map((Function1 & Serializable)x$12 -> {
            ScalaDriverPersistenceSnapshotter.$anonfun$saveSnapshot$4(x$12);
            return BoxedUnit.UNIT;
        }, this.driver.pluginDispatcher());
    }

    @Override
    public Future<BoxedUnit> deleteSnapshot(String pid, long seq, long ts) {
        Future<Object> snaps = this.driver.getSnaps(pid);
        Bson criteria = (Bson)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)ts)).filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$13 -> x$13 > 0L)).foldLeft((Object)Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.equal("pid", (Object)pid), Filters$.MODULE$.equal("sn", (Object)BoxesRunTime.boxToLong((long)seq))})), (Function2 & Serializable)(x0$1, x1$1) -> ScalaDriverPersistenceSnapshotter.$anonfun$deleteSnapshot$2(x0$1, BoxesRunTime.unboxToLong((Object)x1$1)));
        return snaps.map((Function1 & Serializable)s0 -> {
            MongoCollection s = s0.withWriteConcern($this.driver.snapsWriteConcern());
            return new Tuple2(s0, (Object)s);
        }, this.driver.pluginDispatcher()).flatMap((Function1 & Serializable)x$15 -> {
            Tuple2 tuple2 = x$15;
            if (tuple2 != null) {
                MongoCollection s = (MongoCollection)tuple2._2();
                return package$.MODULE$.SingleObservableFuture((Function0 & Serializable)() -> s.deleteMany(criteria)).toFuture().map((Function1 & Serializable)wr -> {
                    object = this.driver.useSuffixedCollectionNames() && this.driver.suffixDropEmpty() && wr.wasAcknowledged() ? this.driver.removeEmptySnapshot(s).map((Function1 & Serializable)x$14 -> {
                        $this.driver.removeSnapsInCache(pid$2);
                        return BoxedUnit.UNIT;
                    }, this.driver.pluginDispatcher()) : BoxedUnit.UNIT;
                    return BoxedUnit.UNIT;
                }, $this.driver.pluginDispatcher());
            }
            throw new MatchError((Object)tuple2);
        }, this.driver.pluginDispatcher());
    }

    @Override
    public Future<BoxedUnit> deleteMatchingSnapshots(String pid, long maxSeq, long maxTs) {
        Future<Object> snaps = this.driver.getSnaps(pid);
        return snaps.map((Function1 & Serializable)s0 -> {
            MongoCollection s = s0.withWriteConcern($this.driver.snapsWriteConcern());
            return new Tuple2(s0, (Object)s);
        }, this.driver.pluginDispatcher()).flatMap((Function1 & Serializable)x$17 -> {
            Tuple2 tuple2 = x$17;
            if (tuple2 != null) {
                MongoCollection s = (MongoCollection)tuple2._2();
                return package$.MODULE$.SingleObservableFuture((Function0 & Serializable)() -> s.deleteMany(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.equal("pid", (Object)pid), Filters$.MODULE$.lte("sn", (Object)BoxesRunTime.boxToLong((long)maxSeq)), Filters$.MODULE$.lte("ts", (Object)BoxesRunTime.boxToLong((long)maxTs))})))).toFuture().map((Function1 & Serializable)wr -> {
                    object = this.driver.useSuffixedCollectionNames() && this.driver.suffixDropEmpty() && wr.wasAcknowledged() ? this.driver.removeEmptySnapshot(s).map((Function1 & Serializable)x$16 -> {
                        $this.driver.removeSnapsInCache(pid$3);
                        return BoxedUnit.UNIT;
                    }, this.driver.pluginDispatcher()) : BoxedUnit.UNIT;
                    return BoxedUnit.UNIT;
                }, $this.driver.pluginDispatcher());
            }
            throw new MatchError((Object)tuple2);
        }, this.driver.pluginDispatcher());
    }

    public static final /* synthetic */ void $anonfun$saveSnapshot$4(UpdateResult x$12) {
    }

    public static final /* synthetic */ Bson $anonfun$deleteSnapshot$2(Bson x0$1, long x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)BoxesRunTime.boxToLong((long)x1$1));
        if (tuple2 != null) {
            Bson bson = (Bson)tuple2._1();
            long stamp = tuple2._2$mcJ$sp();
            return Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{bson, Filters$.MODULE$.equal("ts", (Object)BoxesRunTime.boxToLong((long)stamp))}));
        }
        throw new MatchError((Object)tuple2);
    }

    public ScalaDriverPersistenceSnapshotter(ScalaMongoDriver driver) {
        this.driver = driver;
    }
}

