/*
 * Decompiled with CFR 0.152.
 */
package pekko.contrib.persistence.mongodb.driver;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCommandException;
import com.mongodb.WriteConcern;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.IndexOptions;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.actor.ActorSystem;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.MongoClient;
import org.mongodb.scala.MongoClient$;
import org.mongodb.scala.MongoCollection;
import org.mongodb.scala.MongoDatabase;
import org.mongodb.scala.SingleObservable;
import org.mongodb.scala.WriteConcern$;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Indexes$;
import org.mongodb.scala.model.package;
import org.mongodb.scala.package$;
import pekko.contrib.persistence.mongodb.MongoErrors$NamespaceExists$;
import pekko.contrib.persistence.mongodb.MongoPersistenceDriver;
import pekko.contrib.persistence.mongodb.MongoPersistenceDriver$Acknowledged$;
import pekko.contrib.persistence.mongodb.MongoPersistenceDriver$Journaled$;
import pekko.contrib.persistence.mongodb.MongoPersistenceDriver$ReplicaAcknowledged$;
import pekko.contrib.persistence.mongodb.MongoPersistenceDriver$Unacknowledged$;
import pekko.contrib.persistence.mongodb.MongoPersistenceDriver$W1$;
import pekko.contrib.persistence.mongodb.MongoPersistenceDriver$W2$;
import pekko.contrib.persistence.mongodb.MongoPersistenceDriver$W3$;
import pekko.contrib.persistence.mongodb.driver.ScalaDriverSerializers;
import pekko.contrib.persistence.mongodb.driver.ScalaDriverSerializersExtension$;
import pekko.contrib.persistence.mongodb.driver.ScalaDriverSettings;
import pekko.contrib.persistence.mongodb.driver.ScalaDriverSettings$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tua\u0001B\u000f\u001f\u0001%B\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tu\u0001\u0011\t\u0011)A\u0005w!)A\t\u0001C\u0001\u000b\u0016!!\n\u0001\u0011L\u000b\u00111\u0007\u0001\t*\t\u000f\u001d\u0004!\u0019!C\u0001Q\"1A\u000e\u0001Q\u0001\n%Dq!\u001c\u0001C\u0002\u0013\u0005a\u000e\u0003\u0004s\u0001\u0001\u0006Ia\u001c\u0005\bg\u0002\u0011\r\u0011\"\u0001u\u0011\u0019Y\b\u0001)A\u0005k\"AA\u0010\u0001EC\u0002\u0013\u0005Q\u0010\u0003\u0006\u0002\u0004\u0001A)\u0019!C\u0001\u0003\u000bAq!!\u0004\u0001\t\u0003\ny\u0001C\u0004\u00028\u0001!\t%!\u000f\t\u0011\u0005]\u0002\u0001)C\u0005\u0003{Aq!!\u0017\u0001\t\u0003\tY\u0006C\u0004\u0002d\u0001!\t!a\u0017\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002\\!9\u0011q\r\u0001\u0005\n\u0005%\u0004bBAT\u0001\u0011\u0005\u0013\u0011\u0016\u0005\t\u0003[\u0003\u0001\u0015\"\u0003\u00020\"9\u0011q\u0017\u0001\u0005B\u0005e\u0006bBAg\u0001\u0011\u0005\u0013q\u001a\u0005\t\u0003'\u0004\u0001\u0015\"\u0003\u0002V\"9\u0011\u0011\u001e\u0001\u0005B\u0005-\bbBAz\u0001\u0011\u0005\u0013Q\u001f\u0005\b\u00053\u0001A\u0011\tB\u000e\u0005A\u00196-\u00197b\u001b>twm\u001c#sSZ,'O\u0003\u0002 A\u00051AM]5wKJT!!\t\u0012\u0002\u000f5|gnZ8eE*\u00111\u0005J\u0001\fa\u0016\u00148/[:uK:\u001cWM\u0003\u0002&M\u000591m\u001c8ue&\u0014'\"A\u0014\u0002\u000bA,7n[8\u0004\u0001M\u0011\u0001A\u000b\t\u0003W1j\u0011\u0001I\u0005\u0003[\u0001\u0012a#T8oO>\u0004VM]:jgR,gnY3Ee&4XM]\u0001\u0007gf\u001cH/Z7\u0011\u0005ABT\"A\u0019\u000b\u0005I\u001a\u0014!B1di>\u0014(BA\u00145\u0015\t)d'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002o\u0005\u0019qN]4\n\u0005e\n$aC!di>\u00148+_:uK6\faaY8oM&<\u0007C\u0001\u001fC\u001b\u0005i$B\u0001\u001e?\u0015\ty\u0004)\u0001\u0005usB,7/\u00194f\u0015\u0005\t\u0015aA2p[&\u00111)\u0010\u0002\u0007\u0007>tg-[4\u0002\rqJg.\u001b;?)\r1\u0005*\u0013\t\u0003\u000f\u0002i\u0011A\b\u0005\u0006]\r\u0001\ra\f\u0005\u0006u\r\u0001\ra\u000f\u0002\u0002\u0007B\u0019A\n\u0015*\u000e\u00035S!AT(\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005\u00052\u0014BA)N\u0005=iuN\\4p\u0007>dG.Z2uS>t\u0007CA*d\u001d\t!\u0006M\u0004\u0002V=:\u0011a+\u0018\b\u0003/rs!\u0001W.\u000e\u0003eS!A\u0017\u0015\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0014BA\u00117\u0013\tqu*\u0003\u0002`\u001b\u0006!!m]8o\u0013\t\t'-A\u0004qC\u000e\\\u0017mZ3\u000b\u0005}k\u0015B\u00013f\u00051\u00115o\u001c8E_\u000e,X.\u001a8u\u0015\t\t'MA\u0001E\u0003A\u00196-\u00197b'\u0016\u0014\u0018.\u00197ju\u0016\u00148/F\u0001j!\t9%.\u0003\u0002l=\t12kY1mC\u0012\u0013\u0018N^3s'\u0016\u0014\u0018.\u00197ju\u0016\u00148/A\tTG\u0006d\u0017mU3sS\u0006d\u0017N_3sg\u0002\n1c]2bY\u0006$%/\u001b<feN+G\u000f^5oON,\u0012a\u001c\t\u0003\u000fBL!!\u001d\u0010\u0003'M\u001b\u0017\r\\1Ee&4XM]*fiRLgnZ:\u0002)M\u001c\u0017\r\\1Ee&4XM]*fiRLgnZ:!\u0003MiwN\\4p\u00072LWM\u001c;TKR$\u0018N\\4t+\u0005)\bC\u0001<y\u001d\t)v/\u0003\u0002b\u001b&\u0011\u0011P\u001f\u0002\u0014\u001b>twm\\\"mS\u0016tGoU3ui&twm\u001d\u0006\u0003C6\u000bA#\\8oO>\u001cE.[3oiN+G\u000f^5oON\u0004\u0013AB2mS\u0016tG/F\u0001\u007f!\tau0C\u0002\u0002\u00025\u00131\"T8oO>\u001cE.[3oi\u0006\u0011AMY\u000b\u0003\u0003\u000f\u00012\u0001TA\u0005\u0013\r\tY!\u0014\u0002\u000e\u001b>twm\u001c#bi\u0006\u0014\u0017m]3\u0002\u0015\r|G\u000e\\3di&|g\u000e\u0006\u0003\u0002\u0012\u0005\r\u0002CBA\n\u00037\ty\"\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0002\u001d&!\u0011QDA\u000b\u0005\u00191U\u000f^;sKB\u0019\u0011\u0011\u0005\u0003\u000e\u0003\u0001Aq!!\n\u000f\u0001\u0004\t9#\u0001\u0003oC6,\u0007\u0003BA\u0015\u0003cqA!a\u000b\u0002.A\u0019\u0001,!\u0007\n\t\u0005=\u0012\u0011D\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0012Q\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\t\u0005=\u0012\u0011D\u0001\u0011K:\u001cXO]3D_2dWm\u0019;j_:$B!!\u0005\u0002<!9\u0011QE\bA\u0002\u0005\u001dBCBA\t\u0003\u007f\t\t\u0005C\u0004\u0002&A\u0001\r!a\n\t\u000f\u0005\r\u0003\u00031\u0001\u0002F\u0005\t2m\u001c7mK\u000e$\u0018n\u001c8De\u0016\fGo\u001c:\u0011\u0011\u0005\u001d\u0013\u0011JA\u0014\u0003\u001bj!!!\u0007\n\t\u0005-\u0013\u0011\u0004\u0002\n\rVt7\r^5p]F\u0002R\u0001TA(\u0003'J1!!\u0015N\u0005A\u0019\u0016N\\4mK>\u00137/\u001a:wC\ndW\r\u0005\u0003\u0002H\u0005U\u0013\u0002BA,\u00033\u0011A!\u00168ji\u0006\u0019\"n\\;s]\u0006dwK]5uK\u000e{gnY3s]V\u0011\u0011Q\f\t\u0004m\u0006}\u0013bAA1u\naqK]5uK\u000e{gnY3s]\u0006\t2O\\1qg^\u0013\u0018\u000e^3D_:\u001cWM\u001d8\u0002)5,G/\u00193bi\u0006<&/\u001b;f\u0007>t7-\u001a:o\u00039!xn\u0016:ji\u0016\u001cuN\\2fe:$\u0002\"!\u0018\u0002l\u00055\u0015Q\u0014\u0005\b\u0003[\"\u0002\u0019AA8\u0003-9(/\u001b;f'\u00064W\r^=\u0011\t\u0005E\u0014q\u0011\b\u0005\u0003g\n\u0019I\u0004\u0003\u0002v\u0005\u0005e\u0002BA<\u0003\u007frA!!\u001f\u0002~9\u0019\u0001,a\u001f\n\u0003\u001dJ!!\n\u0014\n\u0005\r\"\u0013BA\u0011#\u0013\r\t)\tI\u0001\u0017\u001b>twm\u001c)feNL7\u000f^3oG\u0016$%/\u001b<fe&!\u0011\u0011RAF\u0005-9&/\u001b;f'\u00064W\r^=\u000b\u0007\u0005\u0015\u0005\u0005C\u0004\u0002\u0010R\u0001\r!!%\u0002\u0011]$\u0018.\\3pkR\u0004B!a%\u0002\u001a6\u0011\u0011Q\u0013\u0006\u0005\u0003/\u000b)\"\u0001\u0005ekJ\fG/[8o\u0013\u0011\tY*!&\u0003\u0011\u0011+(/\u0019;j_:Dq!a(\u0015\u0001\u0004\t\t+A\u0003ggft7\r\u0005\u0003\u0002H\u0005\r\u0016\u0002BAS\u00033\u0011qAQ8pY\u0016\fg.\u0001\tdCB\u0004X\rZ\"pY2,7\r^5p]R!\u0011\u0011CAV\u0011\u001d\t)#\u0006a\u0001\u0003O\t!#[:DCB\u0004X\rZ\"pY2,7\r^5p]R!\u0011\u0011WAZ!\u0019\t\u0019\"a\u0007\u0002\"\"9\u0011Q\u0017\fA\u0002\u0005\u001d\u0012AD2pY2,7\r^5p]:\u000bW.Z\u0001\u0010G>dG.Z2uS>tg*Y7fgV\u0011\u00111\u0018\t\u0007\u0003'\tY\"!0\u0011\r\u0005}\u0016qYA\u0014\u001d\u0011\t\t-!2\u000f\u0007a\u000b\u0019-C\u0001O\u0013\r\t\u0017\u0011D\u0005\u0005\u0003\u0013\fYM\u0001\u0003MSN$(bA1\u0002\u001a\u0005ar-\u001a;N_:<wNV3sg&|gN\u0012:p[\n+\u0018\u000e\u001c3J]\u001a|WCAAi!\u0019\t\u0019\"a\u0007\u0002(\u0005qq-\u001a;J]\u0012,\u00070Q:Cg>tGCBAl\u0003?\f)\u000f\u0005\u0004\u0002\u0014\u0005m\u0011\u0011\u001c\t\u0006\u0003\u000f\nYNU\u0005\u0005\u0003;\fIB\u0001\u0004PaRLwN\u001c\u0005\b\u0003\u001bI\u0002\u0019AAq!\u0011a\u0005+a9\u0011\u0007\u0005\u0005R\u0001C\u0004\u0002hf\u0001\r!a\n\u0002\u0013%tG-\u001a=OC6,\u0017!\u0006:f[>4X-R7qif\u001cu\u000e\u001c7fGRLwN\u001c\u000b\u0007\u0003[\fy/!=\u0011\r\u0005M\u00111DA*\u0011\u001d\tiA\u0007a\u0001\u0003CDq!a:\u001b\u0001\u0004\t9#A\u0006f]N,(/Z%oI\u0016DHCCA|\u0003s\fY0a@\u0003\u0004AA\u0011qIA%\u0003?\t\t\u0002C\u0004\u0002hn\u0001\r!a\n\t\u000f\u0005u8\u00041\u0001\u0002\"\u00061QO\\5rk\u0016DqA!\u0001\u001c\u0001\u0004\t\t+\u0001\u0004ta\u0006\u00148/\u001a\u0005\b\u0005\u000bY\u0002\u0019\u0001B\u0004\u0003\u00191\u0017.\u001a7egB1\u0011q\tB\u0005\u0005\u001bIAAa\u0003\u0002\u001a\tQAH]3qK\u0006$X\r\u001a \u0011\u0011\u0005\u001d#qBA\u0014\u0005'IAA!\u0005\u0002\u001a\t1A+\u001e9mKJ\u0002B!a\u0012\u0003\u0016%!!qCA\r\u0005\rIe\u000e^\u0001\u0011G2|7/Z\"p]:,7\r^5p]N$\"!a\u0015")
public class ScalaMongoDriver
extends MongoPersistenceDriver {
    private MongoClient client;
    private MongoDatabase db;
    private final ScalaDriverSerializers ScalaSerializers;
    private final ScalaDriverSettings scalaDriverSettings;
    private final MongoClientSettings mongoClientSettings;
    private volatile byte bitmap$0;

    public ScalaDriverSerializers ScalaSerializers() {
        return this.ScalaSerializers;
    }

    public ScalaDriverSettings scalaDriverSettings() {
        return this.scalaDriverSettings;
    }

    public MongoClientSettings mongoClientSettings() {
        return this.mongoClientSettings;
    }

    private MongoClient client$lzycompute() {
        ScalaMongoDriver scalaMongoDriver = this;
        synchronized (scalaMongoDriver) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.client = MongoClient$.MODULE$.apply(this.mongoClientSettings());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.client;
    }

    public MongoClient client() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.client$lzycompute();
        }
        return this.client;
    }

    private MongoDatabase db$lzycompute() {
        ScalaMongoDriver scalaMongoDriver = this;
        synchronized (scalaMongoDriver) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String dbName = (String)this.databaseName().orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)new ConnectionString(this.mongoUri()).getDatabase())).getOrElse((Function0 & Serializable)() -> this.DEFAULT_DB_NAME());
                this.db = this.client().getDatabase(dbName);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.db;
    }

    public MongoDatabase db() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.db$lzycompute();
        }
        return this.db;
    }

    public Future<MongoCollection<BsonDocument>> collection(String name) {
        return Future$.MODULE$.successful((Object)this.db().getCollection(name, DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)));
    }

    public Future<MongoCollection<BsonDocument>> ensureCollection(String name) {
        return this.ensureCollection(name, (Function1<String, SingleObservable<BoxedUnit>>)(Function1 & Serializable)collectionName -> this.db().createCollection(collectionName));
    }

    private Future<MongoCollection<BsonDocument>> ensureCollection(String name, Function1<String, SingleObservable<BoxedUnit>> collectionCreator) {
        return package$.MODULE$.SingleObservableFuture((Function0 & Serializable)() -> (SingleObservable)collectionCreator.apply((Object)name)).toFuture().recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                MongoCommandException mongoCommandException;
                A1 A1 = x1;
                if (A1 instanceof MongoCommandException && MongoErrors$NamespaceExists$.MODULE$.unapply(mongoCommandException = (MongoCommandException)A1)) {
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                MongoCommandException mongoCommandException;
                Throwable throwable = x1;
                return throwable instanceof MongoCommandException && MongoErrors$NamespaceExists$.MODULE$.unapply(mongoCommandException = (MongoCommandException)throwable);
            }
        }, this.pluginDispatcher()).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return this.collection(name).map((Function1 & Serializable)mongoCollection -> mongoCollection, this.pluginDispatcher());
        }, this.pluginDispatcher());
    }

    public WriteConcern journalWriteConcern() {
        return this.toWriteConcern(this.journalWriteSafety(), (Duration)this.journalWTimeout(), this.journalFsync());
    }

    public WriteConcern snapsWriteConcern() {
        return this.toWriteConcern(this.snapsWriteSafety(), (Duration)this.snapsWTimeout(), this.snapsFsync());
    }

    public WriteConcern metadataWriteConcern() {
        return this.toWriteConcern(this.journalWriteSafety(), (Duration)this.journalWTimeout(), this.journalFsync());
    }

    private WriteConcern toWriteConcern(MongoPersistenceDriver.WriteSafety writeSafety, Duration wtimeout, boolean fsync) {
        Tuple3 tuple3 = new Tuple3((Object)writeSafety, (Object)BoxesRunTime.boxToLong((long)wtimeout.toMillis()), (Object)BoxesRunTime.boxToBoolean((boolean)fsync));
        if (tuple3 != null) {
            MongoPersistenceDriver.WriteSafety writeSafety2 = (MongoPersistenceDriver.WriteSafety)tuple3._1();
            long w = BoxesRunTime.unboxToLong((Object)tuple3._2());
            if (MongoPersistenceDriver$Unacknowledged$.MODULE$.equals(writeSafety2)) {
                return WriteConcern$.MODULE$.UNACKNOWLEDGED().withWTimeout(w, TimeUnit.MILLISECONDS);
            }
        }
        if (tuple3 != null) {
            MongoPersistenceDriver.WriteSafety writeSafety3 = (MongoPersistenceDriver.WriteSafety)tuple3._1();
            long w = BoxesRunTime.unboxToLong((Object)tuple3._2());
            if (MongoPersistenceDriver$Acknowledged$.MODULE$.equals(writeSafety3)) {
                return WriteConcern$.MODULE$.ACKNOWLEDGED().withWTimeout(w, TimeUnit.MILLISECONDS);
            }
        }
        if (tuple3 != null) {
            MongoPersistenceDriver.WriteSafety writeSafety4 = (MongoPersistenceDriver.WriteSafety)tuple3._1();
            long w = BoxesRunTime.unboxToLong((Object)tuple3._2());
            if (MongoPersistenceDriver$W1$.MODULE$.equals(writeSafety4)) {
                return WriteConcern$.MODULE$.W1().withWTimeout(w, TimeUnit.MILLISECONDS);
            }
        }
        if (tuple3 != null) {
            MongoPersistenceDriver.WriteSafety writeSafety5 = (MongoPersistenceDriver.WriteSafety)tuple3._1();
            long w = BoxesRunTime.unboxToLong((Object)tuple3._2());
            if (MongoPersistenceDriver$W2$.MODULE$.equals(writeSafety5)) {
                return WriteConcern$.MODULE$.W2().withWTimeout(w, TimeUnit.MILLISECONDS);
            }
        }
        if (tuple3 != null) {
            MongoPersistenceDriver.WriteSafety writeSafety6 = (MongoPersistenceDriver.WriteSafety)tuple3._1();
            long w = BoxesRunTime.unboxToLong((Object)tuple3._2());
            if (MongoPersistenceDriver$W3$.MODULE$.equals(writeSafety6)) {
                return WriteConcern$.MODULE$.W3().withWTimeout(w, TimeUnit.MILLISECONDS);
            }
        }
        if (tuple3 != null) {
            MongoPersistenceDriver.WriteSafety writeSafety7 = (MongoPersistenceDriver.WriteSafety)tuple3._1();
            long w = BoxesRunTime.unboxToLong((Object)tuple3._2());
            if (MongoPersistenceDriver$Journaled$.MODULE$.equals(writeSafety7)) {
                return WriteConcern$.MODULE$.JOURNALED().withWTimeout(w, TimeUnit.MILLISECONDS);
            }
        }
        if (tuple3 != null) {
            MongoPersistenceDriver.WriteSafety writeSafety8 = (MongoPersistenceDriver.WriteSafety)tuple3._1();
            long w = BoxesRunTime.unboxToLong((Object)tuple3._2());
            boolean f = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            if (MongoPersistenceDriver$ReplicaAcknowledged$.MODULE$.equals(writeSafety8)) {
                return WriteConcern$.MODULE$.MAJORITY().withWTimeout(w, TimeUnit.MILLISECONDS).withJournal(Predef$.MODULE$.boolean2Boolean(!f));
            }
        }
        throw new MatchError((Object)tuple3);
    }

    public Future<MongoCollection<BsonDocument>> cappedCollection(String name) {
        Function1 & Serializable cappedCollectionCreator = (Function1 & Serializable)ccName -> this.db().createCollection(ccName, new CreateCollectionOptions().capped(true).sizeInBytes(this.realtimeCollectionSize()));
        return this.ensureCollection(name, (Function1<String, SingleObservable<BoxedUnit>>)cappedCollectionCreator).flatMap((Function1 & Serializable)collection -> this.isCappedCollection(name).flatMap((Function1 & Serializable)capped -> ScalaMongoDriver.$anonfun$cappedCollection$6(this, collection, name, cappedCollectionCreator, BoxesRunTime.unboxToBoolean((Object)capped)), this.pluginDispatcher()), this.pluginDispatcher());
    }

    private Future<Object> isCappedCollection(String collectionName) {
        return package$.MODULE$.SingleObservableFuture((Function0 & Serializable)() -> this.db().runCommand((Bson)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"collStats"), (Object)collectionName), (BsonTransformer)BsonTransformer$.MODULE$.TransformString())})), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class))).toFuture().map((Function1 & Serializable)stats -> BoxesRunTime.boxToBoolean((boolean)ScalaMongoDriver.$anonfun$isCappedCollection$2(stats)), this.pluginDispatcher());
    }

    @Override
    public Future<List<String>> collectionNames() {
        return package$.MODULE$.ObservableFuture((Function0 & Serializable)() -> this.db().listCollectionNames()).toFuture().map((Function1 & Serializable)x$4 -> x$4.toList(), this.pluginDispatcher());
    }

    @Override
    public Future<String> getMongoVersionFromBuildInfo() {
        return package$.MODULE$.SingleObservableFuture((Function0 & Serializable)() -> this.db().runCommand((Bson)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"buildInfo"), (Object)BoxesRunTime.boxToInteger((int)1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformInt())})), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class))).toFuture().map((Function1 & Serializable)x$5 -> ((BsonValue)x$5.get("version", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).getOrElse((Function0 & Serializable)() -> BsonString$.MODULE$.apply(""))).asString().getValue(), this.pluginDispatcher());
    }

    private Future<Option<BsonDocument>> getIndexAsBson(MongoCollection<BsonDocument> collection, String indexName) {
        return package$.MODULE$.ObservableFuture((Function0 & Serializable)() -> collection.listIndexes(DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class))).toFuture().map((Function1 & Serializable)indexList -> {
            None$ none$;
            Option indexDoc = indexList.find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ScalaMongoDriver.$anonfun$getIndexAsBson$3(indexName, x$6)));
            Option option = indexDoc;
            if (option instanceof Some) {
                Some some = (Some)option;
                BsonDocument doc = (BsonDocument)some.value();
                none$ = new Some((Object)doc.get((Object)"key").asDocument());
            } else if (None$.MODULE$.equals(option)) {
                none$ = None$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            None$ indexKey = none$;
            return new Tuple3(indexList, (Object)indexDoc, (Object)indexKey);
        }, this.pluginDispatcher()).map((Function1 & Serializable)x$7 -> {
            Tuple3 tuple3 = x$7;
            if (tuple3 != null) {
                Option indexKey = (Option)tuple3._3();
                return indexKey;
            }
            throw new MatchError((Object)tuple3);
        }, this.pluginDispatcher());
    }

    public Future<BoxedUnit> removeEmptyCollection(MongoCollection<BsonDocument> collection, String indexName) {
        return this.mongoVersion().flatMap((Function1 & Serializable)version -> package$.MODULE$.SingleObservableFuture((Function0 & Serializable)() -> collection.estimatedDocumentCount()).toFuture().flatMap((Function1 & Serializable)firstCount -> ScalaMongoDriver.$anonfun$removeEmptyCollection$3(this, collection, indexName, BoxesRunTime.unboxToLong((Object)firstCount)), this.pluginDispatcher()), this.pluginDispatcher());
    }

    public Function1<MongoCollection<BsonDocument>, Future<MongoCollection<BsonDocument>>> ensureIndex(String indexName, boolean unique, boolean sparse, Seq<Tuple2<String, Object>> fields) {
        return (Function1 & Serializable)collection -> package$.MODULE$.SingleObservableFuture((Function0 & Serializable)() -> collection.createIndex(Indexes$.MODULE$.compoundIndex((Seq)fields.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                int d = tuple2._2$mcI$sp();
                if (d > 0) {
                    return Indexes$.MODULE$.ascending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name}));
                }
            }
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                return Indexes$.MODULE$.descending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name}));
            }
            throw new MatchError((Object)tuple2);
        })), new IndexOptions().unique(unique).sparse(sparse).name(indexName))).toFuture().map((Function1 & Serializable)x$10 -> {
            String string = x$10;
            return collection;
        }, this.pluginDispatcher());
    }

    @Override
    public void closeConnections() {
        this.client().close();
    }

    private final Future recreate$1(MongoCollection collection, String name$2, Function1 cappedCollectionCreator$1) {
        return package$.MODULE$.SingleObservableFuture((Function0 & Serializable)() -> collection.drop()).toFuture().flatMap((Function1 & Serializable)x$2 -> {
            BoxedUnit boxedUnit = x$2;
            return this.ensureCollection(name$2, (Function1<String, SingleObservable<BoxedUnit>>)cappedCollectionCreator$1).map((Function1 & Serializable)recreatedCappedCollection -> recreatedCappedCollection, this.pluginDispatcher());
        }, this.pluginDispatcher());
    }

    public static final /* synthetic */ Future $anonfun$cappedCollection$6(ScalaMongoDriver $this, MongoCollection collection$2, String name$2, Function1 cappedCollectionCreator$1, boolean capped) {
        return (capped ? Future$.MODULE$.successful((Object)collection$2) : $this.recreate$1(collection$2, name$2, cappedCollectionCreator$1)).map((Function1 & Serializable)cc -> cc, $this.pluginDispatcher());
    }

    public static final /* synthetic */ boolean $anonfun$isCappedCollection$3(BsonValue x$3) {
        return x$3.asBoolean().getValue();
    }

    public static final /* synthetic */ boolean $anonfun$isCappedCollection$2(Document stats) {
        return stats.get("capped", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ScalaMongoDriver.$anonfun$isCappedCollection$3(x$3)));
    }

    public static final /* synthetic */ boolean $anonfun$getIndexAsBson$3(String indexName$1, BsonDocument x$6) {
        return x$6.get((Object)"name").asString().getValue().equals(indexName$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$removeEmptyCollection$9(ScalaMongoDriver $this, MongoCollection collection$4, long secondCount) {
        BoxedUnit x$8 = secondCount == 0L ? package$.MODULE$.SingleObservableFuture((Function0 & Serializable)() -> collection$4.drop()).toFuture().recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                return (B1)BoxedUnit.UNIT;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
        }, $this.pluginDispatcher()) : BoxedUnit.UNIT;
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)secondCount), (Object)x$8);
    }

    public static final /* synthetic */ void $anonfun$removeEmptyCollection$11(Tuple2 x$9) {
        Tuple2 tuple2 = x$9;
        if (tuple2 != null) {
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Future $anonfun$removeEmptyCollection$3(ScalaMongoDriver $this, MongoCollection collection$4, String indexName$2, long firstCount) {
        return (firstCount == 0L ? $this.getIndexAsBson((MongoCollection<BsonDocument>)collection$4, indexName$2).flatMap((Function1 & Serializable)indexKey -> package$.MODULE$.SingleObservableFuture((Function0 & Serializable)() -> (SingleObservable)indexKey.fold((Function0 & Serializable)() -> collection$4.countDocuments(), (Function1 & Serializable)index -> collection$4.countDocuments((Bson)BsonDocument$.MODULE$.apply(), package.CountOptions$.MODULE$.apply().hint((Bson)index)))).toFuture().map((Function1)(JFunction1.mcJJ.sp & Serializable)count -> count, $this.pluginDispatcher()), $this.pluginDispatcher()) : Future$.MODULE$.successful((Object)BoxesRunTime.boxToLong((long)firstCount))).map((Function1 & Serializable)secondCount -> ScalaMongoDriver.$anonfun$removeEmptyCollection$9($this, collection$4, BoxesRunTime.unboxToLong((Object)secondCount)), $this.pluginDispatcher()).map((Function1 & Serializable)x$9 -> {
            ScalaMongoDriver.$anonfun$removeEmptyCollection$11(x$9);
            return BoxedUnit.UNIT;
        }, $this.pluginDispatcher());
    }

    public ScalaMongoDriver(ActorSystem system, Config config) {
        super(system, config);
        this.ScalaSerializers = (ScalaDriverSerializers)ScalaDriverSerializersExtension$.MODULE$.apply(system);
        this.scalaDriverSettings = (ScalaDriverSettings)ScalaDriverSettings$.MODULE$.apply(system);
        this.mongoClientSettings = this.scalaDriverSettings().configure(this.mongoUri()).build();
    }
}

