/*
 * Decompiled with CFR 0.152.
 */
package pekko.contrib.persistence.mongodb;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Materializer$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pekko.contrib.persistence.mongodb.Atom;
import pekko.contrib.persistence.mongodb.CanDeserializeJournal;
import pekko.contrib.persistence.mongodb.CanSerializeJournal;
import pekko.contrib.persistence.mongodb.CanSuffixCollectionNames;
import pekko.contrib.persistence.mongodb.Event;
import pekko.contrib.persistence.mongodb.IndexSettings;
import pekko.contrib.persistence.mongodb.MongoCollectionCache;
import pekko.contrib.persistence.mongodb.MongoCollectionCache$;
import pekko.contrib.persistence.mongodb.MongoPersistenceDriver$;
import pekko.contrib.persistence.mongodb.MongoSettings;
import pekko.contrib.persistence.mongodb.MongoSettings$;
import pekko.contrib.persistence.mongodb.ReflectiveLookupExtension;
import pekko.contrib.persistence.mongodb.ReflectiveLookupExtension$;
import pekko.contrib.persistence.mongodb.ServerVersion;
import pekko.contrib.persistence.mongodb.ServerVersion$;
import pekko.contrib.persistence.mongodb.WithMongoPersistencePluginDispatcher;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u00115w\u0001CA%\u0003\u0017B\t!!\u0018\u0007\u0011\u0005\u0005\u00141\nE\u0001\u0003GBq!!\u001d\u0002\t\u0003\t\u0019HB\u0005\u0002v\u0005\u0001\n1%\t\u0002x\u001d9!qL\u0001\t\u0002\n\u0015ba\u0002B\u0010\u0003!\u0005%\u0011\u0005\u0005\b\u0003c*A\u0011\u0001B\u0012\u0011%\t)+BA\u0001\n\u0003\n9\u000bC\u0005\u0002:\u0016\t\t\u0011\"\u0001\u0002<\"I\u00111Y\u0003\u0002\u0002\u0013\u0005!q\u0005\u0005\n\u0003#,\u0011\u0011!C!\u0003'D\u0011\"!9\u0006\u0003\u0003%\tAa\u000b\t\u0013\u00055X!!A\u0005B\u0005=\b\"CAy\u000b\u0005\u0005I\u0011IAz\u0011%\t)0BA\u0001\n\u0013\t9pB\u0004\u0003b\u0005A\t)a)\u0007\u000f\u0005m\u0014\u0001#!\u0002~!9\u0011\u0011\u000f\t\u0005\u0002\u0005\u0005\u0006\"CAS!\u0005\u0005I\u0011IAT\u0011%\tI\fEA\u0001\n\u0003\tY\fC\u0005\u0002DB\t\t\u0011\"\u0001\u0002F\"I\u0011\u0011\u001b\t\u0002\u0002\u0013\u0005\u00131\u001b\u0005\n\u0003C\u0004\u0012\u0011!C\u0001\u0003GD\u0011\"!<\u0011\u0003\u0003%\t%a<\t\u0013\u0005E\b#!A\u0005B\u0005M\b\"CA{!\u0005\u0005I\u0011BA|\u000f\u001d\u0011\u0019'\u0001EA\u0005k1qAa\f\u0002\u0011\u0003\u0013\t\u0004C\u0004\u0002rm!\tAa\r\t\u0013\u0005\u00156$!A\u0005B\u0005\u001d\u0006\"CA]7\u0005\u0005I\u0011AA^\u0011%\t\u0019mGA\u0001\n\u0003\u00119\u0004C\u0005\u0002Rn\t\t\u0011\"\u0011\u0002T\"I\u0011\u0011]\u000e\u0002\u0002\u0013\u0005!1\b\u0005\n\u0003[\\\u0012\u0011!C!\u0003_D\u0011\"!=\u001c\u0003\u0003%\t%a=\t\u0013\u0005U8$!A\u0005\n\u0005]xa\u0002B3\u0003!\u0005%Q\t\u0004\b\u0005\u007f\t\u0001\u0012\u0011B!\u0011\u001d\t\tH\nC\u0001\u0005\u0007B\u0011\"!*'\u0003\u0003%\t%a*\t\u0013\u0005ef%!A\u0005\u0002\u0005m\u0006\"CAbM\u0005\u0005I\u0011\u0001B$\u0011%\t\tNJA\u0001\n\u0003\n\u0019\u000eC\u0005\u0002b\u001a\n\t\u0011\"\u0001\u0003L!I\u0011Q\u001e\u0014\u0002\u0002\u0013\u0005\u0013q\u001e\u0005\n\u0003c4\u0013\u0011!C!\u0003gD\u0011\"!>'\u0003\u0003%I!a>\b\u000f\t\u001d\u0014\u0001#!\u0003V\u00199!qJ\u0001\t\u0002\nE\u0003bBA9c\u0011\u0005!1\u000b\u0005\n\u0003K\u000b\u0014\u0011!C!\u0003OC\u0011\"!/2\u0003\u0003%\t!a/\t\u0013\u0005\r\u0017'!A\u0005\u0002\t]\u0003\"CAic\u0005\u0005I\u0011IAj\u0011%\t\t/MA\u0001\n\u0003\u0011Y\u0006C\u0005\u0002nF\n\t\u0011\"\u0011\u0002p\"I\u0011\u0011_\u0019\u0002\u0002\u0013\u0005\u00131\u001f\u0005\n\u0003k\f\u0014\u0011!C\u0005\u0003o<qA!\u001b\u0002\u0011\u0003\u0013)AB\u0004\u0002\u0000\u0006A\tI!\u0001\t\u000f\u0005ED\b\"\u0001\u0003\u0004!I\u0011Q\u0015\u001f\u0002\u0002\u0013\u0005\u0013q\u0015\u0005\n\u0003sc\u0014\u0011!C\u0001\u0003wC\u0011\"a1=\u0003\u0003%\tAa\u0002\t\u0013\u0005EG(!A\u0005B\u0005M\u0007\"CAqy\u0005\u0005I\u0011\u0001B\u0006\u0011%\ti\u000fPA\u0001\n\u0003\ny\u000fC\u0005\u0002rr\n\t\u0011\"\u0011\u0002t\"I\u0011Q\u001f\u001f\u0002\u0002\u0013%\u0011q_\u0004\b\u0005W\n\u0001\u0012\u0011B\u000b\r\u001d\u0011y!\u0001EA\u0005#Aq!!\u001dH\t\u0003\u0011\u0019\u0002C\u0005\u0002&\u001e\u000b\t\u0011\"\u0011\u0002(\"I\u0011\u0011X$\u0002\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003\u0007<\u0015\u0011!C\u0001\u0005/A\u0011\"!5H\u0003\u0003%\t%a5\t\u0013\u0005\u0005x)!A\u0005\u0002\tm\u0001\"CAw\u000f\u0006\u0005I\u0011IAx\u0011%\t\tpRA\u0001\n\u0003\n\u0019\u0010C\u0005\u0002v\u001e\u000b\t\u0011\"\u0003\u0002x\"9!QN\u0001\u0005\u0004\t=d\u0001CA1\u0003\u0017\n\tAa!\t\u0015\t-%K!A!\u0002\u0013\u0011i\t\u0003\u0006\u0003$J\u0013\t\u0011)A\u0005\u0005KCq!!\u001dS\t\u0003\u00119\fB\u0004\u0003@J\u0013\tA!1\u0005\u000f\t%'K!\u0001\u0003B\"I!1\u001a*C\u0002\u0013\u0005\u0011q\u0015\u0005\t\u0005\u001b\u0014\u0006\u0015!\u0003\u0002*\"I!q\u001a*C\u0002\u0013E!\u0011\u001b\u0005\t\u0005?\u0014\u0006\u0015!\u0003\u0003T\"I!\u0011\u001d*C\u0002\u0013\r!1\u001d\u0005\t\u0005K\u0014\u0006\u0015!\u0003\u0003\u000e\"I!q\u001d*C\u0002\u0013\r!\u0011\u001e\u0005\t\u0005o\u0014\u0006\u0015!\u0003\u0003l\"Q!\u0011 *\t\u0006\u0004%\tAa?\t\u000f\u0005m'K\"\u0001\u0004\u0004!91\u0011\u0004*\u0007\u0002\rm\u0001bBB\u0013%\u001a\u00051q\u0005\u0005\b\u0007W\u0011f\u0011AB\u0017\u0011\u001d\u0019\tD\u0015D\u0001\u0007gAqaa\u0016S\r\u0003\u0019I\u0006C\u0004\u0004hI3\ta!\u001b\t\u000f\r-$K\"\u0001\u0004n!a1\u0011\u000f*\t\u0006\u0004%\t!a\u0013\u0004t!91Q\u0010*\u0005\u0002\r}\u0004bBBI%\u0012\u000511\u0013\u0005\b\u00073\u0013F\u0011ABN\u0011\u001d\u0019iJ\u0015C\u0001\u00077Cqaa(S\t\u0003\u0019Y\nC\u0004\u0004\"J#\taa'\t\u000f\r\r&\u000b\"\u0001\u0004&\"911\u0016*\u0005\u0002\r5\u0006\"CBZ%\n\u0007I\u0011BB[\u0011!\u0019yL\u0015Q\u0001\n\r]\u0006\u0002CBa%\u0002&Iaa1\t\u0011\r%'\u000b)C\u0005\u0007\u0017D\u0001b!5SA\u0013%11\u001b\u0005\b\u0007?\u0014F\u0011ABq\u0011\u001d\u0019)O\u0015C\u0001\u0007ODqaa;S\t\u0003\u0019i\u000fC\u0004\u0004rJ#\taa=\t\u0019\r](\u000b#b\u0001\n\u0003\tYe!?\t\u0011\u0011\u001d!\u000b)A\u0005\t\u0013Aq\u0001b\u0004S\t\u0003!\t\u0002C\u0004\u0005\u0010I#\t\u0001b\u0005\t\u000f\u0011]!\u000b\"\u0001\u0005\u001a!AAQ\u0004*!\u0002\u0013!I\u0001C\u0004\u0005 I#\t\u0001\"\u0005\t\u000f\u0011}!\u000b\"\u0001\u0005\"!9AQ\u0005*\u0005\u0002\u0011\u001d\u0002\u0002\u0003C\u0016%\u0002\u0006I\u0001\"\u0003\t\u0013\u00115\"\u000b\"\u0001\u0002L\u0011E\u0001b\u0003C\u0018%\n\u0007I\u0011AA&\tcA\u0001\u0002b\u0010SA\u0003%A1\u0007\u0005\t\t\u0003\u0012\u0006\u0015!\u0003\u0005\n!9A1\t*\u0005\u0002\u0011E\u0001b\u0002C#%\u0012\u0005Aq\t\u0005\b\t\u0013\u0012F\u0011\u0001C&\u0011\u001d!yE\u0015C\u0001\t#Bq\u0001b\u0015S\t\u0003!\t\u0006C\u0004\u0005VI#\t\u0001b\u0016\t\u000f\u0011u#\u000b\"\u0001\u0005`!9AQ\u000e*\u0005\u0002\u0011\u001d\u0003b\u0002C8%\u0012\u0005A\u0011\u000b\u0005\b\tc\u0012F\u0011\u0001C)\u0011\u001d!\u0019H\u0015C\u0001\t#Bq\u0001\"\u001eS\t\u0003!\t\u0006C\u0004\u0005xI#\t\u0001b\u0016\t\u000f\u0011e$\u000b\"\u0001\u0005`!9A1\u0010*\u0005\u0002\u0011\u001d\u0003b\u0002C?%\u0012\u0005Aq\t\u0005\b\t\u007f\u0012F\u0011\u0001C)\u0011\u001d!\tI\u0015C\u0001\t\u0007Cq\u0001b#S\t\u0003!\t\u0006C\u0004\u0005\u000eJ#\t\u0001\"\u0015\t\u000f\u0011=%\u000b\"\u0001\u0005R!9A\u0011\u0013*\u0005\u0002\u0011\u001d\u0003b\u0002CJ%\u0012\u0005A1\n\u0005\b\t+\u0013F\u0011\u0001C)\u0011\u001d!9J\u0015C\u0001\t\u000fBq\u0001\"'S\t\u0003!Y\nC\u0004\u00056J#\t\u0001b.\u0002-5{gnZ8QKJ\u001c\u0018n\u001d;f]\u000e,GI]5wKJTA!!\u0014\u0002P\u00059Qn\u001c8h_\u0012\u0014'\u0002BA)\u0003'\n1\u0002]3sg&\u001cH/\u001a8dK*!\u0011QKA,\u0003\u001d\u0019wN\u001c;sS\nT!!!\u0017\u0002\u000bA,7n[8\u0004\u0001A\u0019\u0011qL\u0001\u000e\u0005\u0005-#AF'p]\u001e|\u0007+\u001a:tSN$XM\\2f\tJLg/\u001a:\u0014\u0007\u0005\t)\u0007\u0005\u0003\u0002h\u00055TBAA5\u0015\t\tY'A\u0003tG\u0006d\u0017-\u0003\u0003\u0002p\u0005%$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003;\u00121b\u0016:ji\u0016\u001c\u0016MZ3usN\u00191!!\u001a*\u0011\r\u0001BhR\u0003\u001cME\u0012A\"Q2l]><H.\u001a3hK\u0012\u001c\u0012\u0002EA3\u0003\u007f\n\u0019)!#\u0011\u0007\u0005\u00055!D\u0001\u0002!\u0011\t9'!\"\n\t\u0005\u001d\u0015\u0011\u000e\u0002\b!J|G-^2u!\u0011\tY)a'\u000f\t\u00055\u0015q\u0013\b\u0005\u0003\u001f\u000b)*\u0004\u0002\u0002\u0012*!\u00111SA.\u0003\u0019a$o\\8u}%\u0011\u00111N\u0005\u0005\u00033\u000bI'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005u\u0015q\u0014\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0005\u00033\u000bI\u0007\u0006\u0002\u0002$B\u0019\u0011\u0011\u0011\t\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\u000b\u0005\u0003\u0002,\u0006UVBAAW\u0015\u0011\ty+!-\u0002\t1\fgn\u001a\u0006\u0003\u0003g\u000bAA[1wC&!\u0011qWAW\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0018\t\u0005\u0003O\ny,\u0003\u0003\u0002B\u0006%$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAd\u0003\u001b\u0004B!a\u001a\u0002J&!\u00111ZA5\u0005\r\te.\u001f\u0005\n\u0003\u001f$\u0012\u0011!a\u0001\u0003{\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAk!\u0019\t9.!8\u0002H6\u0011\u0011\u0011\u001c\u0006\u0005\u00037\fI'\u0001\u0006d_2dWm\u0019;j_:LA!a8\u0002Z\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t)/a;\u0011\t\u0005\u001d\u0014q]\u0005\u0005\u0003S\fIGA\u0004C_>dW-\u00198\t\u0013\u0005=g#!AA\u0002\u0005\u001d\u0017\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005u\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005%\u0016\u0001D<sSR,'+\u001a9mC\u000e,GCAA}!\u0011\tY+a?\n\t\u0005u\u0018Q\u0016\u0002\u0007\u001f\nTWm\u0019;\u0003\u0013){WO\u001d8bY\u0016$7#\u0003\u001f\u0002f\u0005}\u00141QAE)\t\u0011)\u0001E\u0002\u0002\u0002r\"B!a2\u0003\n!I\u0011q\u001a!\u0002\u0002\u0003\u0007\u0011Q\u0018\u000b\u0005\u0003K\u0014i\u0001C\u0005\u0002P\n\u000b\t\u00111\u0001\u0002H\n\u0019\"+\u001a9mS\u000e\f\u0017iY6o_^dW\rZ4fINIq)!\u001a\u0002\u0000\u0005\r\u0015\u0011\u0012\u000b\u0003\u0005+\u00012!!!H)\u0011\t9M!\u0007\t\u0013\u0005=7*!AA\u0002\u0005uF\u0003BAs\u0005;A\u0011\"a4N\u0003\u0003\u0005\r!a2\u0003\u001dUs\u0017mY6o_^dW\rZ4fINIQ!!\u001a\u0002\u0000\u0005\r\u0015\u0011\u0012\u000b\u0003\u0005K\u00012!!!\u0006)\u0011\t9M!\u000b\t\u0013\u0005=\u0017\"!AA\u0002\u0005uF\u0003BAs\u0005[A\u0011\"a4\f\u0003\u0003\u0005\r!a2\u0003\u0005]\u000b4#C\u000e\u0002f\u0005}\u00141QAE)\t\u0011)\u0004E\u0002\u0002\u0002n!B!a2\u0003:!I\u0011qZ\u0010\u0002\u0002\u0003\u0007\u0011Q\u0018\u000b\u0005\u0003K\u0014i\u0004C\u0005\u0002P\u0006\n\t\u00111\u0001\u0002H\n\u0011qKM\n\nM\u0005\u0015\u0014qPAB\u0003\u0013#\"A!\u0012\u0011\u0007\u0005\u0005e\u0005\u0006\u0003\u0002H\n%\u0003\"CAhU\u0005\u0005\t\u0019AA_)\u0011\t)O!\u0014\t\u0013\u0005=G&!AA\u0002\u0005\u001d'AA,4'%\t\u0014QMA@\u0003\u0007\u000bI\t\u0006\u0002\u0003VA\u0019\u0011\u0011Q\u0019\u0015\t\u0005\u001d'\u0011\f\u0005\n\u0003\u001f,\u0014\u0011!a\u0001\u0003{#B!!:\u0003^!I\u0011qZ\u001c\u0002\u0002\u0003\u0007\u0011qY\u0001\u000f+:\f7m\u001b8po2,GmZ3e\u00031\t5m\u001b8po2,GmZ3e\u0003\t9\u0016'\u0001\u0002Xe\u0005\u0011qkM\u0001\n\u0015>,(O\\1mK\u0012\f1CU3qY&\u001c\u0017-Q2l]><H.\u001a3hK\u0012\f!c\u001d;sS:<'g\u0016:ji\u0016\u001c\u0016MZ3usR!\u0011q\u0010B9\u0011\u001d\u0011\u0019(\u0015a\u0001\u0005k\n!B\u001a:p[\u000e{gNZ5h!\u0011\u00119Ha \u000f\t\te$1\u0010\t\u0005\u0003\u001f\u000bI'\u0003\u0003\u0003~\u0005%\u0014A\u0002)sK\u0012,g-\u0003\u0003\u00028\n\u0005%\u0002\u0002B?\u0003S\u001a2A\u0015BC!\u0011\tyFa\"\n\t\t%\u00151\n\u0002%/&$\b.T8oO>\u0004VM]:jgR,gnY3QYV<\u0017N\u001c#jgB\fGo\u00195fe\u0006\u0011\u0011m\u001d\t\u0005\u0005\u001f\u0013y*\u0004\u0002\u0003\u0012*!!1\u0013BK\u0003\u0015\t7\r^8s\u0015\u0011\tIFa&\u000b\t\te%1T\u0001\u0007CB\f7\r[3\u000b\u0005\tu\u0015aA8sO&!!\u0011\u0015BI\u0005-\t5\r^8s'f\u001cH/Z7\u0002\r\r|gNZ5h!\u0011\u00119Ka-\u000e\u0005\t%&\u0002\u0002BR\u0005WSAA!,\u00030\u0006AA/\u001f9fg\u00064WM\u0003\u0002\u00032\u0006\u00191m\\7\n\t\tU&\u0011\u0016\u0002\u0007\u0007>tg-[4\u0015\r\te&1\u0018B_!\r\tyF\u0015\u0005\b\u0005\u0017+\u0006\u0019\u0001BG\u0011\u001d\u0011\u0019+\u0016a\u0001\u0005K\u0013\u0011aQ\t\u0005\u0005\u0007\f9\r\u0005\u0003\u0002h\t\u0015\u0017\u0002\u0002Bd\u0003S\u0012qAT8uQ&twMA\u0001E\u0003=!UIR!V\u0019R{FIQ0O\u00036+\u0015\u0001\u0005#F\r\u0006+F\nV0E\u0005~s\u0015)T#!\u0003\u0019awnZ4feV\u0011!1\u001b\t\u0005\u0005+\u0014Y.\u0004\u0002\u0003X*!!\u0011\u001cBN\u0003\u0015\u0019HN\u001a\u001bk\u0013\u0011\u0011iNa6\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\n1\"Y2u_J\u001c\u0016p\u001d;f[V\u0011!QR\u0001\rC\u000e$xN]*zgR,W\u000eI\u0001\r[\u0006$XM]5bY&TXM]\u000b\u0003\u0005W\u0004BA!<\u0003t6\u0011!q\u001e\u0006\u0005\u0005c\u0014)*\u0001\u0004tiJ,\u0017-\\\u0005\u0005\u0005k\u0014yO\u0001\u0007NCR,'/[1mSj,'/A\u0007nCR,'/[1mSj,'\u000fI\u0001\tg\u0016$H/\u001b8hgV\u0011!Q \t\u0005\u0003?\u0012y0\u0003\u0003\u0004\u0002\u0005-#!D'p]\u001e|7+\u001a;uS:<7\u000f\u0006\u0003\u0004\u0006\rU\u0001CBB\u0004\u0007\u001b\u0019\t\"\u0004\u0002\u0004\n)!11BA5\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0007\u001f\u0019IA\u0001\u0004GkR,(/\u001a\t\u0004\u0007'1V\"\u0001*\t\u000f\r]\u0011\r1\u0001\u0003v\u0005!a.Y7f\u0003=\u0019w\u000e\u001c7fGRLwN\u001c(b[\u0016\u001cXCAB\u000f!\u0019\u00199a!\u0004\u0004 A1\u00111RB\u0011\u0005kJAaa\t\u0002 \n!A*[:u\u0003A)gn];sK\u000e{G\u000e\\3di&|g\u000e\u0006\u0003\u0004\u0006\r%\u0002bBB\fG\u0002\u0007!QO\u0001\u0011G\u0006\u0004\b/\u001a3D_2dWm\u0019;j_:$Ba!\u0002\u00040!91q\u00033A\u0002\tU\u0014aC3ogV\u0014X-\u00138eKb$\"b!\u000e\u0004<\r}21IB$!!\t9ga\u000e\u0004\u0012\r\u0015\u0011\u0002BB\u001d\u0003S\u0012\u0011BR;oGRLwN\\\u0019\t\u000f\ruR\r1\u0001\u0003v\u0005I\u0011N\u001c3fq:\u000bW.\u001a\u0005\b\u0007\u0003*\u0007\u0019AAs\u0003\u0019)h.[9vK\"91QI3A\u0002\u0005\u0015\u0018AB:qCJ\u001cX\rC\u0004\u0004J\u0015\u0004\raa\u0013\u0002\r\u0019LW\r\u001c3t!\u0019\t9g!\u0014\u0004R%!1qJA5\u0005)a$/\u001a9fCR,GM\u0010\t\t\u0003O\u001a\u0019F!\u001e\u0002>&!1QKA5\u0005\u0019!V\u000f\u001d7fe\u0005)\"/Z7pm\u0016,U\u000e\u001d;z\u0007>dG.Z2uS>tGCBB.\u0007G\u001a)\u0007\u0005\u0004\u0004\b\r51Q\f\t\u0005\u0003O\u001ay&\u0003\u0003\u0004b\u0005%$\u0001B+oSRDq!a7g\u0001\u0004\u0019\t\u0002C\u0004\u0004>\u0019\u0004\rA!\u001e\u0002!\rdwn]3D_:tWm\u0019;j_:\u001cHCAB/\u0003q9W\r^'p]\u001e|g+\u001a:tS>tgI]8n\u0005VLG\u000eZ%oM>,\"aa\u001c\u0011\r\r\u001d1Q\u0002B;\u00031iwN\\4p-\u0016\u00148/[8o+\t\u0019)\b\u0005\u0004\u0004\b\r51q\u000f\t\u0005\u0003?\u001aI(\u0003\u0003\u0004|\u0005-#!D*feZ,'OV3sg&|g.A\rhKR\fE\u000e\\\"pY2,7\r^5p]N\f5OR;ukJ,G\u0003BBA\u0007\u000b\u0003baa\u0002\u0004\u000e\r\r\u0005CBAF\u0007C\u0019\t\u0002C\u0004\u0004\b*\u0004\ra!#\u0002\u00159\fW.\u001a$jYR,'\u000f\u0005\u0004\u0002h\r-5qR\u0005\u0005\u0007\u001b\u000bIG\u0001\u0004PaRLwN\u001c\t\t\u0003O\u001a9D!\u001e\u0002f\u00061r-\u001a;D_2dWm\u0019;j_:\u001c\u0018i\u001d$viV\u0014X\r\u0006\u0003\u0004\u0002\u000eU\u0005bBBLW\u0002\u0007!QO\u0001\u000fG>dG.Z2uS>tg*Y7f\u0003U9W\r\u001e&pkJt\u0017\r\\\"pY2,7\r^5p]N,\"a!!\u00025)|WO\u001d8bY\u000e{G\u000e\\3di&|gn]!t\rV$XO]3\u0002-\u001d,Go\u00158baNDw\u000e^\"pY2,7\r^5p]N\f1d\u001d8baNDw\u000e^\"pY2,7\r^5p]N\f5OR;ukJ,\u0017A\u0005:f[>4X-R7qifTu.\u001e:oC2$Baa\u0017\u0004(\"91\u0011\u00169A\u0002\rE\u0011a\u00016oY\u0006\u0019\"/Z7pm\u0016,U\u000e\u001d;z':\f\u0007o\u001d5piR!11LBX\u0011\u001d\u0019\t,\u001da\u0001\u0007#\t1a\u001d8q\u0003}\u0019\u0017M\\*vM\u001aL\u0007pQ8mY\u0016\u001cG/[8o\u001d\u0006lWm\u001d\"vS2$WM]\u000b\u0003\u0007o\u0003b!a\u001a\u0004\f\u000ee\u0006\u0003BA0\u0007wKAa!0\u0002L\tA2)\u00198Tk\u001a4\u0017\u000e_\"pY2,7\r^5p]:\u000bW.Z:\u0002A\r\fgnU;gM&D8i\u001c7mK\u000e$\u0018n\u001c8OC6,7OQ;jY\u0012,'\u000fI\u0001\u001bO\u0016$8+\u001e4gSb4%o\\7QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\n\u001a\u000b\u0005\u0005k\u001a)\rC\u0004\u0004HR\u0004\rA!\u001e\u0002\u001bA,'o]5ti\u0016t7-Z%e\u0003]1\u0018\r\\5eCR,Wj\u001c8h_\u000eC\u0017M]1di\u0016\u00148\u000f\u0006\u0003\u0003v\r5\u0007bBBhk\u0002\u0007!QO\u0001\u0006S:\u0004X\u000f^\u0001\u0013CB\u0004XM\u001c3Tk\u001a4\u0017\u000e\u001f+p\u001d\u0006lW\r\u0006\u0003\u0004V\u000emG\u0003\u0002B;\u0007/Dqa!7w\u0001\u0004\u0011)(\u0001\u0004tk\u001a4\u0017\u000e\u001f\u0005\b\u0007;4\b\u0019\u0001B;\u00039q\u0017-\\3J]N+G\u000f^5oON\f\u0001dZ3u\u0015>,(O\\1m\u0007>dG.Z2uS>tg*Y7f)\u0011\u0011)ha9\t\u000f\r\u001dw\u000f1\u0001\u0003v\u00051r-\u001a;T]\u0006\u00048oQ8mY\u0016\u001cG/[8o\u001d\u0006lW\r\u0006\u0003\u0003v\r%\bbBBdq\u0002\u0007!QO\u0001\u000bO\u0016$(j\\;s]\u0006dG\u0003BB\u0003\u0007_Dqaa2z\u0001\u0004\u0011)(\u0001\u0005hKR\u001cf.\u00199t)\u0011\u0019)a!>\t\u000f\r\u001d'\u00101\u0001\u0003v\u00059\u0011N\u001c3fq\u0016\u001cXCAB~!\u0019\tYi!@\u0005\u0002%!1q`AP\u0005\r\u0019V-\u001d\t\u0005\u0003?\"\u0019!\u0003\u0003\u0005\u0006\u0005-#!D%oI\u0016D8+\u001a;uS:<7/\u0001\u0007k_V\u0014h.\u00197DC\u000eDW\r\u0005\u0004\u0002`\u0011-1QA\u0005\u0005\t\u001b\tYE\u0001\u000bN_:<wnQ8mY\u0016\u001cG/[8o\u0007\u0006\u001c\u0007.Z\u0001\bU>,(O\\1m+\t\u0019)\u0001\u0006\u0003\u0004\u0006\u0011U\u0001bBBd}\u0002\u0007!QO\u0001\u0015e\u0016lwN^3K_V\u0014h.\u00197J]\u000e\u000b7\r[3\u0015\t\ruC1\u0004\u0005\b\u0007\u000f|\b\u0019\u0001B;\u0003)\u0019h.\u00199t\u0007\u0006\u001c\u0007.Z\u0001\u0006g:\f\u0007o\u001d\u000b\u0005\u0007\u000b!\u0019\u0003\u0003\u0005\u0004H\u0006\u0015\u0001\u0019\u0001B;\u0003I\u0011X-\\8wKNs\u0017\r]:J]\u000e\u000b7\r[3\u0015\t\ruC\u0011\u0006\u0005\t\u0007\u000f\f9\u00011\u0001\u0003v\u0005i!/Z1mi&lWmQ1dQ\u0016\f\u0001B]3bYRLW.Z\u0001\u0014cV,'/_*jI\u0016$\u0015n\u001d9bi\u000eDWM]\u000b\u0003\tg\u0001B\u0001\"\u000e\u0005<5\u0011Aq\u0007\u0006\u0005\ts\u0011)*\u0001\u0005eSN\u0004\u0018\r^2i\u0013\u0011!i\u0004b\u000e\u0003#5+7o]1hK\u0012K7\u000f]1uG\",'/\u0001\u000brk\u0016\u0014\u0018pU5eK\u0012K7\u000f]1uG\",'\u000fI\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0002\u00115,G/\u00193bi\u0006\f!$^:f'V4g-\u001b=fI\u000e{G\u000e\\3di&|gNT1nKN,\"!!:\u0002\u0019\u0011\fG/\u00192bg\u0016t\u0015-\\3\u0016\u0005\u00115\u0003CBA4\u0007\u0017\u0013)(A\nt]\u0006\u00048oQ8mY\u0016\u001cG/[8o\u001d\u0006lW-\u0006\u0002\u0003v\u0005q1O\\1qg&sG-\u001a=OC6,\u0017\u0001E:oCB\u001cxK]5uKN\u000bg-\u001a;z+\t!I\u0006E\u0002\u0005\\\rq1!a\u0018\u0001\u00035\u0019h.\u00199t/RKW.Z8viV\u0011A\u0011\r\t\u0005\tG\"I'\u0004\u0002\u0005f)!AqMB\u0005\u0003!!WO]1uS>t\u0017\u0002\u0002C6\tK\u0012aBR5oSR,G)\u001e:bi&|g.\u0001\u0006t]\u0006\u00048OR:z]\u000e\fQC[8ve:\fGnQ8mY\u0016\u001cG/[8o\u001d\u0006lW-\u0001\tk_V\u0014h.\u00197J]\u0012,\u0007PT1nK\u0006)\"n\\;s]\u0006d7+Z9Oe&sG-\u001a=OC6,\u0017a\u00056pkJt\u0017\r\u001c+bO&sG-\u001a=OC6,\u0017A\u00056pkJt\u0017\r\\,sSR,7+\u00194fif\fqB[8ve:\fGn\u0016+j[\u0016|W\u000f^\u0001\rU>,(O\\1m\rNLhnY\u0001\u001ae\u0016\fG\u000e^5nK\u0016s\u0017M\u00197f!\u0016\u00148/[:uK:\u001cW-\u0001\fsK\u0006dG/[7f\u0007>dG.Z2uS>tg*Y7f\u0003Y\u0011X-\u00197uS6,7i\u001c7mK\u000e$\u0018n\u001c8TSj,WC\u0001CC!\u0011\t9\u0007b\"\n\t\u0011%\u0015\u0011\u000e\u0002\u0005\u0019>tw-\u0001\fnKR\fG-\u0019;b\u0007>dG.Z2uS>tg*Y7f\u0003EiW\r^1eCR\f\u0017J\u001c3fq:\u000bW.Z\u0001\t[>twm\\+sS\u00061Ro]3MK\u001e\f7-_*fe&\fG.\u001b>bi&|g.\u0001\rtk\u001a4\u0017\u000e\u001f\"vS2$WM]\"mCN\u001cx\n\u001d;j_:\fqb];gM&D8+\u001a9be\u0006$xN]\u0001\u0010gV4g-\u001b=Ee>\u0004X)\u001c9us\u0006\u0011B-Z:fe&\fG.\u001b>f\u0015>,(O\\1m)\u0011!i\n\"-\u0015\t\u0011}EQ\u0015\t\u0005\u0003?\"\t+\u0003\u0003\u0005$\u0006-#!B#wK:$\b\u0002\u0003CT\u0003\u000b\u0002\u001d\u0001\"+\u0002\u0005\u00154\bCBA0\tW#y+\u0003\u0003\u0005.\u0006-#!F\"b]\u0012+7/\u001a:jC2L'0\u001a&pkJt\u0017\r\u001c\t\u0004\u0007'9\u0006\u0002\u0003CZ\u0003\u000b\u0002\r\u0001b,\u0002\u0007\u0011\u0014w.\u0001\ttKJL\u0017\r\\5{K*{WO\u001d8bYR!A\u0011\u0018Cb)\u0011!y\u000bb/\t\u0011\u0011\u001d\u0016q\ta\u0002\t{\u0003b!a\u0018\u0005@\u0012=\u0016\u0002\u0002Ca\u0003\u0017\u00121cQ1o'\u0016\u0014\u0018.\u00197ju\u0016Tu.\u001e:oC2D\u0001\u0002\"2\u0002H\u0001\u0007AqY\u0001\u0003C^\u0004B!a\u0018\u0005J&!A1ZA&\u0005\u0011\tEo\\7")
public abstract class MongoPersistenceDriver
extends WithMongoPersistencePluginDispatcher {
    private MongoSettings settings;
    private Future<ServerVersion> mongoVersion;
    private Seq<IndexSettings> indexes;
    private final ActorSystem as;
    private final Config config;
    private final String DEFAULT_DB_NAME;
    private final Logger logger;
    private final ActorSystem actorSystem;
    private final Materializer materializer;
    private final Option<CanSuffixCollectionNames> canSuffixCollectionNamesBuilder;
    private final MongoCollectionCache<Future<Object>> journalCache;
    private final MongoCollectionCache<Future<Object>> snapsCache;
    private final MongoCollectionCache<Future<Object>> realtimeCache;
    private final MessageDispatcher querySideDispatcher;
    private final MongoCollectionCache<Future<Object>> metadataCache;
    private volatile byte bitmap$0;

    public static WriteSafety string2WriteSafety(String fromConfig) {
        return MongoPersistenceDriver$.MODULE$.string2WriteSafety(fromConfig);
    }

    public String DEFAULT_DB_NAME() {
        return this.DEFAULT_DB_NAME;
    }

    public Logger logger() {
        return this.logger;
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public Materializer materializer() {
        return this.materializer;
    }

    private MongoSettings settings$lzycompute() {
        MongoPersistenceDriver mongoPersistenceDriver = this;
        synchronized (mongoPersistenceDriver) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                MongoSettings mongoSettings;
                MongoSettings defaults = MongoSettings$.MODULE$.apply(this.as.settings());
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.config.getConfig("overrides"));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Config overrides = (Config)success.value();
                    this.logger().info("Applying configuration-specific overrides for driver");
                    mongoSettings = defaults.withOverride(overrides);
                } else if (try_ instanceof Failure) {
                    this.logger().debug("No configuration-specific overrides found to apply to driver");
                    mongoSettings = defaults;
                } else {
                    throw new MatchError((Object)try_);
                }
                this.settings = mongoSettings;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.settings;
    }

    public MongoSettings settings() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.settings$lzycompute();
        }
        return this.settings;
    }

    public abstract Future<Object> collection(String var1);

    public abstract Future<List<String>> collectionNames();

    public abstract Future<Object> ensureCollection(String var1);

    public abstract Future<Object> cappedCollection(String var1);

    public abstract Function1<Object, Future<Object>> ensureIndex(String var1, boolean var2, boolean var3, Seq<Tuple2<String, Object>> var4);

    public abstract Future<BoxedUnit> removeEmptyCollection(Object var1, String var2);

    public abstract void closeConnections();

    public abstract Future<String> getMongoVersionFromBuildInfo();

    private Future<ServerVersion> mongoVersion$lzycompute() {
        MongoPersistenceDriver mongoPersistenceDriver = this;
        synchronized (mongoPersistenceDriver) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.mongoVersion = this.getMongoVersionFromBuildInfo().map((Function1 & Serializable)x0$1 -> {
                    Option<ServerVersion> option;
                    String string = x0$1;
                    if (string != null && !(option = ServerVersion$.MODULE$.unapply(string)).isEmpty()) {
                        ServerVersion v = (ServerVersion)option.get();
                        return v;
                    }
                    return new ServerVersion.Unsupported(-1.0, "UNKNOWN");
                }, this.pluginDispatcher());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.mongoVersion;
    }

    public Future<ServerVersion> mongoVersion() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.mongoVersion$lzycompute();
        }
        return this.mongoVersion;
    }

    public Future<List<Object>> getAllCollectionsAsFuture(Option<Function1<String, Object>> nameFilter) {
        return this.collectionNames().flatMap((Function1 & Serializable)names -> Future$.MODULE$.sequence((IterableOnce)names.filterNot((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)this.excluded$1(name))).filter((Function1)nameFilter.getOrElse((Function0 & Serializable)() -> (Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)MongoPersistenceDriver.allPass$1(name)))).map((Function1 & Serializable)name -> this.collection((String)name)), BuildFrom$.MODULE$.buildFromIterableOps(), this.pluginDispatcher()).map((Function1 & Serializable)list -> list, this.pluginDispatcher()), this.pluginDispatcher());
    }

    public Future<List<Object>> getCollectionsAsFuture(String collectionName) {
        return this.getAllCollectionsAsFuture((Option<Function1<String, Object>>)Option$.MODULE$.apply((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith(collectionName))));
    }

    public Future<List<Object>> getJournalCollections() {
        return this.getCollectionsAsFuture(this.journalCollectionName());
    }

    public Future<List<Object>> journalCollectionsAsFuture() {
        return this.getCollectionsAsFuture(this.journalCollectionName());
    }

    public Future<List<Object>> getSnapshotCollections() {
        return this.getCollectionsAsFuture(this.snapsCollectionName());
    }

    public Future<List<Object>> snapshotCollectionsAsFuture() {
        return this.getCollectionsAsFuture(this.snapsCollectionName());
    }

    public Future<BoxedUnit> removeEmptyJournal(Object jnl) {
        return this.removeEmptyCollection(jnl, this.journalIndexName());
    }

    public Future<BoxedUnit> removeEmptySnapshot(Object snp) {
        return this.removeEmptyCollection(snp, this.snapsIndexName());
    }

    private Option<CanSuffixCollectionNames> canSuffixCollectionNamesBuilder() {
        return this.canSuffixCollectionNamesBuilder;
    }

    private String getSuffixFromPersistenceId(String persistenceId) {
        Option<CanSuffixCollectionNames> option = this.canSuffixCollectionNamesBuilder();
        if (option instanceof Some) {
            Some some = (Some)option;
            CanSuffixCollectionNames builderIns = (CanSuffixCollectionNames)some.value();
            return builderIns.getSuffixFromPersistenceId(persistenceId);
        }
        return "";
    }

    private String validateMongoCharacters(String input) {
        Option<CanSuffixCollectionNames> option = this.canSuffixCollectionNamesBuilder();
        if (option instanceof Some) {
            Some some = (Some)option;
            CanSuffixCollectionNames builderIns = (CanSuffixCollectionNames)some.value();
            return builderIns.validateMongoCharacters(input);
        }
        return input;
    }

    private String appendSuffixToName(String nameInSettings, String suffix) {
        String string;
        block3: {
            String string2 = suffix;
            switch (string2 == null ? 0 : string2.hashCode()) {
                case 0: {
                    if (!"".equals(string2)) break;
                    string = nameInSettings;
                    break block3;
                }
            }
            string = new StringBuilder(0).append(nameInSettings).append(this.suffixSeparator()).append(this.validateMongoCharacters(suffix)).toString();
        }
        String name = string;
        this.logger().debug(new StringBuilder(58).append("Suffixed name for value \"").append(nameInSettings).append("\" in settings and suffix \"").append(suffix).append("\" is \"").append(name).append("\"").toString());
        return name;
    }

    public String getJournalCollectionName(String persistenceId) {
        String string = persistenceId;
        switch (string == null ? 0 : string.hashCode()) {
            case 0: {
                if (!"".equals(string)) break;
                return this.journalCollectionName();
            }
        }
        return this.appendSuffixToName(this.journalCollectionName(), this.getSuffixFromPersistenceId(persistenceId));
    }

    public String getSnapsCollectionName(String persistenceId) {
        String string = persistenceId;
        switch (string == null ? 0 : string.hashCode()) {
            case 0: {
                if (!"".equals(string)) break;
                return this.snapsCollectionName();
            }
        }
        return this.appendSuffixToName(this.snapsCollectionName(), this.getSuffixFromPersistenceId(persistenceId));
    }

    public Future<Object> getJournal(String persistenceId) {
        return this.collection(this.getJournalCollectionName(persistenceId));
    }

    public Future<Object> getSnaps(String persistenceId) {
        return this.collection(this.getSnapsCollectionName(persistenceId));
    }

    private Seq<IndexSettings> indexes$lzycompute() {
        MongoPersistenceDriver mongoPersistenceDriver = this;
        synchronized (mongoPersistenceDriver) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.indexes = new .colon.colon((Object)new IndexSettings(this.journalIndexName(), true, false, (Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pid"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"from"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)BoxesRunTime.boxToInteger((int)1))})), (List)new .colon.colon((Object)new IndexSettings(this.journalSeqNrIndexName(), false, false, (Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pid"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)BoxesRunTime.boxToInteger((int)-1))})), (List)new .colon.colon((Object)new IndexSettings(this.journalTagIndexName(), false, true, (Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"_tg"), (Object)BoxesRunTime.boxToInteger((int)1))})), (List)Nil$.MODULE$)));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.indexes;
    }

    public Seq<IndexSettings> indexes() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.indexes$lzycompute();
        }
        return this.indexes;
    }

    public Future<Object> journal() {
        return this.journal("");
    }

    public Future<Object> journal(String persistenceId) {
        String collectionName = this.getJournalCollectionName(persistenceId);
        return this.journalCache.getOrElseCreate(collectionName, (Function1<String, Future<Object>>)(Function1 & Serializable)theCollectionName -> {
            Future<Object> journalCollection = this.ensureCollection((String)theCollectionName);
            return (Future)this.indexes().foldLeft(journalCollection, (Function2 & Serializable)(acc, index) -> acc.flatMap((Function1 & Serializable)x$2 -> (Future)this.ensureIndex(index.name(), index.unique(), index.sparse(), index.fields()).apply(x$2), this.pluginDispatcher()));
        });
    }

    public void removeJournalInCache(String persistenceId) {
        String collectionName = this.getJournalCollectionName(persistenceId);
        this.journalCache.invalidate(collectionName);
    }

    public Future<Object> snaps() {
        return this.snaps("");
    }

    public Future<Object> snaps(String persistenceId) {
        String collectionName = this.getSnapsCollectionName(persistenceId);
        return this.snapsCache.getOrElseCreate(collectionName, (Function1<String, Future<Object>>)(Function1 & Serializable)theCollectionName -> {
            Future<Object> snapsCollection = this.ensureCollection((String)theCollectionName);
            return snapsCollection.flatMap((Function1 & Serializable)x$3 -> (Future)this.ensureIndex(this.snapsIndexName(), true, false, (Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pid"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sn"), (Object)BoxesRunTime.boxToInteger((int)-1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ts"), (Object)BoxesRunTime.boxToInteger((int)-1))})).apply(x$3), this.pluginDispatcher());
        });
    }

    public void removeSnapsInCache(String persistenceId) {
        String collectionName = this.getSnapsCollectionName(persistenceId);
        this.snapsCache.invalidate(collectionName);
    }

    public Future<Object> realtime() {
        return this.realtimeCache.getOrElseCreate(this.realtimeCollectionName(), (Function1<String, Future<Object>>)(Function1 & Serializable)collectionName -> this.cappedCollection((String)collectionName));
    }

    public MessageDispatcher querySideDispatcher() {
        return this.querySideDispatcher;
    }

    public Future<Object> metadata() {
        return this.metadataCache.getOrElseCreate(this.metadataCollectionName(), (Function1<String, Future<Object>>)(Function1 & Serializable)collectionName -> {
            Future<Object> metadataCollection = this.ensureCollection((String)collectionName);
            return metadataCollection.flatMap((Function1 & Serializable)x$4 -> (Future)this.ensureIndex(this.metadataIndexName(), true, true, (Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pid"), (Object)BoxesRunTime.boxToInteger((int)1))})).apply(x$4), this.pluginDispatcher());
        });
    }

    public boolean useSuffixedCollectionNames() {
        return this.suffixBuilderClassOption().isDefined();
    }

    public Option<String> databaseName() {
        return this.settings().Database();
    }

    public String snapsCollectionName() {
        return this.settings().SnapsCollection();
    }

    public String snapsIndexName() {
        return this.settings().SnapsIndex();
    }

    public WriteSafety snapsWriteSafety() {
        return MongoPersistenceDriver$.MODULE$.string2WriteSafety(this.settings().SnapsWriteConcern());
    }

    public FiniteDuration snapsWTimeout() {
        return this.settings().SnapsWTimeout();
    }

    public boolean snapsFsync() {
        return this.settings().SnapsFSync();
    }

    public String journalCollectionName() {
        return this.settings().JournalCollection();
    }

    public String journalIndexName() {
        return this.settings().JournalIndex();
    }

    public String journalSeqNrIndexName() {
        return this.settings().JournalSeqNrIndex();
    }

    public String journalTagIndexName() {
        return this.settings().JournalTagIndex();
    }

    public WriteSafety journalWriteSafety() {
        return MongoPersistenceDriver$.MODULE$.string2WriteSafety(this.settings().JournalWriteConcern());
    }

    public FiniteDuration journalWTimeout() {
        return this.settings().JournalWTimeout();
    }

    public boolean journalFsync() {
        return this.settings().JournalFSync();
    }

    public boolean realtimeEnablePersistence() {
        return this.settings().realtimeEnablePersistence();
    }

    public String realtimeCollectionName() {
        return this.settings().realtimeCollectionName();
    }

    public long realtimeCollectionSize() {
        return this.settings().realtimeCollectionSize();
    }

    public String metadataCollectionName() {
        return this.settings().MetadataCollection();
    }

    public String metadataIndexName() {
        return this.settings().MetadataIndex();
    }

    public String mongoUri() {
        return this.settings().MongoUri();
    }

    public boolean useLegacySerialization() {
        return this.settings().UseLegacyJournalSerialization();
    }

    public Option<String> suffixBuilderClassOption() {
        return Option$.MODULE$.apply((Object)this.settings().SuffixBuilderClass()).filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$5.trim()))));
    }

    public String suffixSeparator() {
        String string = this.settings().SuffixSeparator();
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(string))) {
            return this.validateMongoCharacters(this.settings().SuffixSeparator()).substring(0, 1);
        }
        return "_";
    }

    public boolean suffixDropEmpty() {
        return this.settings().SuffixDropEmptyCollections();
    }

    public Event deserializeJournal(Object dbo, CanDeserializeJournal<Object> ev) {
        return ev.deserializeDocument(dbo);
    }

    public Object serializeJournal(Atom aw, CanSerializeJournal<Object> ev) {
        return ev.serializeAtom(aw);
    }

    private final boolean excluded$1(String name) {
        String string = name;
        String string2 = this.metadataCollectionName();
        return !(string == null ? string2 != null : !string.equals(string2)) || name.startsWith("system.");
    }

    private static final boolean allPass$1(String name) {
        return true;
    }

    public MongoPersistenceDriver(ActorSystem as, Config config) {
        None$ none$;
        Some some;
        String suffixBuilderClass;
        this.as = as;
        this.config = config;
        super(as, config);
        this.DEFAULT_DB_NAME = "pekko-persistence";
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.actorSystem = as;
        this.materializer = Materializer$.MODULE$.apply((ClassicActorSystemProvider)as);
        as.registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable)() -> this.closeConnections());
        Option<String> option = this.suffixBuilderClassOption();
        if (option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((suffixBuilderClass = (String)(some = (Some)option).value()).trim()))) {
            ReflectiveLookupExtension reflectiveAccess = (ReflectiveLookupExtension)ReflectiveLookupExtension$.MODULE$.apply(this.actorSystem());
            Class builderClass = reflectiveAccess.unsafeReflectClassByName(suffixBuilderClass, ClassTag$.MODULE$.apply(CanSuffixCollectionNames.class));
            Constructor builderCons = builderClass.getConstructor(new Class[0]);
            none$ = new Some(builderCons.newInstance(new Object[0]));
        } else {
            none$ = None$.MODULE$;
        }
        this.canSuffixCollectionNamesBuilder = none$;
        this.journalCache = MongoCollectionCache$.MODULE$.apply(this.settings().CollectionCache(), "journal", this.actorSystem());
        this.snapsCache = MongoCollectionCache$.MODULE$.apply(this.settings().CollectionCache(), "snaps", this.actorSystem());
        this.realtimeCache = MongoCollectionCache$.MODULE$.apply(this.settings().CollectionCache(), "realtime", this.actorSystem());
        this.querySideDispatcher = this.actorSystem().dispatchers().lookup("pekko-contrib-persistence-query-dispatcher");
        this.metadataCache = MongoCollectionCache$.MODULE$.apply(this.settings().CollectionCache(), "metadata", this.actorSystem());
    }

    public static interface WriteSafety {
    }
}

