/*
 * Decompiled with CFR 0.152.
 */
package pekko.contrib.persistence.mongodb;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.actor.ActorSystem;
import pekko.contrib.persistence.mongodb.MongoSettings$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005}w!B&M\u0011\u0003)f!B,M\u0011\u0003A\u0006\"B0\u0002\t\u0003\u0001\u0007\"B1\u0002\t\u0003\u0011g\u0001B,M\u0001\u0011D\u0001\"\u001a\u0003\u0003\u0006\u0004%\tA\u001a\u0005\ta\u0012\u0011\t\u0011)A\u0005O\")q\f\u0002C\u0001c\")1\u000f\u0002C\u0001i\"9q\u000f\u0002b\u0001\n\u0003A\bbBA\u0005\t\u0001\u0006I!\u001f\u0005\t\u0003\u0017!!\u0019!C\u0001q\"9\u0011Q\u0002\u0003!\u0002\u0013I\b\"CA\b\t\t\u0007I\u0011AA\t\u0011!\tI\u0002\u0002Q\u0001\n\u0005M\u0001\u0002CA\u000e\t\t\u0007I\u0011\u0001=\t\u000f\u0005uA\u0001)A\u0005s\"A\u0011q\u0004\u0003C\u0002\u0013\u0005\u0001\u0010C\u0004\u0002\"\u0011\u0001\u000b\u0011B=\t\u0011\u0005\rBA1A\u0005\u0002aDq!!\n\u0005A\u0003%\u0011\u0010\u0003\u0005\u0002(\u0011\u0011\r\u0011\"\u0001y\u0011\u001d\tI\u0003\u0002Q\u0001\neD\u0001\"a\u000b\u0005\u0005\u0004%\t\u0001\u001f\u0005\b\u0003[!\u0001\u0015!\u0003z\u0011%\ty\u0003\u0002b\u0001\n\u0003\t\t\u0004\u0003\u0005\u0002D\u0011\u0001\u000b\u0011BA\u001a\u0011%\t)\u0005\u0002b\u0001\n\u0003\t9\u0005\u0003\u0005\u0002P\u0011\u0001\u000b\u0011BA%\u0011%\t\t\u0006\u0002b\u0001\n\u0003\t9\u0005\u0003\u0005\u0002T\u0011\u0001\u000b\u0011BA%\u0011!\t)\u0006\u0002b\u0001\n\u0003A\bbBA,\t\u0001\u0006I!\u001f\u0005\t\u00033\"!\u0019!C\u0001q\"9\u00111\f\u0003!\u0002\u0013I\b\u0002CA/\t\t\u0007I\u0011\u0001=\t\u000f\u0005}C\u0001)A\u0005s\"I\u0011\u0011\r\u0003C\u0002\u0013\u0005\u0011\u0011\u0007\u0005\t\u0003G\"\u0001\u0015!\u0003\u00024!I\u0011Q\r\u0003C\u0002\u0013\u0005\u0011q\t\u0005\t\u0003O\"\u0001\u0015!\u0003\u0002J!I\u0011\u0011\u000e\u0003C\u0002\u0013\u0005\u0011q\t\u0005\t\u0003W\"\u0001\u0015!\u0003\u0002J!A\u0011Q\u000e\u0003C\u0002\u0013\u0005\u0001\u0010C\u0004\u0002p\u0011\u0001\u000b\u0011B=\t\u0013\u0005EDA1A\u0005\u0002\u0005M\u0004\u0002CA>\t\u0001\u0006I!!\u001e\t\u0011\u0005uDA1A\u0005\u0002aDq!a \u0005A\u0003%\u0011\u0010\u0003\u0005\u0002\u0002\u0012\u0011\r\u0011\"\u0001y\u0011\u001d\t\u0019\t\u0002Q\u0001\neD\u0011\"!\"\u0005\u0005\u0004%\t!a\u0012\t\u0011\u0005\u001dE\u0001)A\u0005\u0003\u0013B\u0001\"!#\u0005\u0005\u0004%\t\u0001\u001f\u0005\b\u0003\u0017#\u0001\u0015!\u0003z\u0011!\ti\t\u0002b\u0001\n\u0003A\bbBAH\t\u0001\u0006I!\u001f\u0005\n\u0003##!\u0019!C\u0001\u0003\u000fB\u0001\"a%\u0005A\u0003%\u0011\u0011\n\u0005\n\u0003+#!\u0019!C\u0001\u0003\u000fB\u0001\"a&\u0005A\u0003%\u0011\u0011\n\u0005\n\u00033#!\u0019!C\u0001\u0003\u000fB\u0001\"a'\u0005A\u0003%\u0011\u0011\n\u0005\n\u0003;#!\u0019!C\u0001\u0003?C\u0001\"a*\u0005A\u0003%\u0011\u0011\u0015\u0005\n\u0003S#!\u0019!C\u0001\u0003?C\u0001\"a+\u0005A\u0003%\u0011\u0011\u0015\u0005\n\u0003[#!\u0019!C\u0001\u0003?C\u0001\"a,\u0005A\u0003%\u0011\u0011\u0015\u0005\n\u0003c#!\u0019!C\u0001\u0003?C\u0001\"a-\u0005A\u0003%\u0011\u0011\u0015\u0005\t\u0003k#!\u0019!C\u0001q\"9\u0011q\u0017\u0003!\u0002\u0013I\b\u0002CA]\t\t\u0007I\u0011\u00014\t\u000f\u0005mF\u0001)A\u0005O\u0006iQj\u001c8h_N+G\u000f^5oONT!!\u0014(\u0002\u000f5|gnZ8eE*\u0011q\nU\u0001\fa\u0016\u00148/[:uK:\u001cWM\u0003\u0002R%\u000691m\u001c8ue&\u0014'\"A*\u0002\u000bA,7n[8\u0004\u0001A\u0011a+A\u0007\u0002\u0019\niQj\u001c8h_N+G\u000f^5oON\u001c\"!A-\u0011\u0005ikV\"A.\u000b\u0003q\u000bQa]2bY\u0006L!AX.\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ+A\u0003baBd\u0017\u0010F\u0002d\u0003{\u0003\"A\u0016\u0003\u0014\u0005\u0011I\u0016AB2p]\u001aLw-F\u0001h!\tAg.D\u0001j\u0015\t)'N\u0003\u0002lY\u0006AA/\u001f9fg\u00064WMC\u0001n\u0003\r\u0019w.\\\u0005\u0003_&\u0014aaQ8oM&<\u0017aB2p]\u001aLw\r\t\u000b\u0003GJDQ!Z\u0004A\u0002\u001d\fAb^5uQ>3XM\u001d:jI\u0016$\"aY;\t\u000bYD\u0001\u0019A4\u0002\u0005\tL\u0018AD%na2,W.\u001a8uCRLwN\\\u000b\u0002sB\u0019!0a\u0001\u000f\u0005m|\bC\u0001?\\\u001b\u0005i(B\u0001@U\u0003\u0019a$o\\8u}%\u0019\u0011\u0011A.\u0002\rA\u0013X\rZ3g\u0013\u0011\t)!a\u0002\u0003\rM#(/\u001b8h\u0015\r\t\taW\u0001\u0010\u00136\u0004H.Z7f]R\fG/[8oA\u0005AQj\u001c8h_V\u0013\u0018.A\u0005N_:<w.\u0016:jA\u0005AA)\u0019;bE\u0006\u001cX-\u0006\u0002\u0002\u0014A!!,!\u0006z\u0013\r\t9b\u0017\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0013\u0011\u000bG/\u00192bg\u0016\u0004\u0013!\u0005&pkJt\u0017\r\\\"pY2,7\r^5p]\u0006\u0011\"j\\;s]\u0006d7i\u001c7mK\u000e$\u0018n\u001c8!\u00031Qu.\u001e:oC2Le\u000eZ3y\u00035Qu.\u001e:oC2Le\u000eZ3yA\u0005\t\"j\\;s]\u0006d7+Z9Oe&sG-\u001a=\u0002%){WO\u001d8bYN+\u0017O\u0014:J]\u0012,\u0007\u0010I\u0001\u0010\u0015>,(O\\1m)\u0006<\u0017J\u001c3fq\u0006\u0001\"j\\;s]\u0006dG+Y4J]\u0012,\u0007\u0010I\u0001\u0014\u0015>,(O\\1m/JLG/Z\"p]\u000e,'O\\\u0001\u0015\u0015>,(O\\1m/JLG/Z\"p]\u000e,'O\u001c\u0011\u0002\u001f){WO\u001d8bY^#\u0016.\\3pkR,\"!a\r\u0011\t\u0005U\u0012qH\u0007\u0003\u0003oQA!!\u000f\u0002<\u0005AA-\u001e:bi&|gNC\u0002\u0002>m\u000b!bY8oGV\u0014(/\u001a8u\u0013\u0011\t\t%a\u000e\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006\u0001\"j\\;s]\u0006dw\u000bV5nK>,H\u000fI\u0001\r\u0015>,(O\\1m\rNKhnY\u000b\u0003\u0003\u0013\u00022AWA&\u0013\r\tie\u0017\u0002\b\u0005>|G.Z1o\u00035Qu.\u001e:oC245+\u001f8dA\u00059\"j\\;s]\u0006d\u0017)\u001e;p[\u0006$\u0018nY+qOJ\fG-Z\u0001\u0019\u0015>,(O\\1m\u0003V$x.\\1uS\u000e,\u0006o\u001a:bI\u0016\u0004\u0013aD*oCB\u001c8i\u001c7mK\u000e$\u0018n\u001c8\u0002!Ms\u0017\r]:D_2dWm\u0019;j_:\u0004\u0013AC*oCB\u001c\u0018J\u001c3fq\u0006Y1K\\1qg&sG-\u001a=!\u0003E\u0019f.\u00199t/JLG/Z\"p]\u000e,'O\\\u0001\u0013':\f\u0007o],sSR,7i\u001c8dKJt\u0007%A\u0007T]\u0006\u00048o\u0016+j[\u0016|W\u000f^\u0001\u000f':\f\u0007o],US6,w.\u001e;!\u0003)\u0019f.\u00199t\rNKhnY\u0001\f':\f\u0007o\u001d$Ts:\u001c\u0007%A\rsK\u0006dG/[7f\u000b:\f'\r\\3QKJ\u001c\u0018n\u001d;f]\u000e,\u0017A\u0007:fC2$\u0018.\\3F]\u0006\u0014G.\u001a)feNL7\u000f^3oG\u0016\u0004\u0013A\u0006:fC2$\u0018.\\3D_2dWm\u0019;j_:t\u0015-\\3\u0002/I,\u0017\r\u001c;j[\u0016\u001cu\u000e\u001c7fGRLwN\u001c(b[\u0016\u0004\u0013A\u0006:fC2$\u0018.\\3D_2dWm\u0019;j_:\u001c\u0016N_3\u0016\u0005\u0005U\u0004c\u0001.\u0002x%\u0019\u0011\u0011P.\u0003\t1{gnZ\u0001\u0018e\u0016\fG\u000e^5nK\u000e{G\u000e\\3di&|gnU5{K\u0002\n!#T3uC\u0012\fG/Y\"pY2,7\r^5p]\u0006\u0019R*\u001a;bI\u0006$\u0018mQ8mY\u0016\u001cG/[8oA\u0005iQ*\u001a;bI\u0006$\u0018-\u00138eKb\fa\"T3uC\u0012\fG/Y%oI\u0016D\b%A\u000fVg\u0016dUmZ1ds*{WO\u001d8bYN+'/[1mSj\fG/[8o\u0003y)6/\u001a'fO\u0006\u001c\u0017PS8ve:\fGnU3sS\u0006d\u0017N_1uS>t\u0007%\u0001\nTk\u001a4\u0017\u000e\u001f\"vS2$WM]\"mCN\u001c\u0018aE*vM\u001aL\u0007PQ;jY\u0012,'o\u00117bgN\u0004\u0013aD*vM\u001aL\u0007pU3qCJ\fGo\u001c:\u0002!M+hMZ5y'\u0016\u0004\u0018M]1u_J\u0004\u0013AG*vM\u001aL\u0007\u0010\u0012:pa\u0016k\u0007\u000f^=D_2dWm\u0019;j_:\u001c\u0018aG*vM\u001aL\u0007\u0010\u0012:pa\u0016k\u0007\u000f^=D_2dWm\u0019;j_:\u001c\b%\u0001\rTk\u001a4\u0017\u000e_'jOJ\fG/[8o\u0011\u0016\fg/\u001f'pC\u0012\f\u0011dU;gM&DX*[4sCRLwN\u001c%fCZLHj\\1eA\u0005a2+\u001e4gSbl\u0015n\u001a:bi&|g.R7qiflU\r^1eCR\f\u0017!H*vM\u001aL\u00070T5he\u0006$\u0018n\u001c8F[B$\u00180T3uC\u0012\fG/\u0019\u0011\u0002;M+hMZ5y\u001b&<'/\u0019;j_:l\u0015\r_%og\u0016\u0014HOU3uef,\"!!)\u0011\u0007i\u000b\u0019+C\u0002\u0002&n\u00131!\u00138u\u0003y\u0019VO\u001a4jq6KwM]1uS>tW*\u0019=J]N,'\u000f\u001e*fiJL\b%A\u000fTk\u001a4\u0017\u000e_'jOJ\fG/[8o\u001b\u0006DH)\u001a7fi\u0016\u0014V\r\u001e:z\u0003y\u0019VO\u001a4jq6KwM]1uS>tW*\u0019=EK2,G/\u001a*fiJL\b%\u0001\u0013Tk\u001a4\u0017\u000e_'jOJ\fG/[8o\u001b\u0006DX)\u001c9us6+G/\u00193bi\u0006\u0014V\r\u001e:z\u0003\u0015\u001aVO\u001a4jq6KwM]1uS>tW*\u0019=F[B$\u00180T3uC\u0012\fG/\u0019*fiJL\b%\u0001\u000eTk\u001a4\u0017\u000e_'jOJ\fG/[8o!\u0006\u0014\u0018\r\u001c7fY&\u001cX.A\u000eTk\u001a4\u0017\u000e_'jOJ\fG/[8o!\u0006\u0014\u0018\r\u001c7fY&\u001cX\u000eI\u0001\u0019\u001b>twm\\'fiJL7m\u001d\"vS2$WM]\"mCN\u001c\u0018!G'p]\u001e|W*\u001a;sS\u000e\u001c()^5mI\u0016\u00148\t\\1tg\u0002\nqbQ8mY\u0016\u001cG/[8o\u0007\u0006\u001c\u0007.Z\u0001\u0011\u0007>dG.Z2uS>t7)Y2iK\u0002Bq!a0\u0004\u0001\u0004\t\t-\u0001\btsN$X-\\*fiRLgnZ:\u0011\t\u0005\r\u0017\u0011\u001c\b\u0005\u0003\u000b\f).\u0004\u0002\u0002H*!\u0011\u0011ZAf\u0003\u0015\t7\r^8s\u0015\r\u0019\u0016Q\u001a\u0006\u0005\u0003\u001f\f\t.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003'\f1a\u001c:h\u0013\u0011\t9.a2\u0002\u0017\u0005\u001bGo\u001c:TsN$X-\\\u0005\u0005\u00037\fiN\u0001\u0005TKR$\u0018N\\4t\u0015\u0011\t9.a2")
public class MongoSettings {
    private final Config config;
    private final String Implementation;
    private final String MongoUri;
    private final Option<String> Database;
    private final String JournalCollection;
    private final String JournalIndex;
    private final String JournalSeqNrIndex;
    private final String JournalTagIndex;
    private final String JournalWriteConcern;
    private final FiniteDuration JournalWTimeout;
    private final boolean JournalFSync;
    private final boolean JournalAutomaticUpgrade;
    private final String SnapsCollection;
    private final String SnapsIndex;
    private final String SnapsWriteConcern;
    private final FiniteDuration SnapsWTimeout;
    private final boolean SnapsFSync;
    private final boolean realtimeEnablePersistence;
    private final String realtimeCollectionName;
    private final long realtimeCollectionSize;
    private final String MetadataCollection;
    private final String MetadataIndex;
    private final boolean UseLegacyJournalSerialization;
    private final String SuffixBuilderClass;
    private final String SuffixSeparator;
    private final boolean SuffixDropEmptyCollections;
    private final boolean SuffixMigrationHeavyLoad;
    private final boolean SuffixMigrationEmptyMetadata;
    private final int SuffixMigrationMaxInsertRetry;
    private final int SuffixMigrationMaxDeleteRetry;
    private final int SuffixMigrationMaxEmptyMetadataRetry;
    private final int SuffixMigrationParallelism;
    private final String MongoMetricsBuilderClass;
    private final Config CollectionCache;

    public static MongoSettings apply(ActorSystem.Settings systemSettings) {
        return MongoSettings$.MODULE$.apply(systemSettings);
    }

    public Config config() {
        return this.config;
    }

    public MongoSettings withOverride(Config by) {
        return new MongoSettings(by.withFallback((ConfigMergeable)this.config()));
    }

    public String Implementation() {
        return this.Implementation;
    }

    public String MongoUri() {
        return this.MongoUri;
    }

    public Option<String> Database() {
        return this.Database;
    }

    public String JournalCollection() {
        return this.JournalCollection;
    }

    public String JournalIndex() {
        return this.JournalIndex;
    }

    public String JournalSeqNrIndex() {
        return this.JournalSeqNrIndex;
    }

    public String JournalTagIndex() {
        return this.JournalTagIndex;
    }

    public String JournalWriteConcern() {
        return this.JournalWriteConcern;
    }

    public FiniteDuration JournalWTimeout() {
        return this.JournalWTimeout;
    }

    public boolean JournalFSync() {
        return this.JournalFSync;
    }

    public boolean JournalAutomaticUpgrade() {
        return this.JournalAutomaticUpgrade;
    }

    public String SnapsCollection() {
        return this.SnapsCollection;
    }

    public String SnapsIndex() {
        return this.SnapsIndex;
    }

    public String SnapsWriteConcern() {
        return this.SnapsWriteConcern;
    }

    public FiniteDuration SnapsWTimeout() {
        return this.SnapsWTimeout;
    }

    public boolean SnapsFSync() {
        return this.SnapsFSync;
    }

    public boolean realtimeEnablePersistence() {
        return this.realtimeEnablePersistence;
    }

    public String realtimeCollectionName() {
        return this.realtimeCollectionName;
    }

    public long realtimeCollectionSize() {
        return this.realtimeCollectionSize;
    }

    public String MetadataCollection() {
        return this.MetadataCollection;
    }

    public String MetadataIndex() {
        return this.MetadataIndex;
    }

    public boolean UseLegacyJournalSerialization() {
        return this.UseLegacyJournalSerialization;
    }

    public String SuffixBuilderClass() {
        return this.SuffixBuilderClass;
    }

    public String SuffixSeparator() {
        return this.SuffixSeparator;
    }

    public boolean SuffixDropEmptyCollections() {
        return this.SuffixDropEmptyCollections;
    }

    public boolean SuffixMigrationHeavyLoad() {
        return this.SuffixMigrationHeavyLoad;
    }

    public boolean SuffixMigrationEmptyMetadata() {
        return this.SuffixMigrationEmptyMetadata;
    }

    public int SuffixMigrationMaxInsertRetry() {
        return this.SuffixMigrationMaxInsertRetry;
    }

    public int SuffixMigrationMaxDeleteRetry() {
        return this.SuffixMigrationMaxDeleteRetry;
    }

    public int SuffixMigrationMaxEmptyMetadataRetry() {
        return this.SuffixMigrationMaxEmptyMetadataRetry;
    }

    public int SuffixMigrationParallelism() {
        return this.SuffixMigrationParallelism;
    }

    public String MongoMetricsBuilderClass() {
        return this.MongoMetricsBuilderClass;
    }

    public Config CollectionCache() {
        return this.CollectionCache;
    }

    public MongoSettings(Config config) {
        String string;
        this.config = config;
        this.Implementation = config.getString("driver");
        Option option = Try$.MODULE$.apply((Function0 & Serializable)() -> this.config().getString("mongouri")).toOption();
        if (option instanceof Some) {
            String uri;
            Some some = (Some)option;
            string = uri = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            String Urls = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(config.getStringList("urls")).asScala()).toList().mkString(",");
            Option Username = Try$.MODULE$.apply((Function0 & Serializable)() -> this.config().getString("username")).toOption();
            Option Password = Try$.MODULE$.apply((Function0 & Serializable)() -> this.config().getString("password")).toOption();
            String DbName = config.getString("db");
            string = (String)Username.flatMap((Function1 & Serializable)user -> Password.map((Function1 & Serializable)password -> new StringBuilder(13).append("mongodb://").append((String)user).append(":").append((String)password).append("@").append(Urls).append("/").append(DbName).toString())).getOrElse((Function0 & Serializable)() -> new StringBuilder(11).append("mongodb://").append(Urls).append("/").append(DbName).toString());
        } else {
            throw new MatchError((Object)option);
        }
        this.MongoUri = string;
        this.Database = Try$.MODULE$.apply((Function0 & Serializable)() -> this.config().getString("database")).toOption();
        this.JournalCollection = config.getString("journal-collection");
        this.JournalIndex = config.getString("journal-index");
        this.JournalSeqNrIndex = config.getString("journal-seq-nr-index");
        this.JournalTagIndex = config.getString("journal-tag-index");
        this.JournalWriteConcern = config.getString("journal-write-concern");
        this.JournalWTimeout = new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("journal-wtimeout", TimeUnit.MILLISECONDS))).millis();
        this.JournalFSync = config.getBoolean("journal-fsync");
        this.JournalAutomaticUpgrade = config.getBoolean("journal-automatic-upgrade");
        this.SnapsCollection = config.getString("snaps-collection");
        this.SnapsIndex = config.getString("snaps-index");
        this.SnapsWriteConcern = config.getString("snaps-write-concern");
        this.SnapsWTimeout = new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("snaps-wtimeout", TimeUnit.MILLISECONDS))).millis();
        this.SnapsFSync = config.getBoolean("snaps-fsync");
        this.realtimeEnablePersistence = config.getBoolean("realtime-enable-persistence");
        this.realtimeCollectionName = config.getString("realtime-collection");
        this.realtimeCollectionSize = config.getLong("realtime-collection-size");
        this.MetadataCollection = config.getString("metadata-collection");
        this.MetadataIndex = config.getString("metadata-index");
        this.UseLegacyJournalSerialization = config.getBoolean("use-legacy-serialization");
        this.SuffixBuilderClass = config.getString("suffix-builder.class");
        this.SuffixSeparator = config.getString("suffix-builder.separator");
        this.SuffixDropEmptyCollections = config.getBoolean("suffix-drop-empty-collections");
        this.SuffixMigrationHeavyLoad = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)config.getBoolean("suffix-migration.heavy-load"))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        this.SuffixMigrationEmptyMetadata = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)config.getBoolean("suffix-migration.empty-metadata"))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        this.SuffixMigrationMaxInsertRetry = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)config.getInt("suffix-migration.max-insert-retry"))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 >= 0).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1));
        this.SuffixMigrationMaxDeleteRetry = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)config.getInt("suffix-migration.max-delete-retry"))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 >= 0).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1));
        this.SuffixMigrationMaxEmptyMetadataRetry = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)config.getInt("suffix-migration.max-empty-metadata-retry"))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> x$3 >= 0).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1));
        this.SuffixMigrationParallelism = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)config.getInt("suffix-migration.parallelism"))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> x$4 > 0).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1));
        this.MongoMetricsBuilderClass = config.getString("metrics-builder.class");
        this.CollectionCache = config.getConfig("collection-cache");
    }
}

