/*
 * Decompiled with CFR 0.152.
 */
package pekko.contrib.persistence.mongodb;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.time.Duration;
import org.apache.pekko.actor.ActorSystem;
import pekko.contrib.persistence.mongodb.MongoCollectionCache;
import pekko.contrib.persistence.mongodb.ReflectiveLookupExtension;
import pekko.contrib.persistence.mongodb.ReflectiveLookupExtension$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class MongoCollectionCache$ {
    public static final MongoCollectionCache$ MODULE$ = new MongoCollectionCache$();

    public <C> MongoCollectionCache<C> apply(Config config, String path, ActorSystem system) {
        ReflectiveLookupExtension reflectiveLookup = (ReflectiveLookupExtension)ReflectiveLookupExtension$.MODULE$.apply(system);
        Try configuredCache = Try$.MODULE$.apply((Function0 & Serializable)() -> config.getString(new StringBuilder(6).append(path).append(".class").toString())).flatMap((Function1 & Serializable)className -> MODULE$.loadCacheConstructor((String)className, reflectiveLookup).map((Function1 & Serializable)constructor -> (MongoCollectionCache)constructor.apply((Object)config.getConfig(path))));
        return (MongoCollectionCache)configuredCache.getOrElse((Function0 & Serializable)() -> MODULE$.createDefaultCache(config, path));
    }

    private <C> Try<Function1<Config, MongoCollectionCache<C>>> loadCacheConstructor(String className, ReflectiveLookupExtension reflectiveLookup) {
        return new Success((Object)className.trim()).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$6)))).flatMap((Function1 & Serializable)nonEmptyClassName -> reflectiveLookup.reflectClassByName((String)nonEmptyClassName, ClassTag$.MODULE$.apply(MongoCollectionCache.class)).withFilter((Function1 & Serializable)cacheClass -> BoxesRunTime.boxToBoolean((boolean)MongoCollectionCache$.$anonfun$loadCacheConstructor$3(cacheClass))).flatMap((Function1 & Serializable)cacheClass -> MODULE$.getExpectedConstructor((Class)cacheClass).map((Function1 & Serializable)constructor -> constructor)));
    }

    private <T> Try<Function1<Config, T>> getExpectedConstructor(Class<T> cacheClass) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> cacheClass.getConstructor(Config.class)).map((Function1 & Serializable)constructor -> (Function1 & Serializable)x -> constructor.newInstance(x));
    }

    private <C> MongoCollectionCache<C> createDefaultCache(Config config, String path) {
        Try try_;
        String maxSizePath = new StringBuilder(9).append(path).append(".max-size").toString();
        String ttlPath = new StringBuilder(19).append(path).append(".expire-after-write").toString();
        Tuple3 tuple3 = new Tuple3((Object)Try$.MODULE$.apply((Function0 & Serializable)() -> config.getConfig(path)), (Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> config.getInt(maxSizePath)), (Object)Try$.MODULE$.apply((Function0 & Serializable)() -> config.getDuration(ttlPath)));
        if (tuple3 != null) {
            Try try_2 = (Try)tuple3._1();
            Try try_3 = (Try)tuple3._2();
            if (try_2 instanceof Success) {
                Success success;
                int n;
                Success success2 = (Success)try_2;
                Config cacheConfig = (Config)success2.value();
                if (try_3 instanceof Success && 1 == (n = BoxesRunTime.unboxToInt((Object)(success = (Success)try_3).value()))) {
                    return new MongoCollectionCache.Single(cacheConfig);
                }
            }
        }
        if (tuple3 != null && (try_ = (Try)tuple3._3()) instanceof Success) {
            Success success = (Success)try_;
            Duration ttl = (Duration)success.value();
            return new MongoCollectionCache.Expiring(ttl);
        }
        return new MongoCollectionCache.Default();
    }

    public static final /* synthetic */ boolean $anonfun$loadCacheConstructor$3(Class cacheClass) {
        return MongoCollectionCache.class.isAssignableFrom(cacheClass);
    }

    private MongoCollectionCache$() {
    }
}

