/*
 * Decompiled with CFR 0.152.
 */
package pekko.contrib.persistence.mongodb.driver;

import com.mongodb.ErrorCategory;
import com.mongodb.MongoWriteException;
import com.mongodb.WriteConcern;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.Done;
import org.apache.pekko.NotUsed;
import org.apache.pekko.persistence.AtomicWrite;
import org.apache.pekko.persistence.PersistentRepr;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.MongoCollection;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.model.Accumulators$;
import org.mongodb.scala.model.Aggregates$;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Projections$;
import org.mongodb.scala.model.Sorts$;
import org.mongodb.scala.model.Updates$;
import org.mongodb.scala.model.package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pekko.contrib.persistence.mongodb.Atom$;
import pekko.contrib.persistence.mongodb.Event;
import pekko.contrib.persistence.mongodb.MongoPersistenceJournallingApi;
import pekko.contrib.persistence.mongodb.driver.RxStreamsInterop$;
import pekko.contrib.persistence.mongodb.driver.ScalaDriverPersistenceJournaller$;
import pekko.contrib.persistence.mongodb.driver.ScalaMongoDriver;
import pekko.contrib.persistence.mongodb.driver.package$;
import pekko.contrib.persistence.mongodb.driver.package$NonWrappingLongToInt$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005Uh\u0001B\u000b\u0017\u0001\u0005B\u0001b\u0006\u0001\u0003\u0006\u0004%\t\u0001\f\u0005\tc\u0001\u0011\t\u0011)A\u0005[!)!\u0007\u0001C\u0001g!9a\u0007\u0001b\u0001\n#9\u0004B\u0002!\u0001A\u0003%\u0001\b\u0003\u0004B\u0001\u0001\u0006IA\u0011\u0005\u0007)\u0002\u0001K\u0011B+\t\r\u0005\u0004\u0001\u0015\"\u0003V\u0011\u0019\u0011\u0007\u0001)C\u0005+\"11\r\u0001Q\u0005\n\u0011Dq!!\u0003\u0001\t\u0003\tY\u0001\u0003\u0005\u0002B\u0001\u0001K\u0011BA\"\u0011!\ti\b\u0001Q\u0005\n\u0005}\u0004bBAE\u0001\u0011\u0005\u00131\u0012\u0005\t\u00037\u0003\u0001\u0015\"\u0003\u0002\u001e\"A\u0011\u0011\u0016\u0001!\n\u0013\tY\u000bC\u0004\u0002:\u0002!\t%a/\t\u0011\u0005\r\u0007\u0001)C\u0005\u0003\u000bDq!a*\u0001\t\u0003\ny\rC\u0004\u0002X\u0002!\t%!7\u0003AM\u001b\u0017\r\\1Ee&4XM\u001d)feNL7\u000f^3oG\u0016Tu.\u001e:oC2dWM\u001d\u0006\u0003/a\ta\u0001\u001a:jm\u0016\u0014(BA\r\u001b\u0003\u001diwN\\4pI\nT!a\u0007\u000f\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u0003;y\tqaY8oiJL'MC\u0001 \u0003\u0015\u0001Xm[6p\u0007\u0001\u00192\u0001\u0001\u0012)!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0019\te.\u001f*fMB\u0011\u0011FK\u0007\u00021%\u00111\u0006\u0007\u0002\u001f\u001b>twm\u001c)feNL7\u000f^3oG\u0016Tu.\u001e:oC2d\u0017N\\4Ba&,\u0012!\f\t\u0003]=j\u0011AF\u0005\u0003aY\u0011\u0001cU2bY\u0006luN\\4p\tJLg/\u001a:\u0002\u000f\u0011\u0014\u0018N^3sA\u00051A(\u001b8jiz\"\"\u0001N\u001b\u0011\u00059\u0002\u0001\"B\f\u0004\u0001\u0004i\u0013A\u00027pO\u001e,'/F\u00019!\tId(D\u0001;\u0015\tYD(A\u0003tY\u001a$$NC\u0001>\u0003\ry'oZ\u0005\u0003\u007fi\u0012a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\roJLG/Z\"p]\u000e,'O\u001c\t\u0003\u0007Fs!\u0001\u0012(\u000f\u0005\u0015ceB\u0001$L\u001d\t9%*D\u0001I\u0015\tI\u0005%\u0001\u0004=e>|GOP\u0005\u0002{%\u0011\u0011\u0004P\u0005\u0003K5S!!\u0007\u001f\n\u0005=\u0003\u0016a\u00029bG.\fw-\u001a\u0006\u0003K5K!AU*\u0003\u0019]\u0013\u0018\u000e^3D_:\u001cWM\u001d8\u000b\u0005=\u0003\u0016a\u00026pkJt\u0017\r\\\u000b\u0002-B\u0019qK\u0017/\u000e\u0003aS!!\u0017\u0013\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002\\1\n1a)\u001e;ve\u0016\u0004\"!X0\u000f\u0005y\u000bQ\"\u0001\u0001\n\u0005\u0001|#!A\"\u0002\u0011I,\u0017\r\u001c;j[\u0016\f\u0001\"\\3uC\u0012\fG/Y\u0001\u0012U>,(O\\1m%\u0006tw-Z)vKJLH#B3t{\u0006\u0015\u0001C\u00014q\u001d\t9gN\u0004\u0002iW:\u0011A)[\u0005\u0003UB\u000bAAY:p]&\u0011A.\\\u0001\fG>tg/\u001a:tS>t7O\u0003\u0002k!&\u0011qj\u001c\u0006\u0003Y6L!!\u001d:\u0003\t\t\u001bxN\u001c\u0006\u0003\u001f>DQ\u0001\u001e\u0006A\u0002U\f1\u0001]5e!\t1(P\u0004\u0002xqB\u0011q\tJ\u0005\u0003s\u0012\na\u0001\u0015:fI\u00164\u0017BA>}\u0005\u0019\u0019FO]5oO*\u0011\u0011\u0010\n\u0005\u0006}*\u0001\ra`\u0001\u0005MJ|W\u000eE\u0002$\u0003\u0003I1!a\u0001%\u0005\u0011auN\\4\t\r\u0005\u001d!\u00021\u0001\u0000\u0003\t!x.\u0001\u0007k_V\u0014h.\u00197SC:<W\r\u0006\u0006\u0002\u000e\u0005E\u00121GA\u001b\u0003o\u0001\u0002\"a\u0004\u0002 \u0005\r\u0012\u0011F\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005A1oY1mC\u0012\u001cHN\u0003\u0003\u0002\u0018\u0005e\u0011AB:ue\u0016\fWNC\u0002 \u00037Q1!!\b=\u0003\u0019\t\u0007/Y2iK&!\u0011\u0011EA\t\u0005\u0019\u0019v.\u001e:dKB\u0019\u0011&!\n\n\u0007\u0005\u001d\u0002DA\u0003Fm\u0016tG\u000f\u0005\u0003\u0002,\u00055RBAA\r\u0013\u0011\ty#!\u0007\u0003\u000f9{G/V:fI\")Ao\u0003a\u0001k\")ap\u0003a\u0001\u007f\"1\u0011qA\u0006A\u0002}Dq!!\u000f\f\u0001\u0004\tY$A\u0002nCb\u00042aIA\u001f\u0013\r\ty\u0004\n\u0002\u0004\u0013:$\u0018A\u00032vS2$')\u0019;dQR!\u0011QIA7!\u0019\t9%!\u0015\u0002V5\u0011\u0011\u0011\n\u0006\u0005\u0003\u0017\ni%A\u0005j[6,H/\u00192mK*\u0019\u0011q\n\u0013\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002T\u0005%#aA*fcB1\u0011qKA/\u0003Cj!!!\u0017\u000b\u0007\u0005mC%\u0001\u0003vi&d\u0017\u0002BA0\u00033\u00121\u0001\u0016:z!\u0011\t\u0019'a\u001a\u000f\u0007!\f)'\u0003\u0002P[&!\u0011\u0011NA6\u00051\u00115o\u001c8E_\u000e,X.\u001a8u\u0015\tyU\u000eC\u0004\u0002p1\u0001\r!!\u001d\u0002\r]\u0014\u0018\u000e^3t!\u0019\t9%!\u0015\u0002tA!\u0011QOA=\u001b\t\t9HC\u0002\u001c\u00033IA!a\u001f\u0002x\tY\u0011\t^8nS\u000e<&/\u001b;f\u00035!wNQ1uG\"\f\u0005\u000f]3oIR1\u0011\u0011QAB\u0003\u000f\u0003Ba\u0016.\u0002F!9\u0011QQ\u0007A\u0002\u0005\u0015\u0013!\u00022bi\u000eD\u0007BBA(\u001b\u0001\u0007a+A\u0006cCR\u001c\u0007.\u00119qK:$G\u0003BAG\u00033\u0003Ba\u0016.\u0002\u0010B1\u0011qIA)\u0003#\u0003b!a\u0016\u0002^\u0005M\u0005cA\u0012\u0002\u0016&\u0019\u0011q\u0013\u0013\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003_r\u0001\u0019AA9\u0003Y\u0019X\r^'bqN+\u0017/^3oG\u0016lU\r^1eCR\fGCBAP\u0003C\u000b)\u000b\u0005\u0003X5\u0006M\u0005BBAR\u001f\u0001\u0007Q/A\u0007qKJ\u001c\u0018n\u001d;f]\u000e,\u0017\n\u001a\u0005\u0007\u0003O{\u0001\u0019A@\u0002\u001b5\f\u0007pU3rk\u0016t7-\u001a(s\u0003=1\u0017N\u001c3NCb\u001cV-];f]\u000e,GCBAW\u0003k\u000b9\f\u0005\u0003X5\u0006=\u0006\u0003B\u0012\u00022~L1!a-%\u0005\u0019y\u0005\u000f^5p]\"1\u00111\u0015\tA\u0002UDa!a*\u0011\u0001\u0004y\u0018A\u00033fY\u0016$XM\u0012:p[R1\u0011qTA_\u0003\u007fCa!a)\u0012\u0001\u0004)\bBBAa#\u0001\u0007q0\u0001\u0007u_N+\u0017/^3oG\u0016t%/A\fnCb\u001cV-];f]\u000e,gI]8n\u001b\u0016$\u0018\rZ1uCR!\u0011qYAg)\u0011\ti+!3\t\u000f\u0005-'\u00031\u0001\u00020\u0006A\u0001O]3wS>,8\u000fC\u0003u%\u0001\u0007Q\u000f\u0006\u0004\u0002R\u0006M\u0017Q\u001b\t\u0004/j{\b\"\u0002;\u0014\u0001\u0004)\b\"\u0002@\u0014\u0001\u0004y\u0018!\u0004:fa2\f\u0017PS8ve:\fG\u000e\u0006\u0006\u0002\\\u00065\u0018q^Ay\u0003g$B!a(\u0002^\"9\u0011q\u001c\u000bA\u0002\u0005\u0005\u0018A\u0004:fa2\f\u0017pQ1mY\n\f7m\u001b\t\bG\u0005\r\u0018q]AJ\u0013\r\t)\u000f\n\u0002\n\rVt7\r^5p]F\u0002B!!\u001e\u0002j&!\u00111^A<\u00059\u0001VM]:jgR,g\u000e\u001e*faJDQ\u0001\u001e\u000bA\u0002UDQA \u000bA\u0002}Da!a\u0002\u0015\u0001\u0004y\bBBA\u001d)\u0001\u0007q\u0010")
public class ScalaDriverPersistenceJournaller
implements MongoPersistenceJournallingApi {
    private final ScalaMongoDriver driver;
    private final Logger logger;
    private final WriteConcern writeConcern;

    @Override
    public <T> Seq<Try<BoxedUnit>> squashToUnit(Seq<Try<T>> seq) {
        return MongoPersistenceJournallingApi.squashToUnit$(this, seq);
    }

    public ScalaMongoDriver driver() {
        return this.driver;
    }

    public Logger logger() {
        return this.logger;
    }

    private Future<MongoCollection<BsonDocument>> journal() {
        return this.driver().journal().map((Function1 & Serializable)x$1 -> x$1.withWriteConcern(this.driver().journalWriteConcern()), this.driver().pluginDispatcher());
    }

    public Future<MongoCollection<BsonDocument>> pekko$contrib$persistence$mongodb$driver$ScalaDriverPersistenceJournaller$$realtime() {
        return this.driver().realtime();
    }

    private Future<MongoCollection<BsonDocument>> metadata() {
        return this.driver().metadata().map((Function1 & Serializable)x$2 -> x$2.withWriteConcern(this.driver().metadataWriteConcern()), this.driver().pluginDispatcher());
    }

    private Bson journalRangeQuery(String pid, long from, long to) {
        return Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.equal("pid", (Object)pid), Filters$.MODULE$.gte("from", (Object)BoxesRunTime.boxToLong((long)from)), Filters$.MODULE$.lte("to", (Object)BoxesRunTime.boxToLong((long)to))}));
    }

    public Source<Event, NotUsed> journalRange(String pid, long from, long to, int max) {
        Future<Object> journal = this.driver().getJournal(pid);
        Source source2 = (Source)Source$.MODULE$.future(journal).flatMapConcat((Function1 & Serializable)x$3 -> (Source)RxStreamsInterop$.MODULE$.ObservableAdapter(x$3.find(this.journalRangeQuery(pid, from, to), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonDocument.class)).sort(Sorts$.MODULE$.ascending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"to"}))).projection(Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"events"})))).asPekko().take((long)max));
        Flow flow = (Flow)Flow$.MODULE$.apply().mapConcat((Function1 & Serializable)e -> (Seq)Option$.MODULE$.apply((Object)e.get((Object)"events")).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isArray())).map((Function1 & Serializable)x$5 -> x$5.asArray()).map((Function1 & Serializable)x$6 -> ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(x$6.getValues()).asScala()).toList().collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ScalaDriverPersistenceJournaller $outer;

            public final <A1 extends BsonValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof BsonDocument) {
                    BsonDocument bsonDocument = (BsonDocument)A1;
                    return (B1)this.$outer.driver().deserializeJournal(bsonDocument, this.$outer.driver().ScalaSerializers().Deserializer());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(BsonValue x1) {
                BsonValue bsonValue = x1;
                return bsonValue instanceof BsonDocument;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).getOrElse((Function0 & Serializable)() -> (Seq)Seq$.MODULE$.empty())).filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ScalaDriverPersistenceJournaller.$anonfun$journalRange$7(from, x$7))).filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ScalaDriverPersistenceJournaller.$anonfun$journalRange$8(to, x$8)));
        return source2.via((Graph)flow);
    }

    private Seq<Try<BsonDocument>> buildBatch(Seq<AtomicWrite> writes) {
        return (Seq)writes.map((Function1 & Serializable)aw -> Try$.MODULE$.apply((Function0 & Serializable)() -> (BsonDocument)this.driver().serializeJournal(Atom$.MODULE$.apply((AtomicWrite)aw, this.driver().useLegacySerialization(), this.driver().ScalaSerializers().serialization(), ManifestFactory$.MODULE$.classType(BsonValue.class), this.driver().ScalaSerializers().dt(), this.driver().ScalaSerializers().loader()), this.driver().ScalaSerializers().Serializer())));
    }

    public Future<Seq<Try<BsonDocument>>> pekko$contrib$persistence$mongodb$driver$ScalaDriverPersistenceJournaller$$doBatchAppend(Seq<Try<BsonDocument>> batch, Future<MongoCollection<BsonDocument>> collection) {
        if (batch.forall((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isSuccess()))) {
            Seq collected = (Seq)batch.collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Try<BsonDocument>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof Success) {
                        Success success = (Success)A1;
                        BsonDocument doc = (BsonDocument)success.value();
                        return (B1)package.InsertOneModel$.MODULE$.apply((Object)doc);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Try<BsonDocument> x1) {
                    Try<BsonDocument> try_ = x1;
                    return try_ instanceof Success;
                }
            });
            return collection.flatMap((Function1 & Serializable)x$10 -> org.mongodb.scala.package$.MODULE$.SingleObservableFuture((Function0 & Serializable)() -> x$10.withWriteConcern($this.writeConcern).bulkWrite(collected, new BulkWriteOptions().ordered(true))).toFuture().map((Function1 & Serializable)x$11 -> batch, this.driver().pluginDispatcher()), this.driver().pluginDispatcher());
        }
        return Future$.MODULE$.sequence((IterableOnce)batch.map((Function1 & Serializable)x0$1 -> {
            Success success;
            BsonDocument document;
            Try try_ = x0$1;
            if (try_ instanceof Success && (document = (BsonDocument)(success = (Success)try_).value()) != null) {
                BsonDocument bsonDocument = document;
                return collection.flatMap((Function1 & Serializable)x$12 -> org.mongodb.scala.package$.MODULE$.SingleObservableFuture((Function0 & Serializable)() -> x$12.withWriteConcern($this.writeConcern).insertOne((Object)bsonDocument)).toFuture().map((Function1 & Serializable)x$13 -> new Success((Object)bsonDocument), this.driver().pluginDispatcher()), this.driver().pluginDispatcher());
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                return Future$.MODULE$.successful((Object)new Failure(failure.exception()));
            }
            throw new MatchError((Object)try_);
        }), BuildFrom$.MODULE$.buildFromIterableOps(), this.driver().pluginDispatcher());
    }

    @Override
    public Future<Seq<Try<BoxedUnit>>> batchAppend(Seq<AtomicWrite> writes) {
        Future batchFuture;
        Future future;
        if (this.driver().useSuffixedCollectionNames()) {
            Future fZero = Future$.MODULE$.successful((Object)Seq$.MODULE$.empty());
            future = (Future)writes.groupBy((Function1 & Serializable)write -> this.driver().getJournalCollectionName(write.persistenceId())).foldLeft((Object)fZero, (Function2 & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    Future future = (Future)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        Seq hunk = (Seq)tuple22._2();
                        return future.map((Function1 & Serializable)prev -> {
                            Seq<Try<BsonDocument>> batch = this.buildBatch((Seq<AtomicWrite>)hunk);
                            return new Tuple2(prev, batch);
                        }, this.driver().pluginDispatcher()).flatMap((Function1 & Serializable)x$14 -> {
                            Tuple2 tuple2 = x$14;
                            if (tuple2 != null) {
                                Seq prev = (Seq)tuple2._1();
                                Seq batch = (Seq)tuple2._2();
                                return this.pekko$contrib$persistence$mongodb$driver$ScalaDriverPersistenceJournaller$$doBatchAppend((Seq<Try<BsonDocument>>)batch, this.driver().journal(((AtomicWrite)hunk.head()).persistenceId())).map((Function1 & Serializable)next -> (Seq)prev.$plus$plus((IterableOnce)next), this.driver().pluginDispatcher());
                            }
                            throw new MatchError((Object)tuple2);
                        }, this.driver().pluginDispatcher());
                    }
                }
                throw new MatchError((Object)tuple2);
            });
        } else {
            Seq<Try<BsonDocument>> batch = this.buildBatch(writes);
            future = batchFuture = this.pekko$contrib$persistence$mongodb$driver$ScalaDriverPersistenceJournaller$$doBatchAppend(batch, this.journal());
        }
        if (this.driver().realtimeEnablePersistence()) {
            return batchFuture.andThen((PartialFunction)new Serializable(this){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ ScalaDriverPersistenceJournaller $outer;

                public final <A1 extends Try<Seq<Try<BsonDocument>>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof Success) {
                        Success success = (Success)A1;
                        Seq batch = (Seq)success.value();
                        Future<Seq<Try<BsonDocument>>> f = this.$outer.pekko$contrib$persistence$mongodb$driver$ScalaDriverPersistenceJournaller$$doBatchAppend((Seq<Try<BsonDocument>>)batch, this.$outer.pekko$contrib$persistence$mongodb$driver$ScalaDriverPersistenceJournaller$$realtime());
                        f.onComplete((Function1 & Serializable)x0$1 -> {
                            $anonfun$batchAppend$6.$anonfun$applyOrElse$1(this, x0$1);
                            return BoxedUnit.UNIT;
                        }, this.$outer.driver().pluginDispatcher());
                        return (B1)f;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Try<Seq<Try<BsonDocument>>> x1) {
                    Try<Seq<Try<BsonDocument>>> try_ = x1;
                    return try_ instanceof Success;
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$1($anonfun$batchAppend$6 $this, Try x0$1) {
                    Try try_ = x0$1;
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable t = failure.exception();
                        $this.$outer.logger().error("Error during write to realtime collection", t);
                        return;
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(pekko.contrib.persistence.mongodb.driver.ScalaDriverPersistenceJournaller$$anonfun$batchAppend$6 scala.util.Try )}, serializedLambda);
                }
            }, this.driver().pluginDispatcher()).map((Function1 & Serializable)seq -> this.squashToUnit((Seq)seq), this.driver().pluginDispatcher());
        }
        return batchFuture.map((Function1 & Serializable)seq -> this.squashToUnit((Seq)seq), this.driver().pluginDispatcher());
    }

    private Future<BoxedUnit> setMaxSequenceMetadata(String persistenceId, long maxSequenceNr) {
        return this.metadata().flatMap((Function1 & Serializable)md -> org.mongodb.scala.package$.MODULE$.SingleObservableFuture((Function0 & Serializable)() -> md.updateOne(Filters$.MODULE$.equal("pid", (Object)persistenceId), Updates$.MODULE$.combine((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Updates$.MODULE$.setOnInsert("pid", (Object)persistenceId), Updates$.MODULE$.setOnInsert("max_sn", (Object)BoxesRunTime.boxToLong((long)maxSequenceNr))})), new UpdateOptions().upsert(true))).toFuture().flatMap((Function1 & Serializable)x$16 -> {
            UpdateResult updateResult = x$16;
            return org.mongodb.scala.package$.MODULE$.SingleObservableFuture((Function0 & Serializable)() -> md.updateOne(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.equal("pid", (Object)persistenceId), Filters$.MODULE$.lte("max_sn", (Object)BoxesRunTime.boxToLong((long)maxSequenceNr))})), Updates$.MODULE$.set("max_sn", (Object)BoxesRunTime.boxToLong((long)maxSequenceNr)), new UpdateOptions().upsert(false))).toFuture().map((Function1 & Serializable)x$15 -> {
                updateResult = x$15;
                return BoxedUnit.UNIT;
            }, this.driver().pluginDispatcher());
        }, this.driver().pluginDispatcher()), this.driver().pluginDispatcher());
    }

    private Future<Option<Object>> findMaxSequence(String persistenceId, long maxSequenceNr) {
        return this.driver().getJournal(persistenceId).flatMap((Function1 & Serializable)j -> this.performAggregation$1((MongoCollection)j, persistenceId, maxSequenceNr).map((Function1 & Serializable)rez -> rez, this.driver().pluginDispatcher()), this.driver().pluginDispatcher());
    }

    @Override
    public Future<BoxedUnit> deleteFrom(String persistenceId, long toSequenceNr) {
        return this.driver().getJournal(persistenceId).flatMap((Function1 & Serializable)journal -> this.findMaxSequence(persistenceId, toSequenceNr).flatMap((Function1 & Serializable)ms -> ((Future)ms.fold((Function0 & Serializable)() -> Future$.MODULE$.successful((Object)BoxedUnit.UNIT), (Function1 & Serializable)x$22 -> this.setMaxSequenceMetadata(persistenceId, BoxesRunTime.unboxToLong((Object)x$22)))).map((Function1 & Serializable)x$24 -> {
            Bson docWithAllEventsToRemove = Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.equal("pid", (Object)persistenceId), Filters$.MODULE$.lte("to", (Object)BoxesRunTime.boxToLong((long)toSequenceNr))}));
            return new Tuple2(x$24, (Object)docWithAllEventsToRemove);
        }, this.driver().pluginDispatcher()).flatMap((Function1 & Serializable)x$27 -> {
            Tuple2 tuple2 = x$27;
            if (tuple2 != null) {
                Bson docWithAllEventsToRemove = (Bson)tuple2._2();
                return org.mongodb.scala.package$.MODULE$.SingleObservableFuture((Function0 & Serializable)() -> journal.deleteMany(docWithAllEventsToRemove)).toFuture().map((Function1 & Serializable)removed -> {
                    Bson query = this.journalRangeQuery(persistenceId, toSequenceNr, toSequenceNr);
                    Bson update = Updates$.MODULE$.combine((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Updates$.MODULE$.pull("events", (Object)Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.equal("pid", (Object)persistenceId), Filters$.MODULE$.lte("sn", (Object)BoxesRunTime.boxToLong((long)toSequenceNr))}))), Updates$.MODULE$.set("from", (Object)BoxesRunTime.boxToLong((long)(toSequenceNr + 1L)))}));
                    return new Tuple3(removed, (Object)query, (Object)update);
                }, this.driver().pluginDispatcher()).flatMap((Function1 & Serializable)x$26 -> {
                    Tuple3 tuple3 = x$26;
                    if (tuple3 != null) {
                        DeleteResult removed = (DeleteResult)tuple3._1();
                        Bson query = (Bson)tuple3._2();
                        Bson update = (Bson)tuple3._3();
                        return org.mongodb.scala.package$.MODULE$.SingleObservableFuture((Function0 & Serializable)() -> journal.withWriteConcern($this.writeConcern).updateMany(query, update, new UpdateOptions().upsert(false))).toFuture().recover((PartialFunction)new Serializable(null){
                            private static final long serialVersionUID = 0L;

                            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                if (A1 instanceof MongoWriteException) {
                                    MongoWriteException mongoWriteException = (MongoWriteException)A1;
                                    ErrorCategory errorCategory = mongoWriteException.getError().getCategory();
                                    ErrorCategory errorCategory2 = ErrorCategory.DUPLICATE_KEY;
                                    if (!(errorCategory != null ? !errorCategory.equals(errorCategory2) : errorCategory2 != null)) {
                                        return (B1)BoxedUnit.UNIT;
                                    }
                                }
                                return (B1)function1.apply(x1);
                            }

                            public final boolean isDefinedAt(Throwable x1) {
                                Throwable throwable = x1;
                                if (throwable instanceof MongoWriteException) {
                                    MongoWriteException mongoWriteException = (MongoWriteException)throwable;
                                    ErrorCategory errorCategory = mongoWriteException.getError().getCategory();
                                    ErrorCategory errorCategory2 = ErrorCategory.DUPLICATE_KEY;
                                    if (!(errorCategory != null ? !errorCategory.equals(errorCategory2) : errorCategory2 != null)) {
                                        return true;
                                    }
                                }
                                return false;
                            }
                        }, this.driver().pluginDispatcher()).map((Function1 & Serializable)x$25 -> {
                            ScalaDriverPersistenceJournaller.$anonfun$deleteFrom$11(this, removed, journal, persistenceId, x$25);
                            return BoxedUnit.UNIT;
                        }, this.driver().pluginDispatcher());
                    }
                    throw new MatchError((Object)tuple3);
                }, this.driver().pluginDispatcher());
            }
            throw new MatchError((Object)tuple2);
        }, this.driver().pluginDispatcher()), this.driver().pluginDispatcher()), this.driver().pluginDispatcher());
    }

    private Future<Option<Object>> maxSequenceFromMetadata(String pid, Option<Object> previous) {
        return (Future)previous.fold((Function0 & Serializable)() -> this.metadata().flatMap((Function1 & Serializable)x$28 -> org.mongodb.scala.package$.MODULE$.SingleObservableFuture((Function0 & Serializable)() -> x$28.find((Bson)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pid"), (Object)pid), (BsonTransformer)BsonTransformer$.MODULE$.TransformString())})), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonDocument.class)).projection((Bson)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max_sn"), (Object)BoxesRunTime.boxToInteger((int)1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformInt())}))).first()).toFutureOption().map((Function1 & Serializable)d -> d.flatMap((Function1 & Serializable)l -> Option$.MODULE$.apply((Object)l.asDocument().get((Object)"max_sn")).filter((Function1 & Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)x$29.isInt64())).map((Function1 & Serializable)x$30 -> x$30.asInt64()).map((Function1 & Serializable)x$31 -> BoxesRunTime.boxToLong((long)x$31.getValue()))), this.driver().pluginDispatcher()), this.driver().pluginDispatcher()), (Function1 & Serializable)l -> Future$.MODULE$.successful((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)l)))));
    }

    @Override
    public Future<Object> maxSequenceNr(String pid, long from) {
        Future<Object> journal = this.driver().getJournal(pid);
        return journal.flatMap((Function1 & Serializable)x$32 -> org.mongodb.scala.package$.MODULE$.SingleObservableFuture((Function0 & Serializable)() -> x$32.find((Bson)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pid"), (Object)pid), (BsonTransformer)BsonTransformer$.MODULE$.TransformString())})), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonDocument.class)).projection((Bson)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)BoxesRunTime.boxToInteger((int)1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformInt())}))).sort((Bson)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonElement[]{BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pid"), (Object)BoxesRunTime.boxToInteger((int)1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformInt()), BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)BoxesRunTime.boxToInteger((int)-1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformInt())}))).first()).toFutureOption().map((Function1 & Serializable)d -> d.flatMap((Function1 & Serializable)a -> Option$.MODULE$.apply((Object)a.asDocument().get((Object)"to")).filter((Function1 & Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)x$33.isInt64())).map((Function1 & Serializable)x$34 -> x$34.asInt64()).map((Function1 & Serializable)x$35 -> BoxesRunTime.boxToLong((long)x$35.getValue()))), this.driver().pluginDispatcher()).flatMap((Function1 & Serializable)x$36 -> this.maxSequenceFromMetadata(pid, (Option<Object>)x$36), this.driver().pluginDispatcher()).map((Function1 & Serializable)x$37 -> BoxesRunTime.boxToLong((long)ScalaDriverPersistenceJournaller.$anonfun$maxSequenceNr$9(x$37)), this.driver().pluginDispatcher()), this.driver().pluginDispatcher());
    }

    @Override
    public Future<BoxedUnit> replayJournal(String pid, long from, long to, long max, Function1<PersistentRepr, BoxedUnit> replayCallback) {
        if (max == 0L) {
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }
        int maxInt = package$NonWrappingLongToInt$.MODULE$.toIntWithoutWrapping$extension(package$.MODULE$.NonWrappingLongToInt(max));
        return ((Future)((Source)this.journalRange(pid, from, to, maxInt).map((Function1 & Serializable)x$38 -> x$38.toRepr())).runWith((Graph)Sink$.MODULE$.foreach(replayCallback), this.driver().materializer())).map((Function1 & Serializable)x$39 -> {
            ScalaDriverPersistenceJournaller.$anonfun$replayJournal$2(x$39);
            return BoxedUnit.UNIT;
        }, this.driver().pluginDispatcher());
    }

    public static final /* synthetic */ boolean $anonfun$journalRange$7(long from$1, Event x$7) {
        return x$7.sn() >= from$1;
    }

    public static final /* synthetic */ boolean $anonfun$journalRange$8(long to$1, Event x$8) {
        return x$8.sn() <= to$1;
    }

    private final Future performAggregation$1(MongoCollection j, String persistenceId$2, long maxSequenceNr$2) {
        return org.mongodb.scala.package$.MODULE$.ObservableFuture((Function0 & Serializable)() -> {
            Bson bson = Aggregates$.MODULE$.match(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.equal("pid", (Object)persistenceId$2), Filters$.MODULE$.lte("to", (Object)BoxesRunTime.boxToLong((long)maxSequenceNr$2))})));
            Bson bson2 = Aggregates$.MODULE$.group((Object)"$pid", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BsonField[]{Accumulators$.MODULE$.max("max", (Object)"$to")}));
            return j.aggregate((Seq)Nil$.MODULE$.$colon$colon((Object)bson2).$colon$colon((Object)bson), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonDocument.class));
        }).toFuture().map((Function1 & Serializable)x$17 -> x$17.headOption(), this.driver().pluginDispatcher()).map((Function1 & Serializable)x$18 -> x$18.flatMap((Function1 & Serializable)l -> Option$.MODULE$.apply((Object)l.asDocument().get((Object)"max")).filter((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isInt64())).map((Function1 & Serializable)x$20 -> x$20.asInt64()).map((Function1 & Serializable)x$21 -> BoxesRunTime.boxToLong((long)x$21.getValue()))), this.driver().pluginDispatcher());
    }

    public static final /* synthetic */ void $anonfun$deleteFrom$12(ScalaDriverPersistenceJournaller $this, String persistenceId$3, BoxedUnit x$23) {
        $this.driver().removeJournalInCache(persistenceId$3);
    }

    public static final /* synthetic */ void $anonfun$deleteFrom$11(ScalaDriverPersistenceJournaller $this, DeleteResult removed$1, MongoCollection journal$1, String persistenceId$3, Object x$25) {
        Object object = x$25;
        Object object2 = $this.driver().useSuffixedCollectionNames() && $this.driver().suffixDropEmpty() && removed$1.wasAcknowledged() ? $this.driver().removeEmptyJournal(journal$1).map((Function1 & Serializable)x$23 -> {
            ScalaDriverPersistenceJournaller.$anonfun$deleteFrom$12($this, persistenceId$3, x$23);
            return BoxedUnit.UNIT;
        }, $this.driver().pluginDispatcher()) : BoxedUnit.UNIT;
    }

    public static final /* synthetic */ long $anonfun$maxSequenceNr$9(Option x$37) {
        return BoxesRunTime.unboxToLong((Object)x$37.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$replayJournal$2(Done x$39) {
    }

    public ScalaDriverPersistenceJournaller(ScalaMongoDriver driver) {
        this.driver = driver;
        MongoPersistenceJournallingApi.$init$(this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.writeConcern = driver.journalWriteConcern();
    }
}

