/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.api;

import com.github.sd4324530.fastweixin.api.config.ApiConfig;
import com.github.sd4324530.fastweixin.api.enums.ResultType;
import com.github.sd4324530.fastweixin.api.response.BaseResponse;
import com.github.sd4324530.fastweixin.util.BeanUtil;
import com.github.sd4324530.fastweixin.util.CollectionUtil;
import com.github.sd4324530.fastweixin.util.NetWorkCenter;
import java.io.File;
import java.util.ArrayList;

public abstract class BaseAPI {
    protected static final String BASE_API_URL = "https://api.weixin.qq.com/";
    protected final ApiConfig config;

    protected BaseAPI(ApiConfig config) {
        this.config = config;
    }

    protected BaseResponse executePost(String url, String json) {
        return this.executePost(url, json, null);
    }

    protected BaseResponse executePost(String url, String json, File file) {
        BeanUtil.requireNonNull(url, "url is null");
        ArrayList files = null;
        if (null != file) {
            files = CollectionUtil.newArrayList(file);
        }
        String postUrl = url.replace("#", this.config.getAccessToken());
        BaseResponse response = NetWorkCenter.post(postUrl, json, files);
        return response;
    }

    protected BaseResponse executeGet(String url) {
        BeanUtil.requireNonNull(url, "url is null");
        String getUrl = url.replace("#", this.config.getAccessToken());
        BaseResponse response = NetWorkCenter.get(getUrl);
        return response;
    }

    protected boolean isSuccess(String errCode) {
        return ResultType.SUCCESS.getCode().toString().equals(errCode);
    }
}

