/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.api;

import com.github.sd4324530.fastweixin.api.BaseAPI;
import com.github.sd4324530.fastweixin.api.config.ApiConfig;
import com.github.sd4324530.fastweixin.api.response.BaseResponse;
import com.github.sd4324530.fastweixin.api.response.GetArticleSummaryResponse;
import com.github.sd4324530.fastweixin.api.response.GetArticleTotalResponse;
import com.github.sd4324530.fastweixin.api.response.GetInterfaceSummaryHourResponse;
import com.github.sd4324530.fastweixin.api.response.GetInterfaceSummaryResponse;
import com.github.sd4324530.fastweixin.api.response.GetUpstreamMsgDistMonthResponse;
import com.github.sd4324530.fastweixin.api.response.GetUpstreamMsgDistResponse;
import com.github.sd4324530.fastweixin.api.response.GetUpstreamMsgDistWeekResponse;
import com.github.sd4324530.fastweixin.api.response.GetUpstreamMsgHourResponse;
import com.github.sd4324530.fastweixin.api.response.GetUpstreamMsgMonthResponse;
import com.github.sd4324530.fastweixin.api.response.GetUpstreamMsgResponse;
import com.github.sd4324530.fastweixin.api.response.GetUpstreamMsgWeekResponse;
import com.github.sd4324530.fastweixin.api.response.GetUserCumulateResponse;
import com.github.sd4324530.fastweixin.api.response.GetUserReadHourResponse;
import com.github.sd4324530.fastweixin.api.response.GetUserReadResponse;
import com.github.sd4324530.fastweixin.api.response.GetUserShareHourResponse;
import com.github.sd4324530.fastweixin.api.response.GetUserShareResponse;
import com.github.sd4324530.fastweixin.api.response.GetUserSummaryResponse;
import com.github.sd4324530.fastweixin.util.BeanUtil;
import com.github.sd4324530.fastweixin.util.JSONUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCubeAPI
extends BaseAPI {
    private static final Logger LOG = LoggerFactory.getLogger(DataCubeAPI.class);
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public DataCubeAPI(ApiConfig config) {
        super(config);
    }

    public GetUserSummaryResponse getUserSummary(Date beginDate, Date endDate) {
        BeanUtil.requireNonNull(beginDate, "beginDate is null");
        BeanUtil.requireNonNull(endDate, "endDate is null");
        GetUserSummaryResponse response = null;
        String url = "https://api.weixin.qq.com/datacube/getusersummary?access_token=#";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("begin_date", DATE_FORMAT.format(beginDate));
        param.put("end_date", DATE_FORMAT.format(endDate));
        String json = JSONUtil.toJson(param);
        BaseResponse r = this.executePost(url, json);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        response = JSONUtil.toBean(resultJson, GetUserSummaryResponse.class);
        return response;
    }

    public GetUserCumulateResponse getUserCumulate(Date beginDate, Date endDate) {
        BeanUtil.requireNonNull(beginDate, "beginDate is null");
        BeanUtil.requireNonNull(endDate, "endDate is null");
        GetUserCumulateResponse response = null;
        String url = "https://api.weixin.qq.com/datacube/getusercumulate?access_token=#";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("begin_date", DATE_FORMAT.format(beginDate));
        param.put("end_date", DATE_FORMAT.format(endDate));
        String json = JSONUtil.toJson(param);
        BaseResponse r = this.executePost(url, json);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        response = JSONUtil.toBean(resultJson, GetUserCumulateResponse.class);
        return response;
    }

    public GetArticleSummaryResponse getArticleSummary(Date day) {
        BeanUtil.requireNonNull(day, "day is null");
        GetArticleSummaryResponse response = null;
        String url = "https://api.weixin.qq.com/datacube/getarticlesummary?access_token=#";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("begin_date", DATE_FORMAT.format(day));
        param.put("end_date", DATE_FORMAT.format(day));
        String json = JSONUtil.toJson(param);
        BaseResponse r = this.executePost(url, json);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        response = JSONUtil.toBean(resultJson, GetArticleSummaryResponse.class);
        return response;
    }

    public GetArticleTotalResponse getArticleTotal(Date day) {
        BeanUtil.requireNonNull(day, "day is null");
        GetArticleTotalResponse response = null;
        String url = "https://api.weixin.qq.com/datacube/getarticletotal?access_token=#";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("begin_date", DATE_FORMAT.format(day));
        param.put("end_date", DATE_FORMAT.format(day));
        String json = JSONUtil.toJson(param);
        BaseResponse r = this.executePost(url, json);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        response = JSONUtil.toBean(resultJson, GetArticleTotalResponse.class);
        return response;
    }

    public GetUserReadResponse getUserRead(Date beginDate, Date endDate) {
        BeanUtil.requireNonNull(beginDate, "beginDate is null");
        BeanUtil.requireNonNull(endDate, "endDate is null");
        GetUserReadResponse response = null;
        String url = "https://api.weixin.qq.com/datacube/getuserread?access_token=#";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("begin_date", DATE_FORMAT.format(beginDate));
        param.put("end_date", DATE_FORMAT.format(endDate));
        String json = JSONUtil.toJson(param);
        BaseResponse r = this.executePost(url, json);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        response = JSONUtil.toBean(resultJson, GetUserReadResponse.class);
        return response;
    }

    public GetUserReadHourResponse getUserReadHour(Date day) {
        BeanUtil.requireNonNull(day, "day is null");
        GetUserReadHourResponse response = null;
        String url = "https://api.weixin.qq.com/datacube/getuserreadhour?access_token=#";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("begin_date", DATE_FORMAT.format(day));
        param.put("end_date", DATE_FORMAT.format(day));
        String json = JSONUtil.toJson(param);
        BaseResponse r = this.executePost(url, json);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        response = JSONUtil.toBean(resultJson, GetUserReadHourResponse.class);
        return response;
    }

    public GetUserShareResponse getUserShare(Date beginDate, Date endDate) {
        BeanUtil.requireNonNull(beginDate, "beginDate is null");
        BeanUtil.requireNonNull(endDate, "endDate is null");
        GetUserShareResponse response = null;
        String url = "https://api.weixin.qq.com/datacube/getusershare?access_token=#";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("begin_date", DATE_FORMAT.format(beginDate));
        param.put("end_date", DATE_FORMAT.format(endDate));
        String json = JSONUtil.toJson(param);
        BaseResponse r = this.executePost(url, json);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        response = JSONUtil.toBean(resultJson, GetUserShareResponse.class);
        return response;
    }

    public GetUserShareHourResponse getUserShareHour(Date day) {
        BeanUtil.requireNonNull(day, "day is null");
        GetUserShareHourResponse response = null;
        String url = "https://api.weixin.qq.com/datacube/getusersharehour?access_token=#";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("begin_date", DATE_FORMAT.format(day));
        param.put("end_date", DATE_FORMAT.format(day));
        String json = JSONUtil.toJson(param);
        BaseResponse r = this.executePost(url, json);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        response = JSONUtil.toBean(resultJson, GetUserShareHourResponse.class);
        return response;
    }

    public GetUpstreamMsgResponse getUpstreamMsg(Date beginDate, Date endDate) {
        BeanUtil.requireNonNull(beginDate, "beginDate is null");
        BeanUtil.requireNonNull(endDate, "endDate is null");
        GetUpstreamMsgResponse response = null;
        String url = "https://api.weixin.qq.com/datacube/getupstreammsg?access_token=#";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("begin_date", DATE_FORMAT.format(beginDate));
        param.put("end_date", DATE_FORMAT.format(endDate));
        String json = JSONUtil.toJson(param);
        BaseResponse r = this.executePost(url, json);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        response = JSONUtil.toBean(resultJson, GetUpstreamMsgResponse.class);
        return response;
    }

    public GetUpstreamMsgHourResponse getUpstreamMsgHour(Date day) {
        BeanUtil.requireNonNull(day, "day is null");
        GetUpstreamMsgHourResponse response = null;
        String url = "https://api.weixin.qq.com/datacube/getupstreammsghour?access_token=#";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("begin_date", DATE_FORMAT.format(day));
        param.put("end_date", DATE_FORMAT.format(day));
        String json = JSONUtil.toJson(param);
        BaseResponse r = this.executePost(url, json);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        response = JSONUtil.toBean(resultJson, GetUpstreamMsgHourResponse.class);
        return response;
    }

    public GetUpstreamMsgWeekResponse getUpstreamMsgWeek(Date beginDate, Date endDate) {
        BeanUtil.requireNonNull(beginDate, "beginDate is null");
        BeanUtil.requireNonNull(endDate, "endDate is null");
        GetUpstreamMsgWeekResponse response = null;
        String url = "https://api.weixin.qq.com/datacube/getupstreammsgweek?access_token=#";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("begin_date", DATE_FORMAT.format(beginDate));
        param.put("end_date", DATE_FORMAT.format(endDate));
        String json = JSONUtil.toJson(param);
        BaseResponse r = this.executePost(url, json);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        response = JSONUtil.toBean(resultJson, GetUpstreamMsgWeekResponse.class);
        return response;
    }

    public GetUpstreamMsgMonthResponse getUpstreamMsgMonth(Date beginDate, Date endDate) {
        BeanUtil.requireNonNull(beginDate, "beginDate is null");
        BeanUtil.requireNonNull(endDate, "endDate is null");
        GetUpstreamMsgMonthResponse response = null;
        String url = "https://api.weixin.qq.com/datacube/getupstreammsgmonth?access_token=#";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("begin_date", DATE_FORMAT.format(beginDate));
        param.put("end_date", DATE_FORMAT.format(endDate));
        String json = JSONUtil.toJson(param);
        BaseResponse r = this.executePost(url, json);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        response = JSONUtil.toBean(resultJson, GetUpstreamMsgMonthResponse.class);
        return response;
    }

    public GetUpstreamMsgDistResponse getUpstreamMsgDist(Date beginDate, Date endDate) {
        BeanUtil.requireNonNull(beginDate, "beginDate is null");
        BeanUtil.requireNonNull(endDate, "endDate is null");
        GetUpstreamMsgDistResponse response = null;
        String url = "https://api.weixin.qq.com/datacube/getupstreammsgdist?access_token=#";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("begin_date", DATE_FORMAT.format(beginDate));
        param.put("end_date", DATE_FORMAT.format(endDate));
        String json = JSONUtil.toJson(param);
        BaseResponse r = this.executePost(url, json);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        response = JSONUtil.toBean(resultJson, GetUpstreamMsgDistResponse.class);
        return response;
    }

    public GetUpstreamMsgDistWeekResponse getUpstreamMsgDistWeek(Date beginDate, Date endDate) {
        BeanUtil.requireNonNull(beginDate, "beginDate is null");
        BeanUtil.requireNonNull(endDate, "endDate is null");
        GetUpstreamMsgDistWeekResponse response = null;
        String url = "https://api.weixin.qq.com/datacube/getupstreammsgdistweek?access_token=#";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("begin_date", DATE_FORMAT.format(beginDate));
        param.put("end_date", DATE_FORMAT.format(endDate));
        String json = JSONUtil.toJson(param);
        BaseResponse r = this.executePost(url, json);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        response = JSONUtil.toBean(resultJson, GetUpstreamMsgDistWeekResponse.class);
        return response;
    }

    public GetUpstreamMsgDistMonthResponse getUpstreamMsgDistMonth(Date beginDate, Date endDate) {
        BeanUtil.requireNonNull(beginDate, "beginDate is null");
        BeanUtil.requireNonNull(endDate, "endDate is null");
        GetUpstreamMsgDistMonthResponse response = null;
        String url = "https://api.weixin.qq.com/datacube/getupstreammsgdistmonth?access_token=#";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("begin_date", DATE_FORMAT.format(beginDate));
        param.put("end_date", DATE_FORMAT.format(endDate));
        String json = JSONUtil.toJson(param);
        BaseResponse r = this.executePost(url, json);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        response = JSONUtil.toBean(resultJson, GetUpstreamMsgDistMonthResponse.class);
        return response;
    }

    public GetInterfaceSummaryResponse getInterfaceSummary(Date beginDate, Date endDate) {
        BeanUtil.requireNonNull(beginDate, "beginDate is null");
        BeanUtil.requireNonNull(endDate, "endDate is null");
        GetInterfaceSummaryResponse response = null;
        String url = "https://api.weixin.qq.com/datacube/getinterfacesummary?access_token=#";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("begin_date", DATE_FORMAT.format(beginDate));
        param.put("end_date", DATE_FORMAT.format(endDate));
        String json = JSONUtil.toJson(param);
        BaseResponse r = this.executePost(url, json);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        response = JSONUtil.toBean(resultJson, GetInterfaceSummaryResponse.class);
        return response;
    }

    public GetInterfaceSummaryHourResponse getInterfaceSummaryHour(Date day) {
        BeanUtil.requireNonNull(day, "day is null");
        GetInterfaceSummaryHourResponse response = null;
        String url = "https://api.weixin.qq.com/datacube/getinterfacesummaryhour?access_token=#";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("begin_date", DATE_FORMAT.format(day));
        param.put("end_date", DATE_FORMAT.format(day));
        String json = JSONUtil.toJson(param);
        BaseResponse r = this.executePost(url, json);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        response = JSONUtil.toBean(resultJson, GetInterfaceSummaryHourResponse.class);
        return response;
    }
}

