/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.github.sd4324530.fastweixin.api.BaseAPI;
import com.github.sd4324530.fastweixin.api.config.ApiConfig;
import com.github.sd4324530.fastweixin.api.response.BaseResponse;
import com.github.sd4324530.fastweixin.util.CollectionUtil;
import com.github.sd4324530.fastweixin.util.JSONUtil;
import com.github.sd4324530.fastweixin.util.StrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemAPI
extends BaseAPI {
    private static final Logger LOG = LoggerFactory.getLogger(SystemAPI.class);

    public SystemAPI(ApiConfig config) {
        super(config);
    }

    public List<String> getCallbackIP() {
        LOG.debug("\u83b7\u53d6\u5fae\u4fe1\u670d\u52a1\u5668IP\u5730\u5740......");
        ArrayList result = null;
        String url = "https://api.weixin.qq.com/cgi-bin/getcallbackip?access_token=#";
        BaseResponse r = this.executeGet(url);
        if (this.isSuccess(r.getErrcode())) {
            JSONArray array = JSON.parseObject((String)r.getErrmsg()).getJSONArray("ip_list");
            result = CollectionUtil.newArrayList(array.size());
            for (Object obj : array) {
                result.add(obj.toString());
            }
        }
        return result;
    }

    public String getShortUrl(String longUrl) {
        String result = "";
        LOG.debug("\u83b7\u53d6\u77edURL.......");
        if (this.checkUrl(longUrl)) {
            String url = "https://api.weixin.qq.com/cgi-bin/shorturl?access_token=#";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("action", "long2short");
            params.put("long_url", longUrl);
            BaseResponse r = this.executePost(url, JSONUtil.toJson(params));
            if (this.isSuccess(r.getErrcode())) {
                result = JSONUtil.toMap(r.getErrmsg()).get("short_url").toString();
            }
        }
        return result;
    }

    private boolean checkUrl(String url) {
        return StrUtil.isNotBlank(url) && (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("weixin://wxpay"));
    }
}

