/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.company.api;

import com.github.sd4324530.fastweixin.api.response.BaseResponse;
import com.github.sd4324530.fastweixin.company.api.QYBaseAPI;
import com.github.sd4324530.fastweixin.company.api.config.QYAPIConfig;
import com.github.sd4324530.fastweixin.company.api.entity.QYAgent;
import com.github.sd4324530.fastweixin.company.api.enums.QYResultType;
import com.github.sd4324530.fastweixin.company.api.response.GetQYAgentInfoResponse;
import com.github.sd4324530.fastweixin.company.api.response.GetQYAgentListResponse;
import com.github.sd4324530.fastweixin.util.BeanUtil;
import com.github.sd4324530.fastweixin.util.JSONUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QYAgentAPI
extends QYBaseAPI {
    private static final Logger LOG = LoggerFactory.getLogger(QYAgentAPI.class);

    public QYAgentAPI(QYAPIConfig config) {
        super(config);
    }

    public GetQYAgentListResponse getAll() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/agent/list?access_token=#";
        BaseResponse r = this.executeGet(url);
        String jsonResult = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        GetQYAgentListResponse response = JSONUtil.toBean(jsonResult, GetQYAgentListResponse.class);
        return response;
    }

    public GetQYAgentInfoResponse getInfo(String agentId) {
        BeanUtil.requireNonNull(agentId, "agentId is null");
        String url = "https://qyapi.weixin.qq.com/cgi-bin/agent/get?access_token=#&agentid=" + agentId;
        BaseResponse r = this.executeGet(url);
        String jsonResult = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        GetQYAgentInfoResponse response = JSONUtil.toBean(jsonResult, GetQYAgentInfoResponse.class);
        return response;
    }

    @Deprecated
    public QYResultType create(QYAgent agent, String mediaId) {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/agent/set?access_token=#";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("agentid", agent.getAgentId());
        params.put("report_location_flag", String.valueOf(agent.getReportLocationFlag()));
        params.put("logo_mediaid", mediaId);
        params.put("name", agent.getName());
        params.put("description", agent.getDescription());
        params.put("redirect_domain", agent.getRedirectDomain());
        params.put("isreportuser", agent.getIsReportUser());
        params.put("isreportenter", agent.getIsReportEnter());
        BaseResponse response = this.executePost(url, JSONUtil.toJson(params));
        return QYResultType.get(response.getErrcode());
    }

    public QYResultType update(Map<String, Object> params) {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/agent/set?access_token=#";
        BaseResponse response = this.executePost(url, JSONUtil.toJson(params));
        return QYResultType.get(response.getErrcode());
    }
}

