/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.message;

import com.github.sd4324530.fastweixin.message.Article;
import com.github.sd4324530.fastweixin.message.BaseMsg;
import com.github.sd4324530.fastweixin.message.util.MessageBuilder;
import java.util.ArrayList;
import java.util.List;

public class NewsMsg
extends BaseMsg {
    private static final int WX_MAX_SIZE = 10;
    private int maxSize = 10;
    private List<Article> articles;

    public NewsMsg() {
        this.articles = new ArrayList<Article>(this.maxSize);
    }

    public NewsMsg(int maxSize) {
        this.setMaxSize(maxSize);
        this.articles = new ArrayList<Article>(maxSize);
    }

    public NewsMsg(List<Article> articles) {
        this.setArticles(articles);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        if (maxSize < 10 && maxSize >= 1) {
            this.maxSize = maxSize;
        }
        if (this.articles != null && this.articles.size() > this.maxSize) {
            this.articles = this.articles.subList(0, this.maxSize);
        }
    }

    public List<Article> getArticles() {
        return this.articles;
    }

    public void setArticles(List<Article> articles) {
        this.articles = articles.size() > this.maxSize ? articles.subList(0, this.maxSize) : articles;
    }

    public void add(String title) {
        this.add(title, null, null, null);
    }

    public void add(String title, String url) {
        this.add(title, null, null, url);
    }

    public void add(String title, String picUrl, String url) {
        this.add(new Article(title, null, picUrl, url));
    }

    public void add(String title, String description, String picUrl, String url) {
        this.add(new Article(title, description, picUrl, url));
    }

    public void add(Article article) {
        if (this.articles.size() < this.maxSize) {
            this.articles.add(article);
        }
    }

    @Override
    public String toXml() {
        MessageBuilder mb = new MessageBuilder(super.toXml());
        mb.addData("MsgType", "news");
        mb.addTag("ArticleCount", String.valueOf(this.articles.size()));
        mb.append("<Articles>\n");
        for (Article article : this.articles) {
            mb.append(article.toXml());
        }
        mb.append("</Articles>\n");
        mb.surroundWith("xml");
        return mb.toString();
    }
}

