/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.message;

import com.github.sd4324530.fastweixin.message.BaseMsg;
import com.github.sd4324530.fastweixin.message.util.MessageBuilder;

public final class TextMsg
extends BaseMsg {
    private StringBuilder contentBuilder;

    public TextMsg() {
        this.contentBuilder = new StringBuilder();
    }

    public TextMsg(String content) {
        this.setContent(content);
    }

    public String getContent() {
        return this.contentBuilder.toString();
    }

    public void setContent(String content) {
        this.contentBuilder = new StringBuilder(content);
    }

    public TextMsg add(String text) {
        this.contentBuilder.append(text);
        return this;
    }

    public TextMsg addln() {
        return this.add("\n");
    }

    public TextMsg addln(String text) {
        this.contentBuilder.append(text);
        return this.addln();
    }

    public TextMsg addLink(String text, String url) {
        this.contentBuilder.append("<a href=\"").append(url).append("\">").append(text).append("</a>");
        return this;
    }

    @Override
    public String toXml() {
        MessageBuilder mb = new MessageBuilder(super.toXml());
        mb.addData("Content", this.contentBuilder.toString().trim());
        mb.addData("MsgType", "text");
        mb.surroundWith("xml");
        return mb.toString();
    }
}

