/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.github.sd4324530.fastweixin.util.BeanUtil;
import com.github.sd4324530.fastweixin.util.StrUtil;
import java.util.Map;

public final class JSONUtil {
    public static final SerializerFeature[] DEFAULT_FORMAT = new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteEnumUsingToString, SerializerFeature.WriteNonStringKeyAsString, SerializerFeature.QuoteFieldNames, SerializerFeature.SkipTransientField, SerializerFeature.SortField, SerializerFeature.PrettyFormat};

    private JSONUtil() {
    }

    public static Object getStringFromJSONObject(String json, String key) {
        BeanUtil.requireNonNull(json, "json is null");
        return JSON.parseObject((String)json).getString(key);
    }

    public static JSONObject getJSONFromString(String jsonString) {
        if (StrUtil.isBlank(jsonString)) {
            return new JSONObject();
        }
        return JSON.parseObject((String)jsonString);
    }

    public static <T> T toBean(String jsonStr, Class<T> beanClass) {
        BeanUtil.requireNonNull(jsonStr, "jsonStr is null");
        JSONObject jo = JSON.parseObject((String)jsonStr);
        jo.put(JSON.DEFAULT_TYPE_KEY, (Object)beanClass.getName());
        return (T)JSON.parseObject((String)jo.toJSONString(), beanClass);
    }

    public static <T> String toJson(T obj) {
        BeanUtil.requireNonNull(obj, "obj is null");
        return JSON.toJSONString(obj, (SerializerFeature[])DEFAULT_FORMAT);
    }

    public static String toJson(Map<String, Object> map) {
        BeanUtil.requireNonNull(map, "map is null");
        return JSON.toJSONString(map, (SerializerFeature[])DEFAULT_FORMAT);
    }

    public static String prettyFormatJson(String jsonString) {
        BeanUtil.requireNonNull(jsonString, "jsonString is null");
        return JSON.toJSONString((Object)JSONUtil.getJSONFromString(jsonString), (boolean)true);
    }

    public static Map<String, Object> toMap(String jsonString) {
        BeanUtil.requireNonNull(jsonString, "jsonString is null");
        return JSONUtil.getJSONFromString(jsonString);
    }
}

