/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdorra.ssp;

import com.github.sdorra.ssp.PermissionActionCheckInterceptor;
import com.github.sdorra.ssp.PermissionGuard;
import com.github.sdorra.ssp.PermissionObject;
import java.util.function.BooleanSupplier;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.subject.Subject;

public class Repository
implements PermissionObject {
    private final String id;

    public Repository(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public static class DeleteGuard
    implements PermissionGuard<Repository> {
        public PermissionActionCheckInterceptor<Repository> intercept(String permission) {
            return new PermissionActionCheckInterceptor<Repository>(){

                public void check(Subject subject, String id, Runnable delegate) {
                    if (id.equals("mustNotBeDeleted")) {
                        throw new AuthorizationException("this repository must not be deleted");
                    }
                    delegate.run();
                }

                public boolean isPermitted(Subject subject, String id, BooleanSupplier delegate) {
                    return !id.equals("mustNotBeDeleted") && delegate.getAsBoolean();
                }
            };
        }
    }
}

