/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdorra.ssp;

import com.github.sdorra.ssp.PassThroughPermissionGuard;
import com.github.sdorra.ssp.PermissionActionCheck;
import com.github.sdorra.ssp.PermissionActionCheckInterceptor;
import com.github.sdorra.ssp.PermissionCheck;
import com.github.sdorra.ssp.PermissionCheckInterceptorWrapper;
import com.github.sdorra.ssp.PermissionGuard;
import com.github.sdorra.ssp.PermissionObject;
import com.github.sdorra.ssp.Repository;

public final class RepositoryPermissions {
    private static final String TYPE = "repositories";
    public static final String ACTION_CREATE = "create";
    public static final String ACTION_READ = "read";
    public static final String ACTION_MODIFY = "modify";
    public static final String ACTION_DELETE = "delete";
    private static final PermissionGuard<Repository> MODIFY_GUARD = new PassThroughPermissionGuard();
    private static final PermissionGuard<Repository> READ_GUARD = new PassThroughPermissionGuard();
    private static final PermissionGuard<Repository> __CUSTOM_GUARD = new PassThroughPermissionGuard();
    private static final PermissionGuard<Repository> CREATE_GUARD = new PassThroughPermissionGuard();
    private static final PermissionGuard<Repository> DELETE_GUARD = new Repository.DeleteGuard();

    private RepositoryPermissions() {
    }

    public static PermissionCheck create() {
        return RepositoryPermissions.check(ACTION_CREATE, RepositoryPermissions.createPermissionCheckWrapper(ACTION_CREATE, CREATE_GUARD));
    }

    public static PermissionCheck read(String id) {
        return RepositoryPermissions.check(ACTION_READ.concat(":").concat(id), RepositoryPermissions.createPermissionCheckWrapper(ACTION_READ, id, READ_GUARD));
    }

    public static PermissionCheck read(Repository item) {
        return RepositoryPermissions.check(ACTION_READ.concat(":").concat(item.getId()), RepositoryPermissions.createPermissionCheckWrapper(ACTION_READ, item, READ_GUARD));
    }

    public static PermissionActionCheck<Repository> read() {
        return RepositoryPermissions.actionCheck(ACTION_READ, READ_GUARD);
    }

    public static PermissionCheck modify(String id) {
        return RepositoryPermissions.check(ACTION_MODIFY.concat(":").concat(id), RepositoryPermissions.createPermissionCheckWrapper(ACTION_MODIFY, id, MODIFY_GUARD));
    }

    public static PermissionCheck modify(Repository item) {
        return RepositoryPermissions.check(ACTION_MODIFY.concat(":").concat(item.getId()), RepositoryPermissions.createPermissionCheckWrapper(ACTION_MODIFY, item, MODIFY_GUARD));
    }

    public static PermissionActionCheck<Repository> modify() {
        return RepositoryPermissions.actionCheck(ACTION_MODIFY, MODIFY_GUARD);
    }

    public static PermissionCheck delete(String id) {
        return RepositoryPermissions.check(ACTION_DELETE.concat(":").concat(id), RepositoryPermissions.createPermissionCheckWrapper(ACTION_DELETE, id, DELETE_GUARD));
    }

    public static PermissionCheck delete(Repository item) {
        return RepositoryPermissions.check(ACTION_DELETE.concat(":").concat(item.getId()), RepositoryPermissions.createPermissionCheckWrapper(ACTION_DELETE, item, DELETE_GUARD));
    }

    public static PermissionActionCheck<Repository> delete() {
        return RepositoryPermissions.actionCheck(ACTION_DELETE, DELETE_GUARD);
    }

    public static PermissionCheck custom(String customAction) {
        return RepositoryPermissions.check(customAction, RepositoryPermissions.createPermissionCheckWrapper(customAction, __CUSTOM_GUARD));
    }

    public static PermissionCheck custom(String customAction, String id) {
        return RepositoryPermissions.check(customAction.concat(":").concat(id), RepositoryPermissions.createPermissionCheckWrapper(customAction, id, __CUSTOM_GUARD));
    }

    public static PermissionCheck custom(String customAction, Repository item) {
        return RepositoryPermissions.check(customAction.concat(":").concat(item.getId()), RepositoryPermissions.createPermissionCheckWrapper(customAction, item, __CUSTOM_GUARD));
    }

    public static PermissionActionCheck<Repository> customActionCheck(String customAction) {
        return RepositoryPermissions.actionCheck(customAction, __CUSTOM_GUARD);
    }

    private static PermissionCheckInterceptorWrapper createPermissionCheckWrapper(String customAction, PermissionGuard<Repository> guard) {
        PermissionActionCheckInterceptor interceptor = guard.intercept(customAction);
        PermissionCheckInterceptorWrapper wrapper = PermissionCheckInterceptorWrapper.forRaw((PermissionActionCheckInterceptor)interceptor);
        return wrapper;
    }

    private static PermissionCheckInterceptorWrapper createPermissionCheckWrapper(String customAction, String id, PermissionGuard<Repository> guard) {
        PermissionActionCheckInterceptor interceptor = guard.intercept(customAction);
        PermissionCheckInterceptorWrapper wrapper = PermissionCheckInterceptorWrapper.forId((String)id, (PermissionActionCheckInterceptor)interceptor);
        return wrapper;
    }

    private static PermissionCheckInterceptorWrapper createPermissionCheckWrapper(String customAction, Repository item, PermissionGuard<Repository> guard) {
        PermissionActionCheckInterceptor interceptor = guard.intercept(customAction);
        PermissionCheckInterceptorWrapper wrapper = PermissionCheckInterceptorWrapper.forItem((PermissionObject)item, (PermissionActionCheckInterceptor)interceptor);
        return wrapper;
    }

    private static PermissionActionCheck<Repository> actionCheck(String action, PermissionGuard<Repository> guard) {
        PermissionActionCheckInterceptor interceptor = guard.intercept(action);
        return new PermissionActionCheck(TYPE.concat(":").concat(action), interceptor);
    }

    private static PermissionCheck check(String permission, PermissionCheckInterceptorWrapper wrapper) {
        return new PermissionCheck(TYPE.concat(":").concat(permission), wrapper);
    }
}

