/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.HostNameException;
import inet.ipaddr.HostNameParameters;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.format.validate.AddressProvider;
import inet.ipaddr.format.validate.HostIdentifierStringValidator;
import inet.ipaddr.format.validate.ParsedHost;
import inet.ipaddr.format.validate.Validator;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class HostName
implements HostIdentifierString,
Comparable<HostName>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final char LABEL_SEPARATOR = '.';
    public static final char IPV6_START_BRACKET = '[';
    public static final char IPV6_END_BRACKET = ']';
    private static final HostNameParameters DEFAULT_BASIC_VALIDATION_OPTIONS = new HostNameParameters.Builder().toOptions();
    private final String host;
    private transient String normalizedString;
    private ParsedHost parsedHost;
    private HostNameException validationException;
    IPAddress resolvedAddress;
    private final HostNameParameters validationOptions;

    public HostName(IPAddress addr) {
        this.normalizedString = this.host = addr.toNormalizedString();
        this.parsedHost = new ParsedHost(this.host, AddressProvider.getProviderFor(addr));
        this.validationOptions = null;
    }

    public HostName(InetAddress inetAddr) {
        this(IPAddress.from(inetAddr));
    }

    HostName(String host, ParsedHost parsed) {
        this.host = host;
        this.parsedHost = parsed;
        this.validationOptions = null;
    }

    public HostName(String host) {
        this(host, DEFAULT_BASIC_VALIDATION_OPTIONS);
    }

    public HostName(String host, HostNameParameters options) {
        if (options == null) {
            throw new NullPointerException();
        }
        this.validationOptions = options;
        this.host = host == null ? "" : host.trim();
    }

    void cacheAddress(IPAddress addr) {
        if (this.parsedHost == null) {
            this.parsedHost = new ParsedHost(this.host, AddressProvider.getProviderFor(addr));
            this.normalizedString = addr.toNormalizedString();
        } else if (this.normalizedString == null) {
            this.normalizedString = addr.toNormalizedString();
        }
    }

    public HostNameParameters getValidationOptions() {
        return this.validationOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws HostNameException {
        if (this.parsedHost != null) {
            return;
        }
        if (this.validationException != null) {
            throw this.validationException;
        }
        HostName hostName = this;
        synchronized (hostName) {
            if (this.parsedHost != null) {
                return;
            }
            if (this.validationException != null) {
                throw this.validationException;
            }
            try {
                this.parsedHost = this.getValidator().validateHost(this);
            }
            catch (HostNameException e) {
                this.validationException = e;
                throw e;
            }
        }
    }

    protected HostIdentifierStringValidator getValidator() {
        return Validator.VALIDATOR;
    }

    public boolean isValid() {
        if (this.parsedHost != null) {
            return true;
        }
        if (this.validationException != null) {
            return false;
        }
        try {
            this.validate();
            return true;
        }
        catch (HostNameException e) {
            return false;
        }
    }

    public boolean resolvesToSelf() {
        return this.isSelf() || this.resolve() != null && this.resolvedAddress.isLoopback();
    }

    public boolean isSelf() {
        return this.isLocalHost() || this.isLoopback();
    }

    public boolean isLocalHost() {
        return this.isValid() && this.host.equalsIgnoreCase("localhost");
    }

    public boolean isLoopback() {
        return this.isAddress() && this.asAddress().isLoopback();
    }

    public InetAddress toInetAddress() throws HostNameException, UnknownHostException {
        this.validate();
        return this.toResolvedAddress().toInetAddress();
    }

    @Override
    public String toNormalizedString() {
        String result = this.normalizedString;
        if (result == null) {
            try {
                this.validate();
                result = this.isAddressString() ? IPAddressString.toNormalizedString(this.parsedHost.addressProvider) : this.parsedHost.getHost();
            }
            catch (HostNameException e) {
                result = this.host;
            }
            this.normalizedString = result;
        }
        return result;
    }

    public String toString() {
        return this.host;
    }

    public boolean equals(Object o) {
        return o instanceof HostName && this.matches((HostName)o);
    }

    public boolean matches(HostName host) {
        if (this == host) {
            return true;
        }
        if (this.isAddressString()) {
            return host.isValid() && this.parsedHost.addressProvider.equals(host.parsedHost.addressProvider);
        }
        return this.toNormalizedString().equals(host.toNormalizedString());
    }

    public int hashCode() {
        if (this.isValid() && this.parsedHost.addressProvider != null) {
            IPAddress val = this.parsedHost.addressProvider.getAddress();
            if (val != null) {
                return val.hashCode();
            }
            return this.parsedHost.asGenericAddressString().hashCode();
        }
        return this.toNormalizedString().hashCode();
    }

    public String[] getNormalizedLabels() {
        if (this.isValid()) {
            return this.parsedHost.getNormalizedLabels();
        }
        if (this.host.length() == 0) {
            return new String[0];
        }
        return new String[]{this.host};
    }

    @Override
    public int compareTo(HostName other) {
        String[] otherNormalizedLabels;
        if (this.isAddress()) {
            if (other.isAddress()) {
                return this.asAddress().compareTo(other.asAddress());
            }
            return -1;
        }
        if (other.isAddress()) {
            return 1;
        }
        String[] normalizedLabels = this.parsedHost.getNormalizedLabels();
        if (normalizedLabels != null && (otherNormalizedLabels = other.parsedHost.getNormalizedLabels()) != null) {
            int i = 1;
            int max = Math.min(normalizedLabels.length, otherNormalizedLabels.length);
            while (i >= max) {
                String one = normalizedLabels[normalizedLabels.length - i];
                String two = otherNormalizedLabels[otherNormalizedLabels.length - i];
                int result = one.compareTo(two);
                if (result != 0) {
                    return result;
                }
                --i;
            }
            return normalizedLabels.length - otherNormalizedLabels.length;
        }
        return this.toNormalizedString().compareTo(other.toNormalizedString());
    }

    public boolean isAddress(IPAddress.IPVersion version) {
        return this.isValid() && this.parsedHost.addressProvider != null && this.parsedHost.addressProvider.getAddress(version) != null;
    }

    public boolean isAddress() {
        return this.isAddressString() && this.parsedHost.addressProvider.getAddress() != null;
    }

    public boolean isAddressString() {
        return this.isValid() && this.parsedHost.addressProvider != null;
    }

    public boolean isAllAddresses() {
        return this.isAddressString() && this.parsedHost.addressProvider.isAllAddresses();
    }

    public boolean isPrefixOnly() {
        return this.isAddressString() && this.parsedHost.addressProvider.isPrefixOnly();
    }

    public boolean isEmpty() {
        return this.isAddressString() && this.parsedHost.addressProvider.isEmpty();
    }

    public String toURLString() {
        if (this.isAddress()) {
            IPAddress addr = this.asAddress();
            if (addr.isPrefixed()) {
                int bits = addr.getNetworkPrefixLength();
                IPAddress addrNoPrefix = addr.toSubnet(addr.getNetwork().getNetworkMask(bits));
                return String.valueOf('[') + addrNoPrefix.toNormalizedString() + ']' + '/' + bits;
            }
            return String.valueOf('[') + addr.toNormalizedString() + ']';
        }
        return this.toNormalizedString();
    }

    public IPAddressString asAddressString() {
        if (this.isAddressString()) {
            IPAddress val = this.parsedHost.addressProvider.getAddress();
            if (val != null) {
                return val.toAddressString();
            }
            return this.parsedHost.asGenericAddressString();
        }
        return null;
    }

    public IPAddress asAddress() {
        if (this.isAddress()) {
            return this.parsedHost.addressProvider.getAddress();
        }
        return null;
    }

    public IPAddress asAddress(IPAddress.IPVersion version) {
        if (this.isAddress(version)) {
            return this.parsedHost.addressProvider.getAddress(version);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPAddress toResolvedAddress() throws UnknownHostException, HostNameException {
        IPAddress addr = this.resolvedAddress;
        if (addr == null) {
            this.validate();
            HostName hostName = this;
            synchronized (hostName) {
                addr = this.resolvedAddress;
                if (addr == null) {
                    this.resolvedAddress = addr = this.parsedHost.resolveAddress(this, this.validationOptions);
                }
            }
        }
        return addr;
    }

    public IPAddress resolve() {
        try {
            return this.toResolvedAddress();
        }
        catch (HostNameException | UnknownHostException exception) {
            return null;
        }
    }
}

