/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.HostName;
import inet.ipaddr.IPAddressComparator;
import inet.ipaddr.IPAddressConverter;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.IPAddressTypeException;
import inet.ipaddr.IPAddressTypeNetwork;
import inet.ipaddr.format.IPAddressPart;
import inet.ipaddr.format.util.IPAddressPartStringCollection;
import inet.ipaddr.format.util.sql.IPAddressSQLTranslator;
import inet.ipaddr.format.validate.AddressProvider;
import inet.ipaddr.format.validate.ParsedHost;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv4.IPv4AddressSegment;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import inet.ipaddr.ipv6.IPv6AddressSegment;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.IntFunction;
import java.util.function.Supplier;

public abstract class IPAddress
implements Comparable<IPAddress>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final char RANGE_SEPARATOR = '-';
    public static final String RANGE_SEPARATOR_STR = String.valueOf('-');
    public static final char SEGMENT_WILDCARD = '*';
    public static final String SEGMENT_WILDCARD_STR = String.valueOf('*');
    public static final char SEGMENT_SQL_WILDCARD = '%';
    public static final String SEGMENT_SQL_WILDCARD_STR = String.valueOf('%');
    public static final char SEGMENT_SQL_SINGLE_WILDCARD = '_';
    public static final String SEGMENT_SQL_SINGLE_WILDCARD_STR = String.valueOf('_');
    public static final char PREFIX_LEN_SEPARATOR = '/';
    public static final IPAddressConverter addressConverter = new IPAddressConverter.DefaultAddressConverter();
    public static final IPAddressComparator addressComparator = new IPAddressComparator.CountComparator();
    final IPAddressSection addressSection;
    protected IPAddressString fromString;
    HostName fromHost;
    private HostName canonicalHost;
    protected transient InetAddress inetAddress;

    protected IPAddress(IPAddressSection section) {
        this.addressSection = section;
    }

    public HostName toHostName() {
        HostName host = this.fromHost;
        if (host == null) {
            this.fromHost = host = this.toCanonicalHostName();
        }
        return host;
    }

    public HostName toCanonicalHostName() {
        HostName host = this.canonicalHost;
        if (host == null) {
            if (this.isMultiple()) {
                throw new IPAddressTypeException(this, "ipaddress.error.unavailable.numeric");
            }
            InetAddress inetAddress = this.toInetAddress();
            String hostStr = inetAddress.getCanonicalHostName();
            if (hostStr.equals(inetAddress.getHostAddress())) {
                host = new HostName(hostStr, new ParsedHost(hostStr, AddressProvider.getProviderFor(this)));
                host.resolvedAddress = this;
            } else {
                host = new HostName(hostStr);
            }
        }
        return host;
    }

    public static IPAddress from(byte[] bytes) {
        return IPAddress.from(bytes, null, null, null);
    }

    public static IPAddress from(byte[] bytes, Integer prefixLength) {
        return IPAddress.from(bytes, null, prefixLength, null);
    }

    public static IPAddress from(byte[] bytes, byte[] bytes2, Integer prefixLength) {
        return IPAddress.from(bytes, bytes2, prefixLength, null);
    }

    protected static IPAddress from(byte[] bytes, byte[] bytes2, Integer prefixLength, String zone) {
        if (bytes.length == 4) {
            if (zone != null) {
                throw new IllegalArgumentException();
            }
            IPv4AddressNetwork.IPv4AddressCreator addressCreator = IPv4Address.network().getAddressCreator();
            IPAddressSegment[] segments = (IPv4AddressSegment[])IPAddress.toSegments((byte[])bytes, (byte[])bytes2, (int)4, (int)1, (int)8, (IPAddressTypeNetwork.IPAddressSegmentCreator)addressCreator, (Integer)prefixLength);
            return addressCreator.createAddressInternal(segments);
        }
        if (bytes.length == 16) {
            IPv6AddressNetwork.IPv6AddressCreator addressCreator = IPv6Address.network().getAddressCreator();
            IPAddressSegment[] segments = (IPv6AddressSegment[])IPAddress.toSegments((byte[])bytes, (byte[])bytes2, (int)8, (int)2, (int)16, (IPAddressTypeNetwork.IPAddressSegmentCreator)addressCreator, (Integer)prefixLength);
            return addressCreator.createAddressInternal(segments, zone);
        }
        throw new IllegalArgumentException();
    }

    protected static <T extends IPAddressSegment> T[] toSegments(byte[] bytes, byte[] bytes2, int segmentCount, int bytesPerSegment, int bitsPerSegment, IPAddressTypeNetwork.IPAddressSegmentCreator<T> creator, Integer networkPrefixLength) {
        IPAddressSegment[] segments = creator.createSegmentArray(segmentCount);
        int i = 0;
        int segmentIndex = 0;
        while (i < bytes.length) {
            Integer segmentPrefixLength = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, networkPrefixLength, segmentIndex);
            if (segmentPrefixLength != null && segmentPrefixLength == 0) {
                segments[segmentIndex] = creator.createSegment(0, 0);
            } else {
                int value = 0;
                int value2 = 0;
                int k = bytesPerSegment + i;
                int j = i;
                while (j < k) {
                    byte byteValue = bytes[j];
                    value <<= 8;
                    value |= 0xFF & byteValue;
                    if (bytes2 != null) {
                        byteValue = bytes2[j];
                        value2 <<= 8;
                        value2 |= 0xFF & byteValue;
                    }
                    ++j;
                }
                segments[segmentIndex] = bytes2 != null ? creator.createSegment(value, value2, segmentPrefixLength) : creator.createSegment(value, segmentPrefixLength);
            }
            i += bytesPerSegment;
            ++segmentIndex;
        }
        return segments;
    }

    protected static String toNormalizedString(byte[] bytes, byte[] bytes2, Integer prefixLength, String zone) {
        if (bytes.length == 4) {
            return IPAddress.toNormalizedString(bytes, bytes2, prefixLength, 4, 1, 8, 255, '.', 10, null, IPv4Address.network());
        }
        if (bytes.length == 16) {
            return IPAddress.toNormalizedString(bytes, bytes2, prefixLength, 8, 2, 16, 65535, ':', 16, zone, IPv6Address.network());
        }
        throw new IllegalArgumentException();
    }

    private static String toNormalizedString(byte[] bytes, byte[] bytes2, Integer prefixLength, int segmentCount, int bytesPerSegment, int bitsPerSegment, int segmentMaxValue, char separator, int radix, String zone, IPAddressNetwork network) {
        StringBuilder builder = new StringBuilder(23);
        int i = 0;
        while (i < bytes.length) {
            Integer segmentPrefixLength = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, prefixLength, i);
            if (segmentPrefixLength != null && segmentPrefixLength == 0) {
                builder.append('0').append(separator);
            } else {
                int value = 0;
                int value2 = 0;
                int k = bytesPerSegment + i;
                int j = i;
                while (j < k) {
                    byte byteValue = bytes[j];
                    value <<= 8;
                    value |= 0xFF & byteValue;
                    if (bytes2 != null) {
                        byteValue = bytes2[j];
                        value2 <<= 8;
                        value2 |= 0xFF & byteValue;
                    }
                    ++j;
                }
                if (bytes2 == null) {
                    if (segmentPrefixLength != null) {
                        value &= network.getSegmentNetworkMask(segmentPrefixLength);
                    }
                    IPAddressSegment.toUnsignedStringFast(value, radix, builder);
                } else {
                    if (segmentPrefixLength != null) {
                        int mask = network.getSegmentNetworkMask(segmentPrefixLength);
                        value &= mask;
                        value2 &= mask;
                    }
                    if (value == value2) {
                        IPAddressSegment.toUnsignedStringFast(value, radix, builder);
                    } else {
                        if (value > value2) {
                            int tmp = value2;
                            value2 = value;
                            value = tmp;
                        }
                        if (value == 0 && value2 == segmentMaxValue) {
                            builder.append(SEGMENT_WILDCARD_STR);
                        } else {
                            IPAddressSegment.getRangeString(value, value2, radix, builder);
                        }
                    }
                }
                builder.append(separator);
            }
            i += bytesPerSegment;
        }
        builder.setLength(builder.length() - 1);
        if (zone != null && zone.length() > 0) {
            builder.append('%').append(zone);
        }
        if (prefixLength != null) {
            builder.append('/').append(prefixLength);
        }
        return builder.toString();
    }

    public abstract IPAddressNetwork getNetwork();

    public static IPAddressNetwork network(IPVersion version) {
        return version.isIPv4() ? IPv4Address.network() : IPv6Address.network();
    }

    public static IPAddress getLoopback(IPVersion version) {
        return IPAddress.network(version).getLoopback();
    }

    public static IPAddress getLocalHost() throws UnknownHostException {
        return IPAddress.from(InetAddress.getLocalHost().getAddress());
    }

    public static String[] getStandardLoopbackStrings(IPVersion version) {
        return IPAddress.network(version).getStandardLoopbackStrings();
    }

    public IPAddressSection getSection() {
        return this.addressSection;
    }

    public IPAddressPart[] getParts(IPAddressSection.IPStringBuilderOptions options) {
        return new IPAddressPart[]{this.getSection()};
    }

    public int getMaxSegmentValue() {
        return IPAddressSegment.getMaxSegmentValue(this.getIPVersion());
    }

    public static int maxSegmentValue(IPVersion version) {
        return IPAddressSegment.getMaxSegmentValue(version);
    }

    public int getBytesPerSegment() {
        return IPAddressSegment.getByteCount(this.getIPVersion());
    }

    public int getBitsPerSegment() {
        return IPAddressSegment.getBitCount(this.getIPVersion());
    }

    public static int bitsPerSegment(IPVersion version) {
        return IPAddressSegment.getBitCount(version);
    }

    public abstract int getByteCount();

    public static int byteCount(IPVersion version) {
        return version.isIPv4() ? 4 : 16;
    }

    public abstract int getSegmentCount();

    public int getSegmentIndex(Integer networkPrefixLength) {
        return this.addressSection.getSegmentIndex(networkPrefixLength);
    }

    static int getSegmentIndex(Integer networkPrefixLength, int byteLength, int bytesPerSegment) {
        return IPAddressSection.getSegmentIndex(networkPrefixLength, byteLength, bytesPerSegment);
    }

    public int getByteIndex(Integer networkPrefixLength) {
        return this.addressSection.getByteIndex(networkPrefixLength);
    }

    static int getByteIndex(Integer networkPrefixLength, int byteLength) {
        return IPAddressSection.getByteIndex(networkPrefixLength, byteLength);
    }

    public static int segmentCount(IPVersion version) {
        return version.isIPv4() ? 4 : 8;
    }

    public abstract int getBitCount();

    public static int bitCount(IPVersion version) {
        return version.isIPv4() ? 32 : 128;
    }

    public boolean isMultipleByNetworkPrefix() {
        return this.addressSection.isMultipleByNetworkPrefix();
    }

    public boolean isMultiple() {
        return this.addressSection.isMultiple();
    }

    public boolean isPrefixed() {
        return this.addressSection.isPrefixed();
    }

    public Integer getNetworkPrefixLength() {
        return this.addressSection.getNetworkPrefixLength();
    }

    public IPAddressSegment getSegment(int index) {
        return this.addressSection.getSegment(index);
    }

    public BigInteger getCount() {
        if (!this.isMultiple()) {
            return BigInteger.ONE;
        }
        return this.addressSection.getCount();
    }

    public abstract IPAddress getLower();

    public abstract IPAddress getUpper();

    protected static <R extends IPAddressSection, S extends IPAddressSegment> S[] createSingle(R original, IPAddressTypeNetwork.IPAddressSegmentCreator<S> segmentCreator, IntFunction<S> segProducer) {
        return IPAddressSection.createSingle(original, segmentCreator, segProducer);
    }

    protected static <T extends IPAddress> T getSingle(T original, Supplier<T> singleFromMultipleCreator) {
        if (!original.isPrefixed() && !original.isMultiple()) {
            return original;
        }
        return (T)((IPAddress)singleFromMultipleCreator.get());
    }

    public abstract Iterator<? extends IPAddress> iterator();

    public abstract Iterable<? extends IPAddress> getAddresses();

    protected static <T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment> Iterator<T> iterator(final T original, final IPAddressTypeNetwork.IPAddressCreator<T, R, S> creator, Supplier<S[]> segs, IntFunction<Iterator<S>> segIteratorProducer) {
        return new Iterator<T>(segs, segIteratorProducer){
            private boolean doThis;
            private Iterator<S[]> iterator;
            {
                this.doThis = !iPAddress.isMultiple() && !iPAddress.isPrefixed();
                this.iterator = iPAddress.addressSection.iterator(iPAddressCreator, this.doThis, supplier, intFunction);
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext() || this.doThis;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.doThis) {
                    this.doThis = false;
                    return original;
                }
                IPAddressSegment[] next = (IPAddressSegment[])this.iterator.next();
                return creator.createAddressInternal(next);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean isIPv4() {
        return this.addressSection.isIPv4();
    }

    public boolean isIPv6() {
        return this.addressSection.isIPv6();
    }

    public IPVersion getIPVersion() {
        return this.addressSection.getIPVersion();
    }

    public IPv4Address toIPv4() {
        return null;
    }

    public IPv6Address toIPv6() {
        return null;
    }

    public abstract boolean isIPv4Convertible();

    public abstract boolean isIPv6Convertible();

    public abstract boolean isLinkLocal();

    public abstract boolean isSiteLocal();

    public abstract boolean isMulticast();

    public boolean isAnyLocal() {
        return this.isZero();
    }

    public abstract boolean isLoopback();

    public byte[] getBytes() {
        if (this.isMultiple()) {
            throw new IPAddressTypeException(this, "ipaddress.error.unavailable.numeric");
        }
        return this.getLowestBytes();
    }

    public byte[] getLowestBytes() {
        return this.addressSection.getLowestBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress toInetAddress() {
        if (this.inetAddress == null) {
            IPAddress iPAddress = this;
            synchronized (iPAddress) {
                if (this.inetAddress == null) {
                    byte[] bytes = this.getBytes();
                    try {
                        this.inetAddress = InetAddress.getByAddress(bytes);
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
            }
        }
        return this.inetAddress;
    }

    public boolean isZero() {
        if (this.isMultipleByNetworkPrefix()) {
            return false;
        }
        return this.addressSection.isZero();
    }

    public int hashCode() {
        return this.addressSection.hashCode();
    }

    @Override
    public int compareTo(IPAddress other) {
        if (this == other) {
            return 0;
        }
        return addressComparator.compare(this, other);
    }

    public boolean matches(IPAddressString otherString) {
        if (this.isFromSameString(otherString)) {
            return true;
        }
        IPAddress otherAddr = otherString.getAddress();
        return otherAddr != null && this.isSameAddress(otherAddr);
    }

    protected boolean isFromSameString(IPAddressString otherString) {
        return this.fromString != null && otherString != null && (this.fromString == otherString || this.fromString.fullAddr.equals(otherString.fullAddr)) && this.fromString.validationOptions == otherString.validationOptions;
    }

    public boolean isSameAddress(IPAddress other) {
        return other == this || this.getSection().equals(other.getSection());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IPAddress) {
            IPAddress other = (IPAddress)o;
            if (this.isFromSameString(other.fromString)) {
                return true;
            }
            return this.isSameAddress(other);
        }
        return false;
    }

    public boolean contains(IPAddress other) {
        if (other == this) {
            return true;
        }
        return this.addressSection.contains(other.addressSection);
    }

    public abstract IPAddress[] subtract(IPAddress var1);

    public static IPAddress from(InetAddress inetAddress) {
        byte[] bytes = inetAddress.getAddress();
        if (bytes.length == 16) {
            Inet6Address inet6Address = (Inet6Address)inetAddress;
            NetworkInterface networkInterface = inet6Address.getScopedInterface();
            String zone = null;
            if (networkInterface == null) {
                int scopeId = inet6Address.getScopeId();
                if (scopeId != 0) {
                    zone = Integer.toString(scopeId);
                }
            } else {
                zone = networkInterface.getName();
            }
            IPv6AddressNetwork.IPv6AddressCreator ipv6Creator = IPv6Address.network().getAddressCreator();
            return ipv6Creator.createAddressInternal(bytes, null, zone);
        }
        IPv4AddressNetwork.IPv4AddressCreator creator = IPv4Address.network().getAddressCreator();
        return creator.createAddressInternal(bytes, null, null);
    }

    public String[] getSegmentStrings() {
        return this.addressSection.getSegmentStrings();
    }

    public String toString() {
        return this.toNormalizedString();
    }

    public String toCanonicalString() {
        return this.addressSection.toCanonicalString();
    }

    public String toFullString() {
        return this.addressSection.toFullString();
    }

    public String toNormalizedString() {
        return this.addressSection.toNormalizedString();
    }

    protected void cacheNormalizedString(String str) {
        this.addressSection.cacheNormalizedString(str);
    }

    public String toCompressedString() {
        return this.addressSection.toCompressedString();
    }

    public String toSubnetString() {
        return this.addressSection.toSubnetString();
    }

    public String toNormalizedWildcardString() {
        return this.addressSection.toNormalizedWildcardString();
    }

    public String toCanonicalWildcardString() {
        return this.addressSection.toCanonicalWildcardString();
    }

    public String toCompressedWildcardString() {
        return this.addressSection.toCompressedWildcardString();
    }

    public String toSQLWildcardString() {
        return this.addressSection.toSQLWildcardString();
    }

    public String toNetworkPrefixLengthString() {
        return this.addressSection.toNetworkPrefixLengthString();
    }

    public String toConvertedString() {
        return this.toNormalizedString();
    }

    public abstract String toUNCHostName();

    public abstract String toReverseDNSLookupString();

    public String toHexString(boolean withPrefix) {
        return this.addressSection.toHexString(withPrefix);
    }

    public String toNormalizedString(IPAddressSection.StringOptions params) {
        return this.addressSection.toNormalizedString(params);
    }

    public String[] toStandardStrings() {
        return this.toStandardStringCollection().toStrings();
    }

    public String[] toAllStrings() {
        return this.toAllStringCollection().toStrings();
    }

    public String[] toStrings(IPAddressSection.IPStringBuilderOptions options) {
        return this.toStringCollection(options).toStrings();
    }

    public IPAddressPartStringCollection toStandardStringCollection() {
        return this.addressSection.toStandardStringCollection();
    }

    public IPAddressPartStringCollection toAllStringCollection() {
        return this.addressSection.toAllStringCollection();
    }

    public IPAddressPartStringCollection toStringCollection(IPAddressSection.IPStringBuilderOptions options) {
        return this.addressSection.toStringCollection(options);
    }

    public IPAddressString toAddressString() {
        if (this.fromString == null) {
            this.fromString = new IPAddressString(this);
        }
        return this.fromString;
    }

    public static String toDelimitedSQLStrs(String[] strs) {
        if (strs.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            builder.append('\'').append(str).append('\'').append(',');
            ++n2;
        }
        return builder.substring(0, builder.length() - 1);
    }

    public boolean isRangeEquivalentToPrefix() {
        return this.addressSection.isRangeEquivalentToPrefix();
    }

    public int getMinPrefix() {
        return this.addressSection.getMinPrefix();
    }

    public Integer getEquivalentPrefix() {
        return this.addressSection.getEquivalentPrefix();
    }

    public IPAddress toPrefixedEquivalent() {
        if (!this.isMultiple()) {
            return this;
        }
        Integer newPrefix = this.getEquivalentPrefix();
        return newPrefix == null ? null : this.toSubnet(newPrefix);
    }

    public IPAddress toPrefixedMin() {
        return this.toSubnet(this.getMinPrefix());
    }

    public Integer getMaskPrefixLength(boolean network) {
        return this.addressSection.getMaskPrefixLength(network);
    }

    public boolean isMaskCompatibleWithRange(IPAddress mask, Integer networkPrefixLength) {
        return this.getSection().isMaskCompatibleWithRange(mask.getSection(), networkPrefixLength);
    }

    public abstract IPAddress toSubnet(IPAddress var1) throws IPAddressTypeException;

    public abstract IPAddress toSubnet(IPAddress var1, Integer var2) throws IPAddressTypeException;

    public abstract IPAddress toSubnet(int var1);

    public abstract IPAddressSection getNetworkSection(int var1, boolean var2);

    public IPAddressSection getNetworkSection(int networkPrefixLength) {
        return this.addressSection.getNetworkSection(networkPrefixLength);
    }

    public abstract IPAddressSection getNetworkSection();

    public abstract IPAddressSection getHostSection(int var1);

    public abstract IPAddressSection getHostSection();

    public IPAddress toSupernet(Integer prefixLengthDecrement) {
        int newPrefix = this.addressSection.getSupernetPrefix(prefixLengthDecrement);
        return this.toSubnet(newPrefix);
    }

    public IPAddress toSupernet() {
        return this.toSupernet(null);
    }

    public void getMatchesSQLClause(StringBuilder builder, String sqlExpression) {
        this.addressSection.getStartsWithSQLClause(builder, sqlExpression);
    }

    public void getMatchesSQLClause(StringBuilder builder, String sqlExpression, IPAddressSQLTranslator translator) {
        this.addressSection.getStartsWithSQLClause(builder, sqlExpression, translator);
    }

    public static enum IPVersion {
        IPV4,
        IPV6;


        public boolean isIPv4() {
            return this == IPV4;
        }

        public boolean isIPv6() {
            return this == IPV6;
        }
    }
}

