/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.util;

import inet.ipaddr.IPAddressSection;
import inet.ipaddr.format.IPAddressDivision;
import inet.ipaddr.format.IPAddressPart;
import inet.ipaddr.format.util.AddressPartStringCollection;
import inet.ipaddr.format.util.IPAddressPartConfiguredString;
import inet.ipaddr.format.util.IPAddressPartStringParams;
import inet.ipaddr.format.util.IPAddressPartStringSubCollection;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class IPAddressPartStringCollection
extends AddressPartStringCollection<IPAddressPart, IPAddressPartStringParams<?>, IPAddressPartConfiguredString<?, ?>> {
    private final List<IPAddressPartStringSubCollection<?, ?, ? extends IPAddressPartConfiguredString<?, ?>>> collections = new ArrayList();

    protected IPAddressPartStringCollection() {
    }

    protected void add(IPAddressPartStringSubCollection<?, ?, ? extends IPAddressPartConfiguredString<?, ?>> collection) {
        this.collections.add(collection);
    }

    protected void addAll(IPAddressPartStringCollection collections) {
        this.collections.addAll(collections.collections);
    }

    public int getPartCount() {
        return this.collections.size();
    }

    public IPAddressPart getPart(int index) {
        return this.getSubCollection((int)index).part;
    }

    public IPAddressPart[] getParts(IPAddressPart[] array) {
        int size = this.getPartCount();
        IPAddressPart[] result = array.length < size ? (IPAddressPart[])Array.newInstance(array.getClass().getComponentType(), size) : array;
        int i = 0;
        for (IPAddressPartStringSubCollection<?, ?, ? extends IPAddressPartConfiguredString<?, ?>> iPAddressPartStringSubCollection : this.collections) {
            result[i++] = iPAddressPartStringSubCollection.part;
        }
        return result;
    }

    public IPAddressPartStringSubCollection<?, ?, ?> getSubCollection(IPAddressPart part) {
        for (IPAddressPartStringSubCollection<?, ?, ? extends IPAddressPartConfiguredString<?, ?>> iPAddressPartStringSubCollection : this.collections) {
            if (!iPAddressPartStringSubCollection.params.equals(part)) continue;
            return iPAddressPartStringSubCollection;
        }
        return null;
    }

    public IPAddressPartStringSubCollection<?, ?, ?> getSubCollection(int index) {
        return this.collections.get(index);
    }

    @Override
    public int size() {
        int size = 0;
        for (IPAddressPartStringSubCollection<?, ?, IPAddressPartConfiguredString<?, ?>> collection : this.collections) {
            size += collection.size();
        }
        return size;
    }

    @Override
    public Iterator<IPAddressPartConfiguredString<?, ?>> iterator() {
        return new Iterator<IPAddressPartConfiguredString<?, ?>>(){
            private int i;
            private Iterator<? extends IPAddressPartConfiguredString<?, ?>> currentIterator;

            @Override
            public boolean hasNext() {
                while (true) {
                    if (this.currentIterator == null) {
                        if (this.i < IPAddressPartStringCollection.this.collections.size()) {
                            this.currentIterator = ((IPAddressPartStringSubCollection)IPAddressPartStringCollection.this.collections.get(this.i++)).iterator();
                        } else {
                            return false;
                        }
                    }
                    if (this.currentIterator.hasNext()) {
                        return true;
                    }
                    this.currentIterator = null;
                }
            }

            @Override
            public IPAddressPartConfiguredString<?, ?> next() {
                if (this.hasNext()) {
                    return this.currentIterator.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (this.currentIterator == null) {
                    throw new IllegalStateException();
                }
                this.currentIterator.remove();
            }
        };
    }

    protected static abstract class AddressPartStringBuilder<T extends IPAddressPart, P extends IPAddressPartStringParams<T>, S extends IPAddressPartConfiguredString<T, P>, C extends IPAddressPartStringSubCollection<T, P, S>, O extends IPAddressSection.IPStringBuilderOptions> {
        protected static int MAX_BASE = 16;
        private int[][] leadingZeros;
        protected final T addressSection;
        protected final O options;
        protected final C collection;
        private boolean done;

        protected AddressPartStringBuilder(T addressSection, O options, C collection) {
            this.addressSection = addressSection;
            this.options = options;
            this.collection = collection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public C getVariations() {
            if (!this.done) {
                AddressPartStringBuilder addressPartStringBuilder = this;
                synchronized (addressPartStringBuilder) {
                    if (!this.done) {
                        this.done = true;
                        this.addAllVariations();
                    }
                }
            }
            return this.collection;
        }

        protected abstract void addAllVariations();

        protected void addStringParam(P stringParams) {
            ((IPAddressPartStringSubCollection)this.collection).add(stringParams);
        }

        protected boolean isExpandable(int radix) {
            return AddressPartStringBuilder.isExpandable(radix, this.addressSection);
        }

        protected boolean isExpandableOutsideRange(int radix, int segmentIndex, int count) {
            return AddressPartStringBuilder.isExpandableOutsideRange(radix, this.addressSection, segmentIndex, count);
        }

        private static boolean isExpandable(int radix, IPAddressPart part) {
            return AddressPartStringBuilder.isExpandableOutsideRange(radix, part, -1, 0);
        }

        private static boolean isExpandableOutsideRange(int radix, IPAddressPart part, int segmentIndex, int count) {
            int nextSegmentIndex = segmentIndex + count;
            int i = 0;
            while (i < part.getDivisionCount()) {
                IPAddressDivision seg;
                if ((i < segmentIndex || i >= nextSegmentIndex) && (seg = part.getDivision(i)).getMaxLeadingZeros(radix) > 0) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        protected int[] getExpandableSegments(int radix) {
            int[] result;
            if (this.leadingZeros == null) {
                this.leadingZeros = new int[MAX_BASE + 1][];
                result = AddressPartStringBuilder.getExpandableSegments(radix, this.addressSection);
                this.leadingZeros[radix] = result;
            } else {
                result = this.leadingZeros[radix];
                if (result == null) {
                    result = AddressPartStringBuilder.getExpandableSegments(radix, this.addressSection);
                    this.leadingZeros[radix] = result;
                }
            }
            return result;
        }

        protected static int[] getExpandableSegments(int radix, IPAddressPart part) {
            int count = part.getDivisionCount();
            int[] expandables = new int[count];
            int i = 0;
            while (i < count) {
                expandables[i] = part.getDivision(i).getMaxLeadingZeros(radix);
                ++i;
            }
            return expandables;
        }
    }

    public static class StringParams<T extends IPAddressPart>
    extends IPAddressPartStringParams<T> {
        public static final IPAddressSection.WildcardOptions DEFAULT_WILDCARD_OPTIONS = new IPAddressSection.WildcardOptions(IPAddressSection.WildcardOptions.WildcardOption.NETWORK_ONLY);
        protected static final int EXTRA_SPACE = 16;
        private IPAddressSection.WildcardOptions wildcardOptions = DEFAULT_WILDCARD_OPTIONS;
        private boolean expandSegments;
        private int[] expandSegment;
        private String segmentStrPrefix;
        private int radix;
        private Character separator;
        private String addressLabel = "";
        private String addressSuffix = "";
        private boolean reverse;
        private boolean splitDigits;
        private boolean uppercase;

        public StringParams(int radix, Character separator, boolean uppercase) {
            this.radix = radix;
            this.separator = separator;
            this.uppercase = uppercase;
        }

        public void setUppercase(boolean uppercase) {
            this.uppercase = uppercase;
        }

        public boolean isUppercase() {
            return this.uppercase;
        }

        public void setSplitDigits(boolean split) {
            this.splitDigits = split;
        }

        public boolean isSplitDigits() {
            return this.splitDigits;
        }

        public void setReverse(boolean rev) {
            this.reverse = rev;
        }

        public boolean isReverse() {
            return this.reverse;
        }

        public String getAddressSuffix() {
            return this.addressSuffix;
        }

        public void setAddressSuffix(String suffix) {
            this.addressSuffix = suffix;
        }

        public String getAddressLabel() {
            return this.addressLabel;
        }

        public void setAddressLabel(String str) {
            this.addressLabel = str;
        }

        public Character getSeparator() {
            return this.separator;
        }

        public void setSeparator(Character separator) {
            this.separator = separator;
        }

        public int getRadix() {
            return this.radix;
        }

        public void setRadix(int radix) {
            this.radix = radix;
        }

        public String getSegmentStrPrefix() {
            return this.segmentStrPrefix;
        }

        public void setSegmentStrPrefix(String segmentStrPrefix) {
            this.segmentStrPrefix = segmentStrPrefix;
        }

        public void setWildcardOption(IPAddressSection.WildcardOptions options) {
            this.wildcardOptions = options;
        }

        public IPAddressSection.WildcardOptions getWildcardOption() {
            return this.wildcardOptions;
        }

        public int getExpandedSegmentLength(int segmentIndex) {
            if (this.expandSegment == null || this.expandSegment.length <= segmentIndex) {
                return 0;
            }
            return this.expandSegment[segmentIndex];
        }

        public void expandSegment(int index, int expansionLength, int segmentCount) {
            if (this.expandSegment == null) {
                this.expandSegment = new int[segmentCount];
            }
            this.expandSegment[index] = expansionLength;
        }

        public void expandSegments(boolean expand) {
            this.expandSegments = expand;
        }

        @Override
        public char getTrailingSegmentSeparator() {
            return this.separator.charValue();
        }

        public void appendSuffix(StringBuilder builder) {
            String suffix = this.getAddressSuffix();
            if (suffix != null) {
                builder.append(suffix);
            }
        }

        public int getAddressSuffixLength() {
            String suffix = this.getAddressSuffix();
            if (suffix != null) {
                return suffix.length();
            }
            return 0;
        }

        public void appendLabel(StringBuilder builder) {
            String str = this.getAddressLabel();
            if (str != null) {
                builder.append(str);
            }
        }

        public int getAddressLabelLength() {
            String str = this.getAddressLabel();
            if (str != null) {
                return str.length();
            }
            return 0;
        }

        protected int getLeadingZeros(int segmentIndex) {
            if (this.expandSegments) {
                return -1;
            }
            if (this.expandSegment != null && this.expandSegment.length > segmentIndex) {
                return this.expandSegment[segmentIndex];
            }
            return 0;
        }

        @Override
        public StringParams<T> clone() {
            Object params = super.clone();
            StringParams parms = (StringParams)params;
            if (this.expandSegment != null) {
                parms.expandSegment = (int[])this.expandSegment.clone();
            }
            return parms;
        }

        @Override
        public String toString(T addr) {
            int length = this.getStringLength(addr);
            StringBuilder builder = new StringBuilder(length);
            this.append(builder, addr);
            this.checkLengths(length, builder);
            return builder.toString();
        }

        @Override
        public int getTrailingSeparatorCount(T addr) {
            if (addr.getDivisionCount() > 0) {
                return addr.getDivisionCount() - 1;
            }
            return 0;
        }

        @Override
        public int getStringLength(T addr) {
            int count = this.getSegmentsStringLength(addr);
            if (!this.isReverse() && this.getWildcardOption().wildcardOption != IPAddressSection.WildcardOptions.WildcardOption.ALL) {
                count += addr.getPrefixStringLength();
            }
            count += this.getAddressSuffixLength();
            return count += this.getAddressLabelLength();
        }

        @Override
        public StringBuilder append(StringBuilder builder, T addr) {
            this.appendLabel(builder);
            this.appendSegments(builder, addr);
            this.appendSuffix(builder);
            if (!this.isReverse() && this.getWildcardOption().wildcardOption != IPAddressSection.WildcardOptions.WildcardOption.ALL) {
                this.appendPrefixIndicator(builder, addr);
            }
            return builder;
        }

        public int getSegmentsStringLength(T part) {
            int count = 0;
            if (part.getDivisionCount() != 0) {
                IPAddressSection.WildcardOptions wildcardOptions = this.getWildcardOption();
                IPAddressSection.WildcardOptions.WildcardOption wildcardOption = wildcardOptions.wildcardOption;
                boolean isAll = wildcardOption == IPAddressSection.WildcardOptions.WildcardOption.ALL;
                int divCount = part.getDivisionCount();
                Character separator = this.getSeparator();
                int i = 0;
                while (i < divCount) {
                    IPAddressDivision seg = part.getDivision(i);
                    int leadingZeroCount = this.getLeadingZeros(i);
                    count = isAll || this.isSplitDigits() ? (count += seg.getWildcardString(wildcardOptions.wildcards, leadingZeroCount, this.getSegmentStrPrefix(), this.getRadix(), this.isUppercase(), this.isSplitDigits(), separator.charValue(), false, null)) : (count += seg.getPrefixAdjustedWildcardString(wildcardOptions.wildcards, leadingZeroCount, this.getSegmentStrPrefix(), this.getRadix(), this.isUppercase(), null));
                    ++i;
                }
                if (separator != null) {
                    count += divCount - 1;
                }
            }
            return count;
        }

        public StringBuilder appendSegments(StringBuilder builder, T part) {
            if (part.getDivisionCount() != 0) {
                IPAddressSection.WildcardOptions wildcardOptions = this.getWildcardOption();
                IPAddressSection.WildcardOptions.WildcardOption wildcardOption = wildcardOptions.wildcardOption;
                boolean isAll = wildcardOption == IPAddressSection.WildcardOptions.WildcardOption.ALL;
                int count = part.getDivisionCount();
                boolean reverse = this.isReverse();
                int i = 0;
                Character separator = this.getSeparator();
                while (true) {
                    int segIndex = reverse ? count - i - 1 : i;
                    IPAddressDivision seg = part.getDivision(segIndex);
                    int leadingZeroCount = this.getLeadingZeros(segIndex);
                    if (isAll || this.isSplitDigits()) {
                        seg.getWildcardString(wildcardOptions.wildcards, leadingZeroCount, this.getSegmentStrPrefix(), this.getRadix(), this.isUppercase(), this.isSplitDigits(), separator.charValue(), this.isReverse(), builder);
                    } else {
                        seg.getPrefixAdjustedWildcardString(wildcardOptions.wildcards, leadingZeroCount, this.getSegmentStrPrefix(), this.getRadix(), this.isUppercase(), builder);
                    }
                    if (++i == count) break;
                    if (separator == null) continue;
                    builder.append(separator);
                }
            }
            return builder;
        }
    }
}

