/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv4;

import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressConverter;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IPAddressTypeException;
import inet.ipaddr.IPAddressTypeNetwork;
import inet.ipaddr.format.IPAddressDivision;
import inet.ipaddr.format.IPAddressPart;
import inet.ipaddr.format.IPAddressSegmentGrouping;
import inet.ipaddr.format.util.IPAddressPartConfiguredString;
import inet.ipaddr.format.util.IPAddressPartStringCollection;
import inet.ipaddr.format.util.IPAddressPartStringSubCollection;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv4.IPv4AddressSegment;
import inet.ipaddr.ipv4.IPv4JoinedSegments;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressSection;
import java.util.ArrayList;
import java.util.Iterator;

public class IPv4AddressSection
extends IPAddressSection {
    private static final long serialVersionUID = 1L;
    transient IPv4StringCache stringCache;

    public IPv4AddressSection(IPv4AddressSegment[] segments, Integer networkPrefixLength) {
        this((IPv4AddressSegment[])IPv4AddressSection.toCIDRSegments((Integer)networkPrefixLength, (IPAddressSegment[])segments, (IPAddressTypeNetwork.IPAddressSegmentCreator)IPv4AddressSection.getIPv4SegmentCreator(), IPv4AddressSegment::toNetworkSegment), false);
    }

    public IPv4AddressSection(IPv4AddressSegment[] segments) {
        this(segments, true);
    }

    IPv4AddressSection(IPv4AddressSegment[] segments, boolean cloneSegments) {
        super(segments, null, cloneSegments, false);
    }

    IPv4AddressSection(byte[] bytes, Integer prefix, boolean cloneBytes) {
        super(IPv4AddressSection.toSegments((byte[])bytes, (int)4, (int)1, (int)8, (IPAddressTypeNetwork.IPAddressSegmentCreator)IPv4AddressSection.getIPv4SegmentCreator(), (Integer)prefix), bytes, false, cloneBytes);
    }

    public IPv4AddressSection(byte[] bytes, Integer prefix) {
        this(bytes, prefix, true);
    }

    public IPv4AddressSection(byte[] bytes) {
        this(bytes, null, true);
    }

    private IPv4AddressSegment[] getLowestOrHighestSegments(boolean lowest) {
        return (IPv4AddressSegment[])IPv4AddressSection.getSingle((IPAddressSection)this, (IPAddressSegment[])((IPv4AddressSegment[])this.divisions), (IPAddressTypeNetwork.IPAddressSegmentCreator)this.getAddressCreator(), (int i) -> {
            IPv4AddressSegment seg = this.getSegment(i);
            return lowest ? seg.getLower() : seg.getUpper();
        }, (boolean)false);
    }

    public IPv4AddressSegment[] getSegments() {
        return (IPv4AddressSegment[])this.divisions.clone();
    }

    public IPv4AddressSegment[] getLowerSegments() {
        return this.getLowestOrHighestSegments(true);
    }

    public IPv4AddressSegment[] getUpperSegments() {
        return this.getLowestOrHighestSegments(false);
    }

    private IPv4AddressSection getLowestOrHighestSection(boolean lowest) {
        return IPv4AddressSection.getSingle(this, () -> {
            IPAddressSection result;
            if (this.hasNoSectionCache() || (result = lowest ? this.sectionCache.lowerSection : this.sectionCache.upperSection) == null) {
                IPv4AddressNetwork.IPv4AddressCreator creator = this.getAddressCreator();
                IPv4AddressSegment[] segs = (IPv4AddressSegment[])IPv4AddressSection.createSingle((IPAddressSection)this, (IPAddressTypeNetwork.IPAddressSegmentCreator)creator, (int i) -> {
                    IPv4AddressSegment seg = this.getSegment(i);
                    return lowest ? seg.getLower() : seg.getUpper();
                });
                IPv4AddressSection newSection = creator.createSectionInternal(segs);
                if (lowest) {
                    this.sectionCache.lowerSection = newSection;
                } else {
                    this.sectionCache.upperSection = newSection;
                }
                return newSection;
            }
            return (IPv4AddressSection)result;
        });
    }

    @Override
    public IPv4AddressSection getLowerSection() {
        return this.getLowestOrHighestSection(true);
    }

    @Override
    public IPv4AddressSection getUpperSection() {
        return this.getLowestOrHighestSection(false);
    }

    public Iterator<IPv4AddressSection> sectionIterator() {
        return new IPAddressSection.SectionIterator<IPv4Address, IPv4AddressSection, IPv4AddressSegment>(this, this.getAddressCreator(), this.iterator(true));
    }

    private Iterator<IPv4AddressSegment[]> iterator(boolean skipThis) {
        return super.iterator(this.getSegmentCreator(), skipThis, this::getLowerSegments, index -> this.getSegment(index).iterator());
    }

    public Iterator<IPv4AddressSegment[]> iterator() {
        return this.iterator(false);
    }

    protected IPv4AddressNetwork.IPv4AddressCreator getSegmentCreator() {
        return IPv4AddressSection.getIPv4SegmentCreator();
    }

    protected IPv4AddressNetwork.IPv4AddressCreator getAddressCreator() {
        return IPv4AddressSection.getIPv4SegmentCreator();
    }

    private static IPv4AddressNetwork.IPv4AddressCreator getIPv4SegmentCreator() {
        return IPv4Address.network().getAddressCreator();
    }

    @Override
    public IPv4AddressSegment getSegment(int index) {
        return (IPv4AddressSegment)super.getSegment(index);
    }

    @Override
    public int getBitsPerSegment() {
        return 8;
    }

    @Override
    public int getBytesPerSegment() {
        return 1;
    }

    @Override
    public boolean isIPv4() {
        return true;
    }

    @Override
    public IPAddress.IPVersion getIPVersion() {
        return IPAddress.IPVersion.IPV4;
    }

    @Override
    protected boolean isSameGrouping(IPAddressSegmentGrouping other) {
        return other instanceof IPv4AddressSection && super.isSameGrouping(other);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IPv4AddressSection) {
            return super.isSameGrouping((IPv4AddressSection)o);
        }
        return false;
    }

    @Override
    public boolean contains(IPAddressSection other) {
        return other.isIPv4() && super.contains(other);
    }

    public IPv4AddressSection[] subtract(IPAddressSection other) {
        if (!(other instanceof IPv4AddressSection)) {
            throw new IPAddressTypeException((IPAddressSection)this, other, "ipaddress.error.typeMismatch");
        }
        return (IPv4AddressSection[])IPv4AddressSection.subtract((IPAddressSection)this, (IPAddressSection)((IPv4AddressSection)other), (IPAddressTypeNetwork.IPAddressCreator)this.getAddressCreator(), this::getSegment, (T section, U prefix) -> section.toSubnet((int)prefix));
    }

    @Override
    public int getByteIndex(Integer networkPrefixLength) {
        return IPv4AddressSection.getByteIndex(networkPrefixLength, 4);
    }

    @Override
    public int getSegmentIndex(Integer networkPrefixLength) {
        return IPv4AddressSection.getSegmentIndex(networkPrefixLength, 4, 1);
    }

    @Override
    public IPv4AddressNetwork getNetwork() {
        return IPv4Address.network();
    }

    @Override
    public IPv4AddressSection toSubnet(int networkPrefixLength) throws IPAddressTypeException {
        super.checkSubnet(networkPrefixLength);
        if (this.isPrefixed() && networkPrefixLength >= this.getNetworkPrefixLength()) {
            return this;
        }
        IPv4Address addressMask = (IPv4Address)this.getNetwork().getNetworkMask(networkPrefixLength, false);
        IPv4AddressSection mask = addressMask.getNetworkSection(this.getBitCount(), false);
        return IPv4AddressSection.getSubnetSegments(this, mask, networkPrefixLength, this.getAddressCreator(), false, this::getSegment, mask::getSegment);
    }

    @Override
    public IPv4AddressSection toSubnet(IPAddressSection mask) throws IPAddressTypeException {
        return this.toSubnet(mask, null);
    }

    @Override
    public IPv4AddressSection toSubnet(IPAddressSection mask, Integer networkPrefixLength) throws IPAddressTypeException {
        if (!(mask instanceof IPv4AddressSection)) {
            throw new IPAddressTypeException((IPAddressSection)this, mask, "ipaddress.error.typeMismatch");
        }
        IPv4AddressSection theMask = (IPv4AddressSection)mask;
        super.checkSubnet(theMask, networkPrefixLength);
        return IPv4AddressSection.getSubnetSegments(this, theMask, networkPrefixLength, this.getAddressCreator(), true, this::getSegment, theMask::getSegment);
    }

    @Override
    public IPv4AddressSection getNetworkSection(int networkPrefixLength) {
        return this.getNetworkSection(networkPrefixLength, true);
    }

    @Override
    public IPv4AddressSection getNetworkSection(int networkPrefixLength, boolean withPrefixLength) {
        int cidrSegmentCount = this.getNetworkSegmentCount(networkPrefixLength);
        return IPv4AddressSection.getNetworkSegments(this, networkPrefixLength, cidrSegmentCount, withPrefixLength, this.getAddressCreator(), (i, prefix) -> this.getSegment((int)i).toNetworkSegment((Integer)prefix, withPrefixLength));
    }

    @Override
    public IPv4AddressSection getHostSection(int networkPrefixLength) {
        int cidrSegmentCount = this.getHostSegmentCount(networkPrefixLength);
        return IPv4AddressSection.getHostSegments(this, networkPrefixLength, cidrSegmentCount, this.getAddressCreator(), (i, prefix) -> this.getSegment((int)i).toHostSegment((Integer)prefix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean hasNoStringCache() {
        if (this.stringCache == null) {
            IPv4AddressSection iPv4AddressSection = this;
            synchronized (iPv4AddressSection) {
                block5: {
                    if (this.stringCache != null) break block5;
                    this.stringCache = new IPv4StringCache();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected IPAddressSection.StringCache getStringCache() {
        return this.stringCache;
    }

    @Override
    public String toCanonicalString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.canonicalString) == null) {
            this.stringCache.canonicalString = result = this.toNormalizedString(IPv4StringCache.canonicalParams);
        }
        return result;
    }

    @Override
    public String toFullString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.fullString) == null) {
            this.stringCache.fullString = result = this.toNormalizedString(IPv4StringCache.fullParams);
        }
        return result;
    }

    @Override
    public String toCompressedString() {
        return this.toCanonicalString();
    }

    @Override
    public String toNormalizedString() {
        return this.toCanonicalString();
    }

    @Override
    protected void cacheNormalizedString(String str) {
        if (this.hasNoStringCache() || this.stringCache.canonicalString == null) {
            this.stringCache.canonicalString = str;
        }
    }

    @Override
    public String toCompressedWildcardString() {
        return this.toNormalizedWildcardString();
    }

    @Override
    public String toSubnetString() {
        return this.toNormalizedWildcardString();
    }

    @Override
    public String toNetworkPrefixLengthString() {
        return this.toCanonicalString();
    }

    public String toInetAtonString(IPv4Address.inet_aton_radix radix) {
        String result;
        if (radix == IPv4Address.inet_aton_radix.OCTAL) {
            if (this.hasNoStringCache() || (result = this.stringCache.octalString) == null) {
                this.stringCache.octalString = result = this.toNormalizedString(IPv4StringCache.octalParams);
            }
        } else if (radix == IPv4Address.inet_aton_radix.HEX) {
            if (this.hasNoStringCache() || (result = this.stringCache.hexString) == null) {
                this.stringCache.hexString = result = this.toNormalizedString(IPv4StringCache.hexParams);
            }
        } else {
            result = this.toCanonicalString();
        }
        return result;
    }

    public String toInetAtonString(IPv4Address.inet_aton_radix radix, int joinedCount) {
        if (joinedCount <= 0) {
            return this.toInetAtonString(radix);
        }
        IPAddressSection.StringOptions stringParams = radix == IPv4Address.inet_aton_radix.OCTAL ? IPv4StringCache.octalParams : (radix == IPv4Address.inet_aton_radix.HEX ? IPv4StringCache.hexParams : IPv4StringCache.canonicalParams);
        return this.toNormalizedString(stringParams, joinedCount);
    }

    @Override
    public String toNormalizedWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.normalizedWildcardString) == null) {
            this.stringCache.normalizedWildcardString = result = this.toNormalizedString(IPv4StringCache.normalizedWildcardParams);
        }
        return result;
    }

    @Override
    public String toCanonicalWildcardString() {
        return this.toNormalizedWildcardString();
    }

    @Override
    public String toSQLWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.sqlWildcardString) == null) {
            this.stringCache.sqlWildcardString = result = this.toNormalizedString(IPv4StringCache.sqlWildcardParams);
        }
        return result;
    }

    public String toNormalizedString(IPAddressSection.StringOptions stringParams, int joinCount) {
        if (joinCount <= 0) {
            return this.toNormalizedString(stringParams);
        }
        int thisCount = this.getSegmentCount();
        if (thisCount <= 1) {
            return this.toNormalizedString(stringParams);
        }
        IPAddressSegmentGrouping equivalentPart = this.toJoinedSegments(joinCount);
        return IPv4AddressSection.toNormalizedString(stringParams, equivalentPart);
    }

    public IPAddressSegmentGrouping toJoinedSegments(int joinCount) {
        int totalCount;
        int thisCount = this.getSegmentCount();
        if (joinCount <= 0 || thisCount <= 1) {
            return this;
        }
        if (joinCount >= thisCount) {
            joinCount = thisCount - 1;
            totalCount = 1;
        } else {
            totalCount = thisCount - joinCount;
        }
        int notJoinedCount = totalCount - 1;
        IPAddressDivision[] segs = new IPAddressDivision[totalCount];
        int i = 0;
        while (i < notJoinedCount) {
            segs[i] = this.getDivision(i);
            ++i;
        }
        IPv4JoinedSegments joinedSegment = this.joinSegments(joinCount);
        segs[notJoinedCount] = joinedSegment;
        IPAddressSegmentGrouping equivalentPart = new IPAddressSegmentGrouping(segs);
        return equivalentPart;
    }

    private IPv4JoinedSegments joinSegments(int joinCount) {
        long lower = 0L;
        long upper = 0L;
        int networkPrefixLength = 0;
        Integer prefix = null;
        int firstSegIndex = 0;
        IPv4AddressSegment firstRange = null;
        int firstJoinedIndex = this.getSegmentCount() - 1 - joinCount;
        int j = 0;
        while (j <= joinCount) {
            IPv4AddressSegment thisSeg = this.getSegment(firstJoinedIndex + j);
            if (firstRange != null) {
                if (!thisSeg.isFullRange()) {
                    throw new IPAddressTypeException(firstRange, firstSegIndex, thisSeg, firstJoinedIndex + j, "ipaddress.error.segmentMismatch");
                }
            } else if (thisSeg.isMultiple()) {
                firstSegIndex = firstJoinedIndex + j;
                firstRange = thisSeg;
            }
            lower = lower << 8 | (long)thisSeg.getLowerSegmentValue();
            upper = upper << 8 | (long)thisSeg.getUpperSegmentValue();
            if (prefix == null) {
                Integer thisSegPrefix = thisSeg.getSegmentPrefixLength();
                if (thisSegPrefix != null) {
                    prefix = networkPrefixLength + thisSegPrefix;
                } else {
                    networkPrefixLength += thisSeg.getBitCount();
                }
            }
            ++j;
        }
        IPv4JoinedSegments joinedSegment = new IPv4JoinedSegments(joinCount, lower, upper, prefix);
        return joinedSegment;
    }

    @Override
    public IPAddressPartStringCollection toAllStringCollection() {
        return this.toStringCollection(IPv4StringBuilderOptions.ALL_OPTS);
    }

    @Override
    public IPAddressPartStringCollection toStandardStringCollection() {
        return this.toStringCollection(IPv4StringBuilderOptions.STANDARD_OPTS);
    }

    @Override
    public IPAddressPartStringCollection toDatabaseSearchStringCollection() {
        return this.toStringCollection(IPv4StringBuilderOptions.DATABASE_SEARCH_OPTS);
    }

    @Override
    public IPAddressPartStringCollection toStringCollection(IPAddressSection.IPStringBuilderOptions opts) {
        return this.toStringCollection(IPv4StringBuilderOptions.from(opts));
    }

    public IPAddressPartStringCollection toStringCollection(IPv4StringBuilderOptions opts) {
        IPAddressPart[] parts;
        IPv4SectionStringCollection collection = new IPv4SectionStringCollection();
        IPAddressPart[] iPAddressPartArray = parts = this.getParts(opts);
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            IPAddressPart part = iPAddressPartArray[n2];
            IPv4StringCollection.IPv4StringBuilder builder = new IPv4StringCollection.IPv4StringBuilder(part, opts, new IPv4StringCollection.IPv4AddressSectionStringCollection(part));
            IPv4StringCollection.IPv4AddressSectionStringCollection subCollection = (IPv4StringCollection.IPv4AddressSectionStringCollection)builder.getVariations();
            collection.add(subCollection);
            ++n2;
        }
        return collection;
    }

    @Override
    public IPAddressPart[] getParts(IPAddressSection.IPStringBuilderOptions options) {
        return this.getParts(IPv4StringBuilderOptions.from(options));
    }

    public IPAddressPart[] getParts(IPv4StringBuilderOptions options) {
        if (!options.includesAny(14)) {
            return super.getParts(options);
        }
        ArrayList<IPAddressSegmentGrouping> parts = new ArrayList<IPAddressSegmentGrouping>(4);
        if (options.includes(1)) {
            parts.add(this);
        }
        boolean[] joined = new boolean[4];
        int segmentCount = this.getSegmentCount();
        joined[Math.max((int)3, (int)(segmentCount - 1))] = options.includes(2);
        int n = Math.max(2, Math.min(2, segmentCount - 1));
        joined[n] = joined[n] | options.includes(4);
        int n2 = Math.max(1, Math.min(1, segmentCount - 1));
        joined[n2] = joined[n2] | options.includes(8);
        int i = 1;
        while (i < joined.length) {
            if (joined[i]) {
                parts.add(this.toJoinedSegments(i));
            }
            ++i;
        }
        return parts.toArray(new IPAddressPart[parts.size()]);
    }

    static class IPv4SectionStringCollection
    extends IPAddressPartStringCollection {
        IPv4SectionStringCollection() {
        }

        @Override
        protected void add(IPAddressPartStringSubCollection<?, ?, ? extends IPAddressPartConfiguredString<?, ?>> collection) {
            super.add(collection);
        }

        @Override
        protected void addAll(IPAddressPartStringCollection collections) {
            super.addAll(collections);
        }
    }

    public static class IPv4StringBuilderOptions
    extends IPAddressSection.IPStringBuilderOptions {
        public static final int JOIN_ALL = 2;
        public static final int JOIN_TWO = 4;
        public static final int JOIN_ONE = 8;
        public static final int ALL_JOINS = 14;
        public static final int IPV6_CONVERSIONS = 65536;
        public static final int OCTAL = 256;
        public static final int HEX = 512;
        public final IPv6AddressSection.IPv6StringBuilderOptions ipv6ConverterOptions;
        public final IPv6Address.IPv6AddressConverter converter;
        public static final IPv4StringBuilderOptions STANDARD_OPTS = new IPv4StringBuilderOptions(17);
        public static final IPv4StringBuilderOptions DATABASE_SEARCH_OPTS = new IPv4StringBuilderOptions();
        public static final IPv4StringBuilderOptions ALL_OPTS = new IPv4StringBuilderOptions(66367, null, new IPv6AddressSection.IPv6StringBuilderOptions(3895));

        public IPv4StringBuilderOptions() {
            this.ipv6ConverterOptions = null;
            this.converter = null;
        }

        public IPv4StringBuilderOptions(int options) {
            this(options, null, null);
        }

        public IPv4StringBuilderOptions(int options, IPv6Address.IPv6AddressConverter ipv6AddressConverter, IPv6AddressSection.IPv6StringBuilderOptions ipv6ConverterOptions) {
            super(options | (ipv6ConverterOptions == null ? 0 : 65536));
            if (this.includes(65536)) {
                if (ipv6ConverterOptions == null) {
                    ipv6ConverterOptions = new IPv6AddressSection.IPv6StringBuilderOptions(3863);
                }
                if (ipv6AddressConverter == null && (ipv6AddressConverter = IPAddress.addressConverter) == null) {
                    ipv6AddressConverter = new IPAddressConverter.DefaultAddressConverter();
                }
            }
            this.ipv6ConverterOptions = ipv6ConverterOptions;
            this.converter = ipv6AddressConverter;
        }

        public static IPv4StringBuilderOptions from(IPAddressSection.IPStringBuilderOptions opts) {
            if (opts instanceof IPv4StringBuilderOptions) {
                return (IPv4StringBuilderOptions)opts;
            }
            return new IPv4StringBuilderOptions(opts.options & 0xFFFEFCF1);
        }
    }

    static class IPv4StringCache
    extends IPAddressSection.StringCache {
        private static final IPAddressSection.StringOptions fullParams;
        private static final IPAddressSection.StringOptions canonicalParams;
        private static final IPAddressSection.StringOptions normalizedWildcardParams;
        private static final IPAddressSection.StringOptions sqlWildcardParams;
        private static final IPAddressSection.StringOptions octalParams;
        private static final IPAddressSection.StringOptions hexParams;
        static final IPAddressSection.StringOptions reverseDNSParams;
        public String octalString;
        public String hexString;

        static {
            IPAddressSection.WildcardOptions allWildcards = new IPAddressSection.WildcardOptions(IPAddressSection.WildcardOptions.WildcardOption.ALL);
            IPAddressSection.WildcardOptions allSQLWildcards = new IPAddressSection.WildcardOptions(IPAddressSection.WildcardOptions.WildcardOption.ALL, new IPAddressSection.WildcardOptions.Wildcards(IPAddress.SEGMENT_SQL_WILDCARD_STR, IPAddress.SEGMENT_SQL_SINGLE_WILDCARD_STR));
            IPAddressSection.WildcardOptions wildcardsRangeOnlyNetworkOnly = new IPAddressSection.WildcardOptions(IPAddressSection.WildcardOptions.WildcardOption.NETWORK_ONLY, new IPAddressSection.WildcardOptions.Wildcards(IPAddress.RANGE_SEPARATOR_STR));
            fullParams = new IPAddressSection.StringOptions.Builder().setExpandedSegments(true).setWildcardOptions(wildcardsRangeOnlyNetworkOnly).toParams();
            canonicalParams = new IPAddressSection.StringOptions.Builder().toParams();
            normalizedWildcardParams = new IPAddressSection.StringOptions.Builder().setWildcardOptions(allWildcards).toParams();
            sqlWildcardParams = new IPAddressSection.StringOptions.Builder().setWildcardOptions(allSQLWildcards).toParams();
            octalParams = new IPAddressSection.StringOptions.Builder().setRadix(IPv4Address.inet_aton_radix.OCTAL.getRadix()).setSegmentStrPrefix(IPv4Address.inet_aton_radix.OCTAL.getSegmentStrPrefix()).toParams();
            hexParams = new IPAddressSection.StringOptions.Builder().setRadix(IPv4Address.inet_aton_radix.HEX.getRadix()).setSegmentStrPrefix(IPv4Address.inet_aton_radix.HEX.getSegmentStrPrefix()).toParams();
            reverseDNSParams = new IPAddressSection.StringOptions.Builder().setWildcardOptions(allWildcards).setReverse(true).setAddressSuffix(".in-addr.arpa").toParams();
        }

        IPv4StringCache() {
        }
    }

    static class IPv4StringCollection
    extends IPAddressPartStringCollection {
        IPv4StringCollection() {
        }

        @Override
        protected void addAll(IPAddressPartStringCollection collections) {
            super.addAll(collections);
        }

        static class IPv4AddressSectionStringCollection
        extends IPAddressPartStringSubCollection<IPAddressPart, IPv4StringParams, IPAddressPartConfiguredString<IPAddressPart, IPv4StringParams>> {
            IPv4AddressSectionStringCollection(IPAddressPart addr) {
                super(addr);
            }

            @Override
            public Iterator<IPAddressPartConfiguredString<IPAddressPart, IPv4StringParams>> iterator() {
                return new IPAddressPartStringSubCollection.IPAddressConfigurableStringIterator(this){

                    @Override
                    public IPAddressPartConfiguredString<IPAddressPart, IPv4StringParams> next() {
                        return new IPAddressPartConfiguredString<IPAddressPart, IPv4StringParams>(part, (IPv4StringParams)this.iterator.next());
                    }
                };
            }
        }

        static class IPv4StringBuilder
        extends IPAddressPartStringCollection.AddressPartStringBuilder<IPAddressPart, IPv4StringParams, IPAddressPartConfiguredString<IPAddressPart, IPv4StringParams>, IPv4AddressSectionStringCollection, IPv4StringBuilderOptions> {
            private IPv4StringBuilder(IPAddressPart address, IPv4StringBuilderOptions options, IPv4AddressSectionStringCollection collection) {
                super(address, options, collection);
            }

            @Override
            public void addAllVariations() {
                ArrayList allParams = new ArrayList();
                ArrayList<Integer> radices = new ArrayList<Integer>();
                radices.add(10);
                if (((IPv4StringBuilderOptions)this.options).includes(512)) {
                    radices.add(16);
                }
                boolean hasDecimalOctalDups = false;
                if (((IPv4StringBuilderOptions)this.options).includes(256)) {
                    radices.add(8);
                    hasDecimalOctalDups = IPv4Address.inet_aton_radix.OCTAL.getSegmentStrPrefix().equals("0") && IPAddressSection.isDecimalSameAsOctal(false, this.addressSection);
                }
                Iterator iterator = radices.iterator();
                while (iterator.hasNext()) {
                    ArrayList<IPv4StringParams> radixParams;
                    block20: {
                        boolean allExpandable;
                        int radix;
                        block17: {
                            radix = (Integer)iterator.next();
                            radixParams = new ArrayList<IPv4StringParams>();
                            IPv4StringParams stringParams = new IPv4StringParams(radix);
                            radixParams.add(stringParams);
                            switch (radix) {
                                case 8: {
                                    stringParams.setSegmentStrPrefix(IPv4Address.inet_aton_radix.OCTAL.getSegmentStrPrefix());
                                    break;
                                }
                                case 16: {
                                    stringParams.setSegmentStrPrefix(IPv4Address.inet_aton_radix.HEX.getSegmentStrPrefix());
                                }
                            }
                            if (!((IPv4StringBuilderOptions)this.options).includes(48)) break block17;
                            int[] expandables = this.getExpandableSegments(radix);
                            int i = 0;
                            while (i < this.addressSection.getDivisionCount()) {
                                int expansionLength = expandables[i];
                                int len = radixParams.size();
                                while (expansionLength > 0) {
                                    int j = 0;
                                    while (j < len) {
                                        block19: {
                                            IPv4StringParams clone;
                                            block18: {
                                                clone = (IPv4StringParams)radixParams.get(j);
                                                if (!hasDecimalOctalDups || radix != 10) break block18;
                                                boolean isDup = true;
                                                int k = 0;
                                                while (k < this.addressSection.getDivisionCount()) {
                                                    int length;
                                                    if (k != i && (length = clone.getExpandedSegmentLength(k)) == 0) {
                                                        isDup = false;
                                                        break;
                                                    }
                                                    ++k;
                                                }
                                                if (isDup) break block19;
                                            }
                                            clone = clone.clone();
                                            clone.expandSegment(i, expansionLength, this.addressSection.getDivisionCount());
                                            radixParams.add(clone);
                                        }
                                        ++j;
                                    }
                                    if (!((IPv4StringBuilderOptions)this.options).includes(112)) break;
                                    --expansionLength;
                                }
                                ++i;
                            }
                            break block20;
                        }
                        if (((IPv4StringBuilderOptions)this.options).includes(16) && (allExpandable = this.isExpandable(radix))) {
                            IPv4StringParams expandParams = new IPv4StringParams(10);
                            expandParams.expandSegments(true);
                            radixParams.add(expandParams);
                        }
                    }
                    allParams.addAll(radixParams);
                }
                int i = 0;
                while (i < allParams.size()) {
                    IPv4StringParams param = (IPv4StringParams)allParams.get(i);
                    this.addStringParam(param);
                    ++i;
                }
            }

            @Override
            protected void addStringParam(IPv4StringParams stringParams) {
                super.addStringParam(stringParams);
            }
        }

        private static class IPv4StringParams
        extends IPAddressPartStringCollection.StringParams<IPAddressPart> {
            IPv4StringParams(int radix) {
                super(radix, Character.valueOf('.'), false);
            }

            @Override
            public IPv4StringParams clone() {
                return (IPv4StringParams)super.clone();
            }
        }
    }
}

