/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IPAddressTypeException;
import inet.ipaddr.IPAddressTypeNetwork;
import inet.ipaddr.format.IPAddressDivision;
import inet.ipaddr.format.IPAddressPart;
import inet.ipaddr.format.IPAddressSegmentGrouping;
import inet.ipaddr.format.util.IPAddressPartConfiguredString;
import inet.ipaddr.format.util.IPAddressPartStringCollection;
import inet.ipaddr.format.util.IPAddressPartStringParams;
import inet.ipaddr.format.util.sql.IPAddressSQLTranslator;
import inet.ipaddr.format.util.sql.MySQLTranslator;
import inet.ipaddr.format.util.sql.SQLStringMatcher;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.function.Supplier;

public abstract class IPAddressSection
extends IPAddressSegmentGrouping {
    private static final long serialVersionUID = 1L;
    private static final IPAddressPart[] EMPTY_PARTS = new IPAddressPart[0];
    private transient byte[] lowerBytes;
    protected transient SectionCache sectionCache;

    protected IPAddressSection(IPAddressSegment[] segments, byte[] bytes, boolean cloneSegments, boolean cloneBytes) {
        super(cloneSegments ? (IPAddressDivision[])segments.clone() : segments);
        Integer previousSegmentPrefix = null;
        IPAddressSegment[] iPAddressSegmentArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            IPAddressSegment segment = iPAddressSegmentArray[n2];
            if (segment == null) {
                throw new NullPointerException("null segment");
            }
            Integer segPrefix = segment.getSegmentPrefixLength();
            if (previousSegmentPrefix != null && (segPrefix == null || segPrefix != 0)) {
                throw new IllegalArgumentException("Segments invalid due to inconsistent prefix values");
            }
            previousSegmentPrefix = segPrefix;
            ++n2;
        }
        if (bytes != null) {
            this.setBytes(cloneBytes ? (byte[])bytes.clone() : bytes);
        }
    }

    protected static <S extends IPAddressSegment> S[] toSegments(byte[] bytes, int segmentCount, int bytesPerSegment, int bitsPerSegment, IPAddressTypeNetwork.IPAddressSegmentCreator<S> creator, Integer networkPrefixLength) {
        return IPAddress.toSegments((byte[])bytes, null, (int)segmentCount, (int)bytesPerSegment, (int)bitsPerSegment, creator, (Integer)networkPrefixLength);
    }

    protected static <S extends IPAddressSegment> S[] toCIDRSegments(Integer bits, S[] segments, IPAddressTypeNetwork.IPAddressSegmentCreator<S> segmentCreator, BiFunction<S, Integer, S> segProducer) {
        segments = (IPAddressSegment[])segments.clone();
        if (bits != null) {
            int i = 0;
            while (i < segments.length) {
                S seg = segments[i];
                int bitCount = ((IPAddressDivision)seg).getBitCount();
                Integer segmentPrefixLength = IPAddressSection.getSegmentPrefixLength(bitCount, bits, i);
                segments[i] = (IPAddressSegment)segProducer.apply(seg, segmentPrefixLength);
                ++i;
            }
        }
        return segments;
    }

    protected void initCachedValues(Integer prefixLen, boolean network, Integer cachedNetworkPrefix, Integer cachedMinPrefix, Integer cachedEquivalentPrefix, BigInteger cachedCount, IPAddressSegmentGrouping.RangeList zeroSegments, IPAddressSegmentGrouping.RangeList zeroRanges) {
        if (this.sectionCache == null) {
            this.sectionCache = new SectionCache();
        }
        if (network) {
            this.setNetworkMaskPrefix(prefixLen);
        } else {
            this.setHostMaskPrefix(prefixLen);
        }
        super.initCachedValues(cachedNetworkPrefix, cachedCount);
        this.sectionCache.cachedMinPrefix = cachedMinPrefix;
        this.sectionCache.cachedEquivalentPrefix = cachedEquivalentPrefix;
    }

    protected static IPAddressSegmentGrouping.RangeList getNoZerosRange() {
        return IPAddressSegmentGrouping.getNoZerosRange();
    }

    protected static IPAddressSegmentGrouping.RangeList getSingleRange(int index, int len) {
        return IPAddressSegmentGrouping.getSingleRange(index, len);
    }

    public abstract int getBitsPerSegment();

    @Override
    public int getBitCount() {
        return this.getSegmentCount() * this.getBitsPerSegment();
    }

    @Override
    public int getByteCount() {
        return this.getSegmentCount() * this.getBytesPerSegment();
    }

    public static int bitsPerSegment(IPAddress.IPVersion version) {
        return IPAddressSegment.getBitCount(version);
    }

    public abstract int getBytesPerSegment();

    public static int bytesPerSegment(IPAddress.IPVersion version) {
        return IPAddressSegment.getBitCount(version);
    }

    public boolean isIPv4() {
        return false;
    }

    public boolean isIPv6() {
        return false;
    }

    public abstract IPAddress.IPVersion getIPVersion();

    protected static int getSegmentIndex(Integer networkPrefixLength, int byteLength, int bytesPerSegment) {
        int byteIndex = IPAddressSection.getByteIndex(networkPrefixLength, byteLength);
        return byteIndex / bytesPerSegment;
    }

    protected static int getByteIndex(Integer networkPrefixLength, int byteLength) {
        if (networkPrefixLength == null) {
            return byteLength;
        }
        if (networkPrefixLength < 0 || networkPrefixLength > byteLength * 8) {
            throw new IPAddressTypeException(networkPrefixLength, "ipaddress.error.prefixSize");
        }
        return Math.min(networkPrefixLength - 1 >> 3, byteLength);
    }

    public abstract int getByteIndex(Integer var1);

    public abstract int getSegmentIndex(Integer var1);

    protected abstract IPAddressTypeNetwork.IPAddressSegmentCreator<?> getSegmentCreator();

    protected abstract IPAddressTypeNetwork.IPAddressCreator<?, ?, ?> getAddressCreator();

    public abstract IPAddressSection getNetworkSection(int var1, boolean var2);

    public abstract IPAddressSection getNetworkSection(int var1);

    protected boolean isNetworkSection(int networkPrefixLength, boolean withPrefixLength) {
        int segmentCount = this.getSegmentCount();
        if (segmentCount == 0) {
            return true;
        }
        int prefixedSegment = this.getSegmentIndex(networkPrefixLength);
        if (prefixedSegment + 1 < segmentCount) {
            return false;
        }
        int lastSegmentIndex = segmentCount - 1;
        int bitsPerSegment = this.getBitsPerSegment();
        int segmentPrefixLength = networkPrefixLength - lastSegmentIndex * bitsPerSegment;
        return !this.getSegment(lastSegmentIndex).isNetworkChangedByPrefix(IPAddressSection.getSegmentPrefixLength(bitsPerSegment, segmentPrefixLength), withPrefixLength);
    }

    protected boolean isHostSection(int networkPrefixLength) {
        int segmentCount = this.getSegmentCount();
        if (segmentCount == 0) {
            return true;
        }
        if (networkPrefixLength >= this.getBitsPerSegment()) {
            return false;
        }
        return !this.getSegment(0).isHostChangedByPrefix(networkPrefixLength);
    }

    public abstract IPAddressSection getHostSection(int var1);

    private Integer checkForPrefixMask(boolean network) {
        int back;
        int front;
        if (network) {
            front = this.getSegment(0).getMaxSegmentValue();
            back = 0;
        } else {
            back = this.getSegment(0).getMaxSegmentValue();
            front = 0;
        }
        int prefixLen = 0;
        int i = 0;
        while (i < this.getSegmentCount()) {
            IPAddressSegment seg = this.getSegment(i);
            int value = seg.getLowerSegmentValue();
            if (value != front) {
                Integer segmentPrefixLen = seg.getMaskPrefixLength(network);
                if (segmentPrefixLen == null) {
                    return null;
                }
                prefixLen += segmentPrefixLen.intValue();
                ++i;
                while (i < this.getSegmentCount()) {
                    value = this.getSegment(i).getLowerSegmentValue();
                    if (value != back) {
                        return null;
                    }
                    ++i;
                }
            } else {
                prefixLen += seg.getBitCount();
            }
            ++i;
        }
        return prefixLen;
    }

    public Integer getMaskPrefixLength(boolean network) {
        Integer prefixLen;
        if (network) {
            if (this.hasNoSectionCache() || (prefixLen = this.sectionCache.networkMaskPrefixLen) == null) {
                prefixLen = this.setNetworkMaskPrefix(this.checkForPrefixMask(network));
            }
        } else if (this.hasNoSectionCache() || (prefixLen = this.sectionCache.hostMaskPrefixLen) == null) {
            prefixLen = this.setHostMaskPrefix(this.checkForPrefixMask(network));
        }
        if (prefixLen < 0) {
            return null;
        }
        return prefixLen;
    }

    private Integer setHostMaskPrefix(Integer prefixLen) {
        if (prefixLen == null) {
            Integer n = -1;
            this.sectionCache.hostMaskPrefixLen = n;
            prefixLen = n;
        } else {
            this.sectionCache.hostMaskPrefixLen = prefixLen;
            this.sectionCache.networkMaskPrefixLen = -1;
        }
        return prefixLen;
    }

    private Integer setNetworkMaskPrefix(Integer prefixLen) {
        if (prefixLen == null) {
            Integer n = -1;
            this.sectionCache.networkMaskPrefixLen = n;
            prefixLen = n;
        } else {
            this.sectionCache.networkMaskPrefixLen = prefixLen;
            this.sectionCache.hostMaskPrefixLen = -1;
        }
        return prefixLen;
    }

    protected static <T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment> R getNetworkSegments(R original, int networkPrefixLength, int networkSegmentCount, boolean withPrefixLength, IPAddressTypeNetwork.IPAddressCreator<T, R, S> creator, BiFunction<Integer, Integer, S> segProducer) {
        int bitsPerSegment;
        if (networkPrefixLength < 0 || networkPrefixLength > original.getBitCount()) {
            throw new IPAddressTypeException(original, networkPrefixLength, "ipaddress.error.prefixSize");
        }
        if (original.isNetworkSection(networkPrefixLength, withPrefixLength)) {
            return original;
        }
        int segmentCount = original.getSegmentCount();
        int totalBits = segmentCount * (bitsPerSegment = original.getBitsPerSegment());
        if (networkPrefixLength > totalBits) {
            return original;
        }
        IPAddressSegment[] result = creator.createSegmentArray(networkSegmentCount);
        if (networkSegmentCount > 0) {
            int i = 0;
            while (i < networkSegmentCount) {
                Integer prefix = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, networkPrefixLength, i);
                result[i] = (IPAddressSegment)segProducer.apply(i, prefix);
                ++i;
            }
        }
        return (R)creator.createSectionInternal(result);
    }

    protected int getNetworkSegmentCount(int networkPrefixLength) {
        int segmentCount;
        if (networkPrefixLength <= 0) {
            return 0;
        }
        int bitsPerSegment = this.getBitsPerSegment();
        int result = (networkPrefixLength + (bitsPerSegment - 1)) / bitsPerSegment;
        if (result > (segmentCount = this.getSegmentCount())) {
            return segmentCount;
        }
        return result;
    }

    protected static <T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment> R getHostSegments(R original, int networkPrefixLength, int networkSegmentCount, IPAddressTypeNetwork.IPAddressCreator<T, R, S> creator, BiFunction<Integer, Integer, S> segProducer) {
        if (networkPrefixLength < 0 || networkPrefixLength > original.getBitCount()) {
            throw new IPAddressTypeException(original, networkPrefixLength, "ipaddress.error.prefixSize");
        }
        if (original.isHostSection(networkPrefixLength) || networkPrefixLength <= 0) {
            return original;
        }
        int segmentCount = original.getSegmentCount();
        IPAddressSegment[] result = creator.createSegmentArray(networkSegmentCount);
        if (networkSegmentCount > 0) {
            int bitsPerSegment = original.getBitsPerSegment();
            int i = networkSegmentCount - 1;
            int j = segmentCount - 1;
            while (i >= 0) {
                Integer prefix = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, networkPrefixLength, j);
                result[i] = (IPAddressSegment)segProducer.apply(j, prefix);
                --i;
                --j;
            }
        }
        return (R)creator.createSectionInternal(result);
    }

    protected int getHostSegmentCount(int networkPrefixLength) {
        if (networkPrefixLength <= 0) {
            return this.getSegmentCount();
        }
        int hostBits = this.getHostBits(networkPrefixLength);
        if (hostBits <= 0) {
            return 0;
        }
        int bitsPerSegment = this.getBitsPerSegment();
        return (hostBits + bitsPerSegment - 1) / bitsPerSegment;
    }

    public Integer getHostBits() {
        if (this.isPrefixed()) {
            return this.getHostBits(this.getNetworkPrefixLength());
        }
        return null;
    }

    private int getHostBits(int networkPrefixLength) {
        return this.getSegmentCount() * this.getBitsPerSegment() - networkPrefixLength;
    }

    protected static <T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment> R getSubnetSegments(R original, R maskSection, Integer networkPrefixLength, IPAddressTypeNetwork.IPAddressCreator<T, R, S> creator, boolean verifyMask, IntFunction<S> segProducer, IntFunction<S> maskSegProducer) {
        if (networkPrefixLength != null && (networkPrefixLength < 0 || networkPrefixLength > original.getBitCount())) {
            throw new IPAddressTypeException(original, (int)networkPrefixLength, "ipaddress.error.prefixSize");
        }
        int i = 0;
        int bitsPerSegment = original.getBitsPerSegment();
        while (i < original.getSegmentCount()) {
            IPAddressSegment mask;
            Integer segmentPrefixLength = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, networkPrefixLength, i);
            IPAddressSegment seg = (IPAddressSegment)segProducer.apply(i);
            if (seg.isChangedByMask((mask = (IPAddressSegment)maskSegProducer.apply(i)).getLowerSegmentValue(), segmentPrefixLength)) {
                IPAddressSegment[] newSegments = creator.createSegmentArray(original.getSegmentCount());
                original.copySegments(0, i, newSegments, 0);
                int j = i;
                while (j < original.getSegmentCount()) {
                    segmentPrefixLength = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, networkPrefixLength, j);
                    seg = (IPAddressSegment)segProducer.apply(j);
                    mask = (IPAddressSegment)maskSegProducer.apply(j);
                    int maskValue = mask.getLowerSegmentValue();
                    if (j > i && !seg.isChangedByMask(maskValue, segmentPrefixLength)) {
                        newSegments[j] = seg;
                    } else {
                        if (verifyMask && !seg.isMaskCompatibleWithRange(maskValue, segmentPrefixLength)) {
                            throw new IPAddressTypeException(seg, mask, "ipaddress.error.maskMismatch");
                        }
                        newSegments[j] = creator.createSegment(seg.getLowerSegmentValue() & maskValue, seg.getUpperSegmentValue() & maskValue, segmentPrefixLength);
                    }
                    ++j;
                }
                return (R)creator.createSectionInternal(newSegments);
            }
            ++i;
        }
        return original;
    }

    static Integer getSplitSegmentPrefixLength(int bitsPerSegment, Integer networkPrefixLength, int segmentIndex) {
        if (networkPrefixLength != null) {
            int segmentPrefixLength = networkPrefixLength - segmentIndex * bitsPerSegment;
            return IPAddressSection.getSegmentPrefixLength(bitsPerSegment, segmentPrefixLength);
        }
        return null;
    }

    public static Integer getSegmentPrefixLength(int bitsPerSegment, Integer networkPrefixLength, int segmentIndex) {
        if (networkPrefixLength != null) {
            int segmentPrefixLength = networkPrefixLength - segmentIndex * bitsPerSegment;
            return IPAddressSection.getSegmentPrefixLength(bitsPerSegment, segmentPrefixLength);
        }
        return null;
    }

    public static Integer getSegmentPrefixLength(int bitsPerSegment, int segmentBits) {
        if (segmentBits <= 0) {
            return 0;
        }
        if (segmentBits <= bitsPerSegment) {
            return segmentBits;
        }
        return null;
    }

    static Integer getJoinedSegmentPrefixLength(int bitsPerSegment, Integer highBits, Integer lowBits) {
        if (lowBits == null) {
            return null;
        }
        if (lowBits == 0) {
            return highBits;
        }
        return lowBits + bitsPerSegment;
    }

    public abstract IPAddressNetwork getNetwork();

    public byte[] getBytes() {
        if (this.isMultiple()) {
            throw new IPAddressTypeException(this, "ipaddress.error.unavailable.numeric");
        }
        return this.getLowestBytes();
    }

    public byte[] getLowestBytes() {
        if (this.lowerBytes == null) {
            this.setBytes(this.getBytesImpl(true));
        }
        return (byte[])this.lowerBytes.clone();
    }

    void setBytes(byte[] bytes) {
        this.lowerBytes = bytes;
    }

    private byte[] getBytesImpl(boolean low) {
        int bytesPerSegment = this.getBytesPerSegment();
        int byteCount = this.getSegmentCount() * bytesPerSegment;
        byte[] bytes = new byte[byteCount];
        int i = 0;
        int n = 0;
        while (i < byteCount) {
            IPAddressSegment seg = this.getSegment(n);
            int segmentValue = low ? seg.getLowerSegmentValue() : seg.getUpperSegmentValue();
            int k = bytesPerSegment + i;
            int j = k - 1;
            while (true) {
                bytes[j] = (byte)(0xFF & segmentValue);
                if (j <= i) break;
                segmentValue >>= 8;
                --j;
            }
            i += bytesPerSegment;
            ++n;
        }
        return bytes;
    }

    public int getSegmentCount() {
        return this.getDivisionCount();
    }

    public IPAddressSegment getSegment(int index) {
        return (IPAddressSegment)this.divisions[index];
    }

    public void copySegments(int start, int end, IPAddressSegment[] segs, int index) {
        System.arraycopy(this.divisions, start, segs, index, end - start);
    }

    public static boolean isDecimalSameAsOctal(boolean checkRange, IPAddressPart part) {
        int count = part.getDivisionCount();
        int i = 0;
        while (i < count) {
            IPAddressDivision seg = part.getDivision(i);
            if (!checkRange ? seg.rangeIsWithin(0L, 7L) : seg.valueIsWithin(0L, 7L)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isContainedBy(IPAddressSection other) {
        return other.contains(this);
    }

    public boolean contains(IPAddressSection other) {
        if (this.getSegmentCount() != other.getSegmentCount()) {
            return false;
        }
        int i = 0;
        while (i < this.getSegmentCount()) {
            IPAddressSegment seg = this.getSegment(i);
            if (!seg.contains(other.getSegment(i))) {
                return false;
            }
            if (seg.isPrefixed()) break;
            ++i;
        }
        return true;
    }

    public abstract IPAddressSection[] subtract(IPAddressSection var1);

    protected static <T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment> R[] subtract(R first, R other, IPAddressTypeNetwork.IPAddressCreator<T, R, S> addrCreator, IntFunction<S> segProducer, BiFunction<R, Integer, R> prefixApplier) {
        int segCount = first.getSegmentCount();
        if (segCount != other.getSegmentCount()) {
            throw new IPAddressTypeException(first, other, "ipaddress.error.sizeMismatch");
        }
        if (!first.isMultiple()) {
            if (other.contains(first)) {
                return null;
            }
            IPAddressSection[] result = addrCreator.createSectionArray(1);
            result[0] = first;
            return result;
        }
        int i = 0;
        while (i < segCount) {
            IPAddressSegment seg = first.getSegment(i);
            IPAddressSegment otherSeg = other.getSegment(i);
            int lower = seg.getLowerSegmentValue();
            int higher = seg.getUpperSegmentValue();
            int otherLower = otherSeg.getLowerSegmentValue();
            int otherHigher = otherSeg.getUpperSegmentValue();
            if (otherLower > higher || lower > otherHigher) {
                IPAddressSection[] result = addrCreator.createSectionArray(1);
                result[0] = first;
                return result;
            }
            ++i;
        }
        IPAddressSegment[] intersections = addrCreator.createSegmentArray(segCount);
        ArrayList<IPAddressSection> sections = new ArrayList<IPAddressSection>();
        int i2 = 0;
        while (i2 < segCount) {
            IPAddressSection section;
            IPAddressSegment seg = (IPAddressSegment)segProducer.apply(i2);
            IPAddressSegment otherSeg = other.getSegment(i2);
            int lower = seg.getLowerSegmentValue();
            int higher = seg.getUpperSegmentValue();
            int otherLower = otherSeg.getLowerSegmentValue();
            int otherHigher = otherSeg.getUpperSegmentValue();
            if (lower >= otherLower) {
                if (higher <= otherHigher) {
                    intersections[i2] = seg.isPrefixed() ? addrCreator.createSegment(lower, higher, null) : seg;
                } else {
                    intersections[i2] = addrCreator.createSegment(lower, otherHigher, null);
                    section = IPAddressSection.createDiffSection(first, (int)(otherHigher + 1), (int)higher, (int)i2, addrCreator, segProducer, (IPAddressSegment[])intersections);
                    sections.add(section);
                }
            } else {
                section = IPAddressSection.createDiffSection(first, (int)lower, (int)(otherLower - 1), (int)i2, addrCreator, segProducer, (IPAddressSegment[])intersections);
                sections.add(section);
                if (higher <= otherHigher) {
                    intersections[i2] = addrCreator.createSegment(otherLower, higher, null);
                } else {
                    intersections[i2] = addrCreator.createSegment(otherLower, otherHigher, null);
                    section = IPAddressSection.createDiffSection(first, (int)(otherHigher + 1), (int)higher, (int)i2, addrCreator, segProducer, (IPAddressSegment[])intersections);
                    sections.add(section);
                }
            }
            ++i2;
        }
        if (first.isPrefixed()) {
            int thisPrefix = first.getNetworkPrefixLength();
            int i3 = 0;
            while (i3 < sections.size()) {
                int bitCount;
                IPAddressSection section = (IPAddressSection)sections.get(i3);
                int totalPrefix = bitCount = section.getBitCount();
                int j = first.getSegmentCount() - 1;
                while (j >= 0) {
                    IPAddressSegment seg = section.getSegment(j);
                    int segBitCount = seg.getBitCount();
                    int segPrefix = seg.getMinPrefix();
                    if (segPrefix == segBitCount) break;
                    totalPrefix -= segBitCount;
                    if (segPrefix != 0) {
                        totalPrefix += segPrefix;
                        break;
                    }
                    --j;
                }
                if (totalPrefix != bitCount) {
                    if (totalPrefix < thisPrefix) {
                        totalPrefix = thisPrefix;
                    }
                    section = (IPAddressSection)prefixApplier.apply(section, totalPrefix);
                    sections.set(i3, section);
                }
                ++i3;
            }
        }
        IPAddressSection[] result = addrCreator.createSectionArray(sections.size());
        sections.toArray(result);
        return result;
    }

    private static <T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment> R createDiffSection(R original, int lower, int upper, int diffIndex, IPAddressTypeNetwork.IPAddressCreator<T, R, S> addrCreator, IntFunction<S> segProducer, S[] intersectingValues) {
        int segCount = original.getSegmentCount();
        IPAddressSegment[] segments = addrCreator.createSegmentArray(segCount);
        int j = 0;
        while (j < diffIndex) {
            segments[j] = intersectingValues[j];
            ++j;
        }
        Object diff = addrCreator.createSegment(lower, upper, null);
        segments[diffIndex] = diff;
        int j2 = diffIndex + 1;
        while (j2 < segCount) {
            segments[j2] = (IPAddressSegment)segProducer.apply(j2);
            ++j2;
        }
        IPAddressSection section = addrCreator.createSectionInternal(segments);
        return (R)section;
    }

    public boolean isMaskCompatibleWithRange(IPAddressSection mask, Integer networkPrefixLength) {
        IPAddress.IPVersion version = this.getIPVersion();
        if (!version.equals((Object)mask.getIPVersion())) {
            throw new IPAddressTypeException(this, mask, "ipaddress.error.typeMismatch");
        }
        int segmentCount = this.getSegmentCount();
        if (mask.getSegmentCount() != segmentCount) {
            throw new IPAddressTypeException(this, mask, "ipaddress.error.sizeMismatch");
        }
        if (networkPrefixLength != null && (networkPrefixLength < 0 || networkPrefixLength > this.getBitCount())) {
            throw new IPAddressTypeException(this, (int)networkPrefixLength, "ipaddress.error.prefixSize");
        }
        if (this.isMultiple() && (networkPrefixLength == null || networkPrefixLength > 0)) {
            int bitsPerSegment = this.getBitsPerSegment();
            if (networkPrefixLength == null) {
                networkPrefixLength = segmentCount * bitsPerSegment;
            }
            int i = 0;
            while (i < segmentCount) {
                IPAddressSegment maskSegment;
                Integer segmentPrefix = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, networkPrefixLength);
                IPAddressSegment segment = this.getSegment(i);
                if (!segment.isMaskCompatibleWithRange((maskSegment = mask.getSegment(i)).getLowerSegmentValue(), segmentPrefix)) {
                    return false;
                }
                ++i;
                networkPrefixLength = networkPrefixLength - bitsPerSegment;
            }
        }
        return true;
    }

    public abstract IPAddressSection toSubnet(IPAddressSection var1) throws IPAddressTypeException;

    public abstract IPAddressSection toSubnet(int var1) throws IPAddressTypeException;

    protected void checkSubnet(int networkPrefixLength) throws IPAddressTypeException {
        if (networkPrefixLength < 0 || networkPrefixLength > this.getBitCount()) {
            throw new IPAddressTypeException(this, networkPrefixLength, "ipaddress.error.prefixSize");
        }
    }

    public abstract IPAddressSection toSubnet(IPAddressSection var1, Integer var2) throws IPAddressTypeException;

    protected void checkSubnet(IPAddressSection mask, Integer networkPrefixLength) throws IPAddressTypeException {
        int segmentCount = this.getSegmentCount();
        if (mask.getSegmentCount() != segmentCount) {
            throw new IPAddressTypeException(this, mask, "ipaddress.error.sizeMismatch");
        }
    }

    public IPAddressSection toPrefixedEquivalent() {
        if (!this.isMultiple()) {
            return this;
        }
        Integer newPrefix = this.getEquivalentPrefix();
        return newPrefix == null ? null : this.toSubnet(newPrefix);
    }

    public IPAddressSection toMinimalPrefixed() {
        return this.toSubnet(this.getMinPrefix());
    }

    public IPAddressSection toSupernet(Integer prefixLengthDecrement) {
        int newPrefix = this.getSupernetPrefix(prefixLengthDecrement);
        return this.toSubnet(newPrefix);
    }

    public IPAddressSection toSupernet() {
        return this.toSupernet(null);
    }

    int getSupernetPrefix(Integer prefixLengthDecrement) {
        int bits;
        Integer prefix = this.getNetworkPrefixLength();
        if (prefixLengthDecrement == null) {
            int adjustment;
            int bitsPerSegment = this.getBitsPerSegment();
            bits = prefix == null ? bitsPerSegment : ((adjustment = prefix % bitsPerSegment) > 0 ? adjustment : bitsPerSegment);
        } else {
            bits = prefixLengthDecrement;
        }
        if (prefix == null) {
            prefix = this.getBitCount();
        }
        int newPrefix = prefix <= bits ? 0 : prefix - bits;
        return newPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasNoSectionCache() {
        if (this.sectionCache == null) {
            IPAddressSection iPAddressSection = this;
            synchronized (iPAddressSection) {
                block5: {
                    if (this.sectionCache != null) break block5;
                    this.sectionCache = new SectionCache();
                    return true;
                }
            }
        }
        return false;
    }

    public int getMinPrefix() {
        Integer result;
        if (this.hasNoSectionCache() || (result = this.sectionCache.cachedMinPrefix) == null) {
            int totalPrefix = this.getBitCount();
            int i = this.getSegmentCount() - 1;
            while (i >= 0) {
                IPAddressSegment seg = this.getSegment(i);
                int segBitCount = seg.getBitCount();
                int segPrefix = seg.getMinPrefix();
                if (segPrefix == segBitCount) break;
                totalPrefix -= segBitCount;
                if (segPrefix != 0) {
                    totalPrefix += segPrefix;
                    break;
                }
                --i;
            }
            result = totalPrefix;
            this.sectionCache.cachedMinPrefix = result;
        }
        return result;
    }

    public Integer getEquivalentPrefix() {
        Integer result;
        if (!this.hasNoSectionCache() && (result = this.sectionCache.cachedEquivalentPrefix) != null) {
            if (result < 0) {
                return null;
            }
            return result;
        }
        int totalPrefix = 0;
        int i = 0;
        while (i < this.getSegmentCount()) {
            int segPrefix;
            IPAddressSegment seg = this.getSegment(i);
            if (!seg.isRangeEquivalent(segPrefix = seg.getMinPrefix())) {
                this.sectionCache.cachedEquivalentPrefix = -1;
                return null;
            }
            if (seg.isPrefixed()) {
                Integer n = totalPrefix + segPrefix;
                this.sectionCache.cachedEquivalentPrefix = n;
                return n;
            }
            if (segPrefix < seg.getBitCount()) {
                ++i;
                while (i < this.getSegmentCount()) {
                    IPAddressSegment laterSeg = this.getSegment(i);
                    if (!laterSeg.isFullRange()) {
                        this.sectionCache.cachedEquivalentPrefix = -1;
                        return null;
                    }
                    ++i;
                }
                Integer n = totalPrefix + segPrefix;
                this.sectionCache.cachedEquivalentPrefix = n;
                return n;
            }
            totalPrefix += segPrefix;
            ++i;
        }
        Integer n = totalPrefix;
        this.sectionCache.cachedEquivalentPrefix = n;
        return n;
    }

    public abstract IPAddressSection getLowerSection();

    public abstract IPAddressSection getUpperSection();

    public abstract IPAddressSegment[] getLowerSegments();

    public abstract IPAddressSegment[] getUpperSegments();

    public abstract IPAddressSegment[] getSegments();

    protected static <R extends IPAddressSection, S extends IPAddressSegment> S[] getSingle(R original, S[] originalSegs, IPAddressTypeNetwork.IPAddressSegmentCreator<S> segmentCreator, IntFunction<S> segProducer, boolean allowTheseSegments) {
        if (!original.isPrefixed() && !original.isMultiple()) {
            if (allowTheseSegments) {
                return originalSegs;
            }
            return (IPAddressSegment[])originalSegs.clone();
        }
        return IPAddressSection.createSingle(original, segmentCreator, segProducer);
    }

    protected static <R extends IPAddressSection, S extends IPAddressSegment> S[] createSingle(R original, IPAddressTypeNetwork.IPAddressSegmentCreator<S> segmentCreator, IntFunction<S> segProducer) {
        int segmentCount = original.getSegmentCount();
        IPAddressSegment[] segs = segmentCreator.createSegmentArray(segmentCount);
        int i = 0;
        while (i < segmentCount) {
            segs[i] = (IPAddressSegment)segProducer.apply(i);
            ++i;
        }
        return segs;
    }

    protected static <T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment> R createSection(IPAddressTypeNetwork.IPAddressCreator<T, R, S> creator, S[] segs) {
        return (R)creator.createSectionInternal((IPAddressSegment[])segs);
    }

    protected static <R extends IPAddressSection> R getSingle(R original, Supplier<R> singleFromMultipleCreator) {
        if (!original.isPrefixed() && !original.isMultiple()) {
            return original;
        }
        return (R)((IPAddressSection)singleFromMultipleCreator.get());
    }

    public abstract Iterator<? extends IPAddressSection> sectionIterator();

    public abstract Iterator<? extends IPAddressSegment[]> iterator();

    protected <S extends IPAddressSegment> Iterator<S[]> iterator(IPAddressTypeNetwork.IPAddressSegmentCreator<S> segmentCreator, boolean skipThis, final Supplier<S[]> segs, final IntFunction<Iterator<S>> segIteratorProducer) {
        if (!this.isMultiple()) {
            return new Iterator<S[]>(skipThis){
                boolean done;
                {
                    this.done = bl;
                }

                @Override
                public boolean hasNext() {
                    return !this.done;
                }

                @Override
                public S[] next() {
                    if (this.done) {
                        throw new NoSuchElementException();
                    }
                    this.done = true;
                    return (IPAddressSegment[])segs.get();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<S[]>(segmentCreator, skipThis){
            private boolean done;
            final int segmentCount;
            private final Iterator<S>[] variations;
            private S[] nextSet;
            {
                this.segmentCount = IPAddressSection.this.getSegmentCount();
                this.variations = new Iterator[this.segmentCount];
                this.nextSet = iPAddressSegmentCreator.createSegmentArray(this.segmentCount);
                this.updateVariations(0);
                if (bl) {
                    this.increment();
                }
            }

            private void updateVariations(int start) {
                int i = start;
                while (i < this.segmentCount) {
                    this.variations[i] = (Iterator)segIteratorProducer.apply(i);
                    this.nextSet[i] = (IPAddressSegment)this.variations[i].next();
                    ++i;
                }
            }

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public S[] next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                IPAddressSegment[] segs = (IPAddressSegment[])this.nextSet.clone();
                this.increment();
                return segs;
            }

            private void increment() {
                int j = this.segmentCount - 1;
                while (j >= 0) {
                    if (this.variations[j].hasNext()) {
                        this.nextSet[j] = (IPAddressSegment)this.variations[j].next();
                        this.updateVariations(j + 1);
                        return;
                    }
                    --j;
                }
                this.done = true;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean isEntireAddress() {
        return this.getSegmentCount() == IPAddress.segmentCount(this.getIPVersion());
    }

    public String[] getSegmentStrings() {
        String[] result = new String[this.getSegmentCount()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getSegment(i).getWildcardString();
            ++i;
        }
        return result;
    }

    @Override
    public String toString() {
        return this.toNormalizedString();
    }

    public abstract String toCanonicalString();

    public abstract String toFullString();

    public abstract String toNormalizedString();

    protected abstract void cacheNormalizedString(String var1);

    public abstract String toCompressedString();

    public abstract String toNetworkPrefixLengthString();

    public abstract String toSubnetString();

    public abstract String toNormalizedWildcardString();

    public abstract String toCanonicalWildcardString();

    public abstract String toCompressedWildcardString();

    public abstract String toSQLWildcardString();

    protected abstract StringCache getStringCache();

    protected abstract boolean hasNoStringCache();

    public String toHexString(boolean withPrefix) {
        String result;
        if (this.hasNoStringCache() || (result = withPrefix ? this.getStringCache().hexStringPrefixed : this.getStringCache().hexString) == null) {
            result = this.toHexString(withPrefix, null);
            if (withPrefix) {
                this.getStringCache().hexStringPrefixed = result;
            } else {
                this.getStringCache().hexString = result;
            }
        }
        return result;
    }

    private boolean isDualString() {
        int count = this.getSegmentCount();
        int i = 0;
        while (i < count) {
            IPAddressSegment segment = this.getSegment(i);
            if (!segment.isRangeEquivalentToPrefix()) {
                boolean isLastFull = true;
                IPAddressSegment lastSegment = null;
                int j = count - 1;
                while (j >= 0) {
                    segment = this.getSegment(j);
                    if (segment.isMultiple()) {
                        if (!isLastFull) {
                            throw new IPAddressTypeException(segment, i, lastSegment, i + 1, "ipaddress.error.segmentMismatch");
                        }
                        isLastFull = segment.isFullRange();
                    } else {
                        isLastFull = false;
                    }
                    lastSegment = segment;
                    --j;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String toHexString(boolean withPrefix, String zone) {
        if (this.isDualString()) {
            return this.toNormalizedStringRange(withPrefix ? StringCache.hexPrefixedParams : StringCache.hexParams, zone);
        }
        return this.toNormalizedString(withPrefix ? StringCache.hexPrefixedParams : StringCache.hexParams);
    }

    protected static IPAddressPartStringCollection.StringParams<IPAddressPart> toParams(StringOptions opts) {
        IPAddressPartStringCollection.StringParams result = (IPAddressPartStringCollection.StringParams)IPAddressSection.getCachedParams(opts);
        if (result == null) {
            result = new IPAddressPartStringCollection.StringParams(opts.base, opts.separator, opts.uppercase);
            result.expandSegments(opts.expandSegments);
            result.setWildcardOption(opts.wildcardOptions);
            result.setSegmentStrPrefix(opts.segmentStrPrefix);
            result.setAddressSuffix(opts.addrSuffix);
            result.setAddressLabel(opts.addrPrefix);
            result.setReverse(opts.reverse);
            result.setSplitDigits(opts.splitDigits);
            IPAddressSection.setCachedParams(opts, result);
        }
        return result;
    }

    protected String toNormalizedStringRange(StringOptions stringOptions, String zone) {
        StringBuilder builder;
        IPAddressSection part1 = this.getLowerSection();
        IPAddressSection part2 = this.getUpperSection();
        IPAddressPartStringCollection.StringParams<IPAddressPart> params = IPAddressSection.toParams(stringOptions);
        int length = params.getStringLength(part1) + params.getStringLength(part2);
        String separator = params.getWildcardOption().wildcards.rangeSeparator;
        if (separator != null) {
            builder = new StringBuilder(length += separator.length());
            params.append(params.append(builder, part1).append(separator), part2);
        } else {
            builder = new StringBuilder(length);
            params.append(params.append(builder, part1), part2);
        }
        params.checkLengths(length, builder);
        return builder.toString();
    }

    protected String toNormalizedString(StringOptions stringOptions, String zone) {
        return this.toNormalizedString(stringOptions);
    }

    public String toNormalizedString(StringOptions stringOptions) {
        return IPAddressSection.toNormalizedString(stringOptions, this);
    }

    public static String toNormalizedString(StringOptions opts, IPAddressPart section) {
        return IPAddressSection.toParams(opts).toString(section);
    }

    public IPAddressPartStringCollection toStandardStringCollection() {
        return this.toStringCollection(new IPStringBuilderOptions(16));
    }

    public IPAddressPartStringCollection toAllStringCollection() {
        return this.toStringCollection(new IPStringBuilderOptions(48));
    }

    public IPAddressPartStringCollection toDatabaseSearchStringCollection() {
        return this.toStringCollection(new IPStringBuilderOptions());
    }

    public abstract IPAddressPartStringCollection toStringCollection(IPStringBuilderOptions var1);

    public IPAddressPart[] getParts(IPStringBuilderOptions options) {
        if (options.includes(1)) {
            return new IPAddressPart[]{this};
        }
        return EMPTY_PARTS;
    }

    public void getStartsWithSQLClause(StringBuilder builder, String expression) {
        this.getStartsWithSQLClause(builder, expression, new MySQLTranslator());
    }

    public void getStartsWithSQLClause(StringBuilder builder, String expression, IPAddressSQLTranslator translator) {
        this.getStartsWithSQLClause(builder, expression, true, translator);
    }

    private void getStartsWithSQLClause(StringBuilder builder, String expression, boolean isFirstCall, IPAddressSQLTranslator translator) {
        if (isFirstCall && this.isMultiple()) {
            Iterator<? extends IPAddressSection> sectionIterator = this.sectionIterator();
            builder.append('(');
            boolean isNotFirst = false;
            while (sectionIterator.hasNext()) {
                if (isNotFirst) {
                    builder.append(" OR ");
                } else {
                    isNotFirst = true;
                }
                IPAddressSection next = sectionIterator.next();
                next.getStartsWithSQLClause(builder, expression, false, translator);
            }
            builder.append(')');
        } else if (this.getSegmentCount() > 0) {
            IPAddressPartStringCollection createdStringCollection = this.toDatabaseSearchStringCollection();
            boolean isNotFirst = false;
            if (createdStringCollection.size() > 1) {
                builder.append('(');
            }
            boolean isEntireAddress = this.isEntireAddress();
            for (IPAddressPartConfiguredString<?, ?> createdStr : createdStringCollection) {
                if (isNotFirst) {
                    builder.append(" OR ");
                } else {
                    isNotFirst = true;
                }
                SQLStringMatcher matcher = createdStr.getNetworkStringMatcher(isEntireAddress, translator);
                matcher.getSQLCondition(builder.append('('), expression).append(')');
            }
            if (createdStringCollection.size() > 1) {
                builder.append(')');
            }
        }
    }

    protected static IPAddressPartStringParams<?> getCachedParams(StringOptions opts) {
        return opts.cachedParams;
    }

    protected static void setCachedParams(StringOptions opts, IPAddressPartStringParams<?> cachedParams) {
        opts.cachedParams = cachedParams;
    }

    public static class IPStringBuilderOptions {
        public static final int BASIC = 1;
        public static final int LEADING_ZEROS_FULL_ALL_SEGMENTS = 16;
        public static final int LEADING_ZEROS_FULL_SOME_SEGMENTS = 48;
        public static final int LEADING_ZEROS_PARTIAL_SOME_SEGMENTS = 112;
        public final int options;

        public IPStringBuilderOptions() {
            this(1);
        }

        public IPStringBuilderOptions(int options) {
            this.options = options;
        }

        public boolean includes(int option) {
            return (option & this.options) == option;
        }

        public boolean includesAny(int option) {
            return (option & this.options) != 0;
        }

        public String toString() {
            TreeMap<Integer, String> options = new TreeMap<Integer, String>();
            Field[] fields = this.getClass().getFields();
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                int modifiers = field.getModifiers();
                if (Modifier.isFinal(modifiers) && Modifier.isStatic(modifiers)) {
                    try {
                        int constant = field.getInt(null);
                        String option = String.valueOf(field.getName()) + ": " + this.includes(constant) + System.lineSeparator();
                        options.put(constant, option);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            Collection values = options.values();
            StringBuilder builder = new StringBuilder();
            for (String val : values) {
                builder.append(val);
            }
            return builder.toString();
        }
    }

    protected static class SectionCache {
        private Integer networkMaskPrefixLen;
        private Integer hostMaskPrefixLen;
        private Integer cachedMinPrefix;
        private Integer cachedEquivalentPrefix;
        public IPAddressSection lowerSection;
        public IPAddressSection upperSection;

        protected SectionCache() {
        }
    }

    protected static class SectionIterator<T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment>
    implements Iterator<R> {
        private Iterator<S[]> iterator;
        private IPAddressTypeNetwork.IPAddressCreator<T, R, S> creator;
        private R original;

        public SectionIterator(R original, IPAddressTypeNetwork.IPAddressCreator<T, R, S> creator, Iterator<S[]> iterator) {
            this.original = original;
            this.iterator = iterator;
            this.creator = creator;
        }

        @Override
        public R next() {
            if (this.original != null) {
                R result = this.original;
                this.original = null;
                return result;
            }
            if (!this.iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            IPAddressSegment[] next = (IPAddressSegment[])this.iterator.next();
            return (R)this.creator.createSectionInternal(next);
        }

        @Override
        public boolean hasNext() {
            return this.original != null || this.iterator.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class StringCache {
        public static final StringOptions hexParams;
        public static final StringOptions hexPrefixedParams;
        public String canonicalString;
        public String normalizedWildcardString;
        public String fullString;
        public String sqlWildcardString;
        public String hexString;
        public String hexStringPrefixed;
        public String reverseDNSString;

        static {
            WildcardOptions wildcardsRangeOnlyNetworkOnly = new WildcardOptions(WildcardOptions.WildcardOption.NETWORK_ONLY, new WildcardOptions.Wildcards(IPAddress.RANGE_SEPARATOR_STR));
            hexParams = new StringOptions.Builder().setSeparator(null).setExpandedSegments(true).setWildcardOptions(wildcardsRangeOnlyNetworkOnly).setRadix(16).toParams();
            hexPrefixedParams = new StringOptions.Builder().setSeparator(null).setExpandedSegments(true).setWildcardOptions(wildcardsRangeOnlyNetworkOnly).setRadix(16).setAddressPrefix("0x").toParams();
        }

        protected StringCache() {
        }
    }

    public static class StringOptions {
        public final WildcardOptions wildcardOptions;
        public final boolean expandSegments;
        public final int base;
        public final String segmentStrPrefix;
        public final Character separator;
        public final String addrSuffix;
        public final String addrPrefix;
        public final boolean reverse;
        public final boolean splitDigits;
        public final boolean uppercase;
        IPAddressPartStringParams<?> cachedParams;

        protected StringOptions(int base, boolean expandSegments, WildcardOptions wildcardOptions, String segmentStrPrefix, Character separator, String prefix, String suffix, boolean reverse, boolean splitDigits, boolean uppercase) {
            this.expandSegments = expandSegments;
            this.wildcardOptions = wildcardOptions;
            this.base = base;
            this.segmentStrPrefix = segmentStrPrefix;
            this.separator = separator;
            this.addrSuffix = suffix;
            this.addrPrefix = prefix;
            this.reverse = reverse;
            this.splitDigits = splitDigits;
            this.uppercase = uppercase;
        }

        public static class Builder {
            public static final WildcardOptions DEFAULT_WILDCARD_OPTIONS = new WildcardOptions();
            protected WildcardOptions wildcardOptions = DEFAULT_WILDCARD_OPTIONS;
            protected boolean expandSegments;
            protected int base;
            protected String segmentStrPrefix;
            protected Character separator;
            protected String addrPrefix = "";
            protected String addrSuffix = "";
            protected boolean reverse;
            protected boolean splitDigits;
            protected boolean uppercase;

            public Builder() {
                this(10, '.');
            }

            protected Builder(int base, char separator) {
                this.base = base;
                this.separator = Character.valueOf(separator);
            }

            public Builder setWildcardOptions(WildcardOptions wildcardOptions) {
                this.wildcardOptions = wildcardOptions;
                return this;
            }

            public Builder setReverse(boolean reverse) {
                this.reverse = reverse;
                return this;
            }

            public Builder setUppercase(boolean uppercase) {
                this.uppercase = uppercase;
                return this;
            }

            public Builder setSplitDigits(boolean splitDigits) {
                this.splitDigits = splitDigits;
                return this;
            }

            public Builder setExpandedSegments(boolean expandSegments) {
                this.expandSegments = expandSegments;
                return this;
            }

            public Builder setRadix(int base) {
                this.base = base;
                return this;
            }

            public Builder setSeparator(Character separator) {
                this.separator = separator;
                return this;
            }

            public Builder setAddressPrefix(String prefix) {
                this.addrPrefix = prefix;
                return this;
            }

            public Builder setAddressSuffix(String suffix) {
                this.addrSuffix = suffix;
                return this;
            }

            public Builder setSegmentStrPrefix(String prefix) {
                this.segmentStrPrefix = prefix;
                return this;
            }

            public StringOptions toParams() {
                return new StringOptions(this.base, this.expandSegments, this.wildcardOptions, this.segmentStrPrefix, this.separator, this.addrPrefix, this.addrSuffix, this.reverse, this.splitDigits, this.uppercase);
            }
        }
    }

    public static class WildcardOptions {
        public final WildcardOption wildcardOption;
        public final Wildcards wildcards;

        public WildcardOptions() {
            this(WildcardOption.NETWORK_ONLY);
        }

        public WildcardOptions(WildcardOption wildcardOption) {
            this(wildcardOption, new Wildcards());
        }

        public WildcardOptions(WildcardOption wildcardOption, Wildcards wildcards) {
            this.wildcardOption = wildcardOption;
            this.wildcards = wildcards;
        }

        public static enum WildcardOption {
            NETWORK_ONLY,
            ALL;

        }

        public static class Wildcards {
            public final String rangeSeparator;
            public final String wildcard;
            public final String singleWildcard;

            public Wildcards() {
                this(IPAddress.RANGE_SEPARATOR_STR, IPAddress.SEGMENT_WILDCARD_STR, null);
            }

            public Wildcards(String wildcard, String singleWildcard) {
                this(IPAddress.RANGE_SEPARATOR_STR, wildcard, singleWildcard);
            }

            public Wildcards(String rangeSeparator) {
                this(rangeSeparator, null, null);
            }

            public Wildcards(String rangeSeparator, String wildcard, String singleWildcard) {
                if (rangeSeparator == null) {
                    rangeSeparator = IPAddress.RANGE_SEPARATOR_STR;
                }
                this.rangeSeparator = rangeSeparator;
                this.wildcard = wildcard;
                this.singleWildcard = singleWildcard;
            }
        }
    }
}

