/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv4;

import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressTypeNetwork;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressSection;
import inet.ipaddr.ipv4.IPv4AddressSegment;
import java.util.function.BiFunction;

public class IPv4AddressNetwork
extends IPAddressTypeNetwork<IPv4Address, IPv4AddressSegment> {
    IPv4AddressNetwork() {
        super(IPv4Address.class);
    }

    @Override
    protected BiFunction<IPv4Address, Integer, IPv4AddressSegment> getSegmentProducer() {
        return (address, index) -> address.getSegment((int)index);
    }

    protected IPv4AddressCreator createAddressCreator() {
        return new IPv4AddressCreator();
    }

    @Override
    protected IPv4Address createLoopback() {
        IPv4AddressCreator creator = this.getAddressCreator();
        IPv4AddressSegment zero = IPv4AddressSegment.ZERO_SEGMENT;
        IPv4AddressSegment[] segs = creator.createSegmentArray(4);
        segs[0] = creator.createSegment(127);
        segs[1] = segs[2] = zero;
        segs[3] = creator.createSegment(1);
        return creator.createAddressInternal(segs);
    }

    public IPv4AddressCreator getAddressCreator() {
        return (IPv4AddressCreator)super.getAddressCreator();
    }

    @Override
    public boolean isIPv4() {
        return true;
    }

    @Override
    public IPAddress.IPVersion getIPVersion() {
        return IPAddress.IPVersion.IPV4;
    }

    public static class IPv4AddressCreator
    extends IPAddressTypeNetwork.IPAddressCreator<IPv4Address, IPv4AddressSection, IPv4AddressSegment> {
        static boolean CACHE_SEGMENTS_BY_PREFIX = true;
        IPv4AddressSegment[] emptySegments = new IPv4AddressSegment[0];
        IPv4AddressSection[] emptySection = new IPv4AddressSection[0];
        private static IPv4AddressSegment[] segmentCache = new IPv4AddressSegment[256];
        private static IPv4AddressSegment[][] segmentPrefixCache;
        private static IPv4AddressSegment[] allPrefixedCache;

        static {
            allPrefixedCache = new IPv4AddressSegment[8];
            if (CACHE_SEGMENTS_BY_PREFIX) {
                segmentPrefixCache = new IPv4AddressSegment[8][];
                int i = 0;
                int digits = 2;
                while (i < segmentPrefixCache.length) {
                    IPv4AddressCreator.segmentPrefixCache[i] = new IPv4AddressSegment[digits];
                    ++i;
                    digits <<= 1;
                }
            }
        }

        public IPv4AddressSegment[] createSegmentArray(int length) {
            if (length == 0) {
                return this.emptySegments;
            }
            return new IPv4AddressSegment[length];
        }

        @Override
        public IPv4AddressSegment createSegment(int value) {
            IPv4AddressSegment result = segmentCache[value];
            if (result == null) {
                IPv4AddressCreator.segmentCache[value] = result = new IPv4AddressSegment(value);
            }
            return result;
        }

        @Override
        public IPv4AddressSegment createSegment(int value, Integer segmentPrefixLength) {
            if (segmentPrefixLength == null) {
                return this.createSegment(value);
            }
            if (segmentPrefixLength == 0) {
                return IPv4AddressSegment.ZERO_PREFIX_SEGMENT;
            }
            if (CACHE_SEGMENTS_BY_PREFIX) {
                int valueIndex;
                int bitsPerSegment = 8;
                if (segmentPrefixLength > bitsPerSegment) {
                    segmentPrefixLength = bitsPerSegment;
                }
                int mask = IPv4Address.network().getSegmentNetworkMask(segmentPrefixLength);
                IPv4AddressSegment[][] cache = segmentPrefixCache;
                int prefixIndex = segmentPrefixLength - 1;
                IPv4AddressSegment result = cache[prefixIndex][valueIndex = (value &= mask) >>> bitsPerSegment - segmentPrefixLength];
                if (result == null) {
                    cache[prefixIndex][valueIndex] = result = new IPv4AddressSegment(value, segmentPrefixLength);
                }
                return result;
            }
            IPv4AddressSegment result = new IPv4AddressSegment(value, segmentPrefixLength);
            return result;
        }

        @Override
        public IPv4AddressSegment createSegment(int lower, int upper, Integer segmentPrefixLength) {
            if (segmentPrefixLength == null) {
                if (lower == upper) {
                    return this.createSegment(lower);
                }
                if (lower == 0 && upper == 255) {
                    return IPv4AddressSegment.ALL_RANGE_SEGMENT;
                }
            } else {
                if (segmentPrefixLength == 0) {
                    return this.createSegment(0, 0);
                }
                if (CACHE_SEGMENTS_BY_PREFIX) {
                    int mask = IPv4Address.network().getSegmentNetworkMask(segmentPrefixLength);
                    if ((upper & mask) == (lower &= mask)) {
                        return this.createSegment(lower, segmentPrefixLength);
                    }
                    if (lower == 0 && upper == mask) {
                        IPv4AddressSegment[] cache = allPrefixedCache;
                        int prefixIndex = segmentPrefixLength - 1;
                        IPv4AddressSegment result = cache[prefixIndex];
                        if (result == null) {
                            cache[prefixIndex] = result = new IPv4AddressSegment(0, 255, segmentPrefixLength);
                        }
                        return result;
                    }
                }
            }
            IPv4AddressSegment result = new IPv4AddressSegment(lower, upper, segmentPrefixLength);
            return result;
        }

        protected IPv4AddressSection[] createSectionArray(int length) {
            if (length == 0) {
                return this.emptySection;
            }
            return new IPv4AddressSection[length];
        }

        protected IPv4AddressSection createSectionInternal(IPv4AddressSegment[] segments) {
            return new IPv4AddressSection(segments, false);
        }

        protected IPv4AddressSection createSectionInternal(IPv4AddressSegment[] segments, IPv4AddressSection mixedSection) {
            return mixedSection;
        }

        @Override
        protected IPv4AddressSection createSectionInternal(byte[] bytes, Integer prefix) {
            return new IPv4AddressSection(bytes, prefix, false);
        }

        public IPv4AddressSection createSection(byte[] bytes, Integer prefix) {
            return new IPv4AddressSection(bytes, prefix);
        }

        public IPv4AddressSection createSection(IPv4AddressSegment[] segments, Integer networkPrefixLength) {
            return new IPv4AddressSection(segments, networkPrefixLength);
        }

        public IPv4AddressSection createSection(IPv4AddressSegment[] segments) {
            return new IPv4AddressSection(segments);
        }

        protected IPv4Address createAddressInternal(IPv4AddressSegment[] segments) {
            return this.createAddress(this.createSectionInternal(segments));
        }

        @Override
        protected IPv4Address createAddress(IPv4AddressSection section, String zone) {
            return this.createAddress(section);
        }

        public IPv4Address createAddress(IPv4AddressSection section) {
            return new IPv4Address(section);
        }
    }
}

