/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv4;

import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressConverter;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressTypeException;
import inet.ipaddr.IPAddressTypeNetwork;
import inet.ipaddr.format.IPAddressPart;
import inet.ipaddr.format.util.IPAddressPartStringCollection;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv4.IPv4AddressSection;
import inet.ipaddr.ipv4.IPv4AddressSegment;
import inet.ipaddr.ipv6.IPv6Address;
import java.net.Inet4Address;
import java.util.Iterator;

public class IPv4Address
extends IPAddress
implements Iterable<IPv4Address> {
    private static final long serialVersionUID = 1L;
    public static final char SEGMENT_SEPARATOR = '.';
    public static final int BITS_PER_SEGMENT = 8;
    public static final int BYTES_PER_SEGMENT = 1;
    public static final int SEGMENT_COUNT = 4;
    public static final int BYTE_COUNT = 4;
    public static final int BIT_COUNT = 32;
    public static final int DEFAULT_TEXTUAL_RADIX = 10;
    public static final int MAX_STRING_LEN = 15;
    public static final int MAX_VALUE_PER_SEGMENT = 255;
    private static IPv4AddressNetwork network = new IPv4AddressNetwork();

    public IPv4Address(IPv4AddressSegment[] segments, Integer networkPrefixLength) {
        this(network.getAddressCreator().createSection(segments, networkPrefixLength));
    }

    public IPv4Address(IPv4AddressSegment[] segments) {
        this(network.getAddressCreator().createSection(segments));
    }

    public IPv4Address(IPv4AddressSection section) {
        super(section);
        if (section.getSegmentCount() != 4) {
            throw new IllegalArgumentException();
        }
    }

    public IPv4Address(int address) {
        this(address, null);
    }

    public IPv4Address(int address, Integer networkPrefixLength) {
        super(IPv4Address.getAddressCreator().createSectionInternal(new byte[]{(byte)(address >> 24), (byte)(address >> 16 & 0xFF), (byte)(address >> 8 & 0xFF), (byte)(address & 0xFF)}, networkPrefixLength));
    }

    public IPv4Address(byte[] bytes) {
        this(bytes, null);
    }

    public IPv4Address(byte[] bytes, Integer networkPrefixLength) {
        super(IPv4Address.getAddressCreator().createSection(bytes, networkPrefixLength));
        if (bytes.length != 4) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public IPv4AddressSection getSection() {
        return (IPv4AddressSection)super.getSection();
    }

    @Override
    public IPv4AddressSegment getSegment(int index) {
        return this.getSection().getSegment(index);
    }

    @Override
    public IPAddressPart[] getParts(IPAddressSection.IPStringBuilderOptions options) {
        return this.getParts(IPv4AddressSection.IPv4StringBuilderOptions.from(options));
    }

    public IPAddressPart[] getParts(IPv4AddressSection.IPv4StringBuilderOptions options) {
        IPAddressPart[] parts = this.getSection().getParts(options);
        IPv6Address ipv6Addr = this.getConverted(options);
        if (ipv6Addr != null) {
            IPAddressPart[] ipv6Parts = ipv6Addr.getParts(options.ipv6ConverterOptions);
            IPAddressPart[] tmp = parts;
            parts = new IPAddressPart[tmp.length + ipv6Parts.length];
            System.arraycopy(tmp, 0, parts, 0, tmp.length);
            System.arraycopy(ipv6Parts, 0, parts, tmp.length, ipv6Parts.length);
        }
        return parts;
    }

    @Override
    public int getSegmentCount() {
        return 4;
    }

    @Override
    public int getByteCount() {
        return 4;
    }

    @Override
    public int getBitCount() {
        return 32;
    }

    @Override
    public IPv4Address toIPv4() {
        return this;
    }

    @Override
    public boolean isIPv4Convertible() {
        return true;
    }

    public IPv6Address getIPv4MappedAddress() {
        return IPv6Address.toIPv4Mapped(this);
    }

    @Override
    public boolean isIPv6Convertible() {
        IPAddressConverter conv = addressConverter;
        return conv != null && conv.isIPv6Convertible(this);
    }

    @Override
    public IPv6Address toIPv6() {
        IPAddressConverter conv = addressConverter;
        if (conv != null && conv.isIPv6Convertible(this)) {
            return conv.toIPv6(this);
        }
        return null;
    }

    private IPv4Address getLowestOrHighest(boolean lowest) {
        return IPv4Address.getSingle(this, () -> {
            IPv4AddressSection section = this.getSection();
            IPv4AddressSegment[] segs = (IPv4AddressSegment[])IPv4Address.createSingle((IPAddressSection)section, (IPAddressTypeNetwork.IPAddressSegmentCreator)IPv4Address.getAddressCreator(), (int i) -> {
                IPv4AddressSegment seg = this.getSegment(i);
                return lowest ? seg.getLower() : seg.getUpper();
            });
            return IPv4Address.getAddressCreator().createAddressInternal(segs);
        });
    }

    @Override
    public IPv4Address getLower() {
        return this.getLowestOrHighest(true);
    }

    @Override
    public IPv4Address getUpper() {
        return this.getLowestOrHighest(false);
    }

    @Override
    public Iterator<IPv4Address> iterator() {
        return IPv4Address.iterator(this, IPv4Address.getAddressCreator(), () -> this.getSection().getLowerSegments(), index -> this.getSegment(index).iterator());
    }

    public Iterable<IPv4Address> getAddresses() {
        return this;
    }

    public static IPv4AddressNetwork network() {
        return network;
    }

    private static IPv4AddressNetwork.IPv4AddressCreator getAddressCreator() {
        return network.getAddressCreator();
    }

    @Override
    public IPv4AddressNetwork getNetwork() {
        return network;
    }

    public static IPv4Address getLoopback() {
        return (IPv4Address)network.getLoopback();
    }

    public static String[] getStandardLoopbackStrings() {
        return network.getStandardLoopbackStrings();
    }

    public IPv4Address[] subtract(IPAddress other) {
        IPv4AddressSection thisSection = this.getSection();
        IPv4AddressSection[] sections = thisSection.subtract(other.getSection());
        if (sections == null) {
            return null;
        }
        IPv4AddressNetwork.IPv4AddressCreator creator = IPv4Address.getAddressCreator();
        IPv4Address[] result = new IPv4Address[sections.length];
        int i = 0;
        while (i < result.length) {
            result[i] = creator.createAddress(sections[i]);
            ++i;
        }
        return result;
    }

    @Override
    public IPv4Address toSubnet(int networkPrefixLength) throws IPAddressTypeException {
        IPv4AddressSection subnetSection;
        IPv4AddressSection thisSection = this.getSection();
        if (thisSection == (subnetSection = thisSection.toSubnet(networkPrefixLength))) {
            return this;
        }
        return IPv4Address.getAddressCreator().createAddress(subnetSection);
    }

    @Override
    public IPv4Address toSubnet(IPAddress mask) throws IPAddressTypeException {
        return this.toSubnet(mask, null);
    }

    @Override
    public IPv4Address toSubnet(IPAddress mask, Integer networkPrefixLength) throws IPAddressTypeException {
        IPv4AddressSection subnetSection;
        IPv4AddressSection thisSection = this.getSection();
        if (thisSection == (subnetSection = thisSection.toSubnet(mask.getSection(), networkPrefixLength))) {
            return this;
        }
        return IPv4Address.getAddressCreator().createAddress(subnetSection);
    }

    @Override
    public IPv4AddressSection getNetworkSection(int networkPrefixLength, boolean withPrefixLength) {
        return this.getSection().getNetworkSection(networkPrefixLength, withPrefixLength);
    }

    @Override
    public IPv4AddressSection getNetworkSection() {
        if (this.isPrefixed()) {
            return this.getNetworkSection(this.getNetworkPrefixLength(), true);
        }
        return this.getNetworkSection(this.getBitCount(), true);
    }

    @Override
    public IPv4AddressSection getHostSection(int networkPrefixLength) {
        return this.getSection().getHostSection(networkPrefixLength);
    }

    @Override
    public IPv4AddressSection getHostSection() {
        if (this.isPrefixed()) {
            return this.getHostSection(this.getNetworkPrefixLength());
        }
        return this.getHostSection(0);
    }

    @Override
    public Inet4Address toInetAddress() {
        return (Inet4Address)super.toInetAddress();
    }

    @Override
    public boolean isLinkLocal() {
        return this.getSegment(0).matches(169) && this.getSegment(1).matches(254);
    }

    @Override
    public boolean isSiteLocal() {
        IPv4AddressSegment seg0 = this.getSegment(0);
        IPv4AddressSegment seg1 = this.getSegment(1);
        return seg0.matches(10) || seg0.matches(172) && seg1.matchesWithPrefix(16, (Integer)4) || seg0.matches(192) && seg1.matches(168);
    }

    @Override
    public boolean isMulticast() {
        return this.getSegment(0).matchesWithPrefix(255, (Integer)4);
    }

    @Override
    public boolean isLoopback() {
        return this.getSegment(0).matches(127);
    }

    public String toInetAtonString(inet_aton_radix radix) {
        return this.getSection().toInetAtonString(radix);
    }

    public String toInetAtonString(inet_aton_radix radix, int joinedCount) {
        return this.getSection().toInetAtonString(radix, joinedCount);
    }

    @Override
    public String toUNCHostName() {
        return super.toCanonicalString();
    }

    @Override
    public String toReverseDNSLookupString() {
        String result;
        IPv4AddressSection section = this.getSection();
        if (section.hasNoStringCache() || (result = section.stringCache.reverseDNSString) == null) {
            section.stringCache.reverseDNSString = result = this.toNormalizedString(IPv4AddressSection.IPv4StringCache.reverseDNSParams);
        }
        return result;
    }

    @Override
    public IPAddressPartStringCollection toStandardStringCollection() {
        return this.toStringCollection(IPv4AddressSection.IPv4StringBuilderOptions.STANDARD_OPTS);
    }

    @Override
    public IPAddressPartStringCollection toAllStringCollection() {
        return this.toStringCollection(IPv4AddressSection.IPv4StringBuilderOptions.ALL_OPTS);
    }

    @Override
    public IPAddressPartStringCollection toStringCollection(IPAddressSection.IPStringBuilderOptions opts) {
        return this.toStringCollection(IPv4AddressSection.IPv4StringBuilderOptions.from(opts));
    }

    private IPv6Address getConverted(IPv4AddressSection.IPv4StringBuilderOptions opts) {
        if (opts.includes(65536)) {
            IPv6Address.IPv6AddressConverter converter = opts.converter;
            return converter.toIPv6(this);
        }
        return null;
    }

    public IPAddressPartStringCollection toStringCollection(IPv4AddressSection.IPv4StringBuilderOptions opts) {
        IPv4AddressSection.IPv4StringCollection coll = new IPv4AddressSection.IPv4StringCollection();
        IPAddressPartStringCollection sectionColl = this.getSection().toStringCollection(opts);
        coll.addAll(sectionColl);
        IPv6Address ipv6Addr = this.getConverted(opts);
        if (ipv6Addr != null) {
            IPAddressPartStringCollection ipv6StringCollection = ipv6Addr.toStringCollection(opts.ipv6ConverterOptions);
            coll.addAll(ipv6StringCollection);
        }
        return coll;
    }

    public static interface IPv4AddressConverter {
        public IPv4Address toIPv4(IPAddress var1);
    }

    public static enum inet_aton_radix {
        OCTAL,
        HEX,
        DECIMAL;


        int getRadix() {
            if (this == OCTAL) {
                return 8;
            }
            if (this == HEX) {
                return 16;
            }
            return 10;
        }

        String getSegmentStrPrefix() {
            if (this == OCTAL) {
                return "0";
            }
            if (this == HEX) {
                return "0x";
            }
            return null;
        }
    }
}

