/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv6;

import inet.ipaddr.Address;
import inet.ipaddr.AddressConversionException;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressPositionException;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressValueException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressConverter;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressSegmentSeries;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.PrefixLenException;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.IPAddressStringDivisionSeries;
import inet.ipaddr.format.util.IPAddressPartStringCollection;
import inet.ipaddr.format.validate.Validator;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv4.IPv4AddressSection;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import inet.ipaddr.ipv6.IPv6AddressSection;
import inet.ipaddr.ipv6.IPv6AddressSegment;
import inet.ipaddr.mac.MACAddress;
import inet.ipaddr.mac.MACAddressNetwork;
import inet.ipaddr.mac.MACAddressSection;
import inet.ipaddr.mac.MACAddressSegment;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class IPv6Address
extends IPAddress
implements Iterable<IPv6Address> {
    private static final long serialVersionUID = 4L;
    public static final char SEGMENT_SEPARATOR = ':';
    public static final char ZONE_SEPARATOR = '%';
    public static final char ALTERNATIVE_ZONE_SEPARATOR = '\u00a7';
    public static final char UNC_SEGMENT_SEPARATOR = '-';
    public static final char UNC_ZONE_SEPARATOR = 's';
    public static final char UNC_RANGE_SEPARATOR = '\u00bb';
    public static final String UNC_RANGE_SEPARATOR_STR = String.valueOf('\u00bb');
    public static final String UNC_SUFFIX = ".ipv6-literal.net";
    public static final String REVERSE_DNS_SUFFIX = ".ip6.arpa";
    public static final String REVERSE_DNS_SUFFIX_DEPRECATED = ".ip6.int";
    public static final int BITS_PER_SEGMENT = 16;
    public static final int BYTES_PER_SEGMENT = 2;
    public static final int SEGMENT_COUNT = 8;
    public static final int MIXED_REPLACED_SEGMENT_COUNT = 2;
    public static final int MIXED_ORIGINAL_SEGMENT_COUNT = 6;
    public static final int BYTE_COUNT = 16;
    public static final int BIT_COUNT = 128;
    public static final int DEFAULT_TEXTUAL_RADIX = 16;
    public static final int MAX_VALUE_PER_SEGMENT = 65535;
    private final String zone;
    private transient ValueCache valueCache;
    private transient IPv6AddressSection.IPv6StringCache stringCache;
    transient IPv6AddressSection.AddressCache sectionCache;

    IPv6Address(IPv6AddressSection section, CharSequence zone, boolean checkZone) throws AddressValueException {
        super(section);
        if (section.getSegmentCount() != 8) {
            throw new AddressValueException("ipaddress.error.ipv6.invalid.segment.count", section.getSegmentCount());
        }
        if (section.addressSegmentIndex != 0) {
            throw new AddressPositionException(section.addressSegmentIndex);
        }
        this.zone = checkZone ? IPv6Address.checkZone(zone) : (zone != null && zone.length() > 0 ? zone.toString() : null);
    }

    public IPv6Address(IPv6AddressSection section, CharSequence zone) throws AddressValueException {
        this(section, zone, true);
    }

    public IPv6Address(IPv6AddressSection section) throws AddressValueException {
        this(section, (CharSequence)null);
    }

    public IPv6Address(IPv6AddressSegment[] segments) throws AddressValueException {
        this(segments, null, null);
    }

    public IPv6Address(IPv6AddressSegment[] segments, Integer networkPrefixLength) throws AddressValueException {
        this(segments, networkPrefixLength, null);
    }

    public IPv6Address(IPv6AddressSegment[] segments, CharSequence zone) throws AddressValueException {
        this(segments, null, zone);
    }

    private IPv6Address(IPv6AddressSegment[] segments, Integer networkPrefixLength, CharSequence zone) throws AddressValueException {
        super((Address thisAddress) -> ((IPv6Address)thisAddress).getDefaultCreator().createSection(segments, networkPrefixLength));
        if (segments.length != 8) {
            throw new AddressValueException("ipaddress.error.ipv6.invalid.segment.count", segments.length);
        }
        this.zone = IPv6Address.checkZone(zone);
    }

    public IPv6Address(Inet6Address inet6Address) {
        this(inet6Address.getAddress(), IPv6Address.getZone(inet6Address));
    }

    public IPv6Address(byte[] bytes, CharSequence zone) throws AddressValueException {
        this(bytes, null, zone);
    }

    public IPv6Address(byte[] bytes) throws AddressValueException {
        this(bytes, null, null);
    }

    public IPv6Address(byte[] bytes, int byteStartIndex, int byteEndIndex) throws AddressValueException {
        this(bytes, byteStartIndex, byteEndIndex, null, null);
    }

    public IPv6Address(byte[] bytes, Integer networkPrefixLength) throws AddressValueException {
        this(bytes, networkPrefixLength, null);
    }

    public IPv6Address(byte[] bytes, int byteStartIndex, int byteEndIndex, Integer networkPrefixLength) throws AddressValueException {
        this(bytes, byteStartIndex, byteEndIndex, networkPrefixLength, null);
    }

    public IPv6Address(BigInteger val) throws AddressValueException {
        this(val, null, null);
    }

    public IPv6Address(BigInteger val, Integer networkPrefixLength) throws AddressValueException {
        this(val, networkPrefixLength, null);
    }

    public IPv6Address(BigInteger val, CharSequence zone) throws AddressValueException {
        this(val, null, zone);
    }

    public IPv6Address(BigInteger val, Integer networkPrefixLength, CharSequence zone) throws AddressValueException {
        super((Address thisAddress) -> ((IPv6Address)thisAddress).getDefaultCreator().createSectionInternal(val.toByteArray(), 8, networkPrefixLength));
        this.zone = IPv6Address.checkZone(zone);
    }

    private IPv6Address(byte[] bytes, Integer networkPrefixLength, CharSequence zone) throws AddressValueException {
        this(bytes, 0, bytes.length, networkPrefixLength, zone);
    }

    private IPv6Address(byte[] bytes, int byteStartIndex, int byteEndIndex, Integer networkPrefixLength, CharSequence zone) throws AddressValueException {
        super((Address thisAddress) -> ((IPv6Address)thisAddress).getDefaultCreator().createSection(bytes, byteStartIndex, byteEndIndex, 8, networkPrefixLength));
        this.zone = IPv6Address.checkZone(zone);
    }

    public IPv6Address(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, Integer networkPrefixLength) throws AddressValueException {
        this(lowerValueProvider, upperValueProvider, networkPrefixLength, null);
    }

    public IPv6Address(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider) {
        this(lowerValueProvider, upperValueProvider, null, null);
    }

    public IPv6Address(Address.SegmentValueProvider valueProvider, Integer networkPrefixLength) throws AddressValueException {
        this(valueProvider, valueProvider, networkPrefixLength);
    }

    public IPv6Address(Address.SegmentValueProvider valueProvider) {
        this(valueProvider, (Integer)null);
    }

    public IPv6Address(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, CharSequence zone) throws AddressValueException {
        this(lowerValueProvider, upperValueProvider, null, zone);
    }

    private IPv6Address(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, Integer networkPrefixLength, CharSequence zone) throws AddressValueException {
        super((Address thisAddress) -> ((IPv6Address)thisAddress).getDefaultCreator().createFullSectionInternal(lowerValueProvider, upperValueProvider, networkPrefixLength));
        this.zone = IPv6Address.checkZone(zone);
    }

    public IPv6Address(IPv6Address prefix, MACAddress eui) throws IncompatibleAddressException {
        this(prefix.getSection(), eui.getSection());
    }

    public IPv6Address(IPv6AddressSection section, MACAddress eui) throws IncompatibleAddressException, AddressValueException {
        this(section, eui.getSection());
    }

    public IPv6Address(IPv6AddressSection section, MACAddressSection eui) throws IncompatibleAddressException, AddressValueException {
        this(section, eui, null);
    }

    public IPv6Address(IPv6AddressSection section, MACAddressSection eui, CharSequence zone) throws IncompatibleAddressException, AddressValueException {
        super((Address thisAddress) -> IPv6Address.toFullEUI64Section(section, eui, ((IPv6Address)thisAddress).getDefaultCreator(), ((IPv6Address)thisAddress).getMACNetwork().getAddressCreator()));
        this.zone = IPv6Address.checkZone(zone);
    }

    private static String checkZone(CharSequence zone) throws AddressValueException {
        if (zone == null || zone.length() == 0) {
            return null;
        }
        int invalidIndex = Validator.validateZone(zone);
        if (invalidIndex >= 0) {
            throw new AddressValueException("ipaddress.error.invalid.zone", invalidIndex);
        }
        return zone.toString();
    }

    private IPv6AddressNetwork.IPv6AddressCreator getDefaultCreator() {
        return this.getNetwork().getAddressCreator();
    }

    private IPv6AddressNetwork.IPv6AddressCreator getCreator() {
        if (!this.hasZone()) {
            return this.getDefaultCreator();
        }
        return new IPv6AddressNetwork.IPv6AddressCreator(this.getNetwork()){
            private static final long serialVersionUID = 4L;

            @Override
            protected IPv6Address createAddressInternal(IPv6AddressSegment[] segments) {
                IPv6AddressNetwork.IPv6AddressCreator creator = IPv6Address.this.getDefaultCreator();
                return creator.createAddressInternal(segments, (CharSequence)IPv6Address.this.zone);
            }

            @Override
            public IPv6Address createAddress(IPv6AddressSection section) {
                IPv6AddressNetwork.IPv6AddressCreator creator = IPv6Address.this.getDefaultCreator();
                return creator.createAddressInternal(section, (CharSequence)IPv6Address.this.zone);
            }
        };
    }

    private static CharSequence getZone(Inet6Address inet6Address) {
        NetworkInterface networkInterface = inet6Address.getScopedInterface();
        String zone = null;
        if (networkInterface == null) {
            int scopeId = inet6Address.getScopeId();
            if (scopeId != 0) {
                zone = Integer.toString(scopeId);
            }
        } else {
            zone = networkInterface.getName();
        }
        return zone;
    }

    private static IPv6AddressSection toFullEUI64Section(IPv6AddressSection section, MACAddressSection eui, IPv6AddressNetwork.IPv6AddressCreator creator, MACAddressNetwork.MACAddressCreator macCreator) throws AddressValueException, IncompatibleAddressException {
        boolean euiIsExtended = eui.isExtended();
        if (eui.addressSegmentIndex != 0) {
            throw new AddressPositionException((AddressItem)eui, eui.addressSegmentIndex);
        }
        if (section.addressSegmentIndex != 0) {
            throw new AddressPositionException((AddressItem)section, section.addressSegmentIndex);
        }
        if (section.getSegmentCount() < 4) {
            throw new AddressValueException((AddressItem)section, "ipaddress.mac.error.not.eui.convertible");
        }
        if (eui.getSegmentCount() != (euiIsExtended ? 8 : 6)) {
            throw new AddressValueException((AddressItem)eui, "ipaddress.mac.error.not.eui.convertible");
        }
        AddressSegment[] segments = creator.createSegmentArray(8);
        section.getSegments(0, 4, segments, 0);
        Integer prefLength = section.getNetworkPrefixLength();
        Integer prefixLength = prefLength != null && prefLength <= 64 ? prefLength : null;
        IPv6Address.toEUI64Segments((IPv6AddressSegment[])segments, 4, eui, 0, eui.isExtended(), creator, macCreator, prefixLength);
        return creator.createSectionInternal((IPv6AddressSegment[])segments);
    }

    static IPv6AddressSegment[] toEUI64Segments(IPv6AddressSegment[] segments, int ipv6StartIndex, MACAddressSection eui, int euiStartIndex, boolean isExtended, IPv6AddressNetwork.IPv6AddressCreator creator, MACAddressNetwork.MACAddressCreator macCreator, Integer prefixLength) throws IncompatibleAddressException {
        boolean isNotNull;
        int euiSegmentIndex = 0;
        int euiSegmentCount = eui.getSegmentCount();
        MACAddressSegment seg0 = euiStartIndex == 0 && euiSegmentIndex < euiSegmentCount ? eui.getSegment(euiSegmentIndex++) : null;
        MACAddressSegment seg1 = euiStartIndex <= 1 && euiSegmentIndex < euiSegmentCount ? eui.getSegment(euiSegmentIndex++) : null;
        MACAddressSegment seg2 = euiStartIndex <= 2 && euiSegmentIndex < euiSegmentCount ? eui.getSegment(euiSegmentIndex++) : null;
        MACAddressSegment seg3 = euiStartIndex <= 3 && euiSegmentIndex < euiSegmentCount ? eui.getSegment(euiSegmentIndex++) : null;
        MACAddressSegment seg4 = euiStartIndex <= 4 && euiSegmentIndex < euiSegmentCount ? eui.getSegment(euiSegmentIndex++) : null;
        MACAddressSegment seg5 = euiStartIndex <= 5 && euiSegmentIndex < euiSegmentCount ? eui.getSegment(euiSegmentIndex++) : null;
        MACAddressSegment seg6 = euiStartIndex <= 6 && euiSegmentIndex < euiSegmentCount ? eui.getSegment(euiSegmentIndex++) : null;
        MACAddressSegment seg7 = euiStartIndex <= 7 && euiSegmentIndex < euiSegmentCount ? eui.getSegment(euiSegmentIndex) : null;
        MACAddressSegment zeroSegment = macCreator.createSegment(0);
        MACAddressSegment ffSegment = macCreator.createSegment(255);
        MACAddressSegment feSegment = macCreator.createSegment(254);
        Integer currentPrefix = null;
        if (prefixLength != null) {
            currentPrefix = 0;
        }
        if ((isNotNull = seg0 != null) || seg1 != null) {
            if (isNotNull) {
                if (seg1 == null) {
                    seg1 = zeroSegment;
                }
            } else {
                seg0 = zeroSegment;
            }
            segments[ipv6StartIndex++] = IPv6Address.join(creator, seg0, seg1, true, currentPrefix);
        }
        if (isExtended) {
            isNotNull = seg2 != null;
            if (isNotNull || seg3 != null) {
                if (!isNotNull) {
                    seg2 = zeroSegment;
                    if (!seg3.matches(255)) {
                        throw new IncompatibleAddressException(eui, "ipaddress.mac.error.not.eui.convertible");
                    }
                }
                segments[ipv6StartIndex++] = IPv6Address.join(creator, seg2, ffSegment, currentPrefix);
            }
            if ((isNotNull = seg4 != null) || seg5 != null) {
                if (isNotNull) {
                    if (!seg4.matches(254)) {
                        throw new IncompatibleAddressException(eui, "ipaddress.mac.error.not.eui.convertible");
                    }
                    if (seg5 == null) {
                        seg5 = zeroSegment;
                    }
                }
                segments[ipv6StartIndex++] = IPv6Address.join(creator, feSegment, seg5, currentPrefix);
            }
        } else {
            if (seg2 != null) {
                segments[ipv6StartIndex++] = IPv6Address.join(creator, seg2, ffSegment, currentPrefix);
            }
            if (seg3 != null) {
                segments[ipv6StartIndex++] = IPv6Address.join(creator, feSegment, seg3, currentPrefix);
            }
            if ((isNotNull = seg4 != null) || seg5 != null) {
                if (isNotNull) {
                    if (seg5 == null) {
                        seg5 = zeroSegment;
                    }
                } else {
                    seg4 = zeroSegment;
                }
                segments[ipv6StartIndex++] = IPv6Address.join(creator, seg4, seg5, currentPrefix);
            }
        }
        if ((isNotNull = seg6 != null) || seg7 != null) {
            if (isNotNull) {
                if (seg7 == null) {
                    seg7 = zeroSegment;
                }
            } else {
                seg6 = zeroSegment;
            }
            segments[ipv6StartIndex] = IPv6Address.join(creator, seg6, seg7, currentPrefix);
        }
        return segments;
    }

    private static IPv6AddressSegment join(IPv6AddressNetwork.IPv6AddressCreator creator, MACAddressSegment macSegment0, MACAddressSegment macSegment1, Integer prefixLength) {
        return IPv6Address.join(creator, macSegment0, macSegment1, false, prefixLength);
    }

    private static IPv6AddressSegment join(IPv6AddressNetwork.IPv6AddressCreator creator, MACAddressSegment macSegment0, MACAddressSegment macSegment1, boolean flip, Integer prefixLength) {
        int lower0 = macSegment0.getLowerSegmentValue();
        int upper0 = macSegment0.getUpperSegmentValue();
        if (flip) {
            int mask2ndBit = 2;
            if (!macSegment0.matchesWithMask(mask2ndBit & lower0, mask2ndBit)) {
                throw new IncompatibleAddressException(macSegment0, "ipaddress.mac.error.not.eui.convertible");
            }
            lower0 ^= mask2ndBit;
            upper0 ^= mask2ndBit;
        }
        return creator.createSegment(lower0 << 8 | macSegment1.getLowerSegmentValue(), upper0 << 8 | macSegment1.getUpperSegmentValue(), prefixLength);
    }

    @Override
    public IPv6AddressNetwork getNetwork() {
        return IPv6Address.defaultIpv6Network();
    }

    public MACAddressNetwork getMACNetwork() {
        return IPv6Address.defaultMACNetwork();
    }

    public IPv4AddressNetwork getIPv4Network() {
        return IPv6Address.defaultIpv4Network();
    }

    @Override
    public IPv6AddressSection getSection() {
        return (IPv6AddressSection)super.getSection();
    }

    @Override
    public IPv6AddressSection getSection(int index) {
        return this.getSection().getSection(index);
    }

    @Override
    public IPv6AddressSection getSection(int index, int endIndex) {
        return this.getSection().getSection(index, endIndex);
    }

    @Override
    public IPv6AddressSegment getDivision(int index) {
        return this.getSegment(index);
    }

    @Override
    public IPv6AddressSegment getSegment(int index) {
        return this.getSection().getSegment(index);
    }

    public IPv6AddressSegment[] getSegments() {
        return this.getSection().getSegments();
    }

    public boolean isEUI64() {
        return this.getSection().isEUI64();
    }

    public MACAddress toEUI(boolean extended) {
        MACAddressSection section = this.getSection().toEUI(extended);
        if (section == null) {
            return null;
        }
        MACAddressNetwork.MACAddressCreator creator = this.getMACNetwork().getAddressCreator();
        return creator.createAddress(section);
    }

    @Override
    public IPAddressStringDivisionSeries[] getParts(IPAddressSection.IPStringBuilderOptions options) {
        return this.getParts(IPv6AddressSection.IPv6StringBuilderOptions.from(options));
    }

    public IPAddressStringDivisionSeries[] getParts(IPv6AddressSection.IPv6StringBuilderOptions options) {
        IPAddressStringDivisionSeries[] parts = this.getSection().getParts(options);
        IPv4Address ipv4Addr = this.getConverted(options);
        if (ipv4Addr != null) {
            IPAddressStringDivisionSeries[] ipv4Parts = ipv4Addr.getParts(options.ipv4ConverterOptions);
            IPAddressStringDivisionSeries[] tmp = parts;
            parts = new IPAddressStringDivisionSeries[tmp.length + ipv4Parts.length];
            System.arraycopy(tmp, 0, parts, 0, tmp.length);
            System.arraycopy(ipv4Parts, 0, parts, tmp.length, ipv4Parts.length);
        }
        return parts;
    }

    @Override
    public int getSegmentCount() {
        return 8;
    }

    @Override
    public int getByteCount() {
        return 16;
    }

    @Override
    public int getBitCount() {
        return 128;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPv6Address getLowestOrHighest(boolean lowest, boolean excludeZeroHost) {
        IPv6Address result;
        block18: {
            IPv6AddressSection.AddressCache cache;
            IPv6AddressSection sectionResult;
            block17: {
                IPv6AddressSection currentSection = this.getSection();
                sectionResult = currentSection.getLowestOrHighestSection(lowest, excludeZeroHost);
                if (sectionResult == currentSection) {
                    return this;
                }
                if (sectionResult == null) {
                    return null;
                }
                result = null;
                cache = this.sectionCache;
                if (cache == null) break block17;
                IPv6Address iPv6Address = lowest ? (excludeZeroHost ? (IPv6Address)cache.lowerNonZeroHost : (IPv6Address)cache.lower) : (result = (IPv6Address)cache.upper);
                if (iPv6Address != null) break block18;
            }
            IPv6Address iPv6Address = this;
            synchronized (iPv6Address) {
                boolean create;
                cache = this.sectionCache;
                boolean bl = create = cache == null;
                if (create) {
                    this.sectionCache = cache = new IPv6AddressSection.AddressCache();
                } else if (lowest) {
                    create = excludeZeroHost ? (result = (IPv6Address)cache.lowerNonZeroHost) == null : (result = (IPv6Address)cache.lower) == null;
                } else {
                    result = (IPv6Address)cache.upper;
                    boolean bl2 = create = result == null;
                }
                if (create) {
                    result = this.getCreator().createAddress(sectionResult);
                    if (lowest) {
                        if (excludeZeroHost) {
                            cache.lowerNonZeroHost = result;
                        } else {
                            cache.lower = result;
                        }
                    } else {
                        cache.upper = result;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public IPv6Address getLowerNonZeroHost() {
        return this.getLowestOrHighest(true, true);
    }

    @Override
    public IPv6Address getLower() {
        return this.getLowestOrHighest(true, false);
    }

    @Override
    public IPv6Address getUpper() {
        return this.getLowestOrHighest(false, false);
    }

    public IPv6Address replace(int startIndex, int endIndex, IPv6Address replacement, int replacementIndex) {
        return this.checkIdentity(this.getSection().replace(startIndex, endIndex, replacement.getSection(), replacementIndex, replacementIndex + (endIndex - startIndex)));
    }

    @Override
    public IPv6Address reverseBits(boolean perByte) {
        IPv6AddressNetwork.IPv6AddressCreator creator = this.getCreator();
        return creator.createAddress(this.getSection().reverseBits(perByte));
    }

    @Override
    public IPv6Address reverseBytes() {
        return this.checkIdentity(this.getSection().reverseBytes());
    }

    @Override
    public IPv6Address reverseBytesPerSegment() {
        return this.checkIdentity(this.getSection().reverseBytesPerSegment());
    }

    @Override
    public IPv6Address reverseSegments() {
        return this.checkIdentity(this.getSection().reverseSegments());
    }

    public Iterator<IPv6AddressSegment[]> segmentsNonZeroHostIterator() {
        return this.getSection().segmentsNonZeroHostIterator();
    }

    public Iterator<IPv6AddressSegment[]> segmentsIterator() {
        return this.getSection().segmentsIterator();
    }

    public Iterator<IPv6Address> prefixBlockIterator() {
        return this.getSection().prefixBlockIterator(this, this.getCreator());
    }

    @Override
    public Iterator<IPv6Address> iterator() {
        return this.getSection().iterator(this, this.getCreator(), false);
    }

    public Iterator<IPv6Address> nonZeroHostIterator() {
        return this.getSection().iterator(this, this.getCreator(), true);
    }

    public Iterable<IPv6Address> getIterable() {
        return this;
    }

    @Override
    public IPv6Address increment(long increment) {
        return this.checkIdentity(this.getSection().increment(increment));
    }

    @Override
    public IPv6Address incrementBoundary(long increment) {
        return this.checkIdentity(this.getSection().incrementBoundary(increment));
    }

    @Override
    public IPv4Address toIPv4() {
        IPAddressConverter conv = DEFAULT_ADDRESS_CONVERTER;
        if (conv != null) {
            return conv.toIPv4(this);
        }
        return null;
    }

    @Override
    public IPv6Address toIPv6() {
        return this;
    }

    @Override
    public boolean isIPv4Convertible() {
        IPAddressConverter conv = DEFAULT_ADDRESS_CONVERTER;
        return conv != null && conv.isIPv4Convertible(this);
    }

    @Override
    public boolean isIPv6Convertible() {
        return true;
    }

    public IPv4AddressSection toMappedIPv4Segments() {
        if (this.isIPv4Mapped()) {
            return this.getSection().getEmbeddedIPv4AddressSection();
        }
        return null;
    }

    public IPv4Address get6to4IPv4Address() {
        return this.getEmbeddedIPv4Address(2);
    }

    public IPv4Address getEmbeddedIPv4Address() {
        IPv4AddressNetwork.IPv4AddressCreator creator = this.getIPv4Network().getAddressCreator();
        return creator.createAddress(this.getSection().getEmbeddedIPv4AddressSection());
    }

    public IPv4Address getEmbeddedIPv4Address(int byteIndex) {
        if (byteIndex == 12) {
            return this.getEmbeddedIPv4Address();
        }
        IPv4AddressNetwork.IPv4AddressCreator creator = this.getIPv4Network().getAddressCreator();
        return creator.createAddress(this.getSection().getEmbeddedIPv4AddressSection(byteIndex, byteIndex + 4));
    }

    @Override
    public boolean isLocal() {
        if (this.isMulticast()) {
            IPv6AddressSegment firstSeg = this.getSegment(0);
            if (firstSeg.matchesWithMask(8, 15)) {
                return true;
            }
            if (firstSeg.getValueCount() <= 5 && (firstSeg.getLowerSegmentValue() & 0xF) >= 1 && (firstSeg.getUpperSegmentValue() & 0xF) <= 5) {
                return true;
            }
            if (firstSeg.matchesWithPrefixMask(65328, (Integer)12) && this.getSegment(6).matchesWithPrefixMask(32768, (Integer)1)) {
                return true;
            }
        }
        return this.isLinkLocal() || this.isSiteLocal() || this.isUniqueLocal() || this.isAnyLocal();
    }

    @Override
    public boolean isLinkLocal() {
        IPv6AddressSegment firstSeg = this.getSegment(0);
        return this.isMulticast() && firstSeg.matchesWithMask(2, 15) || firstSeg.matchesWithPrefixMask(65152, (Integer)10);
    }

    public boolean isSiteLocal() {
        IPv6AddressSegment firstSeg = this.getSegment(0);
        return this.isMulticast() && firstSeg.matchesWithMask(5, 15) || firstSeg.matchesWithPrefixMask(65216, (Integer)10);
    }

    public boolean isUniqueLocal() {
        return this.getSegment(0).matchesWithPrefixMask(64512, (Integer)7);
    }

    public boolean isIPv4Mapped() {
        if (this.getSegment(5).matches(65535)) {
            int i = 0;
            while (i < 5) {
                if (!this.getSegment(i).isZero()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isIPv4Compatible() {
        return this.getSegment(0).isZero() && this.getSegment(1).isZero() && this.getSegment(2).isZero() && this.getSegment(3).isZero() && this.getSegment(4).isZero() && this.getSegment(5).isZero();
    }

    public boolean is6To4() {
        return this.getSegment(0).matches(8194);
    }

    public boolean is6Over4() {
        return this.getSegment(4).isZero() && this.getSegment(5).isZero();
    }

    public boolean isTeredo() {
        return this.getSegment(0).matches(8193) && this.getSegment(1).isZero();
    }

    public boolean isIsatap() {
        return this.getSegment(4).isZero() && this.getSegment(5).matches(24318);
    }

    public boolean isIPv4Translatable() {
        if (this.getSegment(4).matches(65535) && this.getSegment(5).isZero()) {
            int i = 0;
            while (i < 3) {
                if (!this.getSegment(i).isZero()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isWellKnownIPv4Translatable() {
        if (this.getSegment(0).matches(100) && this.getSegment(1).matches(65435)) {
            int i = 2;
            while (i <= 5) {
                if (!this.getSegment(i).isZero()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isMulticast() {
        return this.getSegment(0).matchesWithPrefixMask(255, (Integer)8);
    }

    @Override
    public boolean isLoopback() {
        int i = 0;
        while (i < this.getSegmentCount() - 1) {
            if (!this.getSegment(i).isZero()) {
                return false;
            }
            ++i;
        }
        return this.getSegment(i).matches(1);
    }

    @Override
    public IPv6Address intersect(IPAddress other) throws AddressConversionException {
        IPv6Address otherAddr;
        IPv6AddressSection thisSection = this.getSection();
        IPv6AddressSection section = thisSection.intersect((otherAddr = this.convertArg(other)).getSection());
        if (section == null) {
            return null;
        }
        IPv6AddressNetwork.IPv6AddressCreator creator = Objects.equals(this.zone, otherAddr.zone) ? this.getCreator() : this.getDefaultCreator();
        IPv6Address result = creator.createAddress(section);
        return result;
    }

    public IPv6Address[] subtract(IPAddress other) throws AddressConversionException {
        IPv6AddressSection thisSection = this.getSection();
        IPv6AddressSection[] sections = thisSection.subtract(this.convertArg(other).getSection());
        if (sections == null) {
            return null;
        }
        IPv6Address[] result = new IPv6Address[sections.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getCreator().createAddress(sections[i]);
            ++i;
        }
        return result;
    }

    private IPv6Address checkIdentity(IPv6AddressSection newSection) {
        if (newSection == this.getSection()) {
            return this;
        }
        return this.getCreator().createAddress(newSection);
    }

    @Override
    public IPv6Address adjustPrefixBySegment(boolean nextSegment) {
        return this.checkIdentity(this.getSection().adjustPrefixBySegment(nextSegment));
    }

    @Override
    public IPv6Address adjustPrefixBySegment(boolean nextSegment, boolean zeroed) {
        return this.checkIdentity(this.getSection().adjustPrefixBySegment(nextSegment, zeroed));
    }

    @Override
    public IPv6Address adjustPrefixLength(int adjustment) {
        return this.checkIdentity(this.getSection().adjustPrefixLength(adjustment));
    }

    @Override
    public IPv6Address adjustPrefixLength(int adjustment, boolean zeroed) {
        return this.checkIdentity(this.getSection().adjustPrefixLength(adjustment, zeroed));
    }

    @Override
    public IPv6Address setPrefixLength(int prefixLength) throws PrefixLenException {
        return this.setPrefixLength(prefixLength, true);
    }

    @Override
    public IPv6Address setPrefixLength(int prefixLength, boolean zeroed) throws PrefixLenException {
        return this.checkIdentity(this.getSection().setPrefixLength(prefixLength, zeroed));
    }

    @Override
    public IPv6Address applyPrefixLength(int networkPrefixLength) throws PrefixLenException {
        return this.checkIdentity(this.getSection().applyPrefixLength(networkPrefixLength));
    }

    @Override
    public IPv6Address removePrefixLength() {
        return this.removePrefixLength(true);
    }

    @Override
    public IPv6Address removePrefixLength(boolean zeroed) {
        return this.checkIdentity(this.getSection().removePrefixLength(zeroed));
    }

    private IPv6Address convertArg(IPAddress arg) throws AddressConversionException {
        IPv6Address converted = arg.toIPv6();
        if (converted == null) {
            throw new AddressConversionException(this, arg);
        }
        return converted;
    }

    @Override
    public IPv6Address toZeroHost() {
        if (!this.isPrefixed()) {
            AddressNetwork.PrefixConfiguration config = this.getNetwork().getPrefixConfiguration();
            IPv6Address addr = (IPv6Address)this.getNetwork().getNetworkMask(0, !config.allPrefixedAddressesAreSubnets());
            if (config.zeroHostsAreSubnets()) {
                addr = addr.getLower();
            }
            return addr;
        }
        if (this.includesZeroHost() && this.isSingleNetwork()) {
            return this.getLower();
        }
        return this.checkIdentity(this.getSection().createZeroHost());
    }

    @Override
    public IPv6Address toZeroHost(int prefixLength) {
        if (this.isPrefixed() && prefixLength == this.getNetworkPrefixLength()) {
            return this.toZeroHost();
        }
        return this.checkIdentity(this.getSection().toZeroHost(prefixLength));
    }

    @Override
    public IPv6Address toMaxHost() {
        if (!this.isPrefixed()) {
            IPv6Address resultNoPrefix = (IPv6Address)this.getNetwork().getHostMask(0);
            if (this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
                return resultNoPrefix;
            }
            return resultNoPrefix.setPrefixLength(0);
        }
        if (this.includesMaxHost() && this.isSingleNetwork()) {
            return this.getUpper();
        }
        return this.checkIdentity(this.getSection().createMaxHost());
    }

    @Override
    public IPv6Address toMaxHost(int prefixLength) {
        if (this.isPrefixed() && prefixLength == this.getNetworkPrefixLength()) {
            return this.toMaxHost();
        }
        return this.checkIdentity(this.getSection().toMaxHost(prefixLength));
    }

    @Override
    public IPv6Address mask(IPAddress mask, boolean retainPrefix) throws IncompatibleAddressException, AddressConversionException {
        return this.checkIdentity(this.getSection().mask(this.convertArg(mask).getSection(), retainPrefix));
    }

    @Override
    public IPv6Address mask(IPAddress mask) throws IncompatibleAddressException, AddressConversionException {
        return this.mask(mask, false);
    }

    @Override
    public IPv6Address maskNetwork(IPAddress mask, int networkPrefixLength) throws IncompatibleAddressException, PrefixLenException, AddressConversionException {
        return this.checkIdentity(this.getSection().maskNetwork(this.convertArg(mask).getSection(), networkPrefixLength));
    }

    @Override
    public IPv6Address bitwiseOr(IPAddress mask, boolean retainPrefix) throws IncompatibleAddressException, AddressConversionException {
        return this.checkIdentity(this.getSection().bitwiseOr(this.convertArg(mask).getSection(), retainPrefix));
    }

    @Override
    public IPv6Address bitwiseOr(IPAddress mask) throws IncompatibleAddressException, AddressConversionException {
        return this.bitwiseOr(mask, false);
    }

    @Override
    public IPv6Address bitwiseOrNetwork(IPAddress mask, int networkPrefixLength) throws IncompatibleAddressException, PrefixLenException, AddressConversionException {
        return this.checkIdentity(this.getSection().bitwiseOrNetwork(this.convertArg(mask).getSection(), networkPrefixLength));
    }

    @Override
    public IPv6AddressSection getNetworkSection() {
        return this.getSection().getNetworkSection();
    }

    @Override
    public IPv6AddressSection getNetworkSection(int networkPrefixLength) throws PrefixLenException {
        return this.getSection().getNetworkSection(networkPrefixLength);
    }

    @Override
    public IPv6AddressSection getNetworkSection(int networkPrefixLength, boolean withPrefixLength) throws PrefixLenException {
        return this.getSection().getNetworkSection(networkPrefixLength, withPrefixLength);
    }

    @Override
    public IPv6AddressSection getHostSection(int networkPrefixLength) throws PrefixLenException {
        return this.getSection().getHostSection(networkPrefixLength);
    }

    @Override
    public IPv6AddressSection getHostSection() {
        return this.getSection().getHostSection();
    }

    @Override
    public IPv6Address toPrefixBlock() {
        Integer prefixLength = this.getNetworkPrefixLength();
        if (prefixLength == null || this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
            return this;
        }
        return this.toPrefixBlock(prefixLength);
    }

    @Override
    public IPv6Address toPrefixBlock(int networkPrefixLength) throws PrefixLenException {
        return this.checkIdentity(this.getSection().toPrefixBlock(networkPrefixLength));
    }

    @Override
    public IPv6Address assignPrefixForSingleBlock() {
        return (IPv6Address)super.assignPrefixForSingleBlock();
    }

    @Override
    public IPv6Address assignMinPrefixForBlock() {
        return (IPv6Address)super.assignMinPrefixForBlock();
    }

    public IPv6Address[] spanWithPrefixBlocks(IPAddress other) throws AddressConversionException {
        return (IPv6Address[])IPAddress.getSpanningPrefixBlocks((IPAddress)this, (IPAddress)this.convertArg(other), IPv6Address::getLower, IPv6Address::getUpper, Address.DEFAULT_ADDRESS_COMPARATOR::compare, IPv6Address::removePrefixLength, this.getCreator()::createAddressArray);
    }

    public IPv6Address[] mergePrefixBlocks(IPAddress ... addresses) throws AddressConversionException {
        if (addresses.length == 0) {
            return new IPv6Address[]{this};
        }
        int i = 0;
        while (i < addresses.length) {
            addresses[i] = this.convertArg(addresses[i]);
            ++i;
        }
        List<IPAddressSegmentSeries> blocks = IPv6Address.getMergedBlocks(this, addresses);
        return blocks.toArray(new IPv6Address[blocks.size()]);
    }

    public boolean hasZone() {
        return this.zone != null;
    }

    public String getZone() {
        return this.zone;
    }

    public IPv6Address removeZone() {
        return this.getDefaultCreator().createAddress(this.getSection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasNoValueCache() {
        if (this.valueCache == null) {
            IPv6Address iPv6Address = this;
            synchronized (iPv6Address) {
                block5: {
                    if (this.valueCache != null) break block5;
                    this.valueCache = new ValueCache();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Inet6Address toInetAddress() {
        if (this.hasZone()) {
            Inet6Address result;
            if (this.hasNoValueCache() || (result = this.valueCache.inetAddress) == null) {
                this.valueCache.inetAddress = result = this.toInetAddressImpl(this.getBytes());
            }
            return result;
        }
        return (Inet6Address)super.toUpperInetAddress();
    }

    @Override
    public Inet6Address toUpperInetAddress() {
        if (this.hasZone()) {
            Inet6Address result;
            if (this.hasNoValueCache() || (result = this.valueCache.upperInetAddress) == null) {
                this.valueCache.upperInetAddress = result = this.toInetAddressImpl(this.getUpperBytes());
            }
            return result;
        }
        return (Inet6Address)super.toInetAddress();
    }

    @Override
    protected Inet6Address toInetAddressImpl(byte[] bytes) {
        InetAddress result;
        try {
            if (this.hasZone()) {
                try {
                    int scopeId = Integer.valueOf(this.zone);
                    result = Inet6Address.getByAddress(null, bytes, scopeId);
                }
                catch (NumberFormatException e) {
                    result = InetAddress.getByName(this.toNormalizedString());
                }
            } else {
                result = InetAddress.getByAddress(bytes);
            }
        }
        catch (UnknownHostException e) {
            result = null;
        }
        return (Inet6Address)result;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (this.hasZone()) {
            result *= this.zone.hashCode();
        }
        return result;
    }

    @Override
    public boolean isSameAddress(Address other) {
        return other instanceof IPAddress && this.isSameAddress((IPAddress)other);
    }

    @Override
    public boolean isSameAddress(IPAddress other) {
        if (super.isSameAddress(other)) {
            IPv6Address otherIPv6Address = other.toIPv6();
            String otherZone = otherIPv6Address.zone;
            return Objects.equals(this.zone, otherZone);
        }
        return false;
    }

    @Override
    public boolean contains(Address other) {
        if (super.contains(other)) {
            if (other != this && this.zone != null) {
                IPv6Address otherIPv6Address = (IPv6Address)other;
                String otherZone = otherIPv6Address.zone;
                return Objects.equals(this.zone, otherZone);
            }
            return true;
        }
        return false;
    }

    @Override
    protected IPAddressStringParameters createFromStringParams() {
        return new IPAddressStringParameters.Builder().getIPv4AddressParametersBuilder().setNetwork(this.getIPv4Network()).getParentBuilder().getIPv6AddressParametersBuilder().setNetwork(this.getNetwork()).getParentBuilder().toParams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasNoStringCache() {
        block5: {
            if (this.stringCache != null) break block5;
            IPv6Address iPv6Address = this;
            synchronized (iPv6Address) {
                block4: {
                    if (this.stringCache != null) break block5;
                    if (!this.hasZone()) break block4;
                    this.stringCache = new IPv6AddressSection.IPv6StringCache();
                    return true;
                }
                IPv6AddressSection section = this.getSection();
                boolean result = section.hasNoStringCache();
                this.stringCache = section.getStringCache();
                return result;
            }
        }
        return false;
    }

    public String toMixedString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.mixedString) == null) {
            if (this.hasZone()) {
                this.stringCache.mixedString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.mixedParams);
            } else {
                result = this.getSection().toMixedString();
            }
        }
        return result;
    }

    @Override
    public String toCanonicalString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.canonicalString) == null) {
            if (this.hasZone()) {
                this.stringCache.canonicalString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.canonicalParams);
            } else {
                result = this.getSection().toCanonicalString();
            }
        }
        return result;
    }

    @Override
    public String toFullString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.fullString) == null) {
            if (this.hasZone()) {
                this.stringCache.fullString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.fullParams);
            } else {
                result = this.getSection().toFullString();
            }
        }
        return result;
    }

    public static String toNormalizedString(IPv6AddressNetwork network, Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, Integer prefixLength, CharSequence zone) {
        return IPv6Address.toNormalizedString(network.getPrefixConfiguration(), lowerValueProvider, upperValueProvider, prefixLength, 8, 2, 16, 65535, ':', 16, zone);
    }

    @Override
    public String toNormalizedString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.normalizedString) == null) {
            if (this.hasZone()) {
                this.stringCache.normalizedString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.normalizedParams);
            } else {
                result = this.getSection().toNormalizedString();
            }
        }
        return result;
    }

    @Override
    public String toCompressedString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.compressedString) == null) {
            if (this.hasZone()) {
                this.stringCache.compressedString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.compressedParams);
            } else {
                result = this.getSection().toCompressedString();
            }
        }
        return result;
    }

    @Override
    public String toSubnetString() {
        return this.toPrefixLengthString();
    }

    @Override
    public String toNormalizedWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.normalizedWildcardString) == null) {
            if (this.hasZone()) {
                this.stringCache.normalizedWildcardString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.wildcardNormalizedParams);
            } else {
                result = this.getSection().toNormalizedWildcardString();
            }
        }
        return result;
    }

    public String toBase85String() {
        String result;
        IPAddressString originator = this.getAddressfromString();
        if (originator != null && (!this.isPrefixed() || this.getNetworkPrefixLength() == 128) && originator.isBase85IPv6()) {
            return originator.toString();
        }
        if (this.hasNoStringCache() || (result = this.stringCache.base85String) == null) {
            if (this.hasZone()) {
                this.stringCache.base85String = result = this.getSection().toBase85String(this.getZone());
            } else {
                result = this.getSection().toBase85String();
            }
        }
        return result;
    }

    @Override
    public String toCanonicalWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.canonicalWildcardString) == null) {
            if (this.hasZone()) {
                this.stringCache.canonicalWildcardString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.wildcardCanonicalParams);
            } else {
                result = this.getSection().toCanonicalWildcardString();
            }
        }
        return result;
    }

    @Override
    public String toCompressedWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.compressedWildcardString) == null) {
            if (this.hasZone()) {
                this.stringCache.compressedWildcardString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.wildcardCompressedParams);
            } else {
                result = this.getSection().toCompressedWildcardString();
            }
        }
        return result;
    }

    @Override
    public String toSQLWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.sqlWildcardString) == null) {
            if (this.hasZone()) {
                this.stringCache.sqlWildcardString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.sqlWildcardParams);
            } else {
                result = this.getSection().toSQLWildcardString();
            }
        }
        return result;
    }

    @Override
    public String toHexString(boolean with0xPrefix) {
        String result;
        if (this.hasNoStringCache() || (result = with0xPrefix ? this.stringCache.hexStringPrefixed : this.stringCache.hexString) == null) {
            if (this.hasZone()) {
                result = this.getSection().toHexString(with0xPrefix, this.zone);
                if (with0xPrefix) {
                    this.stringCache.hexStringPrefixed = result;
                } else {
                    this.stringCache.hexString = result;
                }
            } else {
                result = this.getSection().toHexString(with0xPrefix);
            }
        }
        return result;
    }

    @Override
    public String toBinaryString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.binaryString) == null) {
            if (this.hasZone()) {
                this.stringCache.binaryString = result = this.getSection().toBinaryString(this.zone);
            } else {
                result = this.getSection().toBinaryString();
            }
        }
        return result;
    }

    @Override
    public String toOctalString(boolean with0Prefix) {
        String result;
        if (this.hasNoStringCache() || (result = with0Prefix ? this.stringCache.octalStringPrefixed : this.stringCache.octalString) == null) {
            if (this.hasZone()) {
                result = this.getSection().toOctalString(with0Prefix, this.zone);
                if (with0Prefix) {
                    this.stringCache.octalStringPrefixed = result;
                } else {
                    this.stringCache.octalString = result;
                }
            } else {
                result = this.getSection().toOctalString(with0Prefix);
            }
        }
        return result;
    }

    @Override
    public String toPrefixLengthString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.networkPrefixLengthString) == null) {
            if (this.hasZone()) {
                this.stringCache.networkPrefixLengthString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.networkPrefixLengthParams);
            } else {
                result = this.getSection().toPrefixLengthString();
            }
        }
        return result;
    }

    @Override
    public String toConvertedString() {
        if (this.isIPv4Convertible()) {
            return this.toMixedString();
        }
        return this.toNormalizedString();
    }

    @Override
    public String toNormalizedString(IPAddressSection.IPStringOptions params) {
        return this.getSection().toNormalizedString(params, (CharSequence)this.zone);
    }

    public String toNormalizedString(IPv6AddressSection.IPv6StringOptions params) {
        return this.getSection().toNormalizedString(params, (CharSequence)this.zone);
    }

    public String toNormalizedString(boolean keepMixed, IPv6AddressSection.IPv6StringOptions params) {
        if (keepMixed && this.fromString != null && this.getAddressfromString().isMixedIPv6() && !params.makeMixed()) {
            params = new IPv6AddressSection.IPv6StringOptions(params.base, params.expandSegments, params.wildcardOption, params.wildcards, params.segmentStrPrefix, true, params.ipv4Opts, params.compressOptions, params.separator, params.zoneSeparator, params.addrLabel, params.addrSuffix, params.reverse, params.splitDigits, params.uppercase);
        }
        return this.toNormalizedString(params);
    }

    @Override
    public String toUNCHostName() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.uncString) == null) {
            String newZone = this.zone != null ? this.zone.replace('%', 's').replace(':', '-') : null;
            this.stringCache.uncString = result = this.getSection().toNormalizedString(IPv6AddressSection.IPv6StringCache.uncParams, (CharSequence)newZone);
        }
        return result;
    }

    @Override
    public IPAddressPartStringCollection toStandardStringCollection() {
        return this.toStringCollection(IPv6AddressSection.IPv6StringBuilderOptions.STANDARD_OPTS);
    }

    @Override
    public IPAddressPartStringCollection toAllStringCollection() {
        return this.toStringCollection(IPv6AddressSection.IPv6StringBuilderOptions.ALL_OPTS);
    }

    @Override
    public IPAddressPartStringCollection toStringCollection(IPAddressSection.IPStringBuilderOptions opts) {
        return this.toStringCollection(IPv6AddressSection.IPv6StringBuilderOptions.from(opts));
    }

    private IPv4Address getConverted(IPv6AddressSection.IPv6StringBuilderOptions opts) {
        if (!this.hasZone() && opts.includes(65536)) {
            IPv4Address.IPv4AddressConverter converter = opts.converter;
            return converter.toIPv4(this);
        }
        return null;
    }

    public IPAddressPartStringCollection toStringCollection(IPv6AddressSection.IPv6StringBuilderOptions opts) {
        IPv6AddressSection.IPv6StringCollection coll = this.getSection().toStringCollection(opts, this.zone);
        IPv4Address ipv4Addr = this.getConverted(opts);
        if (ipv4Addr != null) {
            IPAddressPartStringCollection ipv4StringCollection = ipv4Addr.toStringCollection(opts.ipv4ConverterOptions);
            coll.addAll(ipv4StringCollection);
        }
        return coll;
    }

    public static interface IPv6AddressConverter {
        public IPv6Address toIPv6(IPAddress var1);
    }

    protected static class ValueCache {
        public Inet6Address inetAddress;
        public Inet6Address upperInetAddress;

        protected ValueCache() {
        }
    }
}

