/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv4;

import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSeqRange;
import inet.ipaddr.NetworkMismatchException;
import inet.ipaddr.PrefixLenException;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.validate.ParsedAddressGrouping;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv4.IPv4AddressSection;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.function.Function;

public class IPv4AddressSeqRange
extends IPAddressSeqRange
implements Iterable<IPv4Address> {
    private static final long serialVersionUID = 1L;
    private static final IPv4AddressSeqRange[] EMPTY = new IPv4AddressSeqRange[0];

    public IPv4AddressSeqRange(IPv4Address first, IPv4Address second) {
        super(first, second, IPv4Address::getLower, IPv4Address::getUpper, IPv4Address::withoutPrefixLength);
        if (!first.getNetwork().equals(second.getNetwork())) {
            throw new NetworkMismatchException(first, second);
        }
    }

    private IPv4AddressSeqRange(IPAddress first, IPAddress second) {
        super(first, second);
    }

    @Override
    public IPv4Address getLower() {
        return (IPv4Address)super.getLower();
    }

    @Override
    public IPv4Address getUpper() {
        return (IPv4Address)super.getUpper();
    }

    private IPv4AddressNetwork.IPv4AddressCreator getAddressCreator() {
        return this.getLower().getNetwork().getAddressCreator();
    }

    public long getIPv4Count() {
        return this.getUpper().longValue() - this.getLower().longValue() + 1L;
    }

    public long getIPv4PrefixCount(int prefixLength) {
        if (prefixLength < 0) {
            throw new PrefixLenException((AddressItem)this, prefixLength);
        }
        int bitCount = this.getBitCount();
        if (bitCount <= prefixLength) {
            return this.getIPv4Count();
        }
        int shiftAdjustment = bitCount - prefixLength;
        long upperAdjusted = this.getUpper().longValue() >>> shiftAdjustment;
        long lowerAdjusted = this.getLower().longValue() >>> shiftAdjustment;
        return upperAdjusted - lowerAdjusted + 1L;
    }

    @Override
    public BigInteger getCountImpl() {
        return BigInteger.valueOf(this.getIPv4Count());
    }

    @Override
    public BigInteger getPrefixCount(int prefixLength) {
        return BigInteger.valueOf(this.getIPv4PrefixCount(prefixLength));
    }

    public Iterable<IPv4Address> getIterable() {
        return this;
    }

    @Override
    public Iterator<IPv4Address> iterator() {
        IPv4Address lower = this.getLower();
        IPv4Address upper = this.getUpper();
        IPv4AddressNetwork.IPv4AddressCreator creator = this.getAddressCreator();
        if (!this.isMultiple()) {
            return IPv4AddressSeqRange.iterator(lower, creator);
        }
        int divCount = lower.getSegmentCount();
        return IPv4AddressSeqRange.iterator(lower, upper, creator, IPv4Address::getSegment, (seg, segIndex) -> seg.iterator(), (addr1, addr2, index) -> addr1.getSegment(index).getSegmentValue() == addr2.getSegment(index).getSegmentValue(), divCount - 1, divCount, null);
    }

    public Iterator<IPv4Address> prefixBlockIterator(int prefLength) {
        if (prefLength < 0) {
            throw new PrefixLenException(prefLength);
        }
        IPv4Address lower = this.getLower();
        IPv4Address upper = this.getUpper();
        IPv4AddressNetwork.IPv4AddressCreator creator = this.getAddressCreator();
        return IPv4AddressSeqRange.iterator(lower, upper, creator, IPv4Address::getSegment, (seg, segIndex) -> seg.iterator(), (addr1, addr2, index) -> {
            Integer segPrefLength = ParsedAddressGrouping.getPrefixedSegmentPrefixLength(8, prefLength, index);
            if (segPrefLength == null) {
                return addr1.getSegment(index).getSegmentValue() == addr2.getSegment(index).getSegmentValue();
            }
            int shift = 8 - segPrefLength;
            return addr1.getSegment(index).getSegmentValue() >>> shift == addr2.getSegment(index).getSegmentValue() >>> shift;
        }, IPv4AddressSeqRange.getNetworkSegmentIndex(prefLength, 1, 8), IPv4AddressSeqRange.getHostSegmentIndex(prefLength, 1, 8), (seg, index) -> {
            Integer segPrefLength = ParsedAddressGrouping.getPrefixedSegmentPrefixLength(8, prefLength, index);
            if (segPrefLength == null) {
                return seg.iterator();
            }
            return seg.prefixBlockIterator(segPrefLength);
        });
    }

    public Iterator<IPv4AddressSeqRange> prefixIterator(int prefixLength) {
        return super.prefixIterator(prefixLength);
    }

    public IPv4Address[] spanWithPrefixBlocks() {
        return this.getLower().spanWithPrefixBlocks(this.getUpper());
    }

    public IPv4Address[] spanWithSequentialBlocks() {
        return this.getLower().spanWithSequentialBlocks(this.getUpper());
    }

    @Override
    public int getMinPrefixLengthForBlock() {
        int upperOnes;
        int result = this.getBitCount();
        int lowerZeros = Integer.numberOfTrailingZeros(this.getLower().intValue());
        if (lowerZeros != 0 && (upperOnes = Integer.numberOfTrailingZeros(~this.getUpper().intValue())) != 0) {
            int prefixedBitCount = Math.min(lowerZeros, upperOnes);
            result -= prefixedBitCount;
        }
        return result;
    }

    @Override
    public Integer getPrefixLengthForSingleBlock() {
        int shift;
        int divPrefix = this.getMinPrefixLengthForBlock();
        int lowerValue = this.getLower().intValue();
        int upperValue = this.getUpper().intValue();
        int bitCount = this.getBitCount();
        if (divPrefix == bitCount ? lowerValue == upperValue : lowerValue >>> (shift = bitCount - divPrefix) == upperValue >>> shift) {
            return IPv4AddressSection.cacheBits(divPrefix);
        }
        return null;
    }

    @Override
    protected IPv4AddressSeqRange create(IPAddress lower, IPAddress upper) {
        return new IPv4AddressSeqRange(lower, upper);
    }

    protected IPv4AddressSeqRange[] createPair(IPAddress lower1, IPAddress upper1, IPAddress lower2, IPAddress upper2) {
        return new IPv4AddressSeqRange[]{this.create(lower1, upper1), this.create(lower2, upper2)};
    }

    protected IPv4AddressSeqRange[] createSingle(IPAddress lower, IPAddress upper) {
        return new IPv4AddressSeqRange[]{this.create(lower, upper)};
    }

    protected IPv4AddressSeqRange[] createSingle() {
        return new IPv4AddressSeqRange[]{this};
    }

    protected IPv4AddressSeqRange[] createEmpty() {
        return EMPTY;
    }

    public String toIPv4String(Function<IPv4Address, String> lowerStringer, String separator, Function<IPv4Address, String> upperStringer) {
        return lowerStringer.apply(this.getLower()) + separator + upperStringer.apply(this.getUpper());
    }

    @Override
    public IPv4AddressSeqRange intersect(IPAddressSeqRange other) {
        return (IPv4AddressSeqRange)super.intersect(other);
    }

    @Override
    public IPv4AddressSeqRange join(IPAddressSeqRange other) {
        return (IPv4AddressSeqRange)super.join(other);
    }

    public IPv4AddressSeqRange[] subtract(IPAddressSeqRange other) {
        return (IPv4AddressSeqRange[])super.subtract(other);
    }
}

