/*
 * Decompiled with CFR 0.152.
 */
package com.github.seanroy.plugins;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cloudwatchevents.AmazonCloudWatchEvents;
import com.amazonaws.services.cloudwatchevents.AmazonCloudWatchEventsClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreamsClientBuilder;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.AmazonKinesisClientBuilder;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.AWSLambdaClientBuilder;
import com.amazonaws.services.lambda.model.GetFunctionConfigurationRequest;
import com.amazonaws.services.lambda.model.GetFunctionRequest;
import com.amazonaws.services.lambda.model.GetFunctionResult;
import com.amazonaws.services.lambda.model.ResourceNotFoundException;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeResult;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.util.CollectionUtils;
import com.github.seanroy.plugins.LambdaFunction;
import com.github.seanroy.utils.AWSEncryption;
import com.github.seanroy.utils.JsonUtil;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractLambdaMojo
extends AbstractMojo {
    public static final String TRIG_INT_LABEL_CLOUDWATCH_EVENTS = "CloudWatch Events - Schedule";
    public static final String TRIG_INT_LABEL_DYNAMO_DB = "DynamoDB";
    public static final String TRIG_INT_LABEL_KINESIS = "Kinesis";
    public static final String TRIG_INT_LABEL_SNS = "SNS";
    public static final String TRIG_INT_LABEL_ALEXA_SK = "Alexa Skills Kit";
    public static final String TRIG_INT_LABEL_LEX = "Lex";
    public static final String TRIG_INT_LABEL_SQS = "SQS";
    public static final String PERM_LAMBDA_INVOKE = "lambda:InvokeFunction";
    public static final String PRINCIPAL_ALEXA = "alexa-appkit.amazon.com";
    public static final String PRINCIPAL_LEX = "lex.amazonaws.com";
    public static final String PRINCIPAL_SNS = "sns.amazonaws.com";
    public static final String PRINCIPAL_EVENTS = "events.amazonaws.com";
    public static final String PRINCIPAL_SQS = "sqs.amazonaws.com";
    @Parameter(property="accessKey", defaultValue="${accessKey}")
    public String accessKey;
    @Parameter(property="secretKey", defaultValue="${secretKey}")
    public String secretKey;
    @Parameter(property="functionCode", defaultValue="${functionCode}", required=true)
    public String functionCode;
    @Parameter(property="version", defaultValue="${version}", required=true)
    public String version;
    @Parameter(property="alias")
    public String alias;
    @Parameter(property="region", alias="region", defaultValue="us-east-1")
    public String regionName;
    @Parameter(property="s3Bucket", defaultValue="lambda-function-code")
    public String s3Bucket;
    @Parameter(property="sse", defaultValue="false")
    public boolean sse;
    @Parameter(property="sseKmsEncryptionKeyArn")
    public String sseKmsEncryptionKeyArn;
    @Parameter(property="keyPrefix", defaultValue="/")
    public String keyPrefix;
    @Parameter(property="runtime", defaultValue="java8")
    public String runtime;
    @Parameter(property="lambdaRoleArn", defaultValue="${lambdaRoleArn}")
    public String lambdaRoleArn;
    @Parameter(property="lambdaFunctionsJSON")
    public String lambdaFunctionsJSON;
    @Parameter(property="lambdaFunctions", defaultValue="${lambdaFunctions}")
    public List<LambdaFunction> lambdaFunctions;
    @Parameter(property="timeout", defaultValue="30")
    public int timeout;
    @Parameter(property="memorySize", defaultValue="1024")
    public int memorySize;
    @Parameter(property="vpcSecurityGroupIds", defaultValue="${vpcSecurityGroupIds}")
    public List<String> vpcSecurityGroupIds;
    @Parameter(property="vpcSubnetIds", defaultValue="${vpcSubnetIds}")
    public List<String> vpcSubnetIds;
    @Parameter(property="publish", defaultValue="true")
    public boolean publish;
    @Parameter(property="functionNameSuffix")
    public String functionNameSuffix;
    @Parameter(property="forceUpdate", defaultValue="false")
    public boolean forceUpdate;
    @Parameter(property="environmentVariables", defaultValue="${environmentVariables}")
    public Map<String, String> environmentVariables;
    @Parameter(property="passThrough")
    public String passThrough;
    @Parameter(property="kmsEncryptionKeyArn")
    public String kmsEncryptionKeyArn;
    @Parameter(property="encryptedPassThrough")
    public String encryptedPassThrough;
    @Parameter(property="clientConfiguration")
    public Map<String, String> clientConfiguration;
    public String fileName;
    public AWSCredentials credentials;
    public AmazonS3 s3Client;
    public AWSLambda lambdaClient;
    public AmazonSNS snsClient;
    public AmazonCloudWatchEvents eventsClient;
    public AmazonDynamoDBStreams dynamoDBStreamsClient;
    public AmazonKinesis kinesisClient;
    public AmazonCloudWatchEvents cloudWatchEventsClient;
    public AmazonSQS sqsClient;
    Function<LambdaFunction, LambdaFunction> updateFunctionCode = lambdaFunction -> {
        this.getLog().info((CharSequence)("About to update functionCode for " + lambdaFunction.getFunctionName()));
        UpdateFunctionCodeRequest updateFunctionRequest = new UpdateFunctionCodeRequest().withFunctionName(lambdaFunction.getFunctionName()).withS3Bucket(this.s3Bucket).withS3Key(this.fileName).withPublish(lambdaFunction.isPublish());
        UpdateFunctionCodeResult updateFunctionCodeResult = this.lambdaClient.updateFunctionCode(updateFunctionRequest);
        GetFunctionRequest getFunctionRequest = new GetFunctionRequest().withFunctionName(lambdaFunction.getFunctionName());
        GetFunctionResult getFunctionResult = this.lambdaClient.getFunction(getFunctionRequest);
        while (!getFunctionResult.getConfiguration().getState().equals("Active") || !getFunctionResult.getConfiguration().getLastUpdateStatus().equals("Successful")) {
            try {
                this.getLog().info((CharSequence)String.format("UpdateFunctionCode for %s is still processing <State: %s, LastUpdateStatus: %s>, waiting... ", lambdaFunction.getFunctionName(), getFunctionResult.getConfiguration().getState(), getFunctionResult.getConfiguration().getLastUpdateStatus()));
                Thread.sleep(3000L);
                getFunctionResult = this.lambdaClient.getFunction(getFunctionRequest);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.getLog().info((CharSequence)("UpdateFunctionCode finished successfully for " + lambdaFunction.getFunctionName()));
        return lambdaFunction.withVersion(updateFunctionCodeResult.getVersion()).withFunctionArn(updateFunctionCodeResult.getFunctionArn());
    };
    BiFunction<AwsClientBuilder, ClientConfiguration, AmazonWebServiceClient> clientFactory = (builder, clientConfig) -> {
        Regions region = Regions.fromName((String)this.regionName);
        return (AmazonWebServiceClient)Optional.of(this.credentials).map(credentials -> builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(credentials)).withClientConfiguration(clientConfig).withRegion(region).build()).orElse(builder.withRegion(region).withCredentials((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain()).build());
    };

    public void execute() throws MojoExecutionException {
        this.initAWSCredentials();
        this.initAWSClients();
        try {
            this.initFileName();
            this.initVersion();
            this.initLambdaFunctionsConfiguration();
            this.lambdaFunctions.forEach(lambdaFunction -> this.getLog().debug((CharSequence)lambdaFunction.toString()));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Initialization of configuration failed", (Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
    }

    void uploadJarToS3() throws Exception {
        String bucket = this.getBucket();
        File file = new File(this.functionCode);
        String localmd5 = DigestUtils.md5Hex((InputStream)new FileInputStream(file));
        this.getLog().debug((CharSequence)String.format("Local file's MD5 hash is %s.", localmd5));
        Optional.ofNullable(this.getObjectMetadata(bucket)).map(ObjectMetadata::getETag).map(remoteMD5 -> {
            this.getLog().info((CharSequence)(this.fileName + " exists in S3 with MD5 hash " + remoteMD5));
            return localmd5.equals(remoteMD5);
        }).map(isTheSame -> {
            if (isTheSame.booleanValue()) {
                this.getLog().info((CharSequence)(this.fileName + " is up to date in AWS S3 bucket " + this.s3Bucket + ". Not uploading..."));
                return true;
            }
            return null;
        }).orElseGet(() -> {
            this.upload(file);
            return true;
        });
    }

    private ObjectMetadata getObjectMetadata(String bucket) {
        try {
            return this.s3Client.getObjectMetadata(bucket, this.fileName);
        }
        catch (AmazonS3Exception ignored) {
            return null;
        }
    }

    private String getBucket() {
        if (this.s3Client.listBuckets().stream().noneMatch(p -> Objects.equals(p.getName(), this.s3Bucket))) {
            this.getLog().info((CharSequence)("Created bucket s3://" + this.s3Client.createBucket(this.s3Bucket).getName()));
        }
        return this.s3Bucket;
    }

    private PutObjectResult upload(File file) {
        this.getLog().info((CharSequence)("Uploading " + this.functionCode + " to AWS S3 bucket " + this.s3Bucket));
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.s3Bucket, this.fileName, file);
        if (this.sse) {
            if (this.sseKmsEncryptionKeyArn != null && this.sseKmsEncryptionKeyArn.length() > 0) {
                putObjectRequest.setSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams(this.sseKmsEncryptionKeyArn));
            } else {
                ObjectMetadata objectMetadata = new ObjectMetadata();
                objectMetadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
                putObjectRequest.setMetadata(objectMetadata);
            }
        }
        PutObjectResult putObjectResult = this.s3Client.putObject(putObjectRequest);
        this.getLog().info((CharSequence)"Upload complete...");
        return putObjectResult;
    }

    private void initAWSCredentials() throws MojoExecutionException {
        DefaultAWSCredentialsProviderChain defaultChain = new DefaultAWSCredentialsProviderChain();
        if (this.accessKey != null && this.secretKey != null) {
            this.credentials = new BasicAWSCredentials(this.accessKey, this.secretKey);
        } else if (defaultChain.getCredentials() != null) {
            this.credentials = defaultChain.getCredentials();
        }
        if (this.credentials == null) {
            this.getLog().error((CharSequence)"Unable to initialize AWS Credentials. Set BasicAWSCredentials with accessKey and secretKey or configure DefaultAWSCredentialsProviderChain");
            throw new MojoExecutionException("AWS Credentials config error");
        }
    }

    private void initFileName() {
        String pattern = Pattern.quote(File.separator);
        String[] pieces = this.functionCode.split(pattern);
        if (!Optional.ofNullable(this.keyPrefix).orElse("/").endsWith("/")) {
            this.keyPrefix = this.keyPrefix + "/";
        }
        this.fileName = this.keyPrefix + pieces[pieces.length - 1];
    }

    private void initVersion() {
        this.version = this.version.replace(".", "-");
    }

    private void initAWSClients() {
        ClientConfiguration clientConfig = this.clientConfiguration();
        this.s3Client = (AmazonS3)this.clientFactory.apply((AwsClientBuilder)AmazonS3ClientBuilder.standard(), clientConfig);
        this.lambdaClient = (AWSLambda)this.clientFactory.apply((AwsClientBuilder)AWSLambdaClientBuilder.standard(), clientConfig);
        this.snsClient = (AmazonSNS)this.clientFactory.apply((AwsClientBuilder)AmazonSNSClientBuilder.standard(), clientConfig);
        this.eventsClient = (AmazonCloudWatchEvents)this.clientFactory.apply((AwsClientBuilder)AmazonCloudWatchEventsClientBuilder.standard(), clientConfig);
        this.dynamoDBStreamsClient = (AmazonDynamoDBStreams)this.clientFactory.apply((AwsClientBuilder)AmazonDynamoDBStreamsClientBuilder.standard(), clientConfig);
        this.kinesisClient = (AmazonKinesis)this.clientFactory.apply((AwsClientBuilder)AmazonKinesisClientBuilder.standard(), clientConfig);
        this.cloudWatchEventsClient = (AmazonCloudWatchEvents)this.clientFactory.apply((AwsClientBuilder)AmazonCloudWatchEventsClientBuilder.standard(), clientConfig);
        this.sqsClient = (AmazonSQS)this.clientFactory.apply((AwsClientBuilder)AmazonSQSClientBuilder.standard(), clientConfig);
    }

    private void initLambdaFunctionsConfiguration() throws MojoExecutionException, IOException {
        if (this.lambdaFunctionsJSON != null) {
            this.lambdaFunctions = (List)JsonUtil.fromJson(this.lambdaFunctionsJSON);
        }
        this.validate(this.lambdaFunctions);
        this.lambdaFunctions = this.lambdaFunctions.stream().map(lambdaFunction -> {
            String functionName = Optional.ofNullable(lambdaFunction.getFunctionName()).orElseThrow(() -> new IllegalArgumentException("Configuration error. LambdaFunction -> 'functionName' is required"));
            lambdaFunction.withFunctionName(this.addSuffix(functionName)).withHandler(Optional.ofNullable(lambdaFunction.getHandler()).orElseThrow(() -> new IllegalArgumentException("Configuration error. LambdaFunction -> 'handler' is required"))).withDescription(Optional.ofNullable(lambdaFunction.getDescription()).orElse("")).withTimeout(Optional.ofNullable(lambdaFunction.getTimeout()).orElse(this.timeout)).withMemorySize(Optional.ofNullable(lambdaFunction.getMemorySize()).orElse(this.memorySize)).withSubnetIds(Optional.ofNullable(this.vpcSubnetIds).orElse(new ArrayList())).withSecurityGroupsIds(Optional.ofNullable(this.vpcSecurityGroupIds).orElse(new ArrayList())).withVersion(this.version).withPublish(Optional.ofNullable(lambdaFunction.isPublish()).orElse(this.publish)).withLambdaRoleArn(Optional.ofNullable(lambdaFunction.getLambdaRoleArn()).orElse(this.lambdaRoleArn)).withAliases(this.aliases(lambdaFunction.isPublish())).withTriggers(Optional.ofNullable(lambdaFunction.getTriggers()).map(triggers -> triggers.stream().map(trigger -> {
                trigger.withRuleName(this.addSuffix(trigger.getRuleName()));
                trigger.withSNSTopic(this.addSuffix(trigger.getSNSTopic()));
                trigger.withDynamoDBTable(this.addSuffix(trigger.getDynamoDBTable()));
                trigger.withLexBotName(this.addSuffix(trigger.getLexBotName()));
                trigger.withStandardQueue(this.addSuffix(trigger.getStandardQueue()));
                return trigger;
            }).collect(Collectors.toList())).orElse(new ArrayList())).withEnvironmentVariables(this.environmentVariables((LambdaFunction)lambdaFunction));
            return lambdaFunction;
        }).collect(Collectors.toList());
    }

    private Map<String, String> environmentVariables(LambdaFunction lambdaFunction) {
        Map<String, String> awsDefinedEnvVars = new HashMap();
        try {
            awsDefinedEnvVars = Optional.ofNullable(this.lambdaClient.getFunctionConfiguration(new GetFunctionConfigurationRequest().withFunctionName(lambdaFunction.getFunctionName()).withQualifier(lambdaFunction.getQualifier())).getEnvironment()).flatMap(x -> Optional.of(x.getVariables())).orElse(new HashMap());
        }
        catch (ResourceNotFoundException rnfe) {
            this.getLog().debug((CharSequence)"Lambda function doesn't exist yet, no existing environment variables retrieved.");
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Could not retrieve existing environment variables " + e.getMessage()));
        }
        Map configurationEnvVars = Optional.ofNullable(this.environmentVariables).orElse(new HashMap());
        Map functionEnvVars = Optional.ofNullable(lambdaFunction.getEnvironmentVariables()).orElse(new HashMap());
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        Map passThroughEnvVars = (Map)new GsonBuilder().create().fromJson(Optional.ofNullable(this.passThrough).orElse("{}"), type);
        passThroughEnvVars.putAll(Optional.ofNullable(this.kmsEncryptionKeyArn).flatMap(arn -> {
            AWSEncryption awsEncryptor = new AWSEncryption((String)arn);
            Map encryptedVariables = (Map)new GsonBuilder().create().fromJson(Optional.ofNullable(this.encryptedPassThrough).orElse("{}"), type);
            encryptedVariables.replaceAll((k, v) -> awsEncryptor.encryptString((String)v));
            return Optional.of(encryptedVariables);
        }).orElse(new HashMap()));
        awsDefinedEnvVars.putAll(configurationEnvVars);
        awsDefinedEnvVars.putAll(functionEnvVars);
        awsDefinedEnvVars.putAll(passThroughEnvVars);
        return awsDefinedEnvVars;
    }

    private ClientConfiguration clientConfiguration() {
        return Optional.ofNullable(this.clientConfiguration).flatMap(clientConfigObject -> Optional.of(new ClientConfiguration().withProtocol(Protocol.valueOf((String)clientConfigObject.getOrDefault("protocol", Protocol.HTTPS.toString()).toUpperCase())).withProxyHost((String)clientConfigObject.get("proxyHost")).withProxyPort(Integer.getInteger((String)clientConfigObject.get("proxyPort"), -1).intValue()).withProxyDomain((String)clientConfigObject.get("proxyDomain")).withProxyUsername((String)clientConfigObject.get("proxyUsername")).withProxyPassword((String)clientConfigObject.get("proxyPassword")).withProxyWorkstation((String)clientConfigObject.get("proxyWorkstation")))).orElse(new ClientConfiguration());
    }

    private String addSuffix(String functionName) {
        return Optional.ofNullable(this.functionNameSuffix).map(suffix -> Stream.of(functionName, suffix).collect(Collectors.joining())).orElse(functionName);
    }

    private List<String> aliases(boolean publish) {
        if (publish) {
            return new ArrayList<String>(){
                {
                    this.add(AbstractLambdaMojo.this.version);
                    Optional.ofNullable(AbstractLambdaMojo.this.alias).ifPresent(a -> this.add(a));
                }
            };
        }
        return Collections.emptyList();
    }

    private void validate(List<LambdaFunction> lambdaFunctions) throws MojoExecutionException {
        if (CollectionUtils.isNullOrEmpty(lambdaFunctions)) {
            this.getLog().error((CharSequence)"At least one function has to be provided in configuration");
            throw new MojoExecutionException("Illegal configuration. Configuration for at least one Lambda function has to be provided");
        }
    }
}

