/*
 * Decompiled with CFR 0.152.
 */
package com.github.seanroy.plugins;

import com.amazonaws.auth.policy.Policy;
import com.amazonaws.services.cloudwatchevents.model.DeleteRuleRequest;
import com.amazonaws.services.cloudwatchevents.model.DescribeRuleRequest;
import com.amazonaws.services.cloudwatchevents.model.DescribeRuleResult;
import com.amazonaws.services.cloudwatchevents.model.ListRuleNamesByTargetRequest;
import com.amazonaws.services.cloudwatchevents.model.PutRuleRequest;
import com.amazonaws.services.cloudwatchevents.model.PutRuleResult;
import com.amazonaws.services.cloudwatchevents.model.PutTargetsRequest;
import com.amazonaws.services.cloudwatchevents.model.RemoveTargetsRequest;
import com.amazonaws.services.cloudwatchevents.model.ResourceNotFoundException;
import com.amazonaws.services.cloudwatchevents.model.Target;
import com.amazonaws.services.dynamodbv2.model.DescribeStreamRequest;
import com.amazonaws.services.dynamodbv2.model.ListStreamsRequest;
import com.amazonaws.services.dynamodbv2.model.ListStreamsResult;
import com.amazonaws.services.dynamodbv2.model.Stream;
import com.amazonaws.services.dynamodbv2.model.StreamDescription;
import com.amazonaws.services.lambda.model.AddPermissionRequest;
import com.amazonaws.services.lambda.model.AddPermissionResult;
import com.amazonaws.services.lambda.model.AliasConfiguration;
import com.amazonaws.services.lambda.model.CreateAliasRequest;
import com.amazonaws.services.lambda.model.CreateEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.CreateEventSourceMappingResult;
import com.amazonaws.services.lambda.model.CreateFunctionRequest;
import com.amazonaws.services.lambda.model.CreateFunctionResult;
import com.amazonaws.services.lambda.model.DeleteEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.Environment;
import com.amazonaws.services.lambda.model.EventSourceMappingConfiguration;
import com.amazonaws.services.lambda.model.EventSourcePosition;
import com.amazonaws.services.lambda.model.FunctionCode;
import com.amazonaws.services.lambda.model.GetFunctionRequest;
import com.amazonaws.services.lambda.model.GetFunctionResult;
import com.amazonaws.services.lambda.model.GetPolicyRequest;
import com.amazonaws.services.lambda.model.GetPolicyResult;
import com.amazonaws.services.lambda.model.ListAliasesRequest;
import com.amazonaws.services.lambda.model.ListAliasesResult;
import com.amazonaws.services.lambda.model.ListEventSourceMappingsRequest;
import com.amazonaws.services.lambda.model.ListEventSourceMappingsResult;
import com.amazonaws.services.lambda.model.RemovePermissionRequest;
import com.amazonaws.services.lambda.model.UpdateAliasRequest;
import com.amazonaws.services.lambda.model.UpdateEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.UpdateEventSourceMappingResult;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationRequest;
import com.amazonaws.services.lambda.model.VpcConfig;
import com.amazonaws.services.lambda.model.VpcConfigResponse;
import com.amazonaws.services.sns.model.CreateTopicRequest;
import com.amazonaws.services.sns.model.CreateTopicResult;
import com.amazonaws.services.sns.model.ListSubscriptionsResult;
import com.amazonaws.services.sns.model.SubscribeRequest;
import com.amazonaws.services.sns.model.SubscribeResult;
import com.amazonaws.services.sns.model.UnsubscribeRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesResult;
import com.amazonaws.services.sqs.model.GetQueueUrlRequest;
import com.amazonaws.services.sqs.model.GetQueueUrlResult;
import com.amazonaws.services.sqs.model.QueueAttributeName;
import com.github.seanroy.plugins.AbstractLambdaMojo;
import com.github.seanroy.plugins.LambdaFunction;
import com.github.seanroy.plugins.Trigger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="deploy-lambda")
public class DeployLambdaMojo
extends AbstractLambdaMojo {
    private Function<LambdaFunction, LambdaFunction> getFunctionPolicy = lambdaFunction -> {
        try {
            lambdaFunction.setExistingPolicy(Policy.fromJson((String)this.lambdaClient.getPolicy(new GetPolicyRequest().withFunctionName(lambdaFunction.getFunctionName()).withQualifier(lambdaFunction.getQualifier())).getPolicy()));
        }
        catch (com.amazonaws.services.lambda.model.ResourceNotFoundException rnfe3) {
            this.getLog().debug((CharSequence)("Probably creating a new function, policy doesn't exist yet: " + rnfe3.getMessage()));
        }
        return lambdaFunction;
    };
    private Function<LambdaFunction, LambdaFunction> updateFunctionConfig = lambdaFunction -> {
        this.getLog().info((CharSequence)("About to update functionConfig for " + lambdaFunction.getFunctionName()));
        UpdateFunctionConfigurationRequest updateFunctionRequest = new UpdateFunctionConfigurationRequest().withFunctionName(lambdaFunction.getFunctionName()).withDescription(lambdaFunction.getDescription()).withHandler(lambdaFunction.getHandler()).withRole(lambdaFunction.getLambdaRoleArn()).withTimeout(lambdaFunction.getTimeout()).withMemorySize(lambdaFunction.getMemorySize()).withRuntime(this.runtime).withVpcConfig(this.getVpcConfig((LambdaFunction)lambdaFunction)).withEnvironment(new Environment().withVariables(lambdaFunction.getEnvironmentVariables()));
        this.lambdaClient.updateFunctionConfiguration(updateFunctionRequest);
        return lambdaFunction;
    };
    private Function<LambdaFunction, LambdaFunction> createOrUpdateAliases = lambdaFunction -> {
        lambdaFunction.getAliases().forEach(alias -> {
            UpdateAliasRequest updateAliasRequest = new UpdateAliasRequest().withFunctionName(lambdaFunction.getFunctionName()).withFunctionVersion(lambdaFunction.getVersion()).withName(alias);
            try {
                this.lambdaClient.updateAlias(updateAliasRequest);
                this.getLog().info((CharSequence)("Alias " + alias + " updated for " + lambdaFunction.getFunctionName() + " with version " + lambdaFunction.getVersion()));
            }
            catch (com.amazonaws.services.lambda.model.ResourceNotFoundException ignored) {
                CreateAliasRequest createAliasRequest = new CreateAliasRequest().withFunctionName(lambdaFunction.getFunctionName()).withFunctionVersion(lambdaFunction.getVersion()).withName(alias);
                this.lambdaClient.createAlias(createAliasRequest);
                this.getLog().info((CharSequence)("Alias " + alias + " created for " + lambdaFunction.getFunctionName() + " with version " + lambdaFunction.getVersion()));
            }
        });
        return lambdaFunction;
    };
    private BiFunction<Trigger, LambdaFunction, Trigger> createOrUpdateSNSTopicSubscription = (trigger, lambdaFunction) -> {
        Optional<Object> statementOpt;
        this.getLog().info((CharSequence)("About to create or update " + trigger.getIntegration() + " trigger for " + trigger.getSNSTopic()));
        CreateTopicRequest createTopicRequest = new CreateTopicRequest().withName(trigger.getSNSTopic());
        CreateTopicResult createTopicResult = this.snsClient.createTopic(createTopicRequest);
        this.getLog().info((CharSequence)("Topic " + createTopicResult.getTopicArn() + " created"));
        SubscribeRequest subscribeRequest = new SubscribeRequest().withTopicArn(createTopicResult.getTopicArn()).withEndpoint(lambdaFunction.getUnqualifiedFunctionArn()).withProtocol("lambda");
        SubscribeResult subscribeResult = this.snsClient.subscribe(subscribeRequest);
        this.getLog().info((CharSequence)("Lambda function " + lambdaFunction.getFunctionName() + " subscribed to " + createTopicResult.getTopicArn()));
        this.getLog().info((CharSequence)("Created " + trigger.getIntegration() + " trigger " + subscribeResult.getSubscriptionArn()));
        try {
            GetPolicyRequest getPolicyRequest = new GetPolicyRequest().withFunctionName(lambdaFunction.getFunctionName());
            GetPolicyResult GetPolicyResult2 = this.lambdaClient.getPolicy(getPolicyRequest);
            statementOpt = Policy.fromJson((String)GetPolicyResult2.getPolicy()).getStatements().stream().filter(statement -> statement.getActions().stream().anyMatch(e -> "lambda:InvokeFunction".equals(e.getActionName())) && statement.getPrincipals().stream().anyMatch(principal -> "sns.amazonaws.com".equals(principal.getId())) && statement.getConditions().stream().anyMatch(condition -> condition.getValues().stream().anyMatch(s -> Objects.equals(createTopicResult.getTopicArn(), s)))).findAny();
        }
        catch (com.amazonaws.services.lambda.model.ResourceNotFoundException ignored) {
            statementOpt = Optional.empty();
        }
        if (!statementOpt.isPresent()) {
            AddPermissionRequest addPermissionRequest = new AddPermissionRequest().withAction("lambda:InvokeFunction").withPrincipal("sns.amazonaws.com").withSourceArn(createTopicResult.getTopicArn()).withFunctionName(lambdaFunction.getFunctionName()).withStatementId(UUID.randomUUID().toString());
            AddPermissionResult addPermissionResult = this.lambdaClient.addPermission(addPermissionRequest);
            this.getLog().debug((CharSequence)("Added permission to lambda function " + addPermissionResult.toString()));
        }
        return trigger;
    };
    private BiFunction<Trigger, LambdaFunction, Trigger> addAlexaSkillsKitPermission = (trigger, lambdaFunction) -> {
        if (!Optional.ofNullable(lambdaFunction.getExistingPolicy()).orElse(new Policy()).getStatements().stream().anyMatch(s -> s.getId().equals(this.getAlexaPermissionStatementId()))) {
            this.getLog().info((CharSequence)("Granting invoke permission to " + trigger.getIntegration()));
            AddPermissionRequest addPermissionRequest = new AddPermissionRequest().withAction("lambda:InvokeFunction").withPrincipal("alexa-appkit.amazon.com").withFunctionName(lambdaFunction.getFunctionName()).withQualifier(lambdaFunction.getQualifier()).withStatementId(this.getAlexaPermissionStatementId());
            AddPermissionResult addPermissionResult = this.lambdaClient.addPermission(addPermissionRequest);
        }
        return trigger;
    };
    private BiFunction<Trigger, LambdaFunction, Trigger> addLexPermission = (trigger, lambdaFunction) -> {
        if (!Optional.ofNullable(lambdaFunction.getExistingPolicy()).orElse(new Policy()).getStatements().stream().anyMatch(s -> s.getId().equals(this.getLexPermissionStatementId(trigger.getLexBotName())))) {
            this.getLog().info((CharSequence)("Granting invoke permission to Lex bot " + trigger.getLexBotName()));
            AddPermissionRequest addPermissionRequest = new AddPermissionRequest().withAction("lambda:InvokeFunction").withPrincipal("lex.amazonaws.com").withFunctionName(lambdaFunction.getFunctionName()).withQualifier(lambdaFunction.getQualifier()).withStatementId(this.getLexPermissionStatementId(trigger.getLexBotName()));
            AddPermissionResult addPermissionResult = this.lambdaClient.addPermission(addPermissionRequest);
        }
        return trigger;
    };
    private BiFunction<Trigger, LambdaFunction, Trigger> createOrUpdateScheduledRule = (trigger, lambdaFunction) -> {
        if (this.isScheduleRuleChanged((LambdaFunction)lambdaFunction) || this.isKeepAliveChanged((LambdaFunction)lambdaFunction)) {
            this.getLog().info((CharSequence)("About to create or update " + trigger.getIntegration() + " trigger for " + trigger.getRuleName()));
            PutRuleRequest putRuleRequest = new PutRuleRequest().withName(trigger.getRuleName()).withDescription(trigger.getRuleDescription()).withScheduleExpression(trigger.getScheduleExpression());
            PutRuleResult putRuleResult = this.eventsClient.putRule(putRuleRequest);
            this.getLog().info((CharSequence)("Created " + trigger.getIntegration() + " trigger " + putRuleResult.getRuleArn()));
            AddPermissionRequest addPermissionRequest = new AddPermissionRequest().withAction("lambda:InvokeFunction").withPrincipal("events.amazonaws.com").withSourceArn(putRuleResult.getRuleArn()).withFunctionName(lambdaFunction.getFunctionName()).withStatementId(UUID.randomUUID().toString());
            AddPermissionResult addPermissionResult = this.lambdaClient.addPermission(addPermissionRequest);
            this.getLog().debug((CharSequence)("Added permission to lambda function " + addPermissionResult.toString()));
            PutTargetsRequest putTargetsRequest = new PutTargetsRequest().withRule(trigger.getRuleName()).withTargets(new Target[]{new Target().withId("1").withArn(lambdaFunction.getUnqualifiedFunctionArn())});
            this.eventsClient.putTargets(putTargetsRequest);
        }
        return trigger;
    };
    private Function<LambdaFunction, LambdaFunction> createOrUpdateKeepAlive = lambdaFunction -> {
        if (this.isKeepAliveChanged((LambdaFunction)lambdaFunction)) {
            Optional.ofNullable(lambdaFunction.getKeepAlive()).flatMap(f -> {
                if (f > 0) {
                    this.getLog().info((CharSequence)("Setting keepAlive to " + f + " minutes."));
                    this.createOrUpdateScheduledRule.apply(new Trigger().withIntegration("Function Keep Alive").withDescription(String.format("This feature pings function %s every %d %s.", lambdaFunction.getFunctionName(), f, f > 1 ? "minutes" : "minute")).withRuleName(lambdaFunction.getKeepAliveRuleName()).withScheduleExpression(lambdaFunction.getKeepAliveScheduleExpression()), (LambdaFunction)lambdaFunction);
                }
                return Optional.of(f);
            });
        }
        return lambdaFunction;
    };
    private BiFunction<Trigger, LambdaFunction, Trigger> createOrUpdateDynamoDBTrigger = (trigger, lambdaFunction) -> {
        this.getLog().info((CharSequence)("About to create or update " + trigger.getIntegration() + " trigger for " + trigger.getDynamoDBTable()));
        ListStreamsRequest listStreamsRequest = new ListStreamsRequest().withTableName(trigger.getDynamoDBTable());
        ListStreamsResult listStreamsResult = this.dynamoDBStreamsClient.listStreams(listStreamsRequest);
        String streamArn = listStreamsResult.getStreams().stream().filter(s -> Objects.equals(trigger.getDynamoDBTable(), s.getTableName())).findFirst().map(Stream::getStreamArn).orElseThrow(() -> new IllegalArgumentException("Unable to find stream for table " + trigger.getDynamoDBTable()));
        return this.findorUpdateMappingConfiguration((Trigger)trigger, (LambdaFunction)lambdaFunction, streamArn);
    };
    private BiFunction<Trigger, LambdaFunction, Trigger> createOrUpdateSQSTrigger = (trigger, lambdaFunction) -> {
        this.getLog().info((CharSequence)("About to create or update " + trigger.getIntegration() + " trigger for " + trigger.getStandardQueue()));
        String queueArn = null;
        Optional<GetQueueUrlResult> getQueueUrlOptionalResult = Optional.ofNullable(this.sqsClient.getQueueUrl(new GetQueueUrlRequest().withQueueName(trigger.getStandardQueue())));
        if (!getQueueUrlOptionalResult.isPresent()) {
            throw new IllegalArgumentException("Unable to find queue " + trigger.getStandardQueue());
        }
        String queueUrl = getQueueUrlOptionalResult.get().getQueueUrl();
        GetQueueAttributesResult getQueueAttributesResult = this.sqsClient.getQueueAttributes(new GetQueueAttributesRequest().withQueueUrl(queueUrl).withAttributeNames(new QueueAttributeName[]{QueueAttributeName.QueueArn}));
        queueArn = (String)getQueueAttributesResult.getAttributes().get(QueueAttributeName.QueueArn.name());
        return this.findorUpdateMappingConfiguration((Trigger)trigger, (LambdaFunction)lambdaFunction, queueArn);
    };
    private BiFunction<Trigger, LambdaFunction, Trigger> createOrUpdateKinesisStream = (trigger, lambdaFunction) -> {
        this.getLog().info((CharSequence)("About to create or update " + trigger.getIntegration() + " trigger for " + trigger.getKinesisStream()));
        try {
            return this.findorUpdateMappingConfiguration((Trigger)trigger, (LambdaFunction)lambdaFunction, this.kinesisClient.describeStream(trigger.getKinesisStream()).getStreamDescription().getStreamARN());
        }
        catch (Exception rnfe) {
            this.getLog().info((CharSequence)rnfe.getMessage());
            throw new IllegalArgumentException("Unable to find stream with name " + trigger.getKinesisStream());
        }
    };
    private Function<LambdaFunction, LambdaFunction> createOrUpdateTriggers = lambdaFunction -> {
        lambdaFunction.getTriggers().forEach(trigger -> {
            if ("CloudWatch Events - Schedule".equals(trigger.getIntegration())) {
                this.createOrUpdateScheduledRule.apply((Trigger)trigger, (LambdaFunction)lambdaFunction);
            } else if ("DynamoDB".equals(trigger.getIntegration())) {
                this.createOrUpdateDynamoDBTrigger.apply((Trigger)trigger, (LambdaFunction)lambdaFunction);
            } else if ("Kinesis".equals(trigger.getIntegration())) {
                this.createOrUpdateKinesisStream.apply((Trigger)trigger, (LambdaFunction)lambdaFunction);
            } else if ("SNS".equals(trigger.getIntegration())) {
                this.createOrUpdateSNSTopicSubscription.apply((Trigger)trigger, (LambdaFunction)lambdaFunction);
            } else if ("Alexa Skills Kit".equals(trigger.getIntegration())) {
                this.addAlexaSkillsKitPermission.apply((Trigger)trigger, (LambdaFunction)lambdaFunction);
            } else if ("Lex".equals(trigger.getIntegration())) {
                this.addLexPermission.apply((Trigger)trigger, (LambdaFunction)lambdaFunction);
            } else if ("SQS".equals(trigger.getIntegration())) {
                this.createOrUpdateSQSTrigger.apply((Trigger)trigger, (LambdaFunction)lambdaFunction);
            } else {
                throw new IllegalArgumentException("Unknown integration for trigger " + trigger.getIntegration() + ". Correct your configuration");
            }
        });
        return lambdaFunction;
    };
    private Function<LambdaFunction, LambdaFunction> createFunction = lambdaFunction -> {
        this.getLog().info((CharSequence)("About to create function " + lambdaFunction.getFunctionName()));
        CreateFunctionRequest createFunctionRequest = new CreateFunctionRequest().withDescription(lambdaFunction.getDescription()).withRole(lambdaFunction.getLambdaRoleArn()).withFunctionName(lambdaFunction.getFunctionName()).withHandler(lambdaFunction.getHandler()).withRuntime(this.runtime).withTimeout(Optional.ofNullable(lambdaFunction.getTimeout()).orElse(this.timeout)).withMemorySize(Optional.ofNullable(lambdaFunction.getMemorySize()).orElse(this.memorySize)).withVpcConfig(this.getVpcConfig((LambdaFunction)lambdaFunction)).withCode(new FunctionCode().withS3Bucket(this.s3Bucket).withS3Key(this.fileName)).withEnvironment(new Environment().withVariables(lambdaFunction.getEnvironmentVariables()));
        CreateFunctionResult createFunctionResult = this.lambdaClient.createFunction(createFunctionRequest);
        lambdaFunction.withVersion(createFunctionResult.getVersion()).withFunctionArn(createFunctionResult.getFunctionArn());
        this.getLog().info((CharSequence)("Function " + createFunctionResult.getFunctionName() + " created. Function Arn: " + createFunctionResult.getFunctionArn()));
        return lambdaFunction;
    };
    Function<LambdaFunction, LambdaFunction> cleanUpOrphanedKinesisTriggers = lambdaFunction -> {
        ListEventSourceMappingsResult listEventSourceMappingsResult = this.lambdaClient.listEventSourceMappings(new ListEventSourceMappingsRequest().withFunctionName(lambdaFunction.getUnqualifiedFunctionArn()));
        ArrayList streamNames = new ArrayList();
        lambdaFunction.getTriggers().stream().forEach(t -> {
            Optional.ofNullable(t.getKinesisStream()).ifPresent(x -> streamNames.add(x));
            Optional.ofNullable(t.getDynamoDBTable()).ifPresent(x -> streamNames.add(x));
        });
        listEventSourceMappingsResult.getEventSourceMappings().stream().forEach(s -> {
            if (s.getEventSourceArn().contains(":kinesis:") && !streamNames.contains(this.kinesisClient.describeStream(new com.amazonaws.services.kinesis.model.DescribeStreamRequest().withStreamName(s.getEventSourceArn().substring(s.getEventSourceArn().lastIndexOf(47) + 1))).getStreamDescription().getStreamName())) {
                this.getLog().info((CharSequence)("    Removing orphaned Kinesis trigger for stream " + s.getEventSourceArn()));
                try {
                    this.lambdaClient.deleteEventSourceMapping(new DeleteEventSourceMappingRequest().withUUID(s.getUUID()));
                }
                catch (Exception e8) {
                    this.getLog().error((CharSequence)("    Error removing orphaned Kinesis trigger for stream " + s.getEventSourceArn()));
                }
            }
        });
        return lambdaFunction;
    };
    Function<LambdaFunction, LambdaFunction> cleanUpOrphanedSNSTriggers = lambdaFunction -> {
        ArrayList subscriptions = new ArrayList();
        ListSubscriptionsResult result = this.snsClient.listSubscriptions();
        do {
            subscriptions.addAll(result.getSubscriptions().stream().filter(sub -> sub.getEndpoint().equals(lambdaFunction.getFunctionArn())).collect(Collectors.toList()));
        } while ((result = this.snsClient.listSubscriptions(result.getNextToken())).getNextToken() != null);
        if (subscriptions.size() > 0) {
            List snsTopicNames = lambdaFunction.getTriggers().stream().map(t -> Optional.ofNullable(t.getSNSTopic()).orElse("")).collect(Collectors.toList());
            subscriptions.stream().forEach(s -> {
                String topicName = s.getTopicArn().substring(s.getTopicArn().lastIndexOf(":") + 1);
                if (!snsTopicNames.contains(topicName)) {
                    this.getLog().info((CharSequence)("    Removing orphaned SNS trigger for topic " + topicName));
                    try {
                        this.snsClient.unsubscribe(new UnsubscribeRequest().withSubscriptionArn(s.getSubscriptionArn()));
                        Optional.ofNullable(lambdaFunction.getExistingPolicy()).flatMap(policy -> {
                            policy.getStatements().stream().filter(stmt -> stmt.getActions().stream().anyMatch(e -> "lambda:InvokeFunction".equals(e.getActionName())) && stmt.getPrincipals().stream().anyMatch(principal -> "sns.amazonaws.com".equals(principal.getId())) && stmt.getResources().stream().anyMatch(r -> r.getId().equals(lambdaFunction.getFunctionArn()))).forEach(st -> {
                                if (st.getConditions().stream().anyMatch(condition -> condition.getValues().contains(s.getTopicArn()))) {
                                    this.getLog().info((CharSequence)"      Removing invoke permission for SNS trigger");
                                    try {
                                        this.lambdaClient.removePermission(new RemovePermissionRequest().withFunctionName(lambdaFunction.getFunctionName()).withQualifier(lambdaFunction.getQualifier()).withStatementId(st.getId()));
                                    }
                                    catch (Exception e7) {
                                        this.getLog().error((CharSequence)"      Error removing invoke permission for SNS trigger");
                                    }
                                }
                            });
                            return Optional.of(policy);
                        });
                    }
                    catch (Exception e5) {
                        this.getLog().error((CharSequence)("    Error removing SNS trigger for topic " + topicName));
                    }
                }
            });
        }
        return lambdaFunction;
    };
    Function<LambdaFunction, LambdaFunction> cleanUpOrphanedSQSTriggers = lambdaFunction -> {
        ListEventSourceMappingsResult listEventSourceMappingsResult = this.lambdaClient.listEventSourceMappings(new ListEventSourceMappingsRequest().withFunctionName(lambdaFunction.getUnqualifiedFunctionArn()));
        ArrayList standardQueues = new ArrayList();
        lambdaFunction.getTriggers().stream().forEach(t -> Optional.ofNullable(t.getStandardQueue()).ifPresent(x -> standardQueues.add(x)));
        listEventSourceMappingsResult.getEventSourceMappings().stream().forEach(s -> {
            if (s.getEventSourceArn().contains(":sqs:")) {
                Optional<GetQueueUrlResult> getQueueUrlOptionalResult = Optional.ofNullable(this.sqsClient.getQueueUrl(new GetQueueUrlRequest().withQueueName(s.getEventSourceArn().substring(s.getEventSourceArn().lastIndexOf(58) + 1))));
                getQueueUrlOptionalResult.ifPresent(queue -> {
                    String queueName = queue.getQueueUrl().substring(queue.getQueueUrl().lastIndexOf(47) + 1);
                    if (!standardQueues.contains(queueName)) {
                        this.getLog().info((CharSequence)("    Removing orphaned SQS trigger for queue " + queueName));
                        try {
                            this.lambdaClient.deleteEventSourceMapping(new DeleteEventSourceMappingRequest().withUUID(s.getUUID()));
                        }
                        catch (Exception exp) {
                            this.getLog().error((CharSequence)("    Error removing SQS trigger for queue " + queueName + ", Error Message :" + exp.getMessage()));
                        }
                    }
                });
            }
        });
        return lambdaFunction;
    };
    Function<LambdaFunction, LambdaFunction> cleanUpOrphanedDynamoDBTriggers = lambdaFunction -> {
        ListEventSourceMappingsResult listEventSourceMappingsResult = this.lambdaClient.listEventSourceMappings(new ListEventSourceMappingsRequest().withFunctionName(lambdaFunction.getUnqualifiedFunctionArn()));
        ArrayList tableNames = new ArrayList();
        lambdaFunction.getTriggers().stream().forEach(t -> {
            Optional.ofNullable(t.getKinesisStream()).ifPresent(x -> tableNames.add(x));
            Optional.ofNullable(t.getDynamoDBTable()).ifPresent(x -> tableNames.add(x));
        });
        listEventSourceMappingsResult.getEventSourceMappings().stream().forEach(s -> {
            StreamDescription sd;
            if (s.getEventSourceArn().contains(":dynamodb:") && !tableNames.contains((sd = this.dynamoDBStreamsClient.describeStream(new DescribeStreamRequest().withStreamArn(s.getEventSourceArn())).getStreamDescription()).getTableName())) {
                this.getLog().info((CharSequence)("    Removing orphaned DynamoDB trigger for table " + sd.getTableName()));
                try {
                    this.lambdaClient.deleteEventSourceMapping(new DeleteEventSourceMappingRequest().withUUID(s.getUUID()));
                }
                catch (Exception e4) {
                    this.getLog().error((CharSequence)("    Error removing DynamoDB trigger for table " + sd.getTableName()));
                }
            }
        });
        return lambdaFunction;
    };
    Function<LambdaFunction, LambdaFunction> cleanUpOrphanedAlexaSkillsTriggers = lambdaFunction -> {
        Optional.ofNullable(lambdaFunction.getExistingPolicy()).flatMap(policy -> {
            policy.getStatements().stream().filter(stmt -> stmt.getActions().stream().anyMatch(e -> "lambda:InvokeFunction".equals(e.getActionName())) && stmt.getPrincipals().stream().anyMatch(principal -> "alexa-appkit.amazon.com".equals(principal.getId())) && !lambdaFunction.getTriggers().stream().anyMatch(t -> t.getIntegration().equals("Alexa Skills Kit"))).forEach(s -> {
                try {
                    this.getLog().info((CharSequence)("    Removing orphaned Alexa permission " + s.getId()));
                    this.lambdaClient.removePermission(new RemovePermissionRequest().withFunctionName(lambdaFunction.getFunctionName()).withQualifier(lambdaFunction.getQualifier()).withStatementId(s.getId()));
                }
                catch (com.amazonaws.services.lambda.model.ResourceNotFoundException rnfe1) {
                    this.getLog().error((CharSequence)("    Error removing permission for " + s.getId() + ": " + rnfe1.getMessage()));
                }
            });
            return Optional.of(policy);
        });
        return lambdaFunction;
    };
    Function<LambdaFunction, LambdaFunction> cleanUpOrphanedLexSkillsTriggers = lambdaFunction -> {
        Optional.ofNullable(lambdaFunction.getExistingPolicy()).flatMap(policy -> {
            policy.getStatements().stream().filter(stmt -> stmt.getActions().stream().anyMatch(e -> "lambda:InvokeFunction".equals(e.getActionName())) && stmt.getPrincipals().stream().anyMatch(principal -> "lex.amazonaws.com".equals(principal.getId())) && !lambdaFunction.getTriggers().stream().anyMatch(t -> stmt.getId().contains(Optional.ofNullable(t.getLexBotName()).orElse("")))).forEach(s -> {
                try {
                    this.getLog().info((CharSequence)("    Removing orphaned Lex permission " + s.getId()));
                    this.lambdaClient.removePermission(new RemovePermissionRequest().withFunctionName(lambdaFunction.getFunctionName()).withQualifier(lambdaFunction.getQualifier()).withStatementId(s.getId()));
                }
                catch (Exception ign2) {
                    this.getLog().error((CharSequence)("   Error removing permission for " + s.getId() + ign2.getMessage()));
                }
            });
            return Optional.of(policy);
        });
        return lambdaFunction;
    };
    Function<LambdaFunction, LambdaFunction> cleanUpOrphanedCloudWatchEventRules = lambdaFunction -> {
        List existingRuleNames = this.cloudWatchEventsClient.listRuleNamesByTarget(new ListRuleNamesByTargetRequest().withTargetArn(lambdaFunction.getFunctionArn())).getRuleNames();
        List definedRuleNames = lambdaFunction.getTriggers().stream().filter(t -> "CloudWatch Events - Schedule".equals(t.getIntegration())).map(t -> t.getRuleName()).collect(Collectors.toList());
        Optional.ofNullable(lambdaFunction.getKeepAlive()).ifPresent(ka -> {
            if (ka > 0) {
                definedRuleNames.add(lambdaFunction.getKeepAliveRuleName());
            }
        });
        existingRuleNames.removeAll(definedRuleNames);
        existingRuleNames.stream().forEach(ern -> {
            this.getLog().info((CharSequence)("    Removing CloudWatch Event Rule: " + ern));
            this.cloudWatchEventsClient.removeTargets(new RemoveTargetsRequest().withIds(new String[]{"1"}).withRule(ern));
            try {
                this.cloudWatchEventsClient.deleteRule(new DeleteRuleRequest().withName(ern));
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("    Error removing orphaned rule: " + e.getMessage()));
            }
        });
        return lambdaFunction;
    };
    Function<LambdaFunction, LambdaFunction> cleanUpOrphans = lambdaFunction -> {
        try {
            lambdaFunction.setFunctionArn(this.lambdaClient.getFunction(new GetFunctionRequest().withFunctionName(lambdaFunction.getFunctionName())).getConfiguration().getFunctionArn());
            this.getLog().info((CharSequence)"Cleaning up orphaned triggers.");
            this.cleanUpOrphanedCloudWatchEventRules.andThen(this.cleanUpOrphanedDynamoDBTriggers).andThen(this.cleanUpOrphanedKinesisTriggers).andThen(this.cleanUpOrphanedSNSTriggers).andThen(this.cleanUpOrphanedAlexaSkillsTriggers).andThen(this.cleanUpOrphanedLexSkillsTriggers).andThen(this.cleanUpOrphanedSQSTriggers).apply((LambdaFunction)lambdaFunction);
        }
        catch (com.amazonaws.services.lambda.model.ResourceNotFoundException ign1) {
            this.getLog().debug((CharSequence)"Assuming function has no orphan triggers to clean up since it doesn't exist yet.");
        }
        return lambdaFunction;
    };
    Function<LambdaFunction, LambdaFunction> createOrUpdate = lambdaFunction -> {
        try {
            lambdaFunction.setFunctionArn(this.lambdaClient.getFunction(new GetFunctionRequest().withFunctionName(lambdaFunction.getFunctionName())).getConfiguration().getFunctionArn());
            Optional.of(this.getFunction((LambdaFunction)lambdaFunction)).filter(getFunctionResult -> this.shouldUpdate((LambdaFunction)lambdaFunction, (GetFunctionResult)getFunctionResult)).map(getFujnctionResult -> this.updateFunctionCode.andThen(this.updateFunctionConfig).andThen(this.createOrUpdateAliases).andThen(this.createOrUpdateTriggers).andThen(this.createOrUpdateKeepAlive).apply((LambdaFunction)lambdaFunction));
        }
        catch (com.amazonaws.services.lambda.model.ResourceNotFoundException ign) {
            this.createFunction.andThen(this.createOrUpdateAliases).andThen(this.createOrUpdateTriggers).apply((LambdaFunction)lambdaFunction);
        }
        return lambdaFunction;
    };

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        try {
            this.uploadJarToS3();
            this.lambdaFunctions.stream().map(f -> {
                this.getLog().info((CharSequence)("---- Create or update " + f.getFunctionName() + " -----"));
                return f;
            }).forEach(lf -> this.getFunctionPolicy.andThen(this.cleanUpOrphans).andThen(this.createOrUpdate).apply((LambdaFunction)lf));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error during processing", (Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private boolean shouldUpdate(LambdaFunction lambdaFunction, GetFunctionResult getFunctionResult) {
        boolean isConfigurationChanged = this.isConfigurationChanged(lambdaFunction, getFunctionResult);
        if (!isConfigurationChanged) {
            this.getLog().info((CharSequence)("Config hasn't changed for " + lambdaFunction.getFunctionName()));
        }
        if (this.forceUpdate) {
            this.getLog().info((CharSequence)("Forcing update for " + lambdaFunction.getFunctionName()));
        }
        return this.forceUpdate || isConfigurationChanged;
    }

    private String getAlexaPermissionStatementId() {
        return "lambda-maven-plugin-alexa-" + this.regionName + "-permission";
    }

    private String getLexPermissionStatementId(String botName) {
        return "lambda-maven-plugin-lex-" + this.regionName + "-permission-" + botName;
    }

    private Trigger findorUpdateMappingConfiguration(Trigger trigger, LambdaFunction lambdaFunction, String streamArn) {
        ListEventSourceMappingsRequest listEventSourceMappingsRequest = new ListEventSourceMappingsRequest().withFunctionName(lambdaFunction.getUnqualifiedFunctionArn());
        ListEventSourceMappingsResult listEventSourceMappingsResult = this.lambdaClient.listEventSourceMappings(listEventSourceMappingsRequest);
        Optional<EventSourceMappingConfiguration> eventSourceMappingConfiguration = listEventSourceMappingsResult.getEventSourceMappings().stream().filter(stream -> {
            boolean isSameFunctionArn = Objects.equals(stream.getFunctionArn(), lambdaFunction.getUnqualifiedFunctionArn());
            boolean isSameSourceArn = Objects.equals(stream.getEventSourceArn(), streamArn);
            return isSameFunctionArn && isSameSourceArn;
        }).findFirst();
        if (eventSourceMappingConfiguration.isPresent()) {
            UpdateEventSourceMappingRequest updateEventSourceMappingRequest = new UpdateEventSourceMappingRequest().withUUID(eventSourceMappingConfiguration.get().getUUID()).withFunctionName(lambdaFunction.getUnqualifiedFunctionArn()).withBatchSize(Optional.ofNullable(trigger.getBatchSize()).orElse(10)).withEnabled(Optional.ofNullable(trigger.getEnabled()).orElse(true));
            UpdateEventSourceMappingResult updateEventSourceMappingResult = this.lambdaClient.updateEventSourceMapping(updateEventSourceMappingRequest);
            trigger.withTriggerArn(updateEventSourceMappingResult.getEventSourceArn());
            this.getLog().info((CharSequence)("Updated " + trigger.getIntegration() + " trigger " + trigger.getTriggerArn()));
        } else {
            CreateEventSourceMappingRequest createEventSourceMappingRequest = new CreateEventSourceMappingRequest().withFunctionName(lambdaFunction.getUnqualifiedFunctionArn()).withEventSourceArn(streamArn).withBatchSize(Optional.ofNullable(trigger.getBatchSize()).orElse(10)).withEnabled(Optional.ofNullable(trigger.getEnabled()).orElse(true));
            if (!streamArn.contains(":sqs:")) {
                createEventSourceMappingRequest.setStartingPosition(EventSourcePosition.fromValue((String)Optional.ofNullable(trigger.getStartingPosition()).orElse(EventSourcePosition.LATEST.toString())));
            }
            CreateEventSourceMappingResult createEventSourceMappingResult = this.lambdaClient.createEventSourceMapping(createEventSourceMappingRequest);
            trigger.withTriggerArn(createEventSourceMappingResult.getEventSourceArn());
            this.getLog().info((CharSequence)("Created " + trigger.getIntegration() + " trigger " + trigger.getTriggerArn()));
        }
        return trigger;
    }

    private GetFunctionResult getFunction(LambdaFunction lambdaFunction) {
        return this.lambdaClient.getFunction(new GetFunctionRequest().withFunctionName(lambdaFunction.getFunctionName()));
    }

    private boolean isConfigurationChanged(LambdaFunction lambdaFunction, GetFunctionResult function) {
        BiPredicate<String, String> isChangeStr = (s0, s1) -> !Objects.equals(s0, s1);
        BiPredicate<Integer, Integer> isChangeInt = (i0, i1) -> !Objects.equals(i0, i1);
        BiPredicate<List, List> isChangeList = (l0, l1) -> !l0.containsAll((Collection<?>)l1) || !l1.containsAll((Collection<?>)l0);
        return Optional.of(function.getConfiguration()).map(config -> {
            VpcConfigResponse vpcConfig = config.getVpcConfig();
            if (vpcConfig == null) {
                vpcConfig = new VpcConfigResponse();
            }
            boolean isDescriptionChanged = isChangeStr.test(config.getDescription(), lambdaFunction.getDescription());
            boolean isHandlerChanged = isChangeStr.test(config.getHandler(), lambdaFunction.getHandler());
            boolean isRoleChanged = isChangeStr.test(config.getRole(), lambdaFunction.getLambdaRoleArn());
            boolean isTimeoutChanged = isChangeInt.test(config.getTimeout(), lambdaFunction.getTimeout());
            boolean isMemoryChanged = isChangeInt.test(config.getMemorySize(), lambdaFunction.getMemorySize());
            boolean isSecurityGroupIdsChanged = isChangeList.test(vpcConfig.getSecurityGroupIds(), lambdaFunction.getSecurityGroupIds());
            boolean isVpcSubnetIdsChanged = isChangeList.test(vpcConfig.getSubnetIds(), lambdaFunction.getSubnetIds());
            return isDescriptionChanged || isHandlerChanged || isRoleChanged || isTimeoutChanged || isMemoryChanged || isSecurityGroupIdsChanged || isVpcSubnetIdsChanged || this.isAliasesChanged(lambdaFunction) || this.isKeepAliveChanged(lambdaFunction) || this.isScheduleRuleChanged(lambdaFunction);
        }).orElse(true);
    }

    private boolean isKeepAliveChanged(LambdaFunction lambdaFunction) {
        try {
            return Optional.ofNullable(lambdaFunction.getKeepAlive()).map(ka -> {
                DescribeRuleResult res = this.eventsClient.describeRule(new DescribeRuleRequest().withName(lambdaFunction.getKeepAliveRuleName()));
                return !Objects.equals(res.getScheduleExpression(), lambdaFunction.getKeepAliveScheduleExpression());
            }).orElse(false);
        }
        catch (ResourceNotFoundException ignored) {
            return true;
        }
    }

    private boolean isScheduleRuleChanged(LambdaFunction lambdaFunction) {
        try {
            return lambdaFunction.getTriggers().stream().filter(t -> "CloudWatch Events - Schedule".equals(t.getIntegration())).anyMatch(trigger -> {
                DescribeRuleResult res = this.eventsClient.describeRule(new DescribeRuleRequest().withName(trigger.getRuleName()));
                return !Objects.equals(res.getName(), trigger.getRuleName()) || !Objects.equals(res.getDescription(), trigger.getRuleDescription()) || !Objects.equals(res.getScheduleExpression(), trigger.getScheduleExpression());
            });
        }
        catch (ResourceNotFoundException ignored) {
            return true;
        }
    }

    private boolean isAliasesChanged(LambdaFunction lambdaFunction) {
        try {
            ListAliasesResult listAliasesResult = this.lambdaClient.listAliases(new ListAliasesRequest().withFunctionName(lambdaFunction.getFunctionName()));
            List configuredAliases = listAliasesResult.getAliases().stream().map(AliasConfiguration::getName).collect(Collectors.toList());
            return !configuredAliases.containsAll(lambdaFunction.getAliases());
        }
        catch (com.amazonaws.services.lambda.model.ResourceNotFoundException ignored) {
            return true;
        }
    }

    private VpcConfig getVpcConfig(LambdaFunction lambdaFunction) {
        return new VpcConfig().withSecurityGroupIds(lambdaFunction.getSecurityGroupIds()).withSubnetIds(lambdaFunction.getSubnetIds());
    }
}

