/*
 * Decompiled with CFR 0.152.
 */
package com.github.seanroy.plugins;

import com.amazonaws.services.lambda.model.GetFunctionRequest;
import com.amazonaws.services.lambda.model.ResourceNotFoundException;
import com.github.seanroy.plugins.AbstractLambdaMojo;
import com.github.seanroy.plugins.LambdaFunction;
import java.util.function.Function;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="update-lambda-code")
public class UpdateLambdaCodeMojo
extends AbstractLambdaMojo {
    private Function<LambdaFunction, LambdaFunction> updateFunctionCodeIfExists = lambdaFunction -> {
        try {
            lambdaFunction.setFunctionArn(this.lambdaClient.getFunction(new GetFunctionRequest().withFunctionName(lambdaFunction.getFunctionName())).getConfiguration().getFunctionArn());
            this.updateFunctionCode.apply(lambdaFunction);
        }
        catch (ResourceNotFoundException e) {
            this.getLog().info((CharSequence)"Lambda function not found", (Throwable)e);
        }
        return lambdaFunction;
    };

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        try {
            this.uploadJarToS3();
            this.lambdaFunctions.stream().map(f -> {
                this.getLog().info((CharSequence)("---- Update function code " + f.getFunctionName() + " -----"));
                return f;
            }).forEach(lf -> this.updateFunctionCodeIfExists.apply((LambdaFunction)lf));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error during processing", (Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
    }
}

