/*
 * Decompiled with CFR 0.152.
 */
package com.github.seanroy.utils;

import com.amazonaws.encryptionsdk.AwsCrypto;
import com.amazonaws.encryptionsdk.CryptoResult;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.kms.KmsMasterKeyProvider;

public class AWSEncryption {
    private String keyArn;

    public AWSEncryption(String keyArn) {
        this.keyArn = keyArn;
    }

    public String encryptString(String data) {
        AwsCrypto crypto = AwsCrypto.builder().build();
        KmsMasterKeyProvider prov = KmsMasterKeyProvider.builder().buildStrict(new String[]{this.keyArn});
        return (String)crypto.encryptString((MasterKeyProvider)prov, data).getResult();
    }

    public String decryptString(String cipherText) {
        AwsCrypto crypto = AwsCrypto.builder().build();
        KmsMasterKeyProvider prov = KmsMasterKeyProvider.builder().buildStrict(new String[]{this.keyArn});
        CryptoResult decryptResult = crypto.decryptString((MasterKeyProvider)prov, cipherText);
        if (!((String)decryptResult.getMasterKeyIds().get(0)).equals(this.keyArn)) {
            throw new IllegalStateException("Wrong encryption key ARN!");
        }
        return (String)decryptResult.getResult();
    }
}

