/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine;

import com.github.searls.jasmine.AbstractJasmineMojo;
import com.github.searls.jasmine.format.JasmineResultLogger;
import com.github.searls.jasmine.model.JasmineResult;
import com.github.searls.jasmine.runner.ReporterType;
import com.github.searls.jasmine.runner.SpecRunnerExecutor;
import com.github.searls.jasmine.runner.SpecRunnerHtmlGenerator;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class TestMojo
extends AbstractJasmineMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skipTests) {
            JasmineResult result;
            this.getLog().info((CharSequence)"Executing Jasmine Tests");
            try {
                File runnerFile = this.writeSpecRunnerToOutputDirectory();
                result = new SpecRunnerExecutor().execute(runnerFile.toURI().toURL(), new File(this.jasmineTargetDir, this.junitXmlReportFileName), this.browserVersion);
            }
            catch (Exception e) {
                throw new MojoExecutionException((Object)e, "There was a problem executing Jasmine specs", e.getMessage());
            }
            this.logResults(result);
            if (this.haltOnFailure && !result.didPass()) {
                throw new MojoFailureException("There were Jasmine spec failures.");
            }
        } else {
            this.getLog().info((CharSequence)"Skipping Jasmine Tests");
        }
    }

    private void logResults(JasmineResult result) {
        JasmineResultLogger resultLogger = new JasmineResultLogger();
        resultLogger.setLog(this.getLog());
        resultLogger.log(result);
    }

    private File writeSpecRunnerToOutputDirectory() throws IOException {
        SpecRunnerHtmlGenerator htmlGenerator = new SpecRunnerHtmlGenerator(new File(this.jasmineTargetDir, this.srcDirectoryName), new File(this.jasmineTargetDir, this.specDirectoryName), this.preloadSources, this.sourceEncoding);
        String html = htmlGenerator.generate(ReporterType.JsApiReporter, this.customRunnerTemplate);
        this.getLog().debug((CharSequence)("Writing out Spec Runner HTML " + html + " to directory " + this.jasmineTargetDir));
        File runnerFile = new File(this.jasmineTargetDir, this.specRunnerHtmlFileName);
        FileUtils.writeStringToFile((File)runnerFile, (String)html);
        return runnerFile;
    }
}

