/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.runner;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.IncorrectnessListener;
import com.gargoylesoftware.htmlunit.NicelyResynchronizingAjaxController;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.github.searls.jasmine.io.FileUtilsWrapper;
import com.github.searls.jasmine.io.IOUtilsWrapper;
import com.github.searls.jasmine.model.JasmineResult;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class SpecRunnerExecutor {
    public static final String BUILD_REPORT_JS = "/buildReport.js";
    public static final String BUILD_CONCLUSION_JS = "/buildConclusion.js";
    public static final String CREATE_JUNIT_XML = "/createJunitXml.js";
    private static final long MAX_EXECUTION_MILLIS = 300000L;
    private IOUtilsWrapper ioUtilsWrapper = new IOUtilsWrapper();
    private FileUtilsWrapper fileUtilsWrapper = new FileUtilsWrapper();

    public JasmineResult execute(URL runnerUrl, File junitXmlReport, String browserVersion) {
        try {
            BrowserVersion htmlUnitBrowserVersion = (BrowserVersion)BrowserVersion.class.getField(browserVersion).get(BrowserVersion.class);
            WebClient webClient = new WebClient(htmlUnitBrowserVersion);
            webClient.setJavaScriptEnabled(true);
            webClient.setAjaxController((AjaxController)new NicelyResynchronizingAjaxController());
            this.quietIncorrectnessListener(webClient);
            HtmlPage page = (HtmlPage)webClient.getPage(runnerUrl);
            this.waitForRunnerToFinish(page);
            JasmineResult jasmineResult = new JasmineResult();
            jasmineResult.setDescription(this.buildRunnerDescription(page));
            jasmineResult.setDetails(this.buildReport(page));
            this.fileUtilsWrapper.writeStringToFile(junitXmlReport, this.buildJunitXmlReport(page), "UTF-8");
            webClient.closeAllWindows();
            return jasmineResult;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String buildReport(HtmlPage page) throws IOException {
        ScriptResult report = page.executeJavaScript(this.ioUtilsWrapper.toString(BUILD_REPORT_JS));
        return report.getJavaScriptResult().toString();
    }

    private String buildRunnerDescription(HtmlPage page) throws IOException {
        ScriptResult description = page.executeJavaScript(this.ioUtilsWrapper.toString(BUILD_CONCLUSION_JS));
        return description.getJavaScriptResult().toString();
    }

    private String buildJunitXmlReport(HtmlPage page) throws IOException {
        ScriptResult junitReport = page.executeJavaScript(this.ioUtilsWrapper.toString(CREATE_JUNIT_XML) + "junitXmlReporter.report(reporter);");
        return junitReport.getJavaScriptResult().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForRunnerToFinish(HtmlPage page) throws InterruptedException {
        page.getWebClient().waitForBackgroundJavaScript(5000L);
        int waitInMillis = 500;
        int i = 0;
        while ((long)i < 300000L / (long)waitInMillis) {
            if (this.executionFinished(page).booleanValue()) {
                return;
            }
            HtmlPage htmlPage = page;
            synchronized (htmlPage) {
                page.wait(waitInMillis);
            }
            ++i;
        }
        if (!this.executionFinished(page).booleanValue()) {
            throw new IllegalStateException("Attempted to wait for the test to complete processing over the course of 300 seconds,but it still appears to be running. Aborting test execution.");
        }
    }

    private Boolean executionFinished(HtmlPage page) {
        ScriptResult result = page.executeJavaScript("reporter.finished");
        return (Boolean)result.getJavaScriptResult();
    }

    private void quietIncorrectnessListener(WebClient webClient) {
        webClient.setIncorrectnessListener(new IncorrectnessListener(){

            public void notify(String arg0, Object arg1) {
            }
        });
    }
}

