/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.runner;

import com.github.searls.jasmine.io.FileUtilsWrapper;
import com.github.searls.jasmine.io.IOUtilsWrapper;
import com.github.searls.jasmine.runner.ReporterType;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecRunnerHtmlGenerator {
    public static final String DEFAULT_RUNNER_HTML_TEMPLATE_FILE = "/jasmine-templates/SpecRunner.htmltemplate";
    public static final String DEFAULT_SOURCE_ENCODING = "UTF-8";
    private static final String SOURCE_ENCODING = "sourceEncoding";
    private static final String CSS_DEPENDENCIES_TEMPLATE_ATTR_NAME = "cssDependencies";
    private static final String JAVASCRIPT_DEPENDENCIES_TEMPLATE_ATTR_NAME = "javascriptDependencies";
    private static final String SOURCES_TEMPLATE_ATTR_NAME = "sources";
    private static final String REPORTER_ATTR_NAME = "reporter";
    public static final String JASMINE_JS = "/vendor/js/jasmine.js";
    public static final String JASMINE_HTML_JS = "/vendor/js/jasmine-html.js";
    public static final String CONSOLE_X_JS = "/vendor/js/consolex.js";
    public static final String JSON_2_JS = "/vendor/js/json2.js";
    public static final String JASMINE_CSS = "/vendor/css/jasmine.css";
    private FileUtilsWrapper fileUtilsWrapper = new FileUtilsWrapper();
    private IOUtilsWrapper ioUtilsWrapper = new IOUtilsWrapper();
    private File sourceDir;
    private File specDir;
    private List<String> sourcesToLoadFirst;
    private List<String> fileNamesAlreadyWrittenAsScriptTags = new ArrayList<String>();
    private String sourceEncoding;

    public SpecRunnerHtmlGenerator(File sourceDir, File specDir, List<String> sourcesToLoadFirst, String sourceEncoding) {
        this.sourcesToLoadFirst = sourcesToLoadFirst;
        this.sourceDir = sourceDir;
        this.specDir = specDir;
        this.sourceEncoding = sourceEncoding;
    }

    public String generate(ReporterType reporterType, File customRunnerTemplate) {
        try {
            String htmlTemplate = this.resolveHtmlTemplate(customRunnerTemplate);
            StringTemplate template = new StringTemplate(htmlTemplate, DefaultTemplateLexer.class);
            this.includeJavaScriptDependencies(Arrays.asList(JASMINE_JS, JASMINE_HTML_JS, CONSOLE_X_JS, JSON_2_JS), template);
            this.includeCssDependencies(Arrays.asList(JASMINE_CSS), template);
            this.setJavaScriptSourcesAttribute(template);
            template.setAttribute(REPORTER_ATTR_NAME, (Object)reporterType.name());
            template.setAttribute(SOURCE_ENCODING, (Object)(StringUtils.isNotBlank((String)this.sourceEncoding) ? this.sourceEncoding : DEFAULT_SOURCE_ENCODING));
            return template.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load file names for dependencies or scripts", e);
        }
    }

    private String resolveHtmlTemplate(File customRunnerTemplate) throws IOException {
        return customRunnerTemplate != null ? this.fileUtilsWrapper.readFileToString(customRunnerTemplate) : this.ioUtilsWrapper.toString(DEFAULT_RUNNER_HTML_TEMPLATE_FILE);
    }

    private void includeJavaScriptDependencies(List<String> dependencies, StringTemplate template) throws IOException {
        StringBuilder js = new StringBuilder();
        for (String jsFile : dependencies) {
            js.append("<script type=\"text/javascript\">").append(this.ioUtilsWrapper.toString(jsFile)).append("</script>");
        }
        template.setAttribute(JAVASCRIPT_DEPENDENCIES_TEMPLATE_ATTR_NAME, (Object)js.toString());
    }

    private void includeCssDependencies(List<String> dependencies, StringTemplate template) throws IOException {
        StringBuilder css = new StringBuilder();
        for (String cssFile : dependencies) {
            css.append("<style type=\"text/css\">").append(this.ioUtilsWrapper.toString(cssFile)).append("</style>");
        }
        template.setAttribute(CSS_DEPENDENCIES_TEMPLATE_ATTR_NAME, (Object)css.toString());
    }

    private void setJavaScriptSourcesAttribute(StringTemplate template) throws IOException {
        StringBuilder scriptTags = new StringBuilder();
        this.appendScriptTagsForFiles(scriptTags, this.expandSourcesToLoadFirstRelativeToSourceDir());
        this.appendScriptTagsForFiles(scriptTags, this.filesForScriptsInDirectory(this.sourceDir));
        this.appendScriptTagsForFiles(scriptTags, this.filesForScriptsInDirectory(this.specDir));
        template.setAttribute(SOURCES_TEMPLATE_ATTR_NAME, (Object)scriptTags.toString());
    }

    private List<String> expandSourcesToLoadFirstRelativeToSourceDir() {
        ArrayList<String> files = new ArrayList<String>();
        if (this.sourcesToLoadFirst != null) {
            for (String sourceToLoadFirst : this.sourcesToLoadFirst) {
                File file = new File(this.sourceDir, sourceToLoadFirst);
                File specFile = new File(this.specDir, sourceToLoadFirst);
                if (file.exists()) {
                    files.add(this.fileToString(file));
                    continue;
                }
                if (specFile.exists()) {
                    files.add(this.fileToString(specFile));
                    continue;
                }
                files.add(sourceToLoadFirst);
            }
        }
        return files;
    }

    private List<String> filesForScriptsInDirectory(File directory) throws IOException {
        ArrayList<String> fileNames = new ArrayList<String>();
        if (directory != null) {
            this.fileUtilsWrapper.forceMkdir(directory);
            ArrayList<File> files = new ArrayList<File>(this.fileUtilsWrapper.listFiles(directory, new String[]{"js"}, true));
            Collections.sort(files);
            for (File file : files) {
                fileNames.add(this.fileToString(file));
            }
        }
        return fileNames;
    }

    private void appendScriptTagsForFiles(StringBuilder sb, List<String> sourceFiles) {
        for (String sourceFile : sourceFiles) {
            if (this.fileNamesAlreadyWrittenAsScriptTags.contains(sourceFile)) continue;
            sb.append("<script type=\"text/javascript\" src=\"").append(sourceFile).append("\"></script>");
            this.fileNamesAlreadyWrittenAsScriptTags.add(sourceFile);
        }
    }

    private String fileToString(File file) {
        try {
            return file.toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

