package com.github.searls.jasmine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on jasmine-maven-plugin.<br/> Call <pre>  mvn jasmine:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Tue Jan 25 21:32:03 EST 2011
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.5.1)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "com.github.searls:jasmine-maven-plugin:1.0.1-beta-6", 0 );
        append( sb, "", 0 );

        append( sb, "jasmine-maven-plugin", 0 );
        append( sb, "A JavaScript unit test plugin that processes JavaScript sources and Jasmine specs, prepares test runner HTML files, executes Jasmine specs headlessly with HtmlUnit, and produces JUnit XML reports", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 6 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "generateManualRunner".equals( goal ) )
        {
            append( sb, "jasmine:generateManualRunner", 0 );
            append( sb, "(no description available)", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "browserVersion (Default: FIREFOX_3)", 2 );
                append( sb, "Determines the browser and version profile to execute the headless specs against. Because the plugin executes specs using HtmlUnit, this maps 1-to-1 with the public static instances found in BrowserVersion. Some valid examples: FIREFOX_3_6, INTERNET_EXPLORER_6, INTERNET_EXPLORER_7, INTERNET_EXPLORER_8", 3 );
                append( sb, "", 0 );

                append( sb, "customRunnerTemplate", 2 );
                append( sb, "It may be the case that the jasmine-maven-plugin doesn\'t currently suit all of your needs, and as a result the generated SpecRunner HTML files are set up in a way that you can\'t run your specs. Have no fear! Simply specify a custom spec runner template in the plugin configuration and make the changes you need. The default template is stored in `src/main/resources/jasmine-templates/SpecRunner.htmltemplate`, and the required template strings are tokenized in \'$*$\' patterns. Example usage: <customRunnerTemplate>${project.basedir}/src/test/resources/myCustomRunner.template</customRunnerTemplate>", 3 );
                append( sb, "", 0 );

                append( sb, "haltOnFailure (Default: true)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "jasmineTargetDir (Default: ${project.build.directory}${file.separator}jasmine)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "jsSrcDir (Default: ${project.basedir}${file.separator}src${file.separator}main${file.separator}javascript)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "jsTestSrcDir (Default: ${project.basedir}${file.separator}src${file.separator}test${file.separator}javascript)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "junitXmlReportFileName (Default: TEST-jasmine.xml)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "manualSpecRunnerHtmlFileName (Default: ManualSpecRunner.html)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "mavenProject (Default: ${project})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "packageDir (Default: ${project.build.directory}${file.separator}${project.build.finalName})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "packageJavaScriptPath (Default: js)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "preloadSources", 2 );
                append( sb, "JavaScript sources (typically vendor/lib dependencies) that need to be loaded before other sources (and specs) in a particular order. Each source will first be searched for relative to ${jsSrcDir}, then ${jsTestSrcDir}, then (if it\'s not found in either) it will be included exactly as it appears in your POM. Therefore, if jquery.js is in `${jsSrcDir}/vendor`, you would configure: <preloadSources> <source>vendor/z.js</source> </preloadSources> And z.js would load before all the other sources and specs.", 3 );
                append( sb, "", 0 );

                append( sb, "skipTests", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "specDirectoryName (Default: spec)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "specRunnerHtmlFileName (Default: SpecRunner.html)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "srcDirectoryName (Default: src)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "jasmine:help", 0 );
            append( sb, "Display help information on jasmine-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0jasmine:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "preparePackage".equals( goal ) )
        {
            append( sb, "jasmine:preparePackage", 0 );
            append( sb, "(no description available)", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "browserVersion (Default: FIREFOX_3)", 2 );
                append( sb, "Determines the browser and version profile to execute the headless specs against. Because the plugin executes specs using HtmlUnit, this maps 1-to-1 with the public static instances found in BrowserVersion. Some valid examples: FIREFOX_3_6, INTERNET_EXPLORER_6, INTERNET_EXPLORER_7, INTERNET_EXPLORER_8", 3 );
                append( sb, "", 0 );

                append( sb, "customRunnerTemplate", 2 );
                append( sb, "It may be the case that the jasmine-maven-plugin doesn\'t currently suit all of your needs, and as a result the generated SpecRunner HTML files are set up in a way that you can\'t run your specs. Have no fear! Simply specify a custom spec runner template in the plugin configuration and make the changes you need. The default template is stored in `src/main/resources/jasmine-templates/SpecRunner.htmltemplate`, and the required template strings are tokenized in \'$*$\' patterns. Example usage: <customRunnerTemplate>${project.basedir}/src/test/resources/myCustomRunner.template</customRunnerTemplate>", 3 );
                append( sb, "", 0 );

                append( sb, "haltOnFailure (Default: true)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "jasmineTargetDir (Default: ${project.build.directory}${file.separator}jasmine)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "jsSrcDir (Default: ${project.basedir}${file.separator}src${file.separator}main${file.separator}javascript)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "jsTestSrcDir (Default: ${project.basedir}${file.separator}src${file.separator}test${file.separator}javascript)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "junitXmlReportFileName (Default: TEST-jasmine.xml)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "manualSpecRunnerHtmlFileName (Default: ManualSpecRunner.html)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "mavenProject (Default: ${project})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "packageDir (Default: ${project.build.directory}${file.separator}${project.build.finalName})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "packageJavaScriptPath (Default: js)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "preloadSources", 2 );
                append( sb, "JavaScript sources (typically vendor/lib dependencies) that need to be loaded before other sources (and specs) in a particular order. Each source will first be searched for relative to ${jsSrcDir}, then ${jsTestSrcDir}, then (if it\'s not found in either) it will be included exactly as it appears in your POM. Therefore, if jquery.js is in `${jsSrcDir}/vendor`, you would configure: <preloadSources> <source>vendor/z.js</source> </preloadSources> And z.js would load before all the other sources and specs.", 3 );
                append( sb, "", 0 );

                append( sb, "skipTests", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "specDirectoryName (Default: spec)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "specRunnerHtmlFileName (Default: SpecRunner.html)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "srcDirectoryName (Default: src)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "resources".equals( goal ) )
        {
            append( sb, "jasmine:resources", 0 );
            append( sb, "(no description available)", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "browserVersion (Default: FIREFOX_3)", 2 );
                append( sb, "Determines the browser and version profile to execute the headless specs against. Because the plugin executes specs using HtmlUnit, this maps 1-to-1 with the public static instances found in BrowserVersion. Some valid examples: FIREFOX_3_6, INTERNET_EXPLORER_6, INTERNET_EXPLORER_7, INTERNET_EXPLORER_8", 3 );
                append( sb, "", 0 );

                append( sb, "customRunnerTemplate", 2 );
                append( sb, "It may be the case that the jasmine-maven-plugin doesn\'t currently suit all of your needs, and as a result the generated SpecRunner HTML files are set up in a way that you can\'t run your specs. Have no fear! Simply specify a custom spec runner template in the plugin configuration and make the changes you need. The default template is stored in `src/main/resources/jasmine-templates/SpecRunner.htmltemplate`, and the required template strings are tokenized in \'$*$\' patterns. Example usage: <customRunnerTemplate>${project.basedir}/src/test/resources/myCustomRunner.template</customRunnerTemplate>", 3 );
                append( sb, "", 0 );

                append( sb, "haltOnFailure (Default: true)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "jasmineTargetDir (Default: ${project.build.directory}${file.separator}jasmine)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "jsSrcDir (Default: ${project.basedir}${file.separator}src${file.separator}main${file.separator}javascript)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "jsTestSrcDir (Default: ${project.basedir}${file.separator}src${file.separator}test${file.separator}javascript)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "junitXmlReportFileName (Default: TEST-jasmine.xml)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "manualSpecRunnerHtmlFileName (Default: ManualSpecRunner.html)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "mavenProject (Default: ${project})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "packageDir (Default: ${project.build.directory}${file.separator}${project.build.finalName})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "packageJavaScriptPath (Default: js)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "preloadSources", 2 );
                append( sb, "JavaScript sources (typically vendor/lib dependencies) that need to be loaded before other sources (and specs) in a particular order. Each source will first be searched for relative to ${jsSrcDir}, then ${jsTestSrcDir}, then (if it\'s not found in either) it will be included exactly as it appears in your POM. Therefore, if jquery.js is in `${jsSrcDir}/vendor`, you would configure: <preloadSources> <source>vendor/z.js</source> </preloadSources> And z.js would load before all the other sources and specs.", 3 );
                append( sb, "", 0 );

                append( sb, "skipTests", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "specDirectoryName (Default: spec)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "specRunnerHtmlFileName (Default: SpecRunner.html)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "srcDirectoryName (Default: src)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "test".equals( goal ) )
        {
            append( sb, "jasmine:test", 0 );
            append( sb, "(no description available)", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "browserVersion (Default: FIREFOX_3)", 2 );
                append( sb, "Determines the browser and version profile to execute the headless specs against. Because the plugin executes specs using HtmlUnit, this maps 1-to-1 with the public static instances found in BrowserVersion. Some valid examples: FIREFOX_3_6, INTERNET_EXPLORER_6, INTERNET_EXPLORER_7, INTERNET_EXPLORER_8", 3 );
                append( sb, "", 0 );

                append( sb, "customRunnerTemplate", 2 );
                append( sb, "It may be the case that the jasmine-maven-plugin doesn\'t currently suit all of your needs, and as a result the generated SpecRunner HTML files are set up in a way that you can\'t run your specs. Have no fear! Simply specify a custom spec runner template in the plugin configuration and make the changes you need. The default template is stored in `src/main/resources/jasmine-templates/SpecRunner.htmltemplate`, and the required template strings are tokenized in \'$*$\' patterns. Example usage: <customRunnerTemplate>${project.basedir}/src/test/resources/myCustomRunner.template</customRunnerTemplate>", 3 );
                append( sb, "", 0 );

                append( sb, "haltOnFailure (Default: true)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "jasmineTargetDir (Default: ${project.build.directory}${file.separator}jasmine)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "jsSrcDir (Default: ${project.basedir}${file.separator}src${file.separator}main${file.separator}javascript)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "jsTestSrcDir (Default: ${project.basedir}${file.separator}src${file.separator}test${file.separator}javascript)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "junitXmlReportFileName (Default: TEST-jasmine.xml)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "manualSpecRunnerHtmlFileName (Default: ManualSpecRunner.html)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "mavenProject (Default: ${project})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "packageDir (Default: ${project.build.directory}${file.separator}${project.build.finalName})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "packageJavaScriptPath (Default: js)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "preloadSources", 2 );
                append( sb, "JavaScript sources (typically vendor/lib dependencies) that need to be loaded before other sources (and specs) in a particular order. Each source will first be searched for relative to ${jsSrcDir}, then ${jsTestSrcDir}, then (if it\'s not found in either) it will be included exactly as it appears in your POM. Therefore, if jquery.js is in `${jsSrcDir}/vendor`, you would configure: <preloadSources> <source>vendor/z.js</source> </preloadSources> And z.js would load before all the other sources and specs.", 3 );
                append( sb, "", 0 );

                append( sb, "skipTests", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "specDirectoryName (Default: spec)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "specRunnerHtmlFileName (Default: SpecRunner.html)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "srcDirectoryName (Default: src)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "testResources".equals( goal ) )
        {
            append( sb, "jasmine:testResources", 0 );
            append( sb, "(no description available)", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "browserVersion (Default: FIREFOX_3)", 2 );
                append( sb, "Determines the browser and version profile to execute the headless specs against. Because the plugin executes specs using HtmlUnit, this maps 1-to-1 with the public static instances found in BrowserVersion. Some valid examples: FIREFOX_3_6, INTERNET_EXPLORER_6, INTERNET_EXPLORER_7, INTERNET_EXPLORER_8", 3 );
                append( sb, "", 0 );

                append( sb, "customRunnerTemplate", 2 );
                append( sb, "It may be the case that the jasmine-maven-plugin doesn\'t currently suit all of your needs, and as a result the generated SpecRunner HTML files are set up in a way that you can\'t run your specs. Have no fear! Simply specify a custom spec runner template in the plugin configuration and make the changes you need. The default template is stored in `src/main/resources/jasmine-templates/SpecRunner.htmltemplate`, and the required template strings are tokenized in \'$*$\' patterns. Example usage: <customRunnerTemplate>${project.basedir}/src/test/resources/myCustomRunner.template</customRunnerTemplate>", 3 );
                append( sb, "", 0 );

                append( sb, "haltOnFailure (Default: true)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "jasmineTargetDir (Default: ${project.build.directory}${file.separator}jasmine)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "jsSrcDir (Default: ${project.basedir}${file.separator}src${file.separator}main${file.separator}javascript)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "jsTestSrcDir (Default: ${project.basedir}${file.separator}src${file.separator}test${file.separator}javascript)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "junitXmlReportFileName (Default: TEST-jasmine.xml)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "manualSpecRunnerHtmlFileName (Default: ManualSpecRunner.html)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "mavenProject (Default: ${project})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "packageDir (Default: ${project.build.directory}${file.separator}${project.build.finalName})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "packageJavaScriptPath (Default: js)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "preloadSources", 2 );
                append( sb, "JavaScript sources (typically vendor/lib dependencies) that need to be loaded before other sources (and specs) in a particular order. Each source will first be searched for relative to ${jsSrcDir}, then ${jsTestSrcDir}, then (if it\'s not found in either) it will be included exactly as it appears in your POM. Therefore, if jquery.js is in `${jsSrcDir}/vendor`, you would configure: <preloadSources> <source>vendor/z.js</source> </preloadSources> And z.js would load before all the other sources and specs.", 3 );
                append( sb, "", 0 );

                append( sb, "skipTests", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "specDirectoryName (Default: spec)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "specRunnerHtmlFileName (Default: SpecRunner.html)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "srcDirectoryName (Default: src)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
