/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine;

import com.github.searls.jasmine.AbstractJasmineMojo;
import com.github.searls.jasmine.runner.ReporterType;
import com.github.searls.jasmine.runner.SpecRunnerHtmlGenerator;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class GenerateManualRunnerMojo
extends AbstractJasmineMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.jsSrcDir.exists() && this.jsTestSrcDir.exists()) {
            this.getLog().info((CharSequence)("Generating runner '" + this.manualSpecRunnerHtmlFileName + "' in the Jasmine plugin's target directory to open in a browser to facilitate faster feedback."));
            try {
                this.writeSpecRunnerToSourceSpecDirectory();
            }
            catch (Exception e) {
                throw new MojoFailureException((Object)e, "JavaScript Test execution failed.", "Failed to generate " + this.manualSpecRunnerHtmlFileName);
            }
        } else {
            this.getLog().warn((CharSequence)("Skipping manual spec runner generation. Check to make sure that both JavaScript directories `" + this.jsSrcDir.getAbsolutePath() + "` and `" + this.jsTestSrcDir.getAbsolutePath() + "` exist."));
        }
    }

    private void writeSpecRunnerToSourceSpecDirectory() throws IOException {
        File destination;
        String existingRunner;
        SpecRunnerHtmlGenerator htmlGenerator = new SpecRunnerHtmlGenerator(this.jsSrcDir, this.jsTestSrcDir, this.preloadSources, this.sourceEncoding);
        String runner = htmlGenerator.generate(ReporterType.TrivialReporter, this.customRunnerTemplate);
        if (!StringUtils.equals((String)runner, (String)(existingRunner = this.loadExistingManualRunner(destination = new File(this.jasmineTargetDir, this.manualSpecRunnerHtmlFileName))))) {
            FileUtils.writeStringToFile((File)destination, (String)runner);
        } else {
            this.getLog().info((CharSequence)"Skipping spec runner generation, because an identical spec runner already exists.");
        }
    }

    private String loadExistingManualRunner(File destination) {
        String existingRunner = null;
        try {
            if (destination.exists()) {
                existingRunner = FileUtils.readFileToString((File)destination);
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"An error occurred while trying to open an existing manual spec runner. Continuing");
        }
        return existingRunner;
    }
}

