/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine;

import com.github.searls.jasmine.exception.StringifiesStackTraces;
import com.github.searls.jasmine.io.ScansDirectory;
import com.github.searls.jasmine.model.ScriptSearch;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public abstract class AbstractJasmineMojo
extends AbstractMojo {
    private File jsSrcDir;
    private File jsTestSrcDir;
    protected String browserVersion;
    protected String format;
    protected String packageJavaScriptPath;
    protected List<String> preloadSources;
    protected File customRunnerTemplate;
    protected File jasmineTargetDir;
    protected boolean skipTests;
    protected boolean haltOnFailure;
    protected int timeout;
    protected boolean debug;
    protected File packageDir;
    protected String specRunnerHtmlFileName;
    protected String manualSpecRunnerHtmlFileName;
    protected String junitXmlReportFileName;
    protected String specDirectoryName;
    protected String srcDirectoryName;
    protected String sourceEncoding;
    private List<String> sourceIncludes = ScansDirectory.DEFAULT_INCLUDES;
    private List<String> sourceExcludes = Collections.emptyList();
    private List<String> specIncludes = ScansDirectory.DEFAULT_INCLUDES;
    private List<String> specExcludes = Collections.emptyList();
    protected MavenProject mavenProject;
    protected int serverPort;
    protected ScriptSearch sources;
    protected ScriptSearch specs;
    protected StringifiesStackTraces stringifiesStackTraces = new StringifiesStackTraces();

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.sources = new ScriptSearch(this.jsSrcDir, this.sourceIncludes, this.sourceExcludes);
        this.specs = new ScriptSearch(this.jsTestSrcDir, this.specIncludes, this.specExcludes);
        try {
            this.run();
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("The jasmine-maven-plugin encountered an exception: \n" + this.stringifiesStackTraces.stringify(e), e);
        }
    }

    public abstract void run() throws Exception;
}

