/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine;

import com.github.searls.jasmine.AbstractJasmineMojo;
import com.github.searls.jasmine.io.FileUtilsWrapper;
import com.github.searls.jasmine.io.scripts.RelativizesASetOfScripts;
import com.github.searls.jasmine.io.scripts.ResolvesCompleteListOfScriptLocations;
import com.github.searls.jasmine.runner.ReporterType;
import com.github.searls.jasmine.runner.SpecRunnerHtmlGenerator;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatesManualRunner {
    private ResolvesCompleteListOfScriptLocations resolvesCompleteListOfScriptLocations = new ResolvesCompleteListOfScriptLocations();
    private RelativizesASetOfScripts relativizesASetOfScripts = new RelativizesASetOfScripts();
    private FileUtilsWrapper fileUtilsWrapper = new FileUtilsWrapper();
    private AbstractJasmineMojo config;
    private Log log;

    public CreatesManualRunner(AbstractJasmineMojo config) {
        this.config = config;
        this.log = config.getLog();
    }

    public void create() throws IOException {
        if (this.writingAManualSpecRunnerIsNecessary()) {
            this.log.info((CharSequence)("Generating runner '" + this.config.manualSpecRunnerHtmlFileName + "' in the Jasmine plugin's target directory to open in a browser to facilitate faster feedback."));
            this.writeSpecRunnerToSourceSpecDirectory();
        } else {
            this.log.warn((CharSequence)("Skipping manual spec runner generation. Check to make sure that both JavaScript directories `" + this.config.sources.getDirectory().getAbsolutePath() + "` and `" + this.config.specs.getDirectory().getAbsolutePath() + "` exist."));
        }
    }

    private boolean writingAManualSpecRunnerIsNecessary() {
        return this.config.sources.getDirectory().exists() && this.config.specs.getDirectory().exists();
    }

    private void writeSpecRunnerToSourceSpecDirectory() throws IOException {
        File runnerDestination = new File(this.config.jasmineTargetDir, this.config.manualSpecRunnerHtmlFileName);
        String newRunnerHtml = new SpecRunnerHtmlGenerator(this.scriptsForRunner(), this.config.sourceEncoding).generate(ReporterType.TrivialReporter, this.config.customRunnerTemplate);
        if (this.newRunnerDiffersFromOldRunner(runnerDestination, newRunnerHtml)) {
            this.saveRunner(runnerDestination, newRunnerHtml);
        } else {
            this.log.info((CharSequence)"Skipping spec runner generation, because an identical spec runner already exists.");
        }
    }

    private Set<String> scriptsForRunner() throws IOException {
        return this.relativizesASetOfScripts.relativize(this.config.jasmineTargetDir, this.resolvesCompleteListOfScriptLocations.resolve(this.config.sources, this.config.specs, this.config.preloadSources));
    }

    private String existingRunner(File destination) throws IOException {
        String existingRunner = null;
        try {
            if (destination.exists()) {
                existingRunner = this.fileUtilsWrapper.readFileToString(destination);
            }
        }
        catch (Exception e) {
            this.log.warn((CharSequence)"An error occurred while trying to open an existing manual spec runner. Continuing.");
        }
        return existingRunner;
    }

    private boolean newRunnerDiffersFromOldRunner(File runnerDestination, String newRunner) throws IOException {
        return !StringUtils.equals((String)newRunner, (String)this.existingRunner(runnerDestination));
    }

    private void saveRunner(File runnerDestination, String newRunner) throws IOException {
        this.fileUtilsWrapper.writeStringToFile(runnerDestination, newRunner, this.config.sourceEncoding);
    }

    public void setLog(Log log) {
        this.log = log;
    }
}

