/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine;

import com.github.searls.jasmine.AbstractJasmineMojo;
import com.github.searls.jasmine.io.RelativizesFilePaths;
import com.github.searls.jasmine.server.JasmineResourceHandler;
import java.io.File;
import java.io.IOException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;

public class ServerMojo
extends AbstractJasmineMojo {
    private Server server = new Server();
    private RelativizesFilePaths relativizesFilePaths = new RelativizesFilePaths();

    public void run() throws Exception {
        this.addConnectorToServer();
        this.addHandlersToServer();
        this.startServer();
    }

    private void addConnectorToServer() {
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.serverPort);
        this.server.addConnector((Connector)connector);
    }

    private void addHandlersToServer() throws IOException {
        ResourceHandler resourceHandler = this.createResourceHandler();
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{resourceHandler, new DefaultHandler()});
        this.server.setHandler((Handler)handlers);
    }

    private ResourceHandler createResourceHandler() throws IOException {
        JasmineResourceHandler resourceHandler = new JasmineResourceHandler(this);
        resourceHandler.setDirectoriesListed(true);
        resourceHandler.setWelcomeFiles(new String[]{this.manualSpecRunnerPath()});
        resourceHandler.setResourceBase(this.mavenProject.getBasedir().getAbsolutePath());
        return resourceHandler;
    }

    private void startServer() throws Exception {
        this.server.start();
        this.getLog().info((CharSequence)this.buildServerInstructions());
        this.server.join();
    }

    private String buildServerInstructions() {
        return "\n\nServer started--it's time to spec some JavaScript! You can run your specs as you develop by visiting this URL in a web browser: \n\n\thttp://localhost:" + this.serverPort + "\n\n" + "Just leave this process running as you test-drive your code, refreshing your browser window to re-run your specs. You can kill the server with Ctrl-C when you're done.";
    }

    private String manualSpecRunnerPath() throws IOException {
        return this.relativizesFilePaths.relativize(this.mavenProject.getBasedir(), this.jasmineTargetDir) + File.separator + this.manualSpecRunnerHtmlFileName;
    }
}

