/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.codehaus.plexus.util.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScansDirectory {
    public static final List<String> DEFAULT_INCLUDES = Arrays.asList("**" + File.separator + "*.js", "**" + File.separator + "*.coffee");
    private DirectoryScanner directoryScanner = new DirectoryScanner();

    public List<String> scan(File directory, List<String> includes, List<String> excludes) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String include : includes) {
            set.addAll(this.performScan(directory, include, excludes));
        }
        return new ArrayList<String>(set);
    }

    private List<String> performScan(File directory, String include, List<String> excludes) {
        this.directoryScanner.setBasedir(directory);
        this.directoryScanner.setIncludes(new String[]{include});
        this.directoryScanner.setExcludes(excludes.toArray(new String[0]));
        this.directoryScanner.addDefaultExcludes();
        this.directoryScanner.scan();
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(this.directoryScanner.getIncludedFiles()));
        Collections.sort(result);
        return result;
    }
}

