/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine;

import com.github.searls.jasmine.AbstractJasmineMojo;
import com.github.searls.jasmine.format.JasmineResultLogger;
import com.github.searls.jasmine.io.scripts.ResolvesCompleteListOfScriptLocations;
import com.github.searls.jasmine.model.JasmineResult;
import com.github.searls.jasmine.model.ScriptSearch;
import com.github.searls.jasmine.runner.ReporterType;
import com.github.searls.jasmine.runner.SpecRunnerExecutor;
import com.github.searls.jasmine.runner.SpecRunnerHtmlGenerator;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoFailureException;

public class TestMojo
extends AbstractJasmineMojo {
    private ResolvesCompleteListOfScriptLocations resolvesCompleteListOfScriptLocations = new ResolvesCompleteListOfScriptLocations();

    public void run() throws Exception {
        if (!this.skipTests) {
            this.getLog().info((CharSequence)"Executing Jasmine Specs");
            File runnerFile = this.writeSpecRunnerToOutputDirectory();
            JasmineResult result = this.executeSpecs(runnerFile);
            this.logResults(result);
            this.throwAnySpecFailures(result);
        } else {
            this.getLog().info((CharSequence)"Skipping Jasmine Specs");
        }
    }

    private File writeSpecRunnerToOutputDirectory() throws IOException {
        Set<String> scripts = this.resolvesCompleteListOfScriptLocations.resolve(this.searchForDir(new File(this.jasmineTargetDir, this.srcDirectoryName), this.sources), this.searchForDir(new File(this.jasmineTargetDir, this.specDirectoryName), this.specs), this.preloadSources);
        SpecRunnerHtmlGenerator htmlGenerator = new SpecRunnerHtmlGenerator(scripts, this.sourceEncoding);
        String html = htmlGenerator.generate(ReporterType.JsApiReporter, this.customRunnerTemplate);
        this.getLog().debug((CharSequence)("Writing out Spec Runner HTML " + html + " to directory " + this.jasmineTargetDir));
        File runnerFile = new File(this.jasmineTargetDir, this.specRunnerHtmlFileName);
        FileUtils.writeStringToFile((File)runnerFile, (String)html);
        return runnerFile;
    }

    private JasmineResult executeSpecs(File runnerFile) throws MalformedURLException {
        JasmineResult result = new SpecRunnerExecutor().execute(runnerFile.toURI().toURL(), new File(this.jasmineTargetDir, this.junitXmlReportFileName), this.browserVersion, this.timeout, this.debug, this.getLog(), this.format);
        return result;
    }

    private void logResults(JasmineResult result) {
        JasmineResultLogger resultLogger = new JasmineResultLogger();
        resultLogger.setLog(this.getLog());
        resultLogger.log(result);
    }

    private void throwAnySpecFailures(JasmineResult result) throws MojoFailureException {
        if (this.haltOnFailure && !result.didPass()) {
            throw new MojoFailureException("There were Jasmine spec failures.");
        }
    }

    private ScriptSearch searchForDir(File dir, ScriptSearch search) {
        return new ScriptSearch(dir, search.getIncludes(), search.getExcludes());
    }
}

