/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.io.scripts;

import com.github.searls.jasmine.io.RelativizesFilePaths;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelativizesASetOfScripts {
    private RelativizesFilePaths relativizesFilePaths = new RelativizesFilePaths();

    public Set<String> relativize(File from, Set<String> absoluteScripts) throws IOException {
        LinkedHashSet<String> relativeScripts = new LinkedHashSet<String>();
        for (String absoluteScript : absoluteScripts) {
            File script = new File(this.normalize(absoluteScript));
            if (!this.webUrl(absoluteScript) && script.exists()) {
                relativeScripts.add(this.relativizesFilePaths.relativize(from, script));
                continue;
            }
            relativeScripts.add(absoluteScript);
        }
        return relativeScripts;
    }

    private String normalize(String absoluteScript) {
        String strip = "file:" + (File.separatorChar == '/' ? "" : "/");
        return StringUtils.stripStart((String)absoluteScript, (String)strip);
    }

    private boolean webUrl(String script) {
        return StringUtils.startsWithAny((String)script, (String[])new String[]{"http:", "https:"});
    }
}

