/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.runner;

import com.github.searls.jasmine.format.FormatsScriptTags;
import com.github.searls.jasmine.runner.HtmlGeneratorConfiguration;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSpecRunnerHtmlGenerator {
    private static final String SOURCE_ENCODING = "sourceEncoding";
    private static final String CSS_DEPENDENCIES_TEMPLATE_ATTR_NAME = "cssDependencies";
    private static final String JAVASCRIPT_DEPENDENCIES_TEMPLATE_ATTR_NAME = "javascriptDependencies";
    protected static final String SOURCES_TEMPLATE_ATTR_NAME = "sources";
    protected static final String REPORTER_ATTR_NAME = "reporter";
    private HtmlGeneratorConfiguration configuration;
    private FormatsScriptTags formatsScriptTags = new FormatsScriptTags();

    protected AbstractSpecRunnerHtmlGenerator(HtmlGeneratorConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void setEncoding(HtmlGeneratorConfiguration htmlGeneratorConfiguration, StringTemplate template) {
        template.setAttribute(SOURCE_ENCODING, (Object)(StringUtils.isNotBlank((String)htmlGeneratorConfiguration.getSourceEncoding()) ? htmlGeneratorConfiguration.getSourceEncoding() : "UTF-8"));
    }

    protected StringTemplate resolveHtmlTemplate() throws IOException {
        String htmlTemplate = this.configuration.getRunnerTemplate(this.getDefaultHtmlTemplatePath());
        return new StringTemplate(htmlTemplate, DefaultTemplateLexer.class);
    }

    protected void includeJavaScriptDependencies(List<String> dependencies, StringTemplate template) throws IOException {
        StringBuilder js = new StringBuilder();
        for (String jsFile : dependencies) {
            if (jsFile == null) continue;
            js.append("<script type=\"text/javascript\">").append(this.configuration.IOtoString(jsFile)).append("</script>");
        }
        template.setAttribute(JAVASCRIPT_DEPENDENCIES_TEMPLATE_ATTR_NAME, (Object)js.toString());
    }

    protected void applyCssToTemplate(List<String> styles, StringTemplate template) throws IOException {
        StringBuilder css = new StringBuilder();
        for (String cssFile : styles) {
            css.append("<style type=\"text/css\">").append(this.configuration.IOtoString(cssFile)).append("</style>");
        }
        template.setAttribute(CSS_DEPENDENCIES_TEMPLATE_ATTR_NAME, (Object)css.toString());
    }

    public HtmlGeneratorConfiguration getConfiguration() {
        return this.configuration;
    }

    protected abstract String getDefaultHtmlTemplatePath();

    protected void applyScriptTagsToTemplate(String sourcesTemplateAttrName, Set<String> scripts, StringTemplate template) throws IOException {
        template.setAttribute(sourcesTemplateAttrName, (Object)this.formatsScriptTags.format(scripts));
    }
}

