/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.runner;

import com.github.searls.jasmine.io.FileUtilsWrapper;
import com.github.searls.jasmine.io.IOUtilsWrapper;
import com.github.searls.jasmine.model.JasmineResult;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.maven.plugin.logging.Log;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.WebDriverWait;

public class SpecRunnerExecutor {
    public static final String BUILD_REPORT_JS = "/lib/buildReport.js";
    public static final String CREATE_JUNIT_XML = "/lib/createJunitXml.js";
    private IOUtilsWrapper ioUtilsWrapper = new IOUtilsWrapper();
    private FileUtilsWrapper fileUtilsWrapper = new FileUtilsWrapper();

    public JasmineResult execute(URL runnerUrl, File junitXmlReport, WebDriver driver, int timeout, boolean debug, Log log, String format) {
        try {
            if (!(driver instanceof JavascriptExecutor)) {
                throw new RuntimeException("The provided web driver can't execute JavaScript: " + driver.getClass());
            }
            JavascriptExecutor executor = (JavascriptExecutor)driver;
            driver.get(runnerUrl.toString());
            this.waitForRunnerToFinish(driver, timeout, debug, log);
            JasmineResult jasmineResult = new JasmineResult();
            jasmineResult.setDetails(this.buildReport(executor, format));
            this.fileUtilsWrapper.writeStringToFile(junitXmlReport, this.buildJunitXmlReport(executor, debug), "UTF-8");
            driver.quit();
            return jasmineResult;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String buildReport(JavascriptExecutor driver, String format) throws IOException {
        String script = this.ioUtilsWrapper.toString(BUILD_REPORT_JS) + "return jasmineMavenPlugin.printReport(window.reporter,{format:'" + format + "'});";
        Object report = driver.executeScript(script, new Object[0]);
        return report.toString();
    }

    private String buildJunitXmlReport(JavascriptExecutor driver, boolean debug) throws IOException {
        Object junitReport = driver.executeScript(this.ioUtilsWrapper.toString(CREATE_JUNIT_XML) + "return junitXmlReporter.report(reporter," + debug + ");", new Object[0]);
        return junitReport.toString();
    }

    private void waitForRunnerToFinish(WebDriver driver, int timeout, boolean debug, Log log) throws InterruptedException {
        final JavascriptExecutor executor = (JavascriptExecutor)driver;
        new WebDriverWait(driver, (long)timeout, 1000L).until((Predicate)new Predicate<WebDriver>(){

            public boolean apply(WebDriver input) {
                return SpecRunnerExecutor.this.executionFinished(executor);
            }
        });
        if (!this.executionFinished(executor).booleanValue()) {
            this.handleTimeout(timeout, debug, log);
        }
    }

    private void handleTimeout(int timeout, boolean debug, Log log) {
        log.warn((CharSequence)("Attempted to wait for your specs to finish processing over the course of " + timeout + " seconds, but it still appears to be running."));
        if (!debug) {
            throw new IllegalStateException("Timeout occurred. Aborting execution of specs. (Try configuring 'debug' to 'true' for more details.)");
        }
        log.warn((CharSequence)"Debug mode: will attempt to parse the incomplete spec runner results");
    }

    private Boolean executionFinished(JavascriptExecutor driver) {
        return (Boolean)driver.executeScript("return reporter.finished", new Object[0]);
    }
}

