/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine;

import com.github.searls.jasmine.AbstractJasmineMojo;
import com.github.searls.jasmine.CustomConfigScriptResolver;
import com.github.searls.jasmine.io.FileUtilsWrapper;
import com.github.searls.jasmine.io.scripts.ProjectDirScripResolver;
import com.github.searls.jasmine.runner.ReporterType;
import com.github.searls.jasmine.runner.SpecRunnerHtmlGenerator;
import com.github.searls.jasmine.runner.SpecRunnerHtmlGeneratorFactory;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.logging.Log;

public class CreatesManualRunner {
    private FileUtilsWrapper fileUtilsWrapper = new FileUtilsWrapper();
    private AbstractJasmineMojo config;
    private Log log;

    public CreatesManualRunner(AbstractJasmineMojo config) {
        this.config = config;
        this.log = config.getLog();
    }

    public void create() throws IOException {
        File runnerDestination = new File(this.config.jasmineTargetDir, this.config.manualSpecRunnerHtmlFileName);
        ProjectDirScripResolver projectDirScripResolver = null != this.config.customRunnerConfiguration ? new CustomConfigScriptResolver(this.config.getMavenProject().getBasedir(), this.config.getSources(), this.config.getSpecs(), this.config.getPreloadSources()) : new ProjectDirScripResolver(this.config.getMavenProject().getBasedir(), this.config.getSources(), this.config.getSpecs(), this.config.getPreloadSources());
        SpecRunnerHtmlGenerator generator = new SpecRunnerHtmlGeneratorFactory().create(ReporterType.HtmlReporter, this.config, projectDirScripResolver);
        String newRunnerHtml = generator.generateWitRelativePaths();
        if (this.newRunnerDiffersFromOldRunner(runnerDestination, newRunnerHtml)) {
            this.saveRunner(runnerDestination, newRunnerHtml);
        } else {
            this.log.info((CharSequence)"Skipping spec runner generation, because an identical spec runner already exists.");
        }
    }

    private String existingRunner(File destination) throws IOException {
        String existingRunner = null;
        try {
            if (destination.exists()) {
                existingRunner = this.fileUtilsWrapper.readFileToString(destination);
            }
        }
        catch (Exception e) {
            this.log.warn((CharSequence)"An error occurred while trying to open an existing manual spec runner. Continuing.");
        }
        return existingRunner;
    }

    private boolean newRunnerDiffersFromOldRunner(File runnerDestination, String newRunner) throws IOException {
        return !StringUtils.equals((String)newRunner, (String)this.existingRunner(runnerDestination));
    }

    private void saveRunner(File runnerDestination, String newRunner) throws IOException {
        this.fileUtilsWrapper.writeStringToFile(runnerDestination, newRunner, this.config.sourceEncoding);
    }

    public void setLog(Log log) {
        this.log = log;
    }
}

