/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine;

import com.github.searls.jasmine.AbstractJasmineMojo;
import com.github.searls.jasmine.io.RelativizesFilePaths;
import com.github.searls.jasmine.server.JasmineResourceHandler;
import java.io.File;
import java.io.IOException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;

public class ResourceHandlerConfigurator {
    private AbstractJasmineMojo configuration;
    private RelativizesFilePaths relativizesFilePaths;

    public ResourceHandlerConfigurator(AbstractJasmineMojo configuration, RelativizesFilePaths relativizesFilePaths) {
        this.configuration = configuration;
        this.relativizesFilePaths = relativizesFilePaths;
    }

    public Handler createHandler(String specRunnerTemplate) throws IOException {
        Handler handler;
        if ("DEFAULT".equals(specRunnerTemplate)) {
            handler = this.createDefaultResourceHandler();
        } else if ("REQUIRE_JS".equals(specRunnerTemplate)) {
            handler = this.createContextualizedResourceHandler();
        } else {
            throw new UnsupportedOperationException("Unable to create handler for " + specRunnerTemplate + " profile!");
        }
        return handler;
    }

    private Handler createContextualizedResourceHandler() throws IOException {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        ContextHandler srcDirContextHandler = contexts.addContext("/" + this.configuration.srcDirectoryName, "");
        srcDirContextHandler.setHandler((Handler)this.createResourceHandler(true, this.configuration.sources.getDirectory().getAbsolutePath(), null));
        ContextHandler specDirContextHandler = contexts.addContext("/" + this.configuration.specDirectoryName, "");
        specDirContextHandler.setHandler((Handler)this.createResourceHandler(true, this.configuration.specs.getDirectory().getAbsolutePath(), null));
        ContextHandler rootContextHandler = contexts.addContext("/", "");
        rootContextHandler.setHandler((Handler)this.createResourceHandler(false, this.configuration.mavenProject.getBasedir().getAbsolutePath(), new String[]{this.manualSpecRunnerPath()}));
        return contexts;
    }

    private Handler createDefaultResourceHandler() throws IOException {
        ResourceHandler resourceHandler = this.createResourceHandler(true, this.configuration.mavenProject.getBasedir().getAbsolutePath(), new String[]{this.manualSpecRunnerPath()});
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{resourceHandler, new DefaultHandler()});
        return handlers;
    }

    private ResourceHandler createResourceHandler(boolean directory, String absolutePath, String[] welcomeFiles) throws IOException {
        JasmineResourceHandler resourceHandler = new JasmineResourceHandler(this.configuration);
        resourceHandler.setDirectoriesListed(directory);
        if (null != welcomeFiles) {
            resourceHandler.setWelcomeFiles(welcomeFiles);
        }
        resourceHandler.setResourceBase(absolutePath);
        return resourceHandler;
    }

    private String manualSpecRunnerPath() throws IOException {
        return this.relativizesFilePaths.relativize(this.configuration.mavenProject.getBasedir(), this.configuration.jasmineTargetDir) + File.separator + this.configuration.manualSpecRunnerHtmlFileName;
    }
}

