/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.io.scripts;

import com.github.searls.jasmine.io.RelativizesFilePaths;
import com.github.searls.jasmine.io.scripts.FindsScriptLocationsInDirectory;
import com.github.searls.jasmine.io.scripts.RelativizesASetOfScripts;
import com.github.searls.jasmine.io.scripts.ResolvesLocationOfPreloadSources;
import com.github.searls.jasmine.io.scripts.ScriptResolver;
import com.github.searls.jasmine.model.ScriptSearch;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScriptResolver
implements ScriptResolver {
    private Set<String> sources;
    private Set<String> specs;
    protected File baseDir;
    protected ScriptSearch scriptSearchSources;
    protected ScriptSearch scriptSearchSpecs;
    protected List<String> preloads;
    protected RelativizesASetOfScripts relativizer = new RelativizesASetOfScripts();
    protected RelativizesFilePaths relativizesFilePaths = new RelativizesFilePaths();
    private Set<String> scriptsToPreload;

    @Override
    public void resolveScripts() throws IOException {
        ResolvesLocationOfPreloadSources resolvesLocationOfPreloadSources = new ResolvesLocationOfPreloadSources();
        FindsScriptLocationsInDirectory findsScriptLocationsInDirectory = new FindsScriptLocationsInDirectory();
        this.setScriptsToPreload(new LinkedHashSet<String>(resolvesLocationOfPreloadSources.resolve(this.preloads, this.scriptSearchSources.getDirectory(), this.scriptSearchSpecs.getDirectory())));
        this.setSources(new LinkedHashSet<String>(findsScriptLocationsInDirectory.find(this.scriptSearchSources)));
        this.setSpecs(new LinkedHashSet<String>(findsScriptLocationsInDirectory.find(this.scriptSearchSpecs)));
    }

    @Override
    public Set<String> getPreloads() {
        return this.scriptsToPreload;
    }

    @Override
    public Set<String> getSources() {
        return this.sources;
    }

    @Override
    public Set<String> getSpecs() {
        return this.specs;
    }

    @Override
    public Set<String> getAllScripts() {
        return this.addAllScripts(this.scriptsToPreload, this.sources, this.specs);
    }

    @Override
    public String getSourceDirectory() throws IOException {
        return this.scriptSearchSources.getDirectory().toURI().toURL().toString();
    }

    @Override
    public String getSpecDirectoryPath() throws MalformedURLException {
        return this.scriptSearchSpecs.getDirectory().toURI().toURL().toString();
    }

    @Override
    public Set<String> getSourcesRelativePath() throws IOException {
        return this.relativizer.relativize(this.baseDir, this.sources);
    }

    @Override
    public Set<String> getSpecsRelativePath() throws IOException {
        return this.relativizer.relativize(this.baseDir, this.specs);
    }

    @Override
    public Set<String> getPreloadsRelativePath() throws IOException {
        return this.relativizer.relativize(this.baseDir, this.scriptsToPreload);
    }

    @Override
    public Set<String> getAllScriptsRelativePath() throws IOException {
        return this.addAllScripts(this.getPreloadsRelativePath(), this.getSourcesRelativePath(), this.getSpecsRelativePath());
    }

    @Override
    public String getSourceDirectoryRelativePath() throws IOException {
        return this.relativizesFilePaths.relativize(this.baseDir, this.scriptSearchSources.getDirectory());
    }

    @Override
    public String getSpecDirectoryRelativePath() throws IOException {
        return this.relativizesFilePaths.relativize(this.baseDir, this.scriptSearchSpecs.getDirectory());
    }

    private Set<String> addAllScripts(Set<String> preloadedSources, Set<String> sources, Set<String> specs) {
        LinkedHashSet<String> allScripts = new LinkedHashSet<String>();
        allScripts.addAll(preloadedSources);
        allScripts.addAll(sources);
        allScripts.addAll(specs);
        return allScripts;
    }

    public void setScriptsToPreload(Set<String> scriptsToPreload) {
        this.scriptsToPreload = scriptsToPreload;
    }

    public void setSources(Set<String> sources) {
        this.sources = sources;
    }

    public void setSpecs(Set<String> specs) {
        this.specs = specs;
    }
}

