/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.io.scripts;

import com.github.searls.jasmine.collections.CollectionHelper;
import com.github.searls.jasmine.io.scripts.ConvertsFileToUriString;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvesLocationOfPreloadSources {
    private CollectionHelper collectionHelper = new CollectionHelper();
    private ConvertsFileToUriString convertsFileToUriString = new ConvertsFileToUriString();

    public List<String> resolve(List<String> preloadSources, File sourceDir, File specDir) {
        ArrayList<String> sources = new ArrayList<String>();
        for (String source : this.collectionHelper.list(preloadSources)) {
            if (!this.fileCouldNotBeAdded(new File(sourceDir, source), sources) || !this.fileCouldNotBeAdded(new File(specDir, source), sources) || !this.fileCouldNotBeAdded(new File(source), sources)) continue;
            sources.add(source);
        }
        return sources;
    }

    private boolean fileCouldNotBeAdded(File file, List<String> sourcePaths) {
        boolean canAdd = file.exists();
        if (canAdd) {
            sourcePaths.add(this.convertsFileToUriString.convert(file));
        }
        return !canAdd;
    }
}

