/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.runner;

import com.github.searls.jasmine.runner.AbstractSpecRunnerHtmlGenerator;
import com.github.searls.jasmine.runner.HtmlGeneratorConfiguration;
import com.github.searls.jasmine.runner.SpecRunnerHtmlGenerator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.antlr.stringtemplate.StringTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequireJsSpecRunnerHtmlGenerator
extends AbstractSpecRunnerHtmlGenerator
implements SpecRunnerHtmlGenerator {
    public static final String REQUIRE_JS_HTML_TEMPLATE_FILE = "/jasmine-templates/RequireJsSpecRunner.htmltemplate";

    protected RequireJsSpecRunnerHtmlGenerator(HtmlGeneratorConfiguration configuration) {
        super(configuration);
    }

    @Override
    public String generate() {
        try {
            return this.generateHtml(this.getConfiguration().getSpecs(), this.getConfiguration().getSourceDirectory());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load files for dependencies, sources, or a custom runner", e);
        }
    }

    @Override
    public String generateWitRelativePaths() {
        try {
            return this.generateHtml(this.getConfiguration().getSpecsRelativePath(), this.getConfiguration().getSourceDirectoryRelativePath());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load files for dependencies, sources, or a custom runner", e);
        }
    }

    private String generateHtml(Set<String> specsRelativePath, String sourceDirectory) throws IOException {
        StringTemplate template = this.resolveHtmlTemplate();
        this.includeJavaScriptDependencies(Arrays.asList("/vendor/js/jasmine.js", "/vendor/js/jasmine-html.js"), template);
        this.applyCssToTemplate(Arrays.asList("/vendor/css/jasmine.css"), template);
        Set<String> preloads = this.getConfiguration().getPreloadsRelativePath();
        template.setAttribute("priority", (Object)this.createArrayOfScripts(preloads));
        template.setAttribute("requirejsPath", (Object)this.resolveRequirejsPath(sourceDirectory));
        this.setCustomRunnerConfig(template);
        template.setAttribute("reporter", (Object)this.getConfiguration().getReporterType().name());
        template.setAttribute("sourceDir", (Object)sourceDirectory);
        template.setAttribute("specs", (Object)this.createArrayOfScripts(specsRelativePath));
        this.setEncoding(this.getConfiguration(), template);
        return template.toString();
    }

    private String resolveRequirejsPath(String sourceDirectory) {
        String scriptLoaderPath = this.getConfiguration().getScriptLoaderPath();
        if (null == scriptLoaderPath) {
            return String.format("%s/require.js", sourceDirectory);
        }
        return String.format("%s/%s", sourceDirectory, scriptLoaderPath);
    }

    private void setCustomRunnerConfig(StringTemplate template) throws IOException {
        String customRunnerConfiguration = this.getConfiguration().getCustomRunnerConfiguration();
        if (null != customRunnerConfiguration) {
            template.setAttribute("customRunnerConfiguration", (Object)customRunnerConfiguration);
        }
    }

    private String createArrayOfScripts(Set<String> scripts) throws IOException {
        if (null == scripts || scripts.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder("[");
        for (String script : scripts) {
            builder.append("'" + script + "'");
            builder.append(", ");
        }
        if (!scripts.isEmpty()) {
            builder.delete(builder.lastIndexOf(", "), builder.length());
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    protected String getDefaultHtmlTemplatePath() {
        return REQUIRE_JS_HTML_TEMPLATE_FILE;
    }
}

