/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.mojo;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.IncorrectnessListener;
import com.gargoylesoftware.htmlunit.NicelyResynchronizingAjaxController;
import com.gargoylesoftware.htmlunit.WebClient;
import com.github.searls.jasmine.format.JasmineResultLogger;
import com.github.searls.jasmine.io.RelativizesFilePaths;
import com.github.searls.jasmine.model.JasmineResult;
import com.github.searls.jasmine.mojo.AbstractJasmineMojo;
import com.github.searls.jasmine.runner.ReporterType;
import com.github.searls.jasmine.runner.SpecRunnerExecutor;
import com.github.searls.jasmine.server.ResourceHandlerConfigurator;
import com.github.searls.jasmine.server.ServerManager;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST)
public class TestMojo
extends AbstractJasmineMojo {
    private final RelativizesFilePaths relativizesFilePaths = new RelativizesFilePaths();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        if (!this.skipTests) {
            ServerManager serverManager = this.getServerManager();
            System.out.println(serverManager);
            try {
                int port = serverManager.start();
                this.setPortProperty(port);
                this.getLog().info((CharSequence)"Executing Jasmine Specs");
                JasmineResult result = this.executeSpecs(new URL("http://localhost:" + port));
                this.logResults(result);
                this.throwAnySpecFailures(result);
            }
            finally {
                if (!this.keepServerAlive) {
                    serverManager.stop();
                }
            }
        } else {
            this.getLog().info((CharSequence)"Skipping Jasmine Specs");
        }
    }

    private ServerManager getServerManager() {
        ResourceHandlerConfigurator configurator = new ResourceHandlerConfigurator(this, this.relativizesFilePaths, this.specRunnerHtmlFileName, ReporterType.JsApiReporter);
        ServerManager manager = new ServerManager(configurator);
        return manager;
    }

    private void setPortProperty(int port) {
        this.mavenProject.getProperties().setProperty("jasmine.serverPort", String.valueOf(port));
    }

    private JasmineResult executeSpecs(URL runner) throws MalformedURLException {
        WebDriver driver = this.createDriver();
        JasmineResult result = new SpecRunnerExecutor().execute(runner, new File(this.jasmineTargetDir, this.junitXmlReportFileName), driver, this.timeout, this.debug, this.getLog(), this.format);
        return result;
    }

    private WebDriver createDriver() {
        BrowserVersion htmlUnitBrowserVersion;
        if (!HtmlUnitDriver.class.getName().equals(this.webDriverClassName)) {
            try {
                Class<?> klass = Class.forName(this.webDriverClassName);
                Constructor<?> ctor = klass.getConstructor(new Class[0]);
                return (WebDriver)ctor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't instantiate webDriverClassName", e);
            }
        }
        try {
            htmlUnitBrowserVersion = (BrowserVersion)BrowserVersion.class.getField(this.browserVersion).get(BrowserVersion.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HtmlUnitDriver driver = new HtmlUnitDriver(htmlUnitBrowserVersion){

            protected WebClient modifyWebClient(WebClient client) {
                client.setAjaxController((AjaxController)new NicelyResynchronizingAjaxController());
                if (!TestMojo.this.debug) {
                    client.setIncorrectnessListener(new IncorrectnessListener(){

                        public void notify(String arg0, Object arg1) {
                        }
                    });
                }
                return client;
            }
        };
        driver.setJavascriptEnabled(true);
        return driver;
    }

    private void logResults(JasmineResult result) {
        JasmineResultLogger resultLogger = new JasmineResultLogger();
        resultLogger.setLog(this.getLog());
        resultLogger.log(result);
    }

    private void throwAnySpecFailures(JasmineResult result) throws MojoFailureException {
        if (this.haltOnFailure && !result.didPass()) {
            throw new MojoFailureException("There were Jasmine spec failures.");
        }
    }
}

