/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.mojo;

import com.github.searls.jasmine.NullLog;
import com.github.searls.jasmine.io.RelativizesFilePaths;
import com.github.searls.jasmine.mojo.AbstractJasmineMojo;
import com.github.searls.jasmine.runner.CreatesRunner;
import com.github.searls.jasmine.runner.ReporterType;
import com.github.searls.jasmine.server.ResourceHandlerConfigurator;
import com.github.searls.jasmine.server.ServerManager;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="bdd", requiresDirectInvocation=true)
public class ServerMojo
extends AbstractJasmineMojo {
    public static final String INSTRUCTION_FORMAT = "\n\nServer started--it's time to spec some JavaScript! You can run your specs as you develop by visiting this URL in a web browser: \n\n  http://localhost:%s\n\nThe server will monitor these two directories for scripts that you add, remove, and change:\n\n  source directory: %s\n\n  spec directory: %s\n\nJust leave this process running as you test-drive your code, refreshing your browser window to re-run your specs. You can kill the server with Ctrl-C when you're done.";
    private final RelativizesFilePaths relativizesFilePaths = new RelativizesFilePaths();

    private String buildServerInstructions() throws IOException {
        return String.format(INSTRUCTION_FORMAT, this.serverPort, this.getRelativePath(this.sources.getDirectory()), this.getRelativePath(this.specs.getDirectory()));
    }

    @Override
    public void run() throws Exception {
        ServerManager serverManager = this.getServerManager();
        serverManager.start(this.serverPort);
        this.getLog().info((CharSequence)this.buildServerInstructions());
        serverManager.join();
    }

    private ServerManager getServerManager() {
        Log log = this.debug ? this.getLog() : new NullLog();
        CreatesRunner createsRunner = new CreatesRunner(this, log, this.manualSpecRunnerHtmlFileName, ReporterType.HtmlReporter);
        ResourceHandlerConfigurator configurator = new ResourceHandlerConfigurator(this, this.relativizesFilePaths, createsRunner);
        return new ServerManager(configurator);
    }

    private String getRelativePath(File absolutePath) throws IOException {
        return this.relativizesFilePaths.relativize(this.mavenProject.getBasedir(), absolutePath);
    }
}

