/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.thirdpartylibs;

import com.github.searls.jasmine.thirdpartylibs.AbstractThirdPartyLibsResourceHandler;
import java.io.InputStream;
import java.util.SortedMap;
import java.util.regex.Pattern;
import org.webjars.WebJarAssetLocator;

public class WebJarResourceHandler
extends AbstractThirdPartyLibsResourceHandler {
    private final WebJarAssetLocator webJarAssetLocator;
    private final ClassLoader projectClassLoader;

    public WebJarResourceHandler(ClassLoader projectClassLoader) {
        this.projectClassLoader = projectClassLoader;
        this.webJarAssetLocator = this.createWebJarAssetLocator();
    }

    @Override
    protected InputStream findResource(String resourcePath) {
        String fullPath;
        try {
            fullPath = this.webJarAssetLocator.getFullPath(resourcePath);
        }
        catch (Exception ignoreToRespondWith404) {
            return null;
        }
        return this.projectClassLoader.getResourceAsStream(fullPath);
    }

    private WebJarAssetLocator createWebJarAssetLocator() {
        SortedMap fullPathIndex = WebJarAssetLocator.getFullPathIndex((Pattern)Pattern.compile(".*"), (ClassLoader[])new ClassLoader[]{this.projectClassLoader});
        return new WebJarAssetLocator(fullPathIndex);
    }
}

